<?php

namespace PartScanner\Infrastructure\Models\SyncStat\Map;

use PartScanner\Infrastructure\Models\SyncStat\SyncStat;
use PartScanner\Infrastructure\Models\SyncStat\SyncStatQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'local_sync_stat' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class SyncStatTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.SyncStat.Map.SyncStatTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'local_sync_stat';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\PartScanner\\Infrastructure\\Models\\SyncStat\\SyncStat';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.SyncStat.SyncStat';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 14;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 14;

    /**
     * the column name for the id field
     */
    const COL_ID = 'local_sync_stat.id';

    /**
     * the column name for the datetime field
     */
    const COL_DATETIME = 'local_sync_stat.datetime';

    /**
     * the column name for the assortment_id field
     */
    const COL_ASSORTMENT_ID = 'local_sync_stat.assortment_id';

    /**
     * the column name for the price_list_id field
     */
    const COL_PRICE_LIST_ID = 'local_sync_stat.price_list_id';

    /**
     * the column name for the file field
     */
    const COL_FILE = 'local_sync_stat.file';

    /**
     * the column name for the file_size field
     */
    const COL_FILE_SIZE = 'local_sync_stat.file_size';

    /**
     * the column name for the datetime_file_load field
     */
    const COL_DATETIME_FILE_LOAD = 'local_sync_stat.datetime_file_load';

    /**
     * the column name for the validate_markup field
     */
    const COL_VALIDATE_MARKUP = 'local_sync_stat.validate_markup';

    /**
     * the column name for the positions_count field
     */
    const COL_POSITIONS_COUNT = 'local_sync_stat.positions_count';

    /**
     * the column name for the analise_success_positions_count field
     */
    const COL_ANALISE_SUCCESS_POSITIONS_COUNT = 'local_sync_stat.analise_success_positions_count';

    /**
     * the column name for the analise_ignore_positions_count field
     */
    const COL_ANALISE_IGNORE_POSITIONS_COUNT = 'local_sync_stat.analise_ignore_positions_count';

    /**
     * the column name for the datetime_price_commit field
     */
    const COL_DATETIME_PRICE_COMMIT = 'local_sync_stat.datetime_price_commit';

    /**
     * the column name for the status field
     */
    const COL_STATUS = 'local_sync_stat.status';

    /**
     * the column name for the status_msg field
     */
    const COL_STATUS_MSG = 'local_sync_stat.status_msg';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'DateTime', 'AssortmentId', 'PriceListId', 'File', 'FileSize', 'DateTimeFileLoad', 'ValidateMarkup', 'PositionsCount', 'AnaliseSuccessPositionsCount', 'AnaliseIgnorePositionsCount', 'DateTimePriceCommit', 'Status', 'StatusMessage', ),
        self::TYPE_CAMELNAME     => array('id', 'dateTime', 'assortmentId', 'priceListId', 'file', 'fileSize', 'dateTimeFileLoad', 'validateMarkup', 'positionsCount', 'analiseSuccessPositionsCount', 'analiseIgnorePositionsCount', 'dateTimePriceCommit', 'status', 'statusMessage', ),
        self::TYPE_COLNAME       => array(SyncStatTableMap::COL_ID, SyncStatTableMap::COL_DATETIME, SyncStatTableMap::COL_ASSORTMENT_ID, SyncStatTableMap::COL_PRICE_LIST_ID, SyncStatTableMap::COL_FILE, SyncStatTableMap::COL_FILE_SIZE, SyncStatTableMap::COL_DATETIME_FILE_LOAD, SyncStatTableMap::COL_VALIDATE_MARKUP, SyncStatTableMap::COL_POSITIONS_COUNT, SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT, SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT, SyncStatTableMap::COL_DATETIME_PRICE_COMMIT, SyncStatTableMap::COL_STATUS, SyncStatTableMap::COL_STATUS_MSG, ),
        self::TYPE_FIELDNAME     => array('id', 'datetime', 'assortment_id', 'price_list_id', 'file', 'file_size', 'datetime_file_load', 'validate_markup', 'positions_count', 'analise_success_positions_count', 'analise_ignore_positions_count', 'datetime_price_commit', 'status', 'status_msg', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'DateTime' => 1, 'AssortmentId' => 2, 'PriceListId' => 3, 'File' => 4, 'FileSize' => 5, 'DateTimeFileLoad' => 6, 'ValidateMarkup' => 7, 'PositionsCount' => 8, 'AnaliseSuccessPositionsCount' => 9, 'AnaliseIgnorePositionsCount' => 10, 'DateTimePriceCommit' => 11, 'Status' => 12, 'StatusMessage' => 13, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'dateTime' => 1, 'assortmentId' => 2, 'priceListId' => 3, 'file' => 4, 'fileSize' => 5, 'dateTimeFileLoad' => 6, 'validateMarkup' => 7, 'positionsCount' => 8, 'analiseSuccessPositionsCount' => 9, 'analiseIgnorePositionsCount' => 10, 'dateTimePriceCommit' => 11, 'status' => 12, 'statusMessage' => 13, ),
        self::TYPE_COLNAME       => array(SyncStatTableMap::COL_ID => 0, SyncStatTableMap::COL_DATETIME => 1, SyncStatTableMap::COL_ASSORTMENT_ID => 2, SyncStatTableMap::COL_PRICE_LIST_ID => 3, SyncStatTableMap::COL_FILE => 4, SyncStatTableMap::COL_FILE_SIZE => 5, SyncStatTableMap::COL_DATETIME_FILE_LOAD => 6, SyncStatTableMap::COL_VALIDATE_MARKUP => 7, SyncStatTableMap::COL_POSITIONS_COUNT => 8, SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT => 9, SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT => 10, SyncStatTableMap::COL_DATETIME_PRICE_COMMIT => 11, SyncStatTableMap::COL_STATUS => 12, SyncStatTableMap::COL_STATUS_MSG => 13, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'datetime' => 1, 'assortment_id' => 2, 'price_list_id' => 3, 'file' => 4, 'file_size' => 5, 'datetime_file_load' => 6, 'validate_markup' => 7, 'positions_count' => 8, 'analise_success_positions_count' => 9, 'analise_ignore_positions_count' => 10, 'datetime_price_commit' => 11, 'status' => 12, 'status_msg' => 13, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('local_sync_stat');
        $this->setPhpName('SyncStat');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\PartScanner\\Infrastructure\\Models\\SyncStat\\SyncStat');
        $this->setPackage('Models.SyncStat');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('datetime', 'DateTime', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('assortment_id', 'AssortmentId', 'INTEGER', true, null, null);
        $this->addColumn('price_list_id', 'PriceListId', 'INTEGER', true, null, null);
        $this->addColumn('file', 'File', 'VARCHAR', false, 255, null);
        $this->addColumn('file_size', 'FileSize', 'INTEGER', false, null, null);
        $this->addColumn('datetime_file_load', 'DateTimeFileLoad', 'TIMESTAMP', false, null, null);
        $this->addColumn('validate_markup', 'ValidateMarkup', 'TINYINT', true, null, 0);
        $this->addColumn('positions_count', 'PositionsCount', 'INTEGER', false, null, null);
        $this->addColumn('analise_success_positions_count', 'AnaliseSuccessPositionsCount', 'INTEGER', false, null, null);
        $this->addColumn('analise_ignore_positions_count', 'AnaliseIgnorePositionsCount', 'INTEGER', false, null, null);
        $this->addColumn('datetime_price_commit', 'DateTimePriceCommit', 'TIMESTAMP', false, null, null);
        $this->addColumn('status', 'Status', 'INTEGER', true, null, null);
        $this->addColumn('status_msg', 'StatusMessage', 'VARCHAR', false, 255, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? SyncStatTableMap::CLASS_DEFAULT : SyncStatTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (SyncStat object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = SyncStatTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = SyncStatTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + SyncStatTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = SyncStatTableMap::OM_CLASS;
            /** @var SyncStat $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            SyncStatTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = SyncStatTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = SyncStatTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var SyncStat $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                SyncStatTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(SyncStatTableMap::COL_ID);
            $criteria->addSelectColumn(SyncStatTableMap::COL_DATETIME);
            $criteria->addSelectColumn(SyncStatTableMap::COL_ASSORTMENT_ID);
            $criteria->addSelectColumn(SyncStatTableMap::COL_PRICE_LIST_ID);
            $criteria->addSelectColumn(SyncStatTableMap::COL_FILE);
            $criteria->addSelectColumn(SyncStatTableMap::COL_FILE_SIZE);
            $criteria->addSelectColumn(SyncStatTableMap::COL_DATETIME_FILE_LOAD);
            $criteria->addSelectColumn(SyncStatTableMap::COL_VALIDATE_MARKUP);
            $criteria->addSelectColumn(SyncStatTableMap::COL_POSITIONS_COUNT);
            $criteria->addSelectColumn(SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT);
            $criteria->addSelectColumn(SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT);
            $criteria->addSelectColumn(SyncStatTableMap::COL_DATETIME_PRICE_COMMIT);
            $criteria->addSelectColumn(SyncStatTableMap::COL_STATUS);
            $criteria->addSelectColumn(SyncStatTableMap::COL_STATUS_MSG);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.datetime');
            $criteria->addSelectColumn($alias . '.assortment_id');
            $criteria->addSelectColumn($alias . '.price_list_id');
            $criteria->addSelectColumn($alias . '.file');
            $criteria->addSelectColumn($alias . '.file_size');
            $criteria->addSelectColumn($alias . '.datetime_file_load');
            $criteria->addSelectColumn($alias . '.validate_markup');
            $criteria->addSelectColumn($alias . '.positions_count');
            $criteria->addSelectColumn($alias . '.analise_success_positions_count');
            $criteria->addSelectColumn($alias . '.analise_ignore_positions_count');
            $criteria->addSelectColumn($alias . '.datetime_price_commit');
            $criteria->addSelectColumn($alias . '.status');
            $criteria->addSelectColumn($alias . '.status_msg');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(SyncStatTableMap::DATABASE_NAME)->getTable(SyncStatTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(SyncStatTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(SyncStatTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new SyncStatTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a SyncStat or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or SyncStat object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncStatTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \PartScanner\Infrastructure\Models\SyncStat\SyncStat) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(SyncStatTableMap::DATABASE_NAME);
            $criteria->add(SyncStatTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = SyncStatQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            SyncStatTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                SyncStatTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the local_sync_stat table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return SyncStatQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a SyncStat or Criteria object.
     *
     * @param mixed               $criteria Criteria or SyncStat object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncStatTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from SyncStat object
        }

        if ($criteria->containsKey(SyncStatTableMap::COL_ID) && $criteria->keyContainsValue(SyncStatTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.SyncStatTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = SyncStatQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // SyncStatTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
SyncStatTableMap::buildTableMap();
