<?php

namespace PartScanner\Infrastructure\Models\SyncStat\Base;

use \Exception;
use \PDO;
use PartScanner\Infrastructure\Models\SyncStat\SyncStat as ChildSyncStat;
use PartScanner\Infrastructure\Models\SyncStat\SyncStatQuery as ChildSyncStatQuery;
use PartScanner\Infrastructure\Models\SyncStat\Map\SyncStatTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'local_sync_stat' table.
 *
 *
 *
 * @method     ChildSyncStatQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildSyncStatQuery orderByDateTime($order = Criteria::ASC) Order by the datetime column
 * @method     ChildSyncStatQuery orderByAssortmentId($order = Criteria::ASC) Order by the assortment_id column
 * @method     ChildSyncStatQuery orderByPriceListId($order = Criteria::ASC) Order by the price_list_id column
 * @method     ChildSyncStatQuery orderByFile($order = Criteria::ASC) Order by the file column
 * @method     ChildSyncStatQuery orderByFileSize($order = Criteria::ASC) Order by the file_size column
 * @method     ChildSyncStatQuery orderByDateTimeFileLoad($order = Criteria::ASC) Order by the datetime_file_load column
 * @method     ChildSyncStatQuery orderByValidateMarkup($order = Criteria::ASC) Order by the validate_markup column
 * @method     ChildSyncStatQuery orderByPositionsCount($order = Criteria::ASC) Order by the positions_count column
 * @method     ChildSyncStatQuery orderByAnaliseSuccessPositionsCount($order = Criteria::ASC) Order by the analise_success_positions_count column
 * @method     ChildSyncStatQuery orderByAnaliseIgnorePositionsCount($order = Criteria::ASC) Order by the analise_ignore_positions_count column
 * @method     ChildSyncStatQuery orderByDateTimePriceCommit($order = Criteria::ASC) Order by the datetime_price_commit column
 * @method     ChildSyncStatQuery orderByStatus($order = Criteria::ASC) Order by the status column
 * @method     ChildSyncStatQuery orderByStatusMessage($order = Criteria::ASC) Order by the status_msg column
 *
 * @method     ChildSyncStatQuery groupById() Group by the id column
 * @method     ChildSyncStatQuery groupByDateTime() Group by the datetime column
 * @method     ChildSyncStatQuery groupByAssortmentId() Group by the assortment_id column
 * @method     ChildSyncStatQuery groupByPriceListId() Group by the price_list_id column
 * @method     ChildSyncStatQuery groupByFile() Group by the file column
 * @method     ChildSyncStatQuery groupByFileSize() Group by the file_size column
 * @method     ChildSyncStatQuery groupByDateTimeFileLoad() Group by the datetime_file_load column
 * @method     ChildSyncStatQuery groupByValidateMarkup() Group by the validate_markup column
 * @method     ChildSyncStatQuery groupByPositionsCount() Group by the positions_count column
 * @method     ChildSyncStatQuery groupByAnaliseSuccessPositionsCount() Group by the analise_success_positions_count column
 * @method     ChildSyncStatQuery groupByAnaliseIgnorePositionsCount() Group by the analise_ignore_positions_count column
 * @method     ChildSyncStatQuery groupByDateTimePriceCommit() Group by the datetime_price_commit column
 * @method     ChildSyncStatQuery groupByStatus() Group by the status column
 * @method     ChildSyncStatQuery groupByStatusMessage() Group by the status_msg column
 *
 * @method     ChildSyncStatQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildSyncStatQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildSyncStatQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildSyncStatQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildSyncStatQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildSyncStatQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildSyncStat findOne(ConnectionInterface $con = null) Return the first ChildSyncStat matching the query
 * @method     ChildSyncStat findOneOrCreate(ConnectionInterface $con = null) Return the first ChildSyncStat matching the query, or a new ChildSyncStat object populated from the query conditions when no match is found
 *
 * @method     ChildSyncStat findOneById(int $id) Return the first ChildSyncStat filtered by the id column
 * @method     ChildSyncStat findOneByDateTime(string $datetime) Return the first ChildSyncStat filtered by the datetime column
 * @method     ChildSyncStat findOneByAssortmentId(int $assortment_id) Return the first ChildSyncStat filtered by the assortment_id column
 * @method     ChildSyncStat findOneByPriceListId(int $price_list_id) Return the first ChildSyncStat filtered by the price_list_id column
 * @method     ChildSyncStat findOneByFile(string $file) Return the first ChildSyncStat filtered by the file column
 * @method     ChildSyncStat findOneByFileSize(int $file_size) Return the first ChildSyncStat filtered by the file_size column
 * @method     ChildSyncStat findOneByDateTimeFileLoad(string $datetime_file_load) Return the first ChildSyncStat filtered by the datetime_file_load column
 * @method     ChildSyncStat findOneByValidateMarkup(int $validate_markup) Return the first ChildSyncStat filtered by the validate_markup column
 * @method     ChildSyncStat findOneByPositionsCount(int $positions_count) Return the first ChildSyncStat filtered by the positions_count column
 * @method     ChildSyncStat findOneByAnaliseSuccessPositionsCount(int $analise_success_positions_count) Return the first ChildSyncStat filtered by the analise_success_positions_count column
 * @method     ChildSyncStat findOneByAnaliseIgnorePositionsCount(int $analise_ignore_positions_count) Return the first ChildSyncStat filtered by the analise_ignore_positions_count column
 * @method     ChildSyncStat findOneByDateTimePriceCommit(string $datetime_price_commit) Return the first ChildSyncStat filtered by the datetime_price_commit column
 * @method     ChildSyncStat findOneByStatus(int $status) Return the first ChildSyncStat filtered by the status column
 * @method     ChildSyncStat findOneByStatusMessage(string $status_msg) Return the first ChildSyncStat filtered by the status_msg column *

 * @method     ChildSyncStat requirePk($key, ConnectionInterface $con = null) Return the ChildSyncStat by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOne(ConnectionInterface $con = null) Return the first ChildSyncStat matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSyncStat requireOneById(int $id) Return the first ChildSyncStat filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByDateTime(string $datetime) Return the first ChildSyncStat filtered by the datetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByAssortmentId(int $assortment_id) Return the first ChildSyncStat filtered by the assortment_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByPriceListId(int $price_list_id) Return the first ChildSyncStat filtered by the price_list_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByFile(string $file) Return the first ChildSyncStat filtered by the file column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByFileSize(int $file_size) Return the first ChildSyncStat filtered by the file_size column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByDateTimeFileLoad(string $datetime_file_load) Return the first ChildSyncStat filtered by the datetime_file_load column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByValidateMarkup(int $validate_markup) Return the first ChildSyncStat filtered by the validate_markup column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByPositionsCount(int $positions_count) Return the first ChildSyncStat filtered by the positions_count column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByAnaliseSuccessPositionsCount(int $analise_success_positions_count) Return the first ChildSyncStat filtered by the analise_success_positions_count column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByAnaliseIgnorePositionsCount(int $analise_ignore_positions_count) Return the first ChildSyncStat filtered by the analise_ignore_positions_count column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByDateTimePriceCommit(string $datetime_price_commit) Return the first ChildSyncStat filtered by the datetime_price_commit column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByStatus(int $status) Return the first ChildSyncStat filtered by the status column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncStat requireOneByStatusMessage(string $status_msg) Return the first ChildSyncStat filtered by the status_msg column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSyncStat[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildSyncStat objects based on current ModelCriteria
 * @method     ChildSyncStat[]|ObjectCollection findById(int $id) Return ChildSyncStat objects filtered by the id column
 * @method     ChildSyncStat[]|ObjectCollection findByDateTime(string $datetime) Return ChildSyncStat objects filtered by the datetime column
 * @method     ChildSyncStat[]|ObjectCollection findByAssortmentId(int $assortment_id) Return ChildSyncStat objects filtered by the assortment_id column
 * @method     ChildSyncStat[]|ObjectCollection findByPriceListId(int $price_list_id) Return ChildSyncStat objects filtered by the price_list_id column
 * @method     ChildSyncStat[]|ObjectCollection findByFile(string $file) Return ChildSyncStat objects filtered by the file column
 * @method     ChildSyncStat[]|ObjectCollection findByFileSize(int $file_size) Return ChildSyncStat objects filtered by the file_size column
 * @method     ChildSyncStat[]|ObjectCollection findByDateTimeFileLoad(string $datetime_file_load) Return ChildSyncStat objects filtered by the datetime_file_load column
 * @method     ChildSyncStat[]|ObjectCollection findByValidateMarkup(int $validate_markup) Return ChildSyncStat objects filtered by the validate_markup column
 * @method     ChildSyncStat[]|ObjectCollection findByPositionsCount(int $positions_count) Return ChildSyncStat objects filtered by the positions_count column
 * @method     ChildSyncStat[]|ObjectCollection findByAnaliseSuccessPositionsCount(int $analise_success_positions_count) Return ChildSyncStat objects filtered by the analise_success_positions_count column
 * @method     ChildSyncStat[]|ObjectCollection findByAnaliseIgnorePositionsCount(int $analise_ignore_positions_count) Return ChildSyncStat objects filtered by the analise_ignore_positions_count column
 * @method     ChildSyncStat[]|ObjectCollection findByDateTimePriceCommit(string $datetime_price_commit) Return ChildSyncStat objects filtered by the datetime_price_commit column
 * @method     ChildSyncStat[]|ObjectCollection findByStatus(int $status) Return ChildSyncStat objects filtered by the status column
 * @method     ChildSyncStat[]|ObjectCollection findByStatusMessage(string $status_msg) Return ChildSyncStat objects filtered by the status_msg column
 * @method     ChildSyncStat[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class SyncStatQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \PartScanner\Infrastructure\Models\SyncStat\Base\SyncStatQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\PartScanner\\Infrastructure\\Models\\SyncStat\\SyncStat', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildSyncStatQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildSyncStatQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildSyncStatQuery) {
            return $criteria;
        }
        $query = new ChildSyncStatQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildSyncStat|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(SyncStatTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = SyncStatTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSyncStat A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `datetime`, `assortment_id`, `price_list_id`, `file`, `file_size`, `datetime_file_load`, `validate_markup`, `positions_count`, `analise_success_positions_count`, `analise_ignore_positions_count`, `datetime_price_commit`, `status`, `status_msg` FROM `local_sync_stat` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildSyncStat $obj */
            $obj = new ChildSyncStat();
            $obj->hydrate($row);
            SyncStatTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildSyncStat|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(SyncStatTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(SyncStatTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the datetime column
     *
     * Example usage:
     * <code>
     * $query->filterByDateTime('2011-03-14'); // WHERE datetime = '2011-03-14'
     * $query->filterByDateTime('now'); // WHERE datetime = '2011-03-14'
     * $query->filterByDateTime(array('max' => 'yesterday')); // WHERE datetime > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateTime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByDateTime($dateTime = null, $comparison = null)
    {
        if (is_array($dateTime)) {
            $useMinMax = false;
            if (isset($dateTime['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_DATETIME, $dateTime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateTime['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_DATETIME, $dateTime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_DATETIME, $dateTime, $comparison);
    }

    /**
     * Filter the query on the assortment_id column
     *
     * Example usage:
     * <code>
     * $query->filterByAssortmentId(1234); // WHERE assortment_id = 1234
     * $query->filterByAssortmentId(array(12, 34)); // WHERE assortment_id IN (12, 34)
     * $query->filterByAssortmentId(array('min' => 12)); // WHERE assortment_id > 12
     * </code>
     *
     * @param     mixed $assortmentId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByAssortmentId($assortmentId = null, $comparison = null)
    {
        if (is_array($assortmentId)) {
            $useMinMax = false;
            if (isset($assortmentId['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_ASSORTMENT_ID, $assortmentId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($assortmentId['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_ASSORTMENT_ID, $assortmentId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_ASSORTMENT_ID, $assortmentId, $comparison);
    }

    /**
     * Filter the query on the price_list_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPriceListId(1234); // WHERE price_list_id = 1234
     * $query->filterByPriceListId(array(12, 34)); // WHERE price_list_id IN (12, 34)
     * $query->filterByPriceListId(array('min' => 12)); // WHERE price_list_id > 12
     * </code>
     *
     * @param     mixed $priceListId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByPriceListId($priceListId = null, $comparison = null)
    {
        if (is_array($priceListId)) {
            $useMinMax = false;
            if (isset($priceListId['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_PRICE_LIST_ID, $priceListId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($priceListId['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_PRICE_LIST_ID, $priceListId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_PRICE_LIST_ID, $priceListId, $comparison);
    }

    /**
     * Filter the query on the file column
     *
     * Example usage:
     * <code>
     * $query->filterByFile('fooValue');   // WHERE file = 'fooValue'
     * $query->filterByFile('%fooValue%', Criteria::LIKE); // WHERE file LIKE '%fooValue%'
     * </code>
     *
     * @param     string $file The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByFile($file = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($file)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_FILE, $file, $comparison);
    }

    /**
     * Filter the query on the file_size column
     *
     * Example usage:
     * <code>
     * $query->filterByFileSize(1234); // WHERE file_size = 1234
     * $query->filterByFileSize(array(12, 34)); // WHERE file_size IN (12, 34)
     * $query->filterByFileSize(array('min' => 12)); // WHERE file_size > 12
     * </code>
     *
     * @param     mixed $fileSize The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByFileSize($fileSize = null, $comparison = null)
    {
        if (is_array($fileSize)) {
            $useMinMax = false;
            if (isset($fileSize['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_FILE_SIZE, $fileSize['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($fileSize['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_FILE_SIZE, $fileSize['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_FILE_SIZE, $fileSize, $comparison);
    }

    /**
     * Filter the query on the datetime_file_load column
     *
     * Example usage:
     * <code>
     * $query->filterByDateTimeFileLoad('2011-03-14'); // WHERE datetime_file_load = '2011-03-14'
     * $query->filterByDateTimeFileLoad('now'); // WHERE datetime_file_load = '2011-03-14'
     * $query->filterByDateTimeFileLoad(array('max' => 'yesterday')); // WHERE datetime_file_load > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateTimeFileLoad The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByDateTimeFileLoad($dateTimeFileLoad = null, $comparison = null)
    {
        if (is_array($dateTimeFileLoad)) {
            $useMinMax = false;
            if (isset($dateTimeFileLoad['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_DATETIME_FILE_LOAD, $dateTimeFileLoad['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateTimeFileLoad['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_DATETIME_FILE_LOAD, $dateTimeFileLoad['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_DATETIME_FILE_LOAD, $dateTimeFileLoad, $comparison);
    }

    /**
     * Filter the query on the validate_markup column
     *
     * Example usage:
     * <code>
     * $query->filterByValidateMarkup(1234); // WHERE validate_markup = 1234
     * $query->filterByValidateMarkup(array(12, 34)); // WHERE validate_markup IN (12, 34)
     * $query->filterByValidateMarkup(array('min' => 12)); // WHERE validate_markup > 12
     * </code>
     *
     * @param     mixed $validateMarkup The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByValidateMarkup($validateMarkup = null, $comparison = null)
    {
        if (is_array($validateMarkup)) {
            $useMinMax = false;
            if (isset($validateMarkup['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_VALIDATE_MARKUP, $validateMarkup['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($validateMarkup['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_VALIDATE_MARKUP, $validateMarkup['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_VALIDATE_MARKUP, $validateMarkup, $comparison);
    }

    /**
     * Filter the query on the positions_count column
     *
     * Example usage:
     * <code>
     * $query->filterByPositionsCount(1234); // WHERE positions_count = 1234
     * $query->filterByPositionsCount(array(12, 34)); // WHERE positions_count IN (12, 34)
     * $query->filterByPositionsCount(array('min' => 12)); // WHERE positions_count > 12
     * </code>
     *
     * @param     mixed $positionsCount The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByPositionsCount($positionsCount = null, $comparison = null)
    {
        if (is_array($positionsCount)) {
            $useMinMax = false;
            if (isset($positionsCount['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_POSITIONS_COUNT, $positionsCount['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($positionsCount['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_POSITIONS_COUNT, $positionsCount['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_POSITIONS_COUNT, $positionsCount, $comparison);
    }

    /**
     * Filter the query on the analise_success_positions_count column
     *
     * Example usage:
     * <code>
     * $query->filterByAnaliseSuccessPositionsCount(1234); // WHERE analise_success_positions_count = 1234
     * $query->filterByAnaliseSuccessPositionsCount(array(12, 34)); // WHERE analise_success_positions_count IN (12, 34)
     * $query->filterByAnaliseSuccessPositionsCount(array('min' => 12)); // WHERE analise_success_positions_count > 12
     * </code>
     *
     * @param     mixed $analiseSuccessPositionsCount The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByAnaliseSuccessPositionsCount($analiseSuccessPositionsCount = null, $comparison = null)
    {
        if (is_array($analiseSuccessPositionsCount)) {
            $useMinMax = false;
            if (isset($analiseSuccessPositionsCount['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT, $analiseSuccessPositionsCount['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($analiseSuccessPositionsCount['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT, $analiseSuccessPositionsCount['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT, $analiseSuccessPositionsCount, $comparison);
    }

    /**
     * Filter the query on the analise_ignore_positions_count column
     *
     * Example usage:
     * <code>
     * $query->filterByAnaliseIgnorePositionsCount(1234); // WHERE analise_ignore_positions_count = 1234
     * $query->filterByAnaliseIgnorePositionsCount(array(12, 34)); // WHERE analise_ignore_positions_count IN (12, 34)
     * $query->filterByAnaliseIgnorePositionsCount(array('min' => 12)); // WHERE analise_ignore_positions_count > 12
     * </code>
     *
     * @param     mixed $analiseIgnorePositionsCount The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByAnaliseIgnorePositionsCount($analiseIgnorePositionsCount = null, $comparison = null)
    {
        if (is_array($analiseIgnorePositionsCount)) {
            $useMinMax = false;
            if (isset($analiseIgnorePositionsCount['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT, $analiseIgnorePositionsCount['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($analiseIgnorePositionsCount['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT, $analiseIgnorePositionsCount['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT, $analiseIgnorePositionsCount, $comparison);
    }

    /**
     * Filter the query on the datetime_price_commit column
     *
     * Example usage:
     * <code>
     * $query->filterByDateTimePriceCommit('2011-03-14'); // WHERE datetime_price_commit = '2011-03-14'
     * $query->filterByDateTimePriceCommit('now'); // WHERE datetime_price_commit = '2011-03-14'
     * $query->filterByDateTimePriceCommit(array('max' => 'yesterday')); // WHERE datetime_price_commit > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateTimePriceCommit The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByDateTimePriceCommit($dateTimePriceCommit = null, $comparison = null)
    {
        if (is_array($dateTimePriceCommit)) {
            $useMinMax = false;
            if (isset($dateTimePriceCommit['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_DATETIME_PRICE_COMMIT, $dateTimePriceCommit['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateTimePriceCommit['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_DATETIME_PRICE_COMMIT, $dateTimePriceCommit['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_DATETIME_PRICE_COMMIT, $dateTimePriceCommit, $comparison);
    }

    /**
     * Filter the query on the status column
     *
     * Example usage:
     * <code>
     * $query->filterByStatus(1234); // WHERE status = 1234
     * $query->filterByStatus(array(12, 34)); // WHERE status IN (12, 34)
     * $query->filterByStatus(array('min' => 12)); // WHERE status > 12
     * </code>
     *
     * @param     mixed $status The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByStatus($status = null, $comparison = null)
    {
        if (is_array($status)) {
            $useMinMax = false;
            if (isset($status['min'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_STATUS, $status['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($status['max'])) {
                $this->addUsingAlias(SyncStatTableMap::COL_STATUS, $status['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_STATUS, $status, $comparison);
    }

    /**
     * Filter the query on the status_msg column
     *
     * Example usage:
     * <code>
     * $query->filterByStatusMessage('fooValue');   // WHERE status_msg = 'fooValue'
     * $query->filterByStatusMessage('%fooValue%', Criteria::LIKE); // WHERE status_msg LIKE '%fooValue%'
     * </code>
     *
     * @param     string $statusMessage The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function filterByStatusMessage($statusMessage = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($statusMessage)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncStatTableMap::COL_STATUS_MSG, $statusMessage, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   ChildSyncStat $syncStat Object to remove from the list of results
     *
     * @return $this|ChildSyncStatQuery The current query, for fluid interface
     */
    public function prune($syncStat = null)
    {
        if ($syncStat) {
            $this->addUsingAlias(SyncStatTableMap::COL_ID, $syncStat->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the local_sync_stat table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncStatTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            SyncStatTableMap::clearInstancePool();
            SyncStatTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncStatTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(SyncStatTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            SyncStatTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            SyncStatTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // SyncStatQuery
