<?php

namespace PartScanner\Infrastructure\Models\SyncStat\Base;

use \DateTime;
use \Exception;
use \PDO;
use PartScanner\Infrastructure\Models\SyncStat\SyncStatQuery as ChildSyncStatQuery;
use PartScanner\Infrastructure\Models\SyncStat\Map\SyncStatTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;

/**
 * Base class that represents a row from the 'local_sync_stat' table.
 *
 *
 *
 * @package    propel.generator.Models.SyncStat.Base
 */
abstract class SyncStat implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\PartScanner\\Infrastructure\\Models\\SyncStat\\Map\\SyncStatTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the datetime field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime
     */
    protected $datetime;

    /**
     * The value for the assortment_id field.
     *
     * @var        int
     */
    protected $assortment_id;

    /**
     * The value for the price_list_id field.
     *
     * @var        int
     */
    protected $price_list_id;

    /**
     * The value for the file field.
     *
     * @var        string
     */
    protected $file;

    /**
     * The value for the file_size field.
     *
     * @var        int
     */
    protected $file_size;

    /**
     * The value for the datetime_file_load field.
     *
     * @var        DateTime
     */
    protected $datetime_file_load;

    /**
     * The value for the validate_markup field.
     *
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $validate_markup;

    /**
     * The value for the positions_count field.
     *
     * @var        int
     */
    protected $positions_count;

    /**
     * The value for the analise_success_positions_count field.
     *
     * @var        int
     */
    protected $analise_success_positions_count;

    /**
     * The value for the analise_ignore_positions_count field.
     *
     * @var        int
     */
    protected $analise_ignore_positions_count;

    /**
     * The value for the datetime_price_commit field.
     *
     * @var        DateTime
     */
    protected $datetime_price_commit;

    /**
     * The value for the status field.
     *
     * @var        int
     */
    protected $status;

    /**
     * The value for the status_msg field.
     *
     * @var        string
     */
    protected $status_msg;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues()
    {
        $this->validate_markup = 0;
    }

    /**
     * Initializes internal state of PartScanner\Infrastructure\Models\SyncStat\Base\SyncStat object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>SyncStat</code> instance.  If
     * <code>obj</code> is an instance of <code>SyncStat</code>, delegates to
     * <code>equals(SyncStat)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|SyncStat The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [optionally formatted] temporal [datetime] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDateTime($format = NULL)
    {
        if ($format === null) {
            return $this->datetime;
        } else {
            return $this->datetime instanceof \DateTimeInterface ? $this->datetime->format($format) : null;
        }
    }

    /**
     * Get the [assortment_id] column value.
     *
     * @return int
     */
    public function getAssortmentId()
    {
        return $this->assortment_id;
    }

    /**
     * Get the [price_list_id] column value.
     *
     * @return int
     */
    public function getPriceListId()
    {
        return $this->price_list_id;
    }

    /**
     * Get the [file] column value.
     *
     * @return string
     */
    public function getFile()
    {
        return $this->file;
    }

    /**
     * Get the [file_size] column value.
     *
     * @return int
     */
    public function getFileSize()
    {
        return $this->file_size;
    }

    /**
     * Get the [optionally formatted] temporal [datetime_file_load] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDateTimeFileLoad($format = NULL)
    {
        if ($format === null) {
            return $this->datetime_file_load;
        } else {
            return $this->datetime_file_load instanceof \DateTimeInterface ? $this->datetime_file_load->format($format) : null;
        }
    }

    /**
     * Get the [validate_markup] column value.
     *
     * @return int
     */
    public function getValidateMarkup()
    {
        return $this->validate_markup;
    }

    /**
     * Get the [positions_count] column value.
     *
     * @return int
     */
    public function getPositionsCount()
    {
        return $this->positions_count;
    }

    /**
     * Get the [analise_success_positions_count] column value.
     *
     * @return int
     */
    public function getAnaliseSuccessPositionsCount()
    {
        return $this->analise_success_positions_count;
    }

    /**
     * Get the [analise_ignore_positions_count] column value.
     *
     * @return int
     */
    public function getAnaliseIgnorePositionsCount()
    {
        return $this->analise_ignore_positions_count;
    }

    /**
     * Get the [optionally formatted] temporal [datetime_price_commit] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getDateTimePriceCommit($format = NULL)
    {
        if ($format === null) {
            return $this->datetime_price_commit;
        } else {
            return $this->datetime_price_commit instanceof \DateTimeInterface ? $this->datetime_price_commit->format($format) : null;
        }
    }

    /**
     * Get the [status] column value.
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Get the [status_msg] column value.
     *
     * @return string
     */
    public function getStatusMessage()
    {
        return $this->status_msg;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_ID] = true;
        }

        return $this;
    } // setId()

    /**
     * Sets the value of [datetime] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setDateTime($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datetime !== null || $dt !== null) {
            if ($this->datetime === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->datetime->format("Y-m-d H:i:s.u")) {
                $this->datetime = $dt === null ? null : clone $dt;
                $this->modifiedColumns[SyncStatTableMap::COL_DATETIME] = true;
            }
        } // if either are not null

        return $this;
    } // setDateTime()

    /**
     * Set the value of [assortment_id] column.
     *
     * @param int $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setAssortmentId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->assortment_id !== $v) {
            $this->assortment_id = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_ASSORTMENT_ID] = true;
        }

        return $this;
    } // setAssortmentId()

    /**
     * Set the value of [price_list_id] column.
     *
     * @param int $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setPriceListId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->price_list_id !== $v) {
            $this->price_list_id = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_PRICE_LIST_ID] = true;
        }

        return $this;
    } // setPriceListId()

    /**
     * Set the value of [file] column.
     *
     * @param string $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setFile($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->file !== $v) {
            $this->file = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_FILE] = true;
        }

        return $this;
    } // setFile()

    /**
     * Set the value of [file_size] column.
     *
     * @param int $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setFileSize($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->file_size !== $v) {
            $this->file_size = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_FILE_SIZE] = true;
        }

        return $this;
    } // setFileSize()

    /**
     * Sets the value of [datetime_file_load] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setDateTimeFileLoad($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datetime_file_load !== null || $dt !== null) {
            if ($this->datetime_file_load === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->datetime_file_load->format("Y-m-d H:i:s.u")) {
                $this->datetime_file_load = $dt === null ? null : clone $dt;
                $this->modifiedColumns[SyncStatTableMap::COL_DATETIME_FILE_LOAD] = true;
            }
        } // if either are not null

        return $this;
    } // setDateTimeFileLoad()

    /**
     * Set the value of [validate_markup] column.
     *
     * @param int $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setValidateMarkup($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->validate_markup !== $v) {
            $this->validate_markup = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_VALIDATE_MARKUP] = true;
        }

        return $this;
    } // setValidateMarkup()

    /**
     * Set the value of [positions_count] column.
     *
     * @param int $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setPositionsCount($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->positions_count !== $v) {
            $this->positions_count = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_POSITIONS_COUNT] = true;
        }

        return $this;
    } // setPositionsCount()

    /**
     * Set the value of [analise_success_positions_count] column.
     *
     * @param int $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setAnaliseSuccessPositionsCount($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->analise_success_positions_count !== $v) {
            $this->analise_success_positions_count = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT] = true;
        }

        return $this;
    } // setAnaliseSuccessPositionsCount()

    /**
     * Set the value of [analise_ignore_positions_count] column.
     *
     * @param int $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setAnaliseIgnorePositionsCount($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->analise_ignore_positions_count !== $v) {
            $this->analise_ignore_positions_count = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT] = true;
        }

        return $this;
    } // setAnaliseIgnorePositionsCount()

    /**
     * Sets the value of [datetime_price_commit] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setDateTimePriceCommit($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datetime_price_commit !== null || $dt !== null) {
            if ($this->datetime_price_commit === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->datetime_price_commit->format("Y-m-d H:i:s.u")) {
                $this->datetime_price_commit = $dt === null ? null : clone $dt;
                $this->modifiedColumns[SyncStatTableMap::COL_DATETIME_PRICE_COMMIT] = true;
            }
        } // if either are not null

        return $this;
    } // setDateTimePriceCommit()

    /**
     * Set the value of [status] column.
     *
     * @param int $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setStatus($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->status !== $v) {
            $this->status = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_STATUS] = true;
        }

        return $this;
    } // setStatus()

    /**
     * Set the value of [status_msg] column.
     *
     * @param string $v new value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object (for fluent API support)
     */
    public function setStatusMessage($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->status_msg !== $v) {
            $this->status_msg = $v;
            $this->modifiedColumns[SyncStatTableMap::COL_STATUS_MSG] = true;
        }

        return $this;
    } // setStatusMessage()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->validate_markup !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : SyncStatTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : SyncStatTableMap::translateFieldName('DateTime', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->datetime = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : SyncStatTableMap::translateFieldName('AssortmentId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->assortment_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : SyncStatTableMap::translateFieldName('PriceListId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->price_list_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : SyncStatTableMap::translateFieldName('File', TableMap::TYPE_PHPNAME, $indexType)];
            $this->file = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : SyncStatTableMap::translateFieldName('FileSize', TableMap::TYPE_PHPNAME, $indexType)];
            $this->file_size = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : SyncStatTableMap::translateFieldName('DateTimeFileLoad', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->datetime_file_load = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : SyncStatTableMap::translateFieldName('ValidateMarkup', TableMap::TYPE_PHPNAME, $indexType)];
            $this->validate_markup = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : SyncStatTableMap::translateFieldName('PositionsCount', TableMap::TYPE_PHPNAME, $indexType)];
            $this->positions_count = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : SyncStatTableMap::translateFieldName('AnaliseSuccessPositionsCount', TableMap::TYPE_PHPNAME, $indexType)];
            $this->analise_success_positions_count = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : SyncStatTableMap::translateFieldName('AnaliseIgnorePositionsCount', TableMap::TYPE_PHPNAME, $indexType)];
            $this->analise_ignore_positions_count = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : SyncStatTableMap::translateFieldName('DateTimePriceCommit', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->datetime_price_commit = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 12 + $startcol : SyncStatTableMap::translateFieldName('Status', TableMap::TYPE_PHPNAME, $indexType)];
            $this->status = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 13 + $startcol : SyncStatTableMap::translateFieldName('StatusMessage', TableMap::TYPE_PHPNAME, $indexType)];
            $this->status_msg = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 14; // 14 = SyncStatTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\PartScanner\\Infrastructure\\Models\\SyncStat\\SyncStat'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(SyncStatTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildSyncStatQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see SyncStat::setDeleted()
     * @see SyncStat::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncStatTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildSyncStatQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncStatTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                SyncStatTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[SyncStatTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . SyncStatTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(SyncStatTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_DATETIME)) {
            $modifiedColumns[':p' . $index++]  = '`datetime`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_ASSORTMENT_ID)) {
            $modifiedColumns[':p' . $index++]  = '`assortment_id`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_PRICE_LIST_ID)) {
            $modifiedColumns[':p' . $index++]  = '`price_list_id`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_FILE)) {
            $modifiedColumns[':p' . $index++]  = '`file`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_FILE_SIZE)) {
            $modifiedColumns[':p' . $index++]  = '`file_size`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_DATETIME_FILE_LOAD)) {
            $modifiedColumns[':p' . $index++]  = '`datetime_file_load`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_VALIDATE_MARKUP)) {
            $modifiedColumns[':p' . $index++]  = '`validate_markup`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_POSITIONS_COUNT)) {
            $modifiedColumns[':p' . $index++]  = '`positions_count`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT)) {
            $modifiedColumns[':p' . $index++]  = '`analise_success_positions_count`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT)) {
            $modifiedColumns[':p' . $index++]  = '`analise_ignore_positions_count`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_DATETIME_PRICE_COMMIT)) {
            $modifiedColumns[':p' . $index++]  = '`datetime_price_commit`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_STATUS)) {
            $modifiedColumns[':p' . $index++]  = '`status`';
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_STATUS_MSG)) {
            $modifiedColumns[':p' . $index++]  = '`status_msg`';
        }

        $sql = sprintf(
            'INSERT INTO `local_sync_stat` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`datetime`':
                        $stmt->bindValue($identifier, $this->datetime ? $this->datetime->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`assortment_id`':
                        $stmt->bindValue($identifier, $this->assortment_id, PDO::PARAM_INT);
                        break;
                    case '`price_list_id`':
                        $stmt->bindValue($identifier, $this->price_list_id, PDO::PARAM_INT);
                        break;
                    case '`file`':
                        $stmt->bindValue($identifier, $this->file, PDO::PARAM_STR);
                        break;
                    case '`file_size`':
                        $stmt->bindValue($identifier, $this->file_size, PDO::PARAM_INT);
                        break;
                    case '`datetime_file_load`':
                        $stmt->bindValue($identifier, $this->datetime_file_load ? $this->datetime_file_load->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`validate_markup`':
                        $stmt->bindValue($identifier, $this->validate_markup, PDO::PARAM_INT);
                        break;
                    case '`positions_count`':
                        $stmt->bindValue($identifier, $this->positions_count, PDO::PARAM_INT);
                        break;
                    case '`analise_success_positions_count`':
                        $stmt->bindValue($identifier, $this->analise_success_positions_count, PDO::PARAM_INT);
                        break;
                    case '`analise_ignore_positions_count`':
                        $stmt->bindValue($identifier, $this->analise_ignore_positions_count, PDO::PARAM_INT);
                        break;
                    case '`datetime_price_commit`':
                        $stmt->bindValue($identifier, $this->datetime_price_commit ? $this->datetime_price_commit->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`status`':
                        $stmt->bindValue($identifier, $this->status, PDO::PARAM_INT);
                        break;
                    case '`status_msg`':
                        $stmt->bindValue($identifier, $this->status_msg, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = SyncStatTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getDateTime();
                break;
            case 2:
                return $this->getAssortmentId();
                break;
            case 3:
                return $this->getPriceListId();
                break;
            case 4:
                return $this->getFile();
                break;
            case 5:
                return $this->getFileSize();
                break;
            case 6:
                return $this->getDateTimeFileLoad();
                break;
            case 7:
                return $this->getValidateMarkup();
                break;
            case 8:
                return $this->getPositionsCount();
                break;
            case 9:
                return $this->getAnaliseSuccessPositionsCount();
                break;
            case 10:
                return $this->getAnaliseIgnorePositionsCount();
                break;
            case 11:
                return $this->getDateTimePriceCommit();
                break;
            case 12:
                return $this->getStatus();
                break;
            case 13:
                return $this->getStatusMessage();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array())
    {

        if (isset($alreadyDumpedObjects['SyncStat'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['SyncStat'][$this->hashCode()] = true;
        $keys = SyncStatTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getDateTime(),
            $keys[2] => $this->getAssortmentId(),
            $keys[3] => $this->getPriceListId(),
            $keys[4] => $this->getFile(),
            $keys[5] => $this->getFileSize(),
            $keys[6] => $this->getDateTimeFileLoad(),
            $keys[7] => $this->getValidateMarkup(),
            $keys[8] => $this->getPositionsCount(),
            $keys[9] => $this->getAnaliseSuccessPositionsCount(),
            $keys[10] => $this->getAnaliseIgnorePositionsCount(),
            $keys[11] => $this->getDateTimePriceCommit(),
            $keys[12] => $this->getStatus(),
            $keys[13] => $this->getStatusMessage(),
        );
        if ($result[$keys[1]] instanceof \DateTimeInterface) {
            $result[$keys[1]] = $result[$keys[1]]->format('c');
        }

        if ($result[$keys[6]] instanceof \DateTimeInterface) {
            $result[$keys[6]] = $result[$keys[6]]->format('c');
        }

        if ($result[$keys[11]] instanceof \DateTimeInterface) {
            $result[$keys[11]] = $result[$keys[11]]->format('c');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }


        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = SyncStatTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setDateTime($value);
                break;
            case 2:
                $this->setAssortmentId($value);
                break;
            case 3:
                $this->setPriceListId($value);
                break;
            case 4:
                $this->setFile($value);
                break;
            case 5:
                $this->setFileSize($value);
                break;
            case 6:
                $this->setDateTimeFileLoad($value);
                break;
            case 7:
                $this->setValidateMarkup($value);
                break;
            case 8:
                $this->setPositionsCount($value);
                break;
            case 9:
                $this->setAnaliseSuccessPositionsCount($value);
                break;
            case 10:
                $this->setAnaliseIgnorePositionsCount($value);
                break;
            case 11:
                $this->setDateTimePriceCommit($value);
                break;
            case 12:
                $this->setStatus($value);
                break;
            case 13:
                $this->setStatusMessage($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = SyncStatTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setDateTime($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setAssortmentId($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setPriceListId($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setFile($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setFileSize($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setDateTimeFileLoad($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setValidateMarkup($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setPositionsCount($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setAnaliseSuccessPositionsCount($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setAnaliseIgnorePositionsCount($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setDateTimePriceCommit($arr[$keys[11]]);
        }
        if (array_key_exists($keys[12], $arr)) {
            $this->setStatus($arr[$keys[12]]);
        }
        if (array_key_exists($keys[13], $arr)) {
            $this->setStatusMessage($arr[$keys[13]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\PartScanner\Infrastructure\Models\SyncStat\SyncStat The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(SyncStatTableMap::DATABASE_NAME);

        if ($this->isColumnModified(SyncStatTableMap::COL_ID)) {
            $criteria->add(SyncStatTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_DATETIME)) {
            $criteria->add(SyncStatTableMap::COL_DATETIME, $this->datetime);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_ASSORTMENT_ID)) {
            $criteria->add(SyncStatTableMap::COL_ASSORTMENT_ID, $this->assortment_id);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_PRICE_LIST_ID)) {
            $criteria->add(SyncStatTableMap::COL_PRICE_LIST_ID, $this->price_list_id);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_FILE)) {
            $criteria->add(SyncStatTableMap::COL_FILE, $this->file);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_FILE_SIZE)) {
            $criteria->add(SyncStatTableMap::COL_FILE_SIZE, $this->file_size);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_DATETIME_FILE_LOAD)) {
            $criteria->add(SyncStatTableMap::COL_DATETIME_FILE_LOAD, $this->datetime_file_load);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_VALIDATE_MARKUP)) {
            $criteria->add(SyncStatTableMap::COL_VALIDATE_MARKUP, $this->validate_markup);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_POSITIONS_COUNT)) {
            $criteria->add(SyncStatTableMap::COL_POSITIONS_COUNT, $this->positions_count);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT)) {
            $criteria->add(SyncStatTableMap::COL_ANALISE_SUCCESS_POSITIONS_COUNT, $this->analise_success_positions_count);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT)) {
            $criteria->add(SyncStatTableMap::COL_ANALISE_IGNORE_POSITIONS_COUNT, $this->analise_ignore_positions_count);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_DATETIME_PRICE_COMMIT)) {
            $criteria->add(SyncStatTableMap::COL_DATETIME_PRICE_COMMIT, $this->datetime_price_commit);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_STATUS)) {
            $criteria->add(SyncStatTableMap::COL_STATUS, $this->status);
        }
        if ($this->isColumnModified(SyncStatTableMap::COL_STATUS_MSG)) {
            $criteria->add(SyncStatTableMap::COL_STATUS_MSG, $this->status_msg);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildSyncStatQuery::create();
        $criteria->add(SyncStatTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \PartScanner\Infrastructure\Models\SyncStat\SyncStat (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setDateTime($this->getDateTime());
        $copyObj->setAssortmentId($this->getAssortmentId());
        $copyObj->setPriceListId($this->getPriceListId());
        $copyObj->setFile($this->getFile());
        $copyObj->setFileSize($this->getFileSize());
        $copyObj->setDateTimeFileLoad($this->getDateTimeFileLoad());
        $copyObj->setValidateMarkup($this->getValidateMarkup());
        $copyObj->setPositionsCount($this->getPositionsCount());
        $copyObj->setAnaliseSuccessPositionsCount($this->getAnaliseSuccessPositionsCount());
        $copyObj->setAnaliseIgnorePositionsCount($this->getAnaliseIgnorePositionsCount());
        $copyObj->setDateTimePriceCommit($this->getDateTimePriceCommit());
        $copyObj->setStatus($this->getStatus());
        $copyObj->setStatusMessage($this->getStatusMessage());
        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \PartScanner\Infrastructure\Models\SyncStat\SyncStat Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        $this->id = null;
        $this->datetime = null;
        $this->assortment_id = null;
        $this->price_list_id = null;
        $this->file = null;
        $this->file_size = null;
        $this->datetime_file_load = null;
        $this->validate_markup = null;
        $this->positions_count = null;
        $this->analise_success_positions_count = null;
        $this->analise_ignore_positions_count = null;
        $this->datetime_price_commit = null;
        $this->status = null;
        $this->status_msg = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(SyncStatTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
