<?php

namespace PartScanner\Infrastructure\Models\SyncRequest\Map;

use PartScanner\Infrastructure\Models\SyncRequest\SyncRequest;
use PartScanner\Infrastructure\Models\SyncRequest\SyncRequestQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'local_sync_request' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class SyncRequestTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.SyncRequest.Map.SyncRequestTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'local_sync_request';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\PartScanner\\Infrastructure\\Models\\SyncRequest\\SyncRequest';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.SyncRequest.SyncRequest';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 11;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 11;

    /**
     * the column name for the id field
     */
    const COL_ID = 'local_sync_request.id';

    /**
     * the column name for the created_at field
     */
    const COL_CREATED_AT = 'local_sync_request.created_at';

    /**
     * the column name for the is_work field
     */
    const COL_IS_WORK = 'local_sync_request.is_work';

    /**
     * the column name for the count_positions field
     */
    const COL_COUNT_POSITIONS = 'local_sync_request.count_positions';

    /**
     * the column name for the work_start_at field
     */
    const COL_WORK_START_AT = 'local_sync_request.work_start_at';

    /**
     * the column name for the work_finish_at field
     */
    const COL_WORK_FINISH_AT = 'local_sync_request.work_finish_at';

    /**
     * the column name for the assortment_id field
     */
    const COL_ASSORTMENT_ID = 'local_sync_request.assortment_id';

    /**
     * the column name for the filter_brand_id field
     */
    const COL_FILTER_BRAND_ID = 'local_sync_request.filter_brand_id';

    /**
     * the column name for the filter_price_list_id field
     */
    const COL_FILTER_PRICE_LIST_ID = 'local_sync_request.filter_price_list_id';

    /**
     * the column name for the filter_auto_detecting field
     */
    const COL_FILTER_AUTO_DETECTING = 'local_sync_request.filter_auto_detecting';

    /**
     * the column name for the filter_mode field
     */
    const COL_FILTER_MODE = 'local_sync_request.filter_mode';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'CreatedAt', 'IsWork', 'CountPositions', 'WorkStartAt', 'WorkFinishAt', 'AssortmentId', 'FilterBrandId', 'FilterPriceListId', 'FilterAutoDetecting', 'FilterMode', ),
        self::TYPE_CAMELNAME     => array('id', 'createdAt', 'isWork', 'countPositions', 'workStartAt', 'workFinishAt', 'assortmentId', 'filterBrandId', 'filterPriceListId', 'filterAutoDetecting', 'filterMode', ),
        self::TYPE_COLNAME       => array(SyncRequestTableMap::COL_ID, SyncRequestTableMap::COL_CREATED_AT, SyncRequestTableMap::COL_IS_WORK, SyncRequestTableMap::COL_COUNT_POSITIONS, SyncRequestTableMap::COL_WORK_START_AT, SyncRequestTableMap::COL_WORK_FINISH_AT, SyncRequestTableMap::COL_ASSORTMENT_ID, SyncRequestTableMap::COL_FILTER_BRAND_ID, SyncRequestTableMap::COL_FILTER_PRICE_LIST_ID, SyncRequestTableMap::COL_FILTER_AUTO_DETECTING, SyncRequestTableMap::COL_FILTER_MODE, ),
        self::TYPE_FIELDNAME     => array('id', 'created_at', 'is_work', 'count_positions', 'work_start_at', 'work_finish_at', 'assortment_id', 'filter_brand_id', 'filter_price_list_id', 'filter_auto_detecting', 'filter_mode', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'CreatedAt' => 1, 'IsWork' => 2, 'CountPositions' => 3, 'WorkStartAt' => 4, 'WorkFinishAt' => 5, 'AssortmentId' => 6, 'FilterBrandId' => 7, 'FilterPriceListId' => 8, 'FilterAutoDetecting' => 9, 'FilterMode' => 10, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'createdAt' => 1, 'isWork' => 2, 'countPositions' => 3, 'workStartAt' => 4, 'workFinishAt' => 5, 'assortmentId' => 6, 'filterBrandId' => 7, 'filterPriceListId' => 8, 'filterAutoDetecting' => 9, 'filterMode' => 10, ),
        self::TYPE_COLNAME       => array(SyncRequestTableMap::COL_ID => 0, SyncRequestTableMap::COL_CREATED_AT => 1, SyncRequestTableMap::COL_IS_WORK => 2, SyncRequestTableMap::COL_COUNT_POSITIONS => 3, SyncRequestTableMap::COL_WORK_START_AT => 4, SyncRequestTableMap::COL_WORK_FINISH_AT => 5, SyncRequestTableMap::COL_ASSORTMENT_ID => 6, SyncRequestTableMap::COL_FILTER_BRAND_ID => 7, SyncRequestTableMap::COL_FILTER_PRICE_LIST_ID => 8, SyncRequestTableMap::COL_FILTER_AUTO_DETECTING => 9, SyncRequestTableMap::COL_FILTER_MODE => 10, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'created_at' => 1, 'is_work' => 2, 'count_positions' => 3, 'work_start_at' => 4, 'work_finish_at' => 5, 'assortment_id' => 6, 'filter_brand_id' => 7, 'filter_price_list_id' => 8, 'filter_auto_detecting' => 9, 'filter_mode' => 10, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('local_sync_request');
        $this->setPhpName('SyncRequest');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\PartScanner\\Infrastructure\\Models\\SyncRequest\\SyncRequest');
        $this->setPackage('Models.SyncRequest');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('created_at', 'CreatedAt', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('is_work', 'IsWork', 'TINYINT', true, null, 0);
        $this->addColumn('count_positions', 'CountPositions', 'INTEGER', false, null, null);
        $this->addColumn('work_start_at', 'WorkStartAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('work_finish_at', 'WorkFinishAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('assortment_id', 'AssortmentId', 'INTEGER', true, null, null);
        $this->addColumn('filter_brand_id', 'FilterBrandId', 'INTEGER', false, null, null);
        $this->addColumn('filter_price_list_id', 'FilterPriceListId', 'INTEGER', false, null, null);
        $this->addColumn('filter_auto_detecting', 'FilterAutoDetecting', 'TINYINT', false, null, null);
        $this->addColumn('filter_mode', 'FilterMode', 'CHAR', true, null, 'none');
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('SyncDraft', '\\PartScanner\\Infrastructure\\Models\\SyncDraft\\SyncDraft', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':request_id',
    1 => ':id',
  ),
), null, null, 'SyncDrafts', false);
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? SyncRequestTableMap::CLASS_DEFAULT : SyncRequestTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (SyncRequest object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = SyncRequestTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = SyncRequestTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + SyncRequestTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = SyncRequestTableMap::OM_CLASS;
            /** @var SyncRequest $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            SyncRequestTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = SyncRequestTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = SyncRequestTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var SyncRequest $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                SyncRequestTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(SyncRequestTableMap::COL_ID);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_CREATED_AT);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_IS_WORK);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_COUNT_POSITIONS);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_WORK_START_AT);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_WORK_FINISH_AT);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_ASSORTMENT_ID);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_FILTER_BRAND_ID);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_FILTER_PRICE_LIST_ID);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_FILTER_AUTO_DETECTING);
            $criteria->addSelectColumn(SyncRequestTableMap::COL_FILTER_MODE);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.created_at');
            $criteria->addSelectColumn($alias . '.is_work');
            $criteria->addSelectColumn($alias . '.count_positions');
            $criteria->addSelectColumn($alias . '.work_start_at');
            $criteria->addSelectColumn($alias . '.work_finish_at');
            $criteria->addSelectColumn($alias . '.assortment_id');
            $criteria->addSelectColumn($alias . '.filter_brand_id');
            $criteria->addSelectColumn($alias . '.filter_price_list_id');
            $criteria->addSelectColumn($alias . '.filter_auto_detecting');
            $criteria->addSelectColumn($alias . '.filter_mode');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(SyncRequestTableMap::DATABASE_NAME)->getTable(SyncRequestTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(SyncRequestTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(SyncRequestTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new SyncRequestTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a SyncRequest or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or SyncRequest object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncRequestTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \PartScanner\Infrastructure\Models\SyncRequest\SyncRequest) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(SyncRequestTableMap::DATABASE_NAME);
            $criteria->add(SyncRequestTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = SyncRequestQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            SyncRequestTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                SyncRequestTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the local_sync_request table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return SyncRequestQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a SyncRequest or Criteria object.
     *
     * @param mixed               $criteria Criteria or SyncRequest object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncRequestTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from SyncRequest object
        }

        if ($criteria->containsKey(SyncRequestTableMap::COL_ID) && $criteria->keyContainsValue(SyncRequestTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.SyncRequestTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = SyncRequestQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // SyncRequestTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
SyncRequestTableMap::buildTableMap();
