<?php

namespace PartScanner\Infrastructure\Models\SyncRequest\Base;

use \Exception;
use \PDO;
use PartScanner\Infrastructure\Models\SyncDraft\SyncDraft;
use PartScanner\Infrastructure\Models\SyncRequest\SyncRequest as ChildSyncRequest;
use PartScanner\Infrastructure\Models\SyncRequest\SyncRequestQuery as ChildSyncRequestQuery;
use PartScanner\Infrastructure\Models\SyncRequest\Map\SyncRequestTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'local_sync_request' table.
 *
 *
 *
 * @method     ChildSyncRequestQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildSyncRequestQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method     ChildSyncRequestQuery orderByIsWork($order = Criteria::ASC) Order by the is_work column
 * @method     ChildSyncRequestQuery orderByCountPositions($order = Criteria::ASC) Order by the count_positions column
 * @method     ChildSyncRequestQuery orderByWorkStartAt($order = Criteria::ASC) Order by the work_start_at column
 * @method     ChildSyncRequestQuery orderByWorkFinishAt($order = Criteria::ASC) Order by the work_finish_at column
 * @method     ChildSyncRequestQuery orderByAssortmentId($order = Criteria::ASC) Order by the assortment_id column
 * @method     ChildSyncRequestQuery orderByFilterBrandId($order = Criteria::ASC) Order by the filter_brand_id column
 * @method     ChildSyncRequestQuery orderByFilterPriceListId($order = Criteria::ASC) Order by the filter_price_list_id column
 * @method     ChildSyncRequestQuery orderByFilterAutoDetecting($order = Criteria::ASC) Order by the filter_auto_detecting column
 * @method     ChildSyncRequestQuery orderByFilterMode($order = Criteria::ASC) Order by the filter_mode column
 *
 * @method     ChildSyncRequestQuery groupById() Group by the id column
 * @method     ChildSyncRequestQuery groupByCreatedAt() Group by the created_at column
 * @method     ChildSyncRequestQuery groupByIsWork() Group by the is_work column
 * @method     ChildSyncRequestQuery groupByCountPositions() Group by the count_positions column
 * @method     ChildSyncRequestQuery groupByWorkStartAt() Group by the work_start_at column
 * @method     ChildSyncRequestQuery groupByWorkFinishAt() Group by the work_finish_at column
 * @method     ChildSyncRequestQuery groupByAssortmentId() Group by the assortment_id column
 * @method     ChildSyncRequestQuery groupByFilterBrandId() Group by the filter_brand_id column
 * @method     ChildSyncRequestQuery groupByFilterPriceListId() Group by the filter_price_list_id column
 * @method     ChildSyncRequestQuery groupByFilterAutoDetecting() Group by the filter_auto_detecting column
 * @method     ChildSyncRequestQuery groupByFilterMode() Group by the filter_mode column
 *
 * @method     ChildSyncRequestQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildSyncRequestQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildSyncRequestQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildSyncRequestQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildSyncRequestQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildSyncRequestQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildSyncRequestQuery leftJoinSyncDraft($relationAlias = null) Adds a LEFT JOIN clause to the query using the SyncDraft relation
 * @method     ChildSyncRequestQuery rightJoinSyncDraft($relationAlias = null) Adds a RIGHT JOIN clause to the query using the SyncDraft relation
 * @method     ChildSyncRequestQuery innerJoinSyncDraft($relationAlias = null) Adds a INNER JOIN clause to the query using the SyncDraft relation
 *
 * @method     ChildSyncRequestQuery joinWithSyncDraft($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the SyncDraft relation
 *
 * @method     ChildSyncRequestQuery leftJoinWithSyncDraft() Adds a LEFT JOIN clause and with to the query using the SyncDraft relation
 * @method     ChildSyncRequestQuery rightJoinWithSyncDraft() Adds a RIGHT JOIN clause and with to the query using the SyncDraft relation
 * @method     ChildSyncRequestQuery innerJoinWithSyncDraft() Adds a INNER JOIN clause and with to the query using the SyncDraft relation
 *
 * @method     \PartScanner\Infrastructure\Models\SyncDraft\SyncDraftQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildSyncRequest findOne(ConnectionInterface $con = null) Return the first ChildSyncRequest matching the query
 * @method     ChildSyncRequest findOneOrCreate(ConnectionInterface $con = null) Return the first ChildSyncRequest matching the query, or a new ChildSyncRequest object populated from the query conditions when no match is found
 *
 * @method     ChildSyncRequest findOneById(int $id) Return the first ChildSyncRequest filtered by the id column
 * @method     ChildSyncRequest findOneByCreatedAt(string $created_at) Return the first ChildSyncRequest filtered by the created_at column
 * @method     ChildSyncRequest findOneByIsWork(int $is_work) Return the first ChildSyncRequest filtered by the is_work column
 * @method     ChildSyncRequest findOneByCountPositions(int $count_positions) Return the first ChildSyncRequest filtered by the count_positions column
 * @method     ChildSyncRequest findOneByWorkStartAt(string $work_start_at) Return the first ChildSyncRequest filtered by the work_start_at column
 * @method     ChildSyncRequest findOneByWorkFinishAt(string $work_finish_at) Return the first ChildSyncRequest filtered by the work_finish_at column
 * @method     ChildSyncRequest findOneByAssortmentId(int $assortment_id) Return the first ChildSyncRequest filtered by the assortment_id column
 * @method     ChildSyncRequest findOneByFilterBrandId(int $filter_brand_id) Return the first ChildSyncRequest filtered by the filter_brand_id column
 * @method     ChildSyncRequest findOneByFilterPriceListId(int $filter_price_list_id) Return the first ChildSyncRequest filtered by the filter_price_list_id column
 * @method     ChildSyncRequest findOneByFilterAutoDetecting(int $filter_auto_detecting) Return the first ChildSyncRequest filtered by the filter_auto_detecting column
 * @method     ChildSyncRequest findOneByFilterMode(string $filter_mode) Return the first ChildSyncRequest filtered by the filter_mode column *

 * @method     ChildSyncRequest requirePk($key, ConnectionInterface $con = null) Return the ChildSyncRequest by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOne(ConnectionInterface $con = null) Return the first ChildSyncRequest matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSyncRequest requireOneById(int $id) Return the first ChildSyncRequest filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByCreatedAt(string $created_at) Return the first ChildSyncRequest filtered by the created_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByIsWork(int $is_work) Return the first ChildSyncRequest filtered by the is_work column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByCountPositions(int $count_positions) Return the first ChildSyncRequest filtered by the count_positions column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByWorkStartAt(string $work_start_at) Return the first ChildSyncRequest filtered by the work_start_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByWorkFinishAt(string $work_finish_at) Return the first ChildSyncRequest filtered by the work_finish_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByAssortmentId(int $assortment_id) Return the first ChildSyncRequest filtered by the assortment_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByFilterBrandId(int $filter_brand_id) Return the first ChildSyncRequest filtered by the filter_brand_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByFilterPriceListId(int $filter_price_list_id) Return the first ChildSyncRequest filtered by the filter_price_list_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByFilterAutoDetecting(int $filter_auto_detecting) Return the first ChildSyncRequest filtered by the filter_auto_detecting column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncRequest requireOneByFilterMode(string $filter_mode) Return the first ChildSyncRequest filtered by the filter_mode column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSyncRequest[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildSyncRequest objects based on current ModelCriteria
 * @method     ChildSyncRequest[]|ObjectCollection findById(int $id) Return ChildSyncRequest objects filtered by the id column
 * @method     ChildSyncRequest[]|ObjectCollection findByCreatedAt(string $created_at) Return ChildSyncRequest objects filtered by the created_at column
 * @method     ChildSyncRequest[]|ObjectCollection findByIsWork(int $is_work) Return ChildSyncRequest objects filtered by the is_work column
 * @method     ChildSyncRequest[]|ObjectCollection findByCountPositions(int $count_positions) Return ChildSyncRequest objects filtered by the count_positions column
 * @method     ChildSyncRequest[]|ObjectCollection findByWorkStartAt(string $work_start_at) Return ChildSyncRequest objects filtered by the work_start_at column
 * @method     ChildSyncRequest[]|ObjectCollection findByWorkFinishAt(string $work_finish_at) Return ChildSyncRequest objects filtered by the work_finish_at column
 * @method     ChildSyncRequest[]|ObjectCollection findByAssortmentId(int $assortment_id) Return ChildSyncRequest objects filtered by the assortment_id column
 * @method     ChildSyncRequest[]|ObjectCollection findByFilterBrandId(int $filter_brand_id) Return ChildSyncRequest objects filtered by the filter_brand_id column
 * @method     ChildSyncRequest[]|ObjectCollection findByFilterPriceListId(int $filter_price_list_id) Return ChildSyncRequest objects filtered by the filter_price_list_id column
 * @method     ChildSyncRequest[]|ObjectCollection findByFilterAutoDetecting(int $filter_auto_detecting) Return ChildSyncRequest objects filtered by the filter_auto_detecting column
 * @method     ChildSyncRequest[]|ObjectCollection findByFilterMode(string $filter_mode) Return ChildSyncRequest objects filtered by the filter_mode column
 * @method     ChildSyncRequest[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class SyncRequestQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \PartScanner\Infrastructure\Models\SyncRequest\Base\SyncRequestQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\PartScanner\\Infrastructure\\Models\\SyncRequest\\SyncRequest', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildSyncRequestQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildSyncRequestQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildSyncRequestQuery) {
            return $criteria;
        }
        $query = new ChildSyncRequestQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildSyncRequest|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(SyncRequestTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = SyncRequestTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSyncRequest A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `created_at`, `is_work`, `count_positions`, `work_start_at`, `work_finish_at`, `assortment_id`, `filter_brand_id`, `filter_price_list_id`, `filter_auto_detecting`, `filter_mode` FROM `local_sync_request` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildSyncRequest $obj */
            $obj = new ChildSyncRequest();
            $obj->hydrate($row);
            SyncRequestTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildSyncRequest|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(SyncRequestTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(SyncRequestTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_CREATED_AT, $createdAt, $comparison);
    }

    /**
     * Filter the query on the is_work column
     *
     * Example usage:
     * <code>
     * $query->filterByIsWork(1234); // WHERE is_work = 1234
     * $query->filterByIsWork(array(12, 34)); // WHERE is_work IN (12, 34)
     * $query->filterByIsWork(array('min' => 12)); // WHERE is_work > 12
     * </code>
     *
     * @param     mixed $isWork The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByIsWork($isWork = null, $comparison = null)
    {
        if (is_array($isWork)) {
            $useMinMax = false;
            if (isset($isWork['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_IS_WORK, $isWork['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($isWork['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_IS_WORK, $isWork['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_IS_WORK, $isWork, $comparison);
    }

    /**
     * Filter the query on the count_positions column
     *
     * Example usage:
     * <code>
     * $query->filterByCountPositions(1234); // WHERE count_positions = 1234
     * $query->filterByCountPositions(array(12, 34)); // WHERE count_positions IN (12, 34)
     * $query->filterByCountPositions(array('min' => 12)); // WHERE count_positions > 12
     * </code>
     *
     * @param     mixed $countPositions The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByCountPositions($countPositions = null, $comparison = null)
    {
        if (is_array($countPositions)) {
            $useMinMax = false;
            if (isset($countPositions['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_COUNT_POSITIONS, $countPositions['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($countPositions['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_COUNT_POSITIONS, $countPositions['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_COUNT_POSITIONS, $countPositions, $comparison);
    }

    /**
     * Filter the query on the work_start_at column
     *
     * Example usage:
     * <code>
     * $query->filterByWorkStartAt('2011-03-14'); // WHERE work_start_at = '2011-03-14'
     * $query->filterByWorkStartAt('now'); // WHERE work_start_at = '2011-03-14'
     * $query->filterByWorkStartAt(array('max' => 'yesterday')); // WHERE work_start_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $workStartAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByWorkStartAt($workStartAt = null, $comparison = null)
    {
        if (is_array($workStartAt)) {
            $useMinMax = false;
            if (isset($workStartAt['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_WORK_START_AT, $workStartAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($workStartAt['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_WORK_START_AT, $workStartAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_WORK_START_AT, $workStartAt, $comparison);
    }

    /**
     * Filter the query on the work_finish_at column
     *
     * Example usage:
     * <code>
     * $query->filterByWorkFinishAt('2011-03-14'); // WHERE work_finish_at = '2011-03-14'
     * $query->filterByWorkFinishAt('now'); // WHERE work_finish_at = '2011-03-14'
     * $query->filterByWorkFinishAt(array('max' => 'yesterday')); // WHERE work_finish_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $workFinishAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByWorkFinishAt($workFinishAt = null, $comparison = null)
    {
        if (is_array($workFinishAt)) {
            $useMinMax = false;
            if (isset($workFinishAt['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_WORK_FINISH_AT, $workFinishAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($workFinishAt['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_WORK_FINISH_AT, $workFinishAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_WORK_FINISH_AT, $workFinishAt, $comparison);
    }

    /**
     * Filter the query on the assortment_id column
     *
     * Example usage:
     * <code>
     * $query->filterByAssortmentId(1234); // WHERE assortment_id = 1234
     * $query->filterByAssortmentId(array(12, 34)); // WHERE assortment_id IN (12, 34)
     * $query->filterByAssortmentId(array('min' => 12)); // WHERE assortment_id > 12
     * </code>
     *
     * @param     mixed $assortmentId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByAssortmentId($assortmentId = null, $comparison = null)
    {
        if (is_array($assortmentId)) {
            $useMinMax = false;
            if (isset($assortmentId['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_ASSORTMENT_ID, $assortmentId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($assortmentId['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_ASSORTMENT_ID, $assortmentId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_ASSORTMENT_ID, $assortmentId, $comparison);
    }

    /**
     * Filter the query on the filter_brand_id column
     *
     * Example usage:
     * <code>
     * $query->filterByFilterBrandId(1234); // WHERE filter_brand_id = 1234
     * $query->filterByFilterBrandId(array(12, 34)); // WHERE filter_brand_id IN (12, 34)
     * $query->filterByFilterBrandId(array('min' => 12)); // WHERE filter_brand_id > 12
     * </code>
     *
     * @param     mixed $filterBrandId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByFilterBrandId($filterBrandId = null, $comparison = null)
    {
        if (is_array($filterBrandId)) {
            $useMinMax = false;
            if (isset($filterBrandId['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_BRAND_ID, $filterBrandId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($filterBrandId['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_BRAND_ID, $filterBrandId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_BRAND_ID, $filterBrandId, $comparison);
    }

    /**
     * Filter the query on the filter_price_list_id column
     *
     * Example usage:
     * <code>
     * $query->filterByFilterPriceListId(1234); // WHERE filter_price_list_id = 1234
     * $query->filterByFilterPriceListId(array(12, 34)); // WHERE filter_price_list_id IN (12, 34)
     * $query->filterByFilterPriceListId(array('min' => 12)); // WHERE filter_price_list_id > 12
     * </code>
     *
     * @param     mixed $filterPriceListId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByFilterPriceListId($filterPriceListId = null, $comparison = null)
    {
        if (is_array($filterPriceListId)) {
            $useMinMax = false;
            if (isset($filterPriceListId['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_PRICE_LIST_ID, $filterPriceListId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($filterPriceListId['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_PRICE_LIST_ID, $filterPriceListId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_PRICE_LIST_ID, $filterPriceListId, $comparison);
    }

    /**
     * Filter the query on the filter_auto_detecting column
     *
     * Example usage:
     * <code>
     * $query->filterByFilterAutoDetecting(1234); // WHERE filter_auto_detecting = 1234
     * $query->filterByFilterAutoDetecting(array(12, 34)); // WHERE filter_auto_detecting IN (12, 34)
     * $query->filterByFilterAutoDetecting(array('min' => 12)); // WHERE filter_auto_detecting > 12
     * </code>
     *
     * @param     mixed $filterAutoDetecting The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByFilterAutoDetecting($filterAutoDetecting = null, $comparison = null)
    {
        if (is_array($filterAutoDetecting)) {
            $useMinMax = false;
            if (isset($filterAutoDetecting['min'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_AUTO_DETECTING, $filterAutoDetecting['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($filterAutoDetecting['max'])) {
                $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_AUTO_DETECTING, $filterAutoDetecting['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_AUTO_DETECTING, $filterAutoDetecting, $comparison);
    }

    /**
     * Filter the query on the filter_mode column
     *
     * Example usage:
     * <code>
     * $query->filterByFilterMode('fooValue');   // WHERE filter_mode = 'fooValue'
     * $query->filterByFilterMode('%fooValue%', Criteria::LIKE); // WHERE filter_mode LIKE '%fooValue%'
     * </code>
     *
     * @param     string $filterMode The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterByFilterMode($filterMode = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($filterMode)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncRequestTableMap::COL_FILTER_MODE, $filterMode, $comparison);
    }

    /**
     * Filter the query by a related \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft object
     *
     * @param \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft|ObjectCollection $syncDraft the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildSyncRequestQuery The current query, for fluid interface
     */
    public function filterBySyncDraft($syncDraft, $comparison = null)
    {
        if ($syncDraft instanceof \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft) {
            return $this
                ->addUsingAlias(SyncRequestTableMap::COL_ID, $syncDraft->getRequestId(), $comparison);
        } elseif ($syncDraft instanceof ObjectCollection) {
            return $this
                ->useSyncDraftQuery()
                ->filterByPrimaryKeys($syncDraft->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterBySyncDraft() only accepts arguments of type \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the SyncDraft relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function joinSyncDraft($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('SyncDraft');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'SyncDraft');
        }

        return $this;
    }

    /**
     * Use the SyncDraft relation SyncDraft object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \PartScanner\Infrastructure\Models\SyncDraft\SyncDraftQuery A secondary query class using the current class as primary query
     */
    public function useSyncDraftQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinSyncDraft($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'SyncDraft', '\PartScanner\Infrastructure\Models\SyncDraft\SyncDraftQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildSyncRequest $syncRequest Object to remove from the list of results
     *
     * @return $this|ChildSyncRequestQuery The current query, for fluid interface
     */
    public function prune($syncRequest = null)
    {
        if ($syncRequest) {
            $this->addUsingAlias(SyncRequestTableMap::COL_ID, $syncRequest->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the local_sync_request table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncRequestTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            SyncRequestTableMap::clearInstancePool();
            SyncRequestTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncRequestTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(SyncRequestTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            SyncRequestTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            SyncRequestTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // SyncRequestQuery
