<?php

namespace PartScanner\Infrastructure\Models\SyncProviderRelation\Base;

use \Exception;
use \PDO;
use PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelation as ChildSyncProviderRelation;
use PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelationQuery as ChildSyncProviderRelationQuery;
use PartScanner\Infrastructure\Models\SyncProviderRelation\Map\SyncProviderRelationTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Provider\Provider;

/**
 * Base class that represents a query for the 'local_sync_provider_relation' table.
 *
 *
 *
 * @method     ChildSyncProviderRelationQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildSyncProviderRelationQuery orderByLocalProviderId($order = Criteria::ASC) Order by the local_provider_id column
 * @method     ChildSyncProviderRelationQuery orderByRemoteProviderId($order = Criteria::ASC) Order by the remote_provider_id column
 *
 * @method     ChildSyncProviderRelationQuery groupById() Group by the id column
 * @method     ChildSyncProviderRelationQuery groupByLocalProviderId() Group by the local_provider_id column
 * @method     ChildSyncProviderRelationQuery groupByRemoteProviderId() Group by the remote_provider_id column
 *
 * @method     ChildSyncProviderRelationQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildSyncProviderRelationQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildSyncProviderRelationQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildSyncProviderRelationQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildSyncProviderRelationQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildSyncProviderRelationQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildSyncProviderRelationQuery leftJoinRequest($relationAlias = null) Adds a LEFT JOIN clause to the query using the Request relation
 * @method     ChildSyncProviderRelationQuery rightJoinRequest($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Request relation
 * @method     ChildSyncProviderRelationQuery innerJoinRequest($relationAlias = null) Adds a INNER JOIN clause to the query using the Request relation
 *
 * @method     ChildSyncProviderRelationQuery joinWithRequest($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Request relation
 *
 * @method     ChildSyncProviderRelationQuery leftJoinWithRequest() Adds a LEFT JOIN clause and with to the query using the Request relation
 * @method     ChildSyncProviderRelationQuery rightJoinWithRequest() Adds a RIGHT JOIN clause and with to the query using the Request relation
 * @method     ChildSyncProviderRelationQuery innerJoinWithRequest() Adds a INNER JOIN clause and with to the query using the Request relation
 *
 * @method     \Shop\Models\Provider\ProviderQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildSyncProviderRelation findOne(ConnectionInterface $con = null) Return the first ChildSyncProviderRelation matching the query
 * @method     ChildSyncProviderRelation findOneOrCreate(ConnectionInterface $con = null) Return the first ChildSyncProviderRelation matching the query, or a new ChildSyncProviderRelation object populated from the query conditions when no match is found
 *
 * @method     ChildSyncProviderRelation findOneById(int $id) Return the first ChildSyncProviderRelation filtered by the id column
 * @method     ChildSyncProviderRelation findOneByLocalProviderId(int $local_provider_id) Return the first ChildSyncProviderRelation filtered by the local_provider_id column
 * @method     ChildSyncProviderRelation findOneByRemoteProviderId(int $remote_provider_id) Return the first ChildSyncProviderRelation filtered by the remote_provider_id column *

 * @method     ChildSyncProviderRelation requirePk($key, ConnectionInterface $con = null) Return the ChildSyncProviderRelation by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncProviderRelation requireOne(ConnectionInterface $con = null) Return the first ChildSyncProviderRelation matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSyncProviderRelation requireOneById(int $id) Return the first ChildSyncProviderRelation filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncProviderRelation requireOneByLocalProviderId(int $local_provider_id) Return the first ChildSyncProviderRelation filtered by the local_provider_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncProviderRelation requireOneByRemoteProviderId(int $remote_provider_id) Return the first ChildSyncProviderRelation filtered by the remote_provider_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSyncProviderRelation[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildSyncProviderRelation objects based on current ModelCriteria
 * @method     ChildSyncProviderRelation[]|ObjectCollection findById(int $id) Return ChildSyncProviderRelation objects filtered by the id column
 * @method     ChildSyncProviderRelation[]|ObjectCollection findByLocalProviderId(int $local_provider_id) Return ChildSyncProviderRelation objects filtered by the local_provider_id column
 * @method     ChildSyncProviderRelation[]|ObjectCollection findByRemoteProviderId(int $remote_provider_id) Return ChildSyncProviderRelation objects filtered by the remote_provider_id column
 * @method     ChildSyncProviderRelation[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class SyncProviderRelationQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \PartScanner\Infrastructure\Models\SyncProviderRelation\Base\SyncProviderRelationQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\PartScanner\\Infrastructure\\Models\\SyncProviderRelation\\SyncProviderRelation', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildSyncProviderRelationQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildSyncProviderRelationQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildSyncProviderRelationQuery) {
            return $criteria;
        }
        $query = new ChildSyncProviderRelationQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildSyncProviderRelation|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(SyncProviderRelationTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = SyncProviderRelationTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSyncProviderRelation A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `local_provider_id`, `remote_provider_id` FROM `local_sync_provider_relation` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildSyncProviderRelation $obj */
            $obj = new ChildSyncProviderRelation();
            $obj->hydrate($row);
            SyncProviderRelationTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildSyncProviderRelation|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildSyncProviderRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(SyncProviderRelationTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildSyncProviderRelationQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(SyncProviderRelationTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncProviderRelationQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(SyncProviderRelationTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(SyncProviderRelationTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncProviderRelationTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the local_provider_id column
     *
     * Example usage:
     * <code>
     * $query->filterByLocalProviderId(1234); // WHERE local_provider_id = 1234
     * $query->filterByLocalProviderId(array(12, 34)); // WHERE local_provider_id IN (12, 34)
     * $query->filterByLocalProviderId(array('min' => 12)); // WHERE local_provider_id > 12
     * </code>
     *
     * @see       filterByRequest()
     *
     * @param     mixed $localProviderId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncProviderRelationQuery The current query, for fluid interface
     */
    public function filterByLocalProviderId($localProviderId = null, $comparison = null)
    {
        if (is_array($localProviderId)) {
            $useMinMax = false;
            if (isset($localProviderId['min'])) {
                $this->addUsingAlias(SyncProviderRelationTableMap::COL_LOCAL_PROVIDER_ID, $localProviderId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($localProviderId['max'])) {
                $this->addUsingAlias(SyncProviderRelationTableMap::COL_LOCAL_PROVIDER_ID, $localProviderId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncProviderRelationTableMap::COL_LOCAL_PROVIDER_ID, $localProviderId, $comparison);
    }

    /**
     * Filter the query on the remote_provider_id column
     *
     * Example usage:
     * <code>
     * $query->filterByRemoteProviderId(1234); // WHERE remote_provider_id = 1234
     * $query->filterByRemoteProviderId(array(12, 34)); // WHERE remote_provider_id IN (12, 34)
     * $query->filterByRemoteProviderId(array('min' => 12)); // WHERE remote_provider_id > 12
     * </code>
     *
     * @param     mixed $remoteProviderId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncProviderRelationQuery The current query, for fluid interface
     */
    public function filterByRemoteProviderId($remoteProviderId = null, $comparison = null)
    {
        if (is_array($remoteProviderId)) {
            $useMinMax = false;
            if (isset($remoteProviderId['min'])) {
                $this->addUsingAlias(SyncProviderRelationTableMap::COL_REMOTE_PROVIDER_ID, $remoteProviderId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($remoteProviderId['max'])) {
                $this->addUsingAlias(SyncProviderRelationTableMap::COL_REMOTE_PROVIDER_ID, $remoteProviderId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncProviderRelationTableMap::COL_REMOTE_PROVIDER_ID, $remoteProviderId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Provider\Provider object
     *
     * @param \Shop\Models\Provider\Provider|ObjectCollection $provider The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSyncProviderRelationQuery The current query, for fluid interface
     */
    public function filterByRequest($provider, $comparison = null)
    {
        if ($provider instanceof \Shop\Models\Provider\Provider) {
            return $this
                ->addUsingAlias(SyncProviderRelationTableMap::COL_LOCAL_PROVIDER_ID, $provider->getId(), $comparison);
        } elseif ($provider instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(SyncProviderRelationTableMap::COL_LOCAL_PROVIDER_ID, $provider->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByRequest() only accepts arguments of type \Shop\Models\Provider\Provider or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Request relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildSyncProviderRelationQuery The current query, for fluid interface
     */
    public function joinRequest($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Request');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Request');
        }

        return $this;
    }

    /**
     * Use the Request relation Provider object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Provider\ProviderQuery A secondary query class using the current class as primary query
     */
    public function useRequestQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinRequest($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Request', '\Shop\Models\Provider\ProviderQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildSyncProviderRelation $syncProviderRelation Object to remove from the list of results
     *
     * @return $this|ChildSyncProviderRelationQuery The current query, for fluid interface
     */
    public function prune($syncProviderRelation = null)
    {
        if ($syncProviderRelation) {
            $this->addUsingAlias(SyncProviderRelationTableMap::COL_ID, $syncProviderRelation->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the local_sync_provider_relation table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncProviderRelationTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            SyncProviderRelationTableMap::clearInstancePool();
            SyncProviderRelationTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncProviderRelationTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(SyncProviderRelationTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            SyncProviderRelationTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            SyncProviderRelationTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // SyncProviderRelationQuery
