<?php

namespace PartScanner\Infrastructure\Models\SyncDraft\Map;

use PartScanner\Infrastructure\Models\SyncDraft\SyncDraft;
use PartScanner\Infrastructure\Models\SyncDraft\SyncDraftQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'local_sync_draft' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class SyncDraftTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.SyncDraft.Map.SyncDraftTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'local_sync_draft';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\PartScanner\\Infrastructure\\Models\\SyncDraft\\SyncDraft';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.SyncDraft.SyncDraft';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 8;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 8;

    /**
     * the column name for the id field
     */
    const COL_ID = 'local_sync_draft.id';

    /**
     * the column name for the position_id field
     */
    const COL_POSITION_ID = 'local_sync_draft.position_id';

    /**
     * the column name for the position_data field
     */
    const COL_POSITION_DATA = 'local_sync_draft.position_data';

    /**
     * the column name for the local_product_id field
     */
    const COL_LOCAL_PRODUCT_ID = 'local_sync_draft.local_product_id';

    /**
     * the column name for the local_brand_id field
     */
    const COL_LOCAL_BRAND_ID = 'local_sync_draft.local_brand_id';

    /**
     * the column name for the local_category_id field
     */
    const COL_LOCAL_CATEGORY_ID = 'local_sync_draft.local_category_id';

    /**
     * the column name for the local_weight field
     */
    const COL_LOCAL_WEIGHT = 'local_sync_draft.local_weight';

    /**
     * the column name for the request_id field
     */
    const COL_REQUEST_ID = 'local_sync_draft.request_id';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'PositionId', 'PositionData', 'LocalProductId', 'LocalBrandId', 'LocalCategoryId', 'LocalWeight', 'RequestId', ),
        self::TYPE_CAMELNAME     => array('id', 'positionId', 'positionData', 'localProductId', 'localBrandId', 'localCategoryId', 'localWeight', 'requestId', ),
        self::TYPE_COLNAME       => array(SyncDraftTableMap::COL_ID, SyncDraftTableMap::COL_POSITION_ID, SyncDraftTableMap::COL_POSITION_DATA, SyncDraftTableMap::COL_LOCAL_PRODUCT_ID, SyncDraftTableMap::COL_LOCAL_BRAND_ID, SyncDraftTableMap::COL_LOCAL_CATEGORY_ID, SyncDraftTableMap::COL_LOCAL_WEIGHT, SyncDraftTableMap::COL_REQUEST_ID, ),
        self::TYPE_FIELDNAME     => array('id', 'position_id', 'position_data', 'local_product_id', 'local_brand_id', 'local_category_id', 'local_weight', 'request_id', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'PositionId' => 1, 'PositionData' => 2, 'LocalProductId' => 3, 'LocalBrandId' => 4, 'LocalCategoryId' => 5, 'LocalWeight' => 6, 'RequestId' => 7, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'positionId' => 1, 'positionData' => 2, 'localProductId' => 3, 'localBrandId' => 4, 'localCategoryId' => 5, 'localWeight' => 6, 'requestId' => 7, ),
        self::TYPE_COLNAME       => array(SyncDraftTableMap::COL_ID => 0, SyncDraftTableMap::COL_POSITION_ID => 1, SyncDraftTableMap::COL_POSITION_DATA => 2, SyncDraftTableMap::COL_LOCAL_PRODUCT_ID => 3, SyncDraftTableMap::COL_LOCAL_BRAND_ID => 4, SyncDraftTableMap::COL_LOCAL_CATEGORY_ID => 5, SyncDraftTableMap::COL_LOCAL_WEIGHT => 6, SyncDraftTableMap::COL_REQUEST_ID => 7, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'position_id' => 1, 'position_data' => 2, 'local_product_id' => 3, 'local_brand_id' => 4, 'local_category_id' => 5, 'local_weight' => 6, 'request_id' => 7, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('local_sync_draft');
        $this->setPhpName('SyncDraft');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\PartScanner\\Infrastructure\\Models\\SyncDraft\\SyncDraft');
        $this->setPackage('Models.SyncDraft');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('position_id', 'PositionId', 'INTEGER', false, null, null);
        $this->addColumn('position_data', 'PositionData', 'LONGVARCHAR', false, null, null);
        $this->addColumn('local_product_id', 'LocalProductId', 'INTEGER', false, null, null);
        $this->addColumn('local_brand_id', 'LocalBrandId', 'INTEGER', false, null, null);
        $this->addColumn('local_category_id', 'LocalCategoryId', 'INTEGER', false, null, null);
        $this->addColumn('local_weight', 'LocalWeight', 'DECIMAL', false, 19, null);
        $this->addForeignPrimaryKey('request_id', 'RequestId', 'INTEGER' , 'local_sync_request', 'id', true, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Request', '\\PartScanner\\Infrastructure\\Models\\SyncRequest\\SyncRequest', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':request_id',
    1 => ':id',
  ),
), null, null, null, false);
    } // buildRelations()

    /**
     * Adds an object to the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database. In some cases you may need to explicitly add objects
     * to the cache in order to ensure that the same objects are always returned by find*()
     * and findPk*() calls.
     *
     * @param \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft $obj A \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft object.
     * @param string $key             (optional) key to use for instance map (for performance boost if key was already calculated externally).
     */
    public static function addInstanceToPool($obj, $key = null)
    {
        if (Propel::isInstancePoolingEnabled()) {
            if (null === $key) {
                $key = serialize([(null === $obj->getId() || is_scalar($obj->getId()) || is_callable([$obj->getId(), '__toString']) ? (string) $obj->getId() : $obj->getId()), (null === $obj->getRequestId() || is_scalar($obj->getRequestId()) || is_callable([$obj->getRequestId(), '__toString']) ? (string) $obj->getRequestId() : $obj->getRequestId())]);
            } // if key === null
            self::$instances[$key] = $obj;
        }
    }

    /**
     * Removes an object from the instance pool.
     *
     * Propel keeps cached copies of objects in an instance pool when they are retrieved
     * from the database.  In some cases -- especially when you override doDelete
     * methods in your stub classes -- you may need to explicitly remove objects
     * from the cache in order to prevent returning objects that no longer exist.
     *
     * @param mixed $value A \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft object or a primary key value.
     */
    public static function removeInstanceFromPool($value)
    {
        if (Propel::isInstancePoolingEnabled() && null !== $value) {
            if (is_object($value) && $value instanceof \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft) {
                $key = serialize([(null === $value->getId() || is_scalar($value->getId()) || is_callable([$value->getId(), '__toString']) ? (string) $value->getId() : $value->getId()), (null === $value->getRequestId() || is_scalar($value->getRequestId()) || is_callable([$value->getRequestId(), '__toString']) ? (string) $value->getRequestId() : $value->getRequestId())]);

            } elseif (is_array($value) && count($value) === 2) {
                // assume we've been passed a primary key";
                $key = serialize([(null === $value[0] || is_scalar($value[0]) || is_callable([$value[0], '__toString']) ? (string) $value[0] : $value[0]), (null === $value[1] || is_scalar($value[1]) || is_callable([$value[1], '__toString']) ? (string) $value[1] : $value[1])]);
            } elseif ($value instanceof Criteria) {
                self::$instances = [];

                return;
            } else {
                $e = new PropelException("Invalid value passed to removeInstanceFromPool().  Expected primary key or \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft object; got " . (is_object($value) ? get_class($value) . ' object.' : var_export($value, true)));
                throw $e;
            }

            unset(self::$instances[$key]);
        }
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null && $row[TableMap::TYPE_NUM == $indexType ? 7 + $offset : static::translateFieldName('RequestId', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return serialize([(null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]), (null === $row[TableMap::TYPE_NUM == $indexType ? 7 + $offset : static::translateFieldName('RequestId', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 7 + $offset : static::translateFieldName('RequestId', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 7 + $offset : static::translateFieldName('RequestId', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 7 + $offset : static::translateFieldName('RequestId', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 7 + $offset : static::translateFieldName('RequestId', TableMap::TYPE_PHPNAME, $indexType)])]);
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
            $pks = [];

        $pks[] = (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
        $pks[] = (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 7 + $offset
                : self::translateFieldName('RequestId', TableMap::TYPE_PHPNAME, $indexType)
        ];

        return $pks;
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? SyncDraftTableMap::CLASS_DEFAULT : SyncDraftTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (SyncDraft object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = SyncDraftTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = SyncDraftTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + SyncDraftTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = SyncDraftTableMap::OM_CLASS;
            /** @var SyncDraft $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            SyncDraftTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = SyncDraftTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = SyncDraftTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var SyncDraft $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                SyncDraftTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(SyncDraftTableMap::COL_ID);
            $criteria->addSelectColumn(SyncDraftTableMap::COL_POSITION_ID);
            $criteria->addSelectColumn(SyncDraftTableMap::COL_POSITION_DATA);
            $criteria->addSelectColumn(SyncDraftTableMap::COL_LOCAL_PRODUCT_ID);
            $criteria->addSelectColumn(SyncDraftTableMap::COL_LOCAL_BRAND_ID);
            $criteria->addSelectColumn(SyncDraftTableMap::COL_LOCAL_CATEGORY_ID);
            $criteria->addSelectColumn(SyncDraftTableMap::COL_LOCAL_WEIGHT);
            $criteria->addSelectColumn(SyncDraftTableMap::COL_REQUEST_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.position_id');
            $criteria->addSelectColumn($alias . '.position_data');
            $criteria->addSelectColumn($alias . '.local_product_id');
            $criteria->addSelectColumn($alias . '.local_brand_id');
            $criteria->addSelectColumn($alias . '.local_category_id');
            $criteria->addSelectColumn($alias . '.local_weight');
            $criteria->addSelectColumn($alias . '.request_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(SyncDraftTableMap::DATABASE_NAME)->getTable(SyncDraftTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(SyncDraftTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(SyncDraftTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new SyncDraftTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a SyncDraft or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or SyncDraft object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncDraftTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \PartScanner\Infrastructure\Models\SyncDraft\SyncDraft) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(SyncDraftTableMap::DATABASE_NAME);
            // primary key is composite; we therefore, expect
            // the primary key passed to be an array of pkey values
            if (count($values) == count($values, COUNT_RECURSIVE)) {
                // array is not multi-dimensional
                $values = array($values);
            }
            foreach ($values as $value) {
                $criterion = $criteria->getNewCriterion(SyncDraftTableMap::COL_ID, $value[0]);
                $criterion->addAnd($criteria->getNewCriterion(SyncDraftTableMap::COL_REQUEST_ID, $value[1]));
                $criteria->addOr($criterion);
            }
        }

        $query = SyncDraftQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            SyncDraftTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                SyncDraftTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the local_sync_draft table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return SyncDraftQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a SyncDraft or Criteria object.
     *
     * @param mixed               $criteria Criteria or SyncDraft object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncDraftTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from SyncDraft object
        }

        if ($criteria->containsKey(SyncDraftTableMap::COL_ID) && $criteria->keyContainsValue(SyncDraftTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.SyncDraftTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = SyncDraftQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // SyncDraftTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
SyncDraftTableMap::buildTableMap();
