<?php

namespace PartScanner\Infrastructure\Models\SyncDraft\Base;

use \Exception;
use \PDO;
use PartScanner\Infrastructure\Models\SyncDraft\SyncDraft as ChildSyncDraft;
use PartScanner\Infrastructure\Models\SyncDraft\SyncDraftQuery as ChildSyncDraftQuery;
use PartScanner\Infrastructure\Models\SyncDraft\Map\SyncDraftTableMap;
use PartScanner\Infrastructure\Models\SyncRequest\SyncRequest;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'local_sync_draft' table.
 *
 *
 *
 * @method     ChildSyncDraftQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildSyncDraftQuery orderByPositionId($order = Criteria::ASC) Order by the position_id column
 * @method     ChildSyncDraftQuery orderByPositionData($order = Criteria::ASC) Order by the position_data column
 * @method     ChildSyncDraftQuery orderByLocalProductId($order = Criteria::ASC) Order by the local_product_id column
 * @method     ChildSyncDraftQuery orderByLocalBrandId($order = Criteria::ASC) Order by the local_brand_id column
 * @method     ChildSyncDraftQuery orderByLocalCategoryId($order = Criteria::ASC) Order by the local_category_id column
 * @method     ChildSyncDraftQuery orderByLocalWeight($order = Criteria::ASC) Order by the local_weight column
 * @method     ChildSyncDraftQuery orderByRequestId($order = Criteria::ASC) Order by the request_id column
 *
 * @method     ChildSyncDraftQuery groupById() Group by the id column
 * @method     ChildSyncDraftQuery groupByPositionId() Group by the position_id column
 * @method     ChildSyncDraftQuery groupByPositionData() Group by the position_data column
 * @method     ChildSyncDraftQuery groupByLocalProductId() Group by the local_product_id column
 * @method     ChildSyncDraftQuery groupByLocalBrandId() Group by the local_brand_id column
 * @method     ChildSyncDraftQuery groupByLocalCategoryId() Group by the local_category_id column
 * @method     ChildSyncDraftQuery groupByLocalWeight() Group by the local_weight column
 * @method     ChildSyncDraftQuery groupByRequestId() Group by the request_id column
 *
 * @method     ChildSyncDraftQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildSyncDraftQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildSyncDraftQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildSyncDraftQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildSyncDraftQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildSyncDraftQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildSyncDraftQuery leftJoinRequest($relationAlias = null) Adds a LEFT JOIN clause to the query using the Request relation
 * @method     ChildSyncDraftQuery rightJoinRequest($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Request relation
 * @method     ChildSyncDraftQuery innerJoinRequest($relationAlias = null) Adds a INNER JOIN clause to the query using the Request relation
 *
 * @method     ChildSyncDraftQuery joinWithRequest($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Request relation
 *
 * @method     ChildSyncDraftQuery leftJoinWithRequest() Adds a LEFT JOIN clause and with to the query using the Request relation
 * @method     ChildSyncDraftQuery rightJoinWithRequest() Adds a RIGHT JOIN clause and with to the query using the Request relation
 * @method     ChildSyncDraftQuery innerJoinWithRequest() Adds a INNER JOIN clause and with to the query using the Request relation
 *
 * @method     \PartScanner\Infrastructure\Models\SyncRequest\SyncRequestQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildSyncDraft findOne(ConnectionInterface $con = null) Return the first ChildSyncDraft matching the query
 * @method     ChildSyncDraft findOneOrCreate(ConnectionInterface $con = null) Return the first ChildSyncDraft matching the query, or a new ChildSyncDraft object populated from the query conditions when no match is found
 *
 * @method     ChildSyncDraft findOneById(int $id) Return the first ChildSyncDraft filtered by the id column
 * @method     ChildSyncDraft findOneByPositionId(int $position_id) Return the first ChildSyncDraft filtered by the position_id column
 * @method     ChildSyncDraft findOneByPositionData(string $position_data) Return the first ChildSyncDraft filtered by the position_data column
 * @method     ChildSyncDraft findOneByLocalProductId(int $local_product_id) Return the first ChildSyncDraft filtered by the local_product_id column
 * @method     ChildSyncDraft findOneByLocalBrandId(int $local_brand_id) Return the first ChildSyncDraft filtered by the local_brand_id column
 * @method     ChildSyncDraft findOneByLocalCategoryId(int $local_category_id) Return the first ChildSyncDraft filtered by the local_category_id column
 * @method     ChildSyncDraft findOneByLocalWeight(string $local_weight) Return the first ChildSyncDraft filtered by the local_weight column
 * @method     ChildSyncDraft findOneByRequestId(int $request_id) Return the first ChildSyncDraft filtered by the request_id column *

 * @method     ChildSyncDraft requirePk($key, ConnectionInterface $con = null) Return the ChildSyncDraft by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncDraft requireOne(ConnectionInterface $con = null) Return the first ChildSyncDraft matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSyncDraft requireOneById(int $id) Return the first ChildSyncDraft filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncDraft requireOneByPositionId(int $position_id) Return the first ChildSyncDraft filtered by the position_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncDraft requireOneByPositionData(string $position_data) Return the first ChildSyncDraft filtered by the position_data column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncDraft requireOneByLocalProductId(int $local_product_id) Return the first ChildSyncDraft filtered by the local_product_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncDraft requireOneByLocalBrandId(int $local_brand_id) Return the first ChildSyncDraft filtered by the local_brand_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncDraft requireOneByLocalCategoryId(int $local_category_id) Return the first ChildSyncDraft filtered by the local_category_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncDraft requireOneByLocalWeight(string $local_weight) Return the first ChildSyncDraft filtered by the local_weight column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildSyncDraft requireOneByRequestId(int $request_id) Return the first ChildSyncDraft filtered by the request_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildSyncDraft[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildSyncDraft objects based on current ModelCriteria
 * @method     ChildSyncDraft[]|ObjectCollection findById(int $id) Return ChildSyncDraft objects filtered by the id column
 * @method     ChildSyncDraft[]|ObjectCollection findByPositionId(int $position_id) Return ChildSyncDraft objects filtered by the position_id column
 * @method     ChildSyncDraft[]|ObjectCollection findByPositionData(string $position_data) Return ChildSyncDraft objects filtered by the position_data column
 * @method     ChildSyncDraft[]|ObjectCollection findByLocalProductId(int $local_product_id) Return ChildSyncDraft objects filtered by the local_product_id column
 * @method     ChildSyncDraft[]|ObjectCollection findByLocalBrandId(int $local_brand_id) Return ChildSyncDraft objects filtered by the local_brand_id column
 * @method     ChildSyncDraft[]|ObjectCollection findByLocalCategoryId(int $local_category_id) Return ChildSyncDraft objects filtered by the local_category_id column
 * @method     ChildSyncDraft[]|ObjectCollection findByLocalWeight(string $local_weight) Return ChildSyncDraft objects filtered by the local_weight column
 * @method     ChildSyncDraft[]|ObjectCollection findByRequestId(int $request_id) Return ChildSyncDraft objects filtered by the request_id column
 * @method     ChildSyncDraft[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class SyncDraftQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \PartScanner\Infrastructure\Models\SyncDraft\Base\SyncDraftQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\PartScanner\\Infrastructure\\Models\\SyncDraft\\SyncDraft', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildSyncDraftQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildSyncDraftQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildSyncDraftQuery) {
            return $criteria;
        }
        $query = new ChildSyncDraftQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array[$id, $request_id] $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildSyncDraft|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(SyncDraftTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = SyncDraftTableMap::getInstanceFromPool(serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]))))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSyncDraft A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `position_id`, `position_data`, `local_product_id`, `local_brand_id`, `local_category_id`, `local_weight`, `request_id` FROM `local_sync_draft` WHERE `id` = :p0 AND `request_id` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildSyncDraft $obj */
            $obj = new ChildSyncDraft();
            $obj->hydrate($row);
            SyncDraftTableMap::addInstanceToPool($obj, serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildSyncDraft|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(SyncDraftTableMap::COL_ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(SyncDraftTableMap::COL_REQUEST_ID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(SyncDraftTableMap::COL_ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(SyncDraftTableMap::COL_REQUEST_ID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncDraftTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the position_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPositionId(1234); // WHERE position_id = 1234
     * $query->filterByPositionId(array(12, 34)); // WHERE position_id IN (12, 34)
     * $query->filterByPositionId(array('min' => 12)); // WHERE position_id > 12
     * </code>
     *
     * @param     mixed $positionId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByPositionId($positionId = null, $comparison = null)
    {
        if (is_array($positionId)) {
            $useMinMax = false;
            if (isset($positionId['min'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_POSITION_ID, $positionId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($positionId['max'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_POSITION_ID, $positionId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncDraftTableMap::COL_POSITION_ID, $positionId, $comparison);
    }

    /**
     * Filter the query on the position_data column
     *
     * Example usage:
     * <code>
     * $query->filterByPositionData('fooValue');   // WHERE position_data = 'fooValue'
     * $query->filterByPositionData('%fooValue%', Criteria::LIKE); // WHERE position_data LIKE '%fooValue%'
     * </code>
     *
     * @param     string $positionData The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByPositionData($positionData = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($positionData)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncDraftTableMap::COL_POSITION_DATA, $positionData, $comparison);
    }

    /**
     * Filter the query on the local_product_id column
     *
     * Example usage:
     * <code>
     * $query->filterByLocalProductId(1234); // WHERE local_product_id = 1234
     * $query->filterByLocalProductId(array(12, 34)); // WHERE local_product_id IN (12, 34)
     * $query->filterByLocalProductId(array('min' => 12)); // WHERE local_product_id > 12
     * </code>
     *
     * @param     mixed $localProductId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByLocalProductId($localProductId = null, $comparison = null)
    {
        if (is_array($localProductId)) {
            $useMinMax = false;
            if (isset($localProductId['min'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_PRODUCT_ID, $localProductId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($localProductId['max'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_PRODUCT_ID, $localProductId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_PRODUCT_ID, $localProductId, $comparison);
    }

    /**
     * Filter the query on the local_brand_id column
     *
     * Example usage:
     * <code>
     * $query->filterByLocalBrandId(1234); // WHERE local_brand_id = 1234
     * $query->filterByLocalBrandId(array(12, 34)); // WHERE local_brand_id IN (12, 34)
     * $query->filterByLocalBrandId(array('min' => 12)); // WHERE local_brand_id > 12
     * </code>
     *
     * @param     mixed $localBrandId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByLocalBrandId($localBrandId = null, $comparison = null)
    {
        if (is_array($localBrandId)) {
            $useMinMax = false;
            if (isset($localBrandId['min'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_BRAND_ID, $localBrandId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($localBrandId['max'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_BRAND_ID, $localBrandId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_BRAND_ID, $localBrandId, $comparison);
    }

    /**
     * Filter the query on the local_category_id column
     *
     * Example usage:
     * <code>
     * $query->filterByLocalCategoryId(1234); // WHERE local_category_id = 1234
     * $query->filterByLocalCategoryId(array(12, 34)); // WHERE local_category_id IN (12, 34)
     * $query->filterByLocalCategoryId(array('min' => 12)); // WHERE local_category_id > 12
     * </code>
     *
     * @param     mixed $localCategoryId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByLocalCategoryId($localCategoryId = null, $comparison = null)
    {
        if (is_array($localCategoryId)) {
            $useMinMax = false;
            if (isset($localCategoryId['min'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_CATEGORY_ID, $localCategoryId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($localCategoryId['max'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_CATEGORY_ID, $localCategoryId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_CATEGORY_ID, $localCategoryId, $comparison);
    }

    /**
     * Filter the query on the local_weight column
     *
     * Example usage:
     * <code>
     * $query->filterByLocalWeight(1234); // WHERE local_weight = 1234
     * $query->filterByLocalWeight(array(12, 34)); // WHERE local_weight IN (12, 34)
     * $query->filterByLocalWeight(array('min' => 12)); // WHERE local_weight > 12
     * </code>
     *
     * @param     mixed $localWeight The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByLocalWeight($localWeight = null, $comparison = null)
    {
        if (is_array($localWeight)) {
            $useMinMax = false;
            if (isset($localWeight['min'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_WEIGHT, $localWeight['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($localWeight['max'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_WEIGHT, $localWeight['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncDraftTableMap::COL_LOCAL_WEIGHT, $localWeight, $comparison);
    }

    /**
     * Filter the query on the request_id column
     *
     * Example usage:
     * <code>
     * $query->filterByRequestId(1234); // WHERE request_id = 1234
     * $query->filterByRequestId(array(12, 34)); // WHERE request_id IN (12, 34)
     * $query->filterByRequestId(array('min' => 12)); // WHERE request_id > 12
     * </code>
     *
     * @see       filterByRequest()
     *
     * @param     mixed $requestId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByRequestId($requestId = null, $comparison = null)
    {
        if (is_array($requestId)) {
            $useMinMax = false;
            if (isset($requestId['min'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_REQUEST_ID, $requestId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($requestId['max'])) {
                $this->addUsingAlias(SyncDraftTableMap::COL_REQUEST_ID, $requestId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(SyncDraftTableMap::COL_REQUEST_ID, $requestId, $comparison);
    }

    /**
     * Filter the query by a related \PartScanner\Infrastructure\Models\SyncRequest\SyncRequest object
     *
     * @param \PartScanner\Infrastructure\Models\SyncRequest\SyncRequest|ObjectCollection $syncRequest The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildSyncDraftQuery The current query, for fluid interface
     */
    public function filterByRequest($syncRequest, $comparison = null)
    {
        if ($syncRequest instanceof \PartScanner\Infrastructure\Models\SyncRequest\SyncRequest) {
            return $this
                ->addUsingAlias(SyncDraftTableMap::COL_REQUEST_ID, $syncRequest->getId(), $comparison);
        } elseif ($syncRequest instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(SyncDraftTableMap::COL_REQUEST_ID, $syncRequest->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByRequest() only accepts arguments of type \PartScanner\Infrastructure\Models\SyncRequest\SyncRequest or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Request relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function joinRequest($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Request');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Request');
        }

        return $this;
    }

    /**
     * Use the Request relation SyncRequest object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \PartScanner\Infrastructure\Models\SyncRequest\SyncRequestQuery A secondary query class using the current class as primary query
     */
    public function useRequestQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinRequest($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Request', '\PartScanner\Infrastructure\Models\SyncRequest\SyncRequestQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildSyncDraft $syncDraft Object to remove from the list of results
     *
     * @return $this|ChildSyncDraftQuery The current query, for fluid interface
     */
    public function prune($syncDraft = null)
    {
        if ($syncDraft) {
            $this->addCond('pruneCond0', $this->getAliasedColName(SyncDraftTableMap::COL_ID), $syncDraft->getId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(SyncDraftTableMap::COL_REQUEST_ID), $syncDraft->getRequestId(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

    /**
     * Deletes all rows from the local_sync_draft table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncDraftTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            SyncDraftTableMap::clearInstancePool();
            SyncDraftTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(SyncDraftTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(SyncDraftTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            SyncDraftTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            SyncDraftTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // SyncDraftQuery
