<?php

namespace Shop\Models\State\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Shop\Models\Order\Order;
use Shop\Models\Order\OrderQuery;
use Shop\Models\OrderItem\OrderItem;
use Shop\Models\OrderItem\OrderItemQuery;
use Shop\Models\OrderItem\Base\OrderItem as BaseOrderItem;
use Shop\Models\OrderItem\Map\OrderItemTableMap;
use Shop\Models\Order\Base\Order as BaseOrder;
use Shop\Models\Order\Map\OrderTableMap;
use Shop\Models\State\ShopStatesArchive as ChildShopStatesArchive;
use Shop\Models\State\ShopStatesArchiveQuery as ChildShopStatesArchiveQuery;
use Shop\Models\State\State as ChildState;
use Shop\Models\State\StateQuery as ChildStateQuery;
use Shop\Models\StateLog\StateLog;
use Shop\Models\StateLog\StateLogQuery;
use Shop\Models\StateLog\Base\StateLog as BaseStateLog;
use Shop\Models\StateLog\Map\StateLogTableMap;
use Shop\Models\State\Map\StateTableMap;

/**
 * Base class that represents a row from the 'shop_states' table.
 *
 *
 *
 * @package    propel.generator.Models.State.Base
 */
abstract class State implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Shop\\Models\\State\\Map\\StateTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the title field.
     *
     * @var        string
     */
    protected $title;

    /**
     * The value for the color field.
     *
     * @var        string
     */
    protected $color;

    /**
     * @var        ObjectCollection|StateLog[] Collection to store aggregation of StateLog objects.
     */
    protected $collStateLogsRelatedByOldStateId;
    protected $collStateLogsRelatedByOldStateIdPartial;

    /**
     * @var        ObjectCollection|StateLog[] Collection to store aggregation of StateLog objects.
     */
    protected $collStateLogsRelatedByNewStateId;
    protected $collStateLogsRelatedByNewStateIdPartial;

    /**
     * @var        ObjectCollection|Order[] Collection to store aggregation of Order objects.
     */
    protected $collOrders;
    protected $collOrdersPartial;

    /**
     * @var        ObjectCollection|OrderItem[] Collection to store aggregation of OrderItem objects.
     */
    protected $collOrderItems;
    protected $collOrderItemsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    // archivable behavior
    protected $archiveOnDelete = true;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|StateLog[]
     */
    protected $stateLogsRelatedByOldStateIdScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|StateLog[]
     */
    protected $stateLogsRelatedByNewStateIdScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Order[]
     */
    protected $ordersScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|OrderItem[]
     */
    protected $orderItemsScheduledForDeletion = null;

    /**
     * Initializes internal state of Shop\Models\State\Base\State object.
     */
    public function __construct()
    {
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>State</code> instance.  If
     * <code>obj</code> is an instance of <code>State</code>, delegates to
     * <code>equals(State)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|State The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [title] column value.
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [color] column value.
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\State\State The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[StateTableMap::COL_ID] = true;
        }

        return $this;
    } // setId()

    /**
     * Set the value of [title] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\State\State The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[StateTableMap::COL_TITLE] = true;
        }

        return $this;
    } // setTitle()

    /**
     * Set the value of [color] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\State\State The current object (for fluent API support)
     */
    public function setColor($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->color !== $v) {
            $this->color = $v;
            $this->modifiedColumns[StateTableMap::COL_COLOR] = true;
        }

        return $this;
    } // setColor()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : StateTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : StateTableMap::translateFieldName('Title', TableMap::TYPE_PHPNAME, $indexType)];
            $this->title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : StateTableMap::translateFieldName('Color', TableMap::TYPE_PHPNAME, $indexType)];
            $this->color = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 3; // 3 = StateTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Models\\State\\State'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StateTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildStateQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collStateLogsRelatedByOldStateId = null;

            $this->collStateLogsRelatedByNewStateId = null;

            $this->collOrders = null;

            $this->collOrderItems = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see State::setDeleted()
     * @see State::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(StateTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildStateQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // archivable behavior
            if ($ret) {
                if ($this->archiveOnDelete) {
                    // do nothing yet. The object will be archived later when calling ChildStateQuery::delete().
                } else {
                    $deleteQuery->setArchiveOnDelete(false);
                    $this->archiveOnDelete = true;
                }
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(StateTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                StateTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->stateLogsRelatedByOldStateIdScheduledForDeletion !== null) {
                if (!$this->stateLogsRelatedByOldStateIdScheduledForDeletion->isEmpty()) {
                    \Shop\Models\StateLog\StateLogQuery::create()
                        ->filterByPrimaryKeys($this->stateLogsRelatedByOldStateIdScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->stateLogsRelatedByOldStateIdScheduledForDeletion = null;
                }
            }

            if ($this->collStateLogsRelatedByOldStateId !== null) {
                foreach ($this->collStateLogsRelatedByOldStateId as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->stateLogsRelatedByNewStateIdScheduledForDeletion !== null) {
                if (!$this->stateLogsRelatedByNewStateIdScheduledForDeletion->isEmpty()) {
                    \Shop\Models\StateLog\StateLogQuery::create()
                        ->filterByPrimaryKeys($this->stateLogsRelatedByNewStateIdScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->stateLogsRelatedByNewStateIdScheduledForDeletion = null;
                }
            }

            if ($this->collStateLogsRelatedByNewStateId !== null) {
                foreach ($this->collStateLogsRelatedByNewStateId as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->ordersScheduledForDeletion !== null) {
                if (!$this->ordersScheduledForDeletion->isEmpty()) {
                    \Shop\Models\Order\OrderQuery::create()
                        ->filterByPrimaryKeys($this->ordersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->ordersScheduledForDeletion = null;
                }
            }

            if ($this->collOrders !== null) {
                foreach ($this->collOrders as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->orderItemsScheduledForDeletion !== null) {
                if (!$this->orderItemsScheduledForDeletion->isEmpty()) {
                    \Shop\Models\OrderItem\OrderItemQuery::create()
                        ->filterByPrimaryKeys($this->orderItemsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->orderItemsScheduledForDeletion = null;
                }
            }

            if ($this->collOrderItems !== null) {
                foreach ($this->collOrderItems as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[StateTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . StateTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(StateTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(StateTableMap::COL_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`title`';
        }
        if ($this->isColumnModified(StateTableMap::COL_COLOR)) {
            $modifiedColumns[':p' . $index++]  = '`color`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_states` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`title`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`color`':
                        $stmt->bindValue($identifier, $this->color, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = StateTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getTitle();
                break;
            case 2:
                return $this->getColor();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['State'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['State'][$this->hashCode()] = true;
        $keys = StateTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getTitle(),
            $keys[2] => $this->getColor(),
        );
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->collStateLogsRelatedByOldStateId) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'stateLogs';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_state_logss';
                        break;
                    default:
                        $key = 'StateLogs';
                }

                $result[$key] = $this->collStateLogsRelatedByOldStateId->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collStateLogsRelatedByNewStateId) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'stateLogs';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_state_logss';
                        break;
                    default:
                        $key = 'StateLogs';
                }

                $result[$key] = $this->collStateLogsRelatedByNewStateId->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collOrders) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'orders';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_orderss';
                        break;
                    default:
                        $key = 'Orders';
                }

                $result[$key] = $this->collOrders->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collOrderItems) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'orderItems';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_order_itemss';
                        break;
                    default:
                        $key = 'OrderItems';
                }

                $result[$key] = $this->collOrderItems->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Shop\Models\State\State
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = StateTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Shop\Models\State\State
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setTitle($value);
                break;
            case 2:
                $this->setColor($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = StateTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setTitle($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setColor($arr[$keys[2]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Shop\Models\State\State The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(StateTableMap::DATABASE_NAME);

        if ($this->isColumnModified(StateTableMap::COL_ID)) {
            $criteria->add(StateTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(StateTableMap::COL_TITLE)) {
            $criteria->add(StateTableMap::COL_TITLE, $this->title);
        }
        if ($this->isColumnModified(StateTableMap::COL_COLOR)) {
            $criteria->add(StateTableMap::COL_COLOR, $this->color);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildStateQuery::create();
        $criteria->add(StateTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Shop\Models\State\State (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setTitle($this->getTitle());
        $copyObj->setColor($this->getColor());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getStateLogsRelatedByOldStateId() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addStateLogRelatedByOldStateId($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getStateLogsRelatedByNewStateId() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addStateLogRelatedByNewStateId($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getOrders() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addOrder($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getOrderItems() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addOrderItem($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Models\State\State Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param      string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('StateLogRelatedByOldStateId' == $relationName) {
            $this->initStateLogsRelatedByOldStateId();
            return;
        }
        if ('StateLogRelatedByNewStateId' == $relationName) {
            $this->initStateLogsRelatedByNewStateId();
            return;
        }
        if ('Order' == $relationName) {
            $this->initOrders();
            return;
        }
        if ('OrderItem' == $relationName) {
            $this->initOrderItems();
            return;
        }
    }

    /**
     * Clears out the collStateLogsRelatedByOldStateId collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addStateLogsRelatedByOldStateId()
     */
    public function clearStateLogsRelatedByOldStateId()
    {
        $this->collStateLogsRelatedByOldStateId = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collStateLogsRelatedByOldStateId collection loaded partially.
     */
    public function resetPartialStateLogsRelatedByOldStateId($v = true)
    {
        $this->collStateLogsRelatedByOldStateIdPartial = $v;
    }

    /**
     * Initializes the collStateLogsRelatedByOldStateId collection.
     *
     * By default this just sets the collStateLogsRelatedByOldStateId collection to an empty array (like clearcollStateLogsRelatedByOldStateId());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initStateLogsRelatedByOldStateId($overrideExisting = true)
    {
        if (null !== $this->collStateLogsRelatedByOldStateId && !$overrideExisting) {
            return;
        }

        $collectionClassName = StateLogTableMap::getTableMap()->getCollectionClassName();

        $this->collStateLogsRelatedByOldStateId = new $collectionClassName;
        $this->collStateLogsRelatedByOldStateId->setModel('\Shop\Models\StateLog\StateLog');
    }

    /**
     * Gets an array of StateLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildState is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|StateLog[] List of StateLog objects
     * @throws PropelException
     */
    public function getStateLogsRelatedByOldStateId(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collStateLogsRelatedByOldStateIdPartial && !$this->isNew();
        if (null === $this->collStateLogsRelatedByOldStateId || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collStateLogsRelatedByOldStateId) {
                // return empty collection
                $this->initStateLogsRelatedByOldStateId();
            } else {
                $collStateLogsRelatedByOldStateId = StateLogQuery::create(null, $criteria)
                    ->filterByOldState($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collStateLogsRelatedByOldStateIdPartial && count($collStateLogsRelatedByOldStateId)) {
                        $this->initStateLogsRelatedByOldStateId(false);

                        foreach ($collStateLogsRelatedByOldStateId as $obj) {
                            if (false == $this->collStateLogsRelatedByOldStateId->contains($obj)) {
                                $this->collStateLogsRelatedByOldStateId->append($obj);
                            }
                        }

                        $this->collStateLogsRelatedByOldStateIdPartial = true;
                    }

                    return $collStateLogsRelatedByOldStateId;
                }

                if ($partial && $this->collStateLogsRelatedByOldStateId) {
                    foreach ($this->collStateLogsRelatedByOldStateId as $obj) {
                        if ($obj->isNew()) {
                            $collStateLogsRelatedByOldStateId[] = $obj;
                        }
                    }
                }

                $this->collStateLogsRelatedByOldStateId = $collStateLogsRelatedByOldStateId;
                $this->collStateLogsRelatedByOldStateIdPartial = false;
            }
        }

        return $this->collStateLogsRelatedByOldStateId;
    }

    /**
     * Sets a collection of StateLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $stateLogsRelatedByOldStateId A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function setStateLogsRelatedByOldStateId(Collection $stateLogsRelatedByOldStateId, ConnectionInterface $con = null)
    {
        /** @var StateLog[] $stateLogsRelatedByOldStateIdToDelete */
        $stateLogsRelatedByOldStateIdToDelete = $this->getStateLogsRelatedByOldStateId(new Criteria(), $con)->diff($stateLogsRelatedByOldStateId);


        $this->stateLogsRelatedByOldStateIdScheduledForDeletion = $stateLogsRelatedByOldStateIdToDelete;

        foreach ($stateLogsRelatedByOldStateIdToDelete as $stateLogRelatedByOldStateIdRemoved) {
            $stateLogRelatedByOldStateIdRemoved->setOldState(null);
        }

        $this->collStateLogsRelatedByOldStateId = null;
        foreach ($stateLogsRelatedByOldStateId as $stateLogRelatedByOldStateId) {
            $this->addStateLogRelatedByOldStateId($stateLogRelatedByOldStateId);
        }

        $this->collStateLogsRelatedByOldStateId = $stateLogsRelatedByOldStateId;
        $this->collStateLogsRelatedByOldStateIdPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseStateLog objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseStateLog objects.
     * @throws PropelException
     */
    public function countStateLogsRelatedByOldStateId(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collStateLogsRelatedByOldStateIdPartial && !$this->isNew();
        if (null === $this->collStateLogsRelatedByOldStateId || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collStateLogsRelatedByOldStateId) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getStateLogsRelatedByOldStateId());
            }

            $query = StateLogQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByOldState($this)
                ->count($con);
        }

        return count($this->collStateLogsRelatedByOldStateId);
    }

    /**
     * Method called to associate a StateLog object to this object
     * through the StateLog foreign key attribute.
     *
     * @param  StateLog $l StateLog
     * @return $this|\Shop\Models\State\State The current object (for fluent API support)
     */
    public function addStateLogRelatedByOldStateId(StateLog $l)
    {
        if ($this->collStateLogsRelatedByOldStateId === null) {
            $this->initStateLogsRelatedByOldStateId();
            $this->collStateLogsRelatedByOldStateIdPartial = true;
        }

        if (!$this->collStateLogsRelatedByOldStateId->contains($l)) {
            $this->doAddStateLogRelatedByOldStateId($l);

            if ($this->stateLogsRelatedByOldStateIdScheduledForDeletion and $this->stateLogsRelatedByOldStateIdScheduledForDeletion->contains($l)) {
                $this->stateLogsRelatedByOldStateIdScheduledForDeletion->remove($this->stateLogsRelatedByOldStateIdScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param StateLog $stateLogRelatedByOldStateId The StateLog object to add.
     */
    protected function doAddStateLogRelatedByOldStateId(StateLog $stateLogRelatedByOldStateId)
    {
        $this->collStateLogsRelatedByOldStateId[]= $stateLogRelatedByOldStateId;
        $stateLogRelatedByOldStateId->setOldState($this);
    }

    /**
     * @param  StateLog $stateLogRelatedByOldStateId The StateLog object to remove.
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function removeStateLogRelatedByOldStateId(StateLog $stateLogRelatedByOldStateId)
    {
        if ($this->getStateLogsRelatedByOldStateId()->contains($stateLogRelatedByOldStateId)) {
            $pos = $this->collStateLogsRelatedByOldStateId->search($stateLogRelatedByOldStateId);
            $this->collStateLogsRelatedByOldStateId->remove($pos);
            if (null === $this->stateLogsRelatedByOldStateIdScheduledForDeletion) {
                $this->stateLogsRelatedByOldStateIdScheduledForDeletion = clone $this->collStateLogsRelatedByOldStateId;
                $this->stateLogsRelatedByOldStateIdScheduledForDeletion->clear();
            }
            $this->stateLogsRelatedByOldStateIdScheduledForDeletion[]= clone $stateLogRelatedByOldStateId;
            $stateLogRelatedByOldStateId->setOldState(null);
        }

        return $this;
    }

    /**
     * Clears out the collStateLogsRelatedByNewStateId collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addStateLogsRelatedByNewStateId()
     */
    public function clearStateLogsRelatedByNewStateId()
    {
        $this->collStateLogsRelatedByNewStateId = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collStateLogsRelatedByNewStateId collection loaded partially.
     */
    public function resetPartialStateLogsRelatedByNewStateId($v = true)
    {
        $this->collStateLogsRelatedByNewStateIdPartial = $v;
    }

    /**
     * Initializes the collStateLogsRelatedByNewStateId collection.
     *
     * By default this just sets the collStateLogsRelatedByNewStateId collection to an empty array (like clearcollStateLogsRelatedByNewStateId());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initStateLogsRelatedByNewStateId($overrideExisting = true)
    {
        if (null !== $this->collStateLogsRelatedByNewStateId && !$overrideExisting) {
            return;
        }

        $collectionClassName = StateLogTableMap::getTableMap()->getCollectionClassName();

        $this->collStateLogsRelatedByNewStateId = new $collectionClassName;
        $this->collStateLogsRelatedByNewStateId->setModel('\Shop\Models\StateLog\StateLog');
    }

    /**
     * Gets an array of StateLog objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildState is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|StateLog[] List of StateLog objects
     * @throws PropelException
     */
    public function getStateLogsRelatedByNewStateId(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collStateLogsRelatedByNewStateIdPartial && !$this->isNew();
        if (null === $this->collStateLogsRelatedByNewStateId || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collStateLogsRelatedByNewStateId) {
                // return empty collection
                $this->initStateLogsRelatedByNewStateId();
            } else {
                $collStateLogsRelatedByNewStateId = StateLogQuery::create(null, $criteria)
                    ->filterByNewState($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collStateLogsRelatedByNewStateIdPartial && count($collStateLogsRelatedByNewStateId)) {
                        $this->initStateLogsRelatedByNewStateId(false);

                        foreach ($collStateLogsRelatedByNewStateId as $obj) {
                            if (false == $this->collStateLogsRelatedByNewStateId->contains($obj)) {
                                $this->collStateLogsRelatedByNewStateId->append($obj);
                            }
                        }

                        $this->collStateLogsRelatedByNewStateIdPartial = true;
                    }

                    return $collStateLogsRelatedByNewStateId;
                }

                if ($partial && $this->collStateLogsRelatedByNewStateId) {
                    foreach ($this->collStateLogsRelatedByNewStateId as $obj) {
                        if ($obj->isNew()) {
                            $collStateLogsRelatedByNewStateId[] = $obj;
                        }
                    }
                }

                $this->collStateLogsRelatedByNewStateId = $collStateLogsRelatedByNewStateId;
                $this->collStateLogsRelatedByNewStateIdPartial = false;
            }
        }

        return $this->collStateLogsRelatedByNewStateId;
    }

    /**
     * Sets a collection of StateLog objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $stateLogsRelatedByNewStateId A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function setStateLogsRelatedByNewStateId(Collection $stateLogsRelatedByNewStateId, ConnectionInterface $con = null)
    {
        /** @var StateLog[] $stateLogsRelatedByNewStateIdToDelete */
        $stateLogsRelatedByNewStateIdToDelete = $this->getStateLogsRelatedByNewStateId(new Criteria(), $con)->diff($stateLogsRelatedByNewStateId);


        $this->stateLogsRelatedByNewStateIdScheduledForDeletion = $stateLogsRelatedByNewStateIdToDelete;

        foreach ($stateLogsRelatedByNewStateIdToDelete as $stateLogRelatedByNewStateIdRemoved) {
            $stateLogRelatedByNewStateIdRemoved->setNewState(null);
        }

        $this->collStateLogsRelatedByNewStateId = null;
        foreach ($stateLogsRelatedByNewStateId as $stateLogRelatedByNewStateId) {
            $this->addStateLogRelatedByNewStateId($stateLogRelatedByNewStateId);
        }

        $this->collStateLogsRelatedByNewStateId = $stateLogsRelatedByNewStateId;
        $this->collStateLogsRelatedByNewStateIdPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseStateLog objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseStateLog objects.
     * @throws PropelException
     */
    public function countStateLogsRelatedByNewStateId(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collStateLogsRelatedByNewStateIdPartial && !$this->isNew();
        if (null === $this->collStateLogsRelatedByNewStateId || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collStateLogsRelatedByNewStateId) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getStateLogsRelatedByNewStateId());
            }

            $query = StateLogQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByNewState($this)
                ->count($con);
        }

        return count($this->collStateLogsRelatedByNewStateId);
    }

    /**
     * Method called to associate a StateLog object to this object
     * through the StateLog foreign key attribute.
     *
     * @param  StateLog $l StateLog
     * @return $this|\Shop\Models\State\State The current object (for fluent API support)
     */
    public function addStateLogRelatedByNewStateId(StateLog $l)
    {
        if ($this->collStateLogsRelatedByNewStateId === null) {
            $this->initStateLogsRelatedByNewStateId();
            $this->collStateLogsRelatedByNewStateIdPartial = true;
        }

        if (!$this->collStateLogsRelatedByNewStateId->contains($l)) {
            $this->doAddStateLogRelatedByNewStateId($l);

            if ($this->stateLogsRelatedByNewStateIdScheduledForDeletion and $this->stateLogsRelatedByNewStateIdScheduledForDeletion->contains($l)) {
                $this->stateLogsRelatedByNewStateIdScheduledForDeletion->remove($this->stateLogsRelatedByNewStateIdScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param StateLog $stateLogRelatedByNewStateId The StateLog object to add.
     */
    protected function doAddStateLogRelatedByNewStateId(StateLog $stateLogRelatedByNewStateId)
    {
        $this->collStateLogsRelatedByNewStateId[]= $stateLogRelatedByNewStateId;
        $stateLogRelatedByNewStateId->setNewState($this);
    }

    /**
     * @param  StateLog $stateLogRelatedByNewStateId The StateLog object to remove.
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function removeStateLogRelatedByNewStateId(StateLog $stateLogRelatedByNewStateId)
    {
        if ($this->getStateLogsRelatedByNewStateId()->contains($stateLogRelatedByNewStateId)) {
            $pos = $this->collStateLogsRelatedByNewStateId->search($stateLogRelatedByNewStateId);
            $this->collStateLogsRelatedByNewStateId->remove($pos);
            if (null === $this->stateLogsRelatedByNewStateIdScheduledForDeletion) {
                $this->stateLogsRelatedByNewStateIdScheduledForDeletion = clone $this->collStateLogsRelatedByNewStateId;
                $this->stateLogsRelatedByNewStateIdScheduledForDeletion->clear();
            }
            $this->stateLogsRelatedByNewStateIdScheduledForDeletion[]= clone $stateLogRelatedByNewStateId;
            $stateLogRelatedByNewStateId->setNewState(null);
        }

        return $this;
    }

    /**
     * Clears out the collOrders collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addOrders()
     */
    public function clearOrders()
    {
        $this->collOrders = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collOrders collection loaded partially.
     */
    public function resetPartialOrders($v = true)
    {
        $this->collOrdersPartial = $v;
    }

    /**
     * Initializes the collOrders collection.
     *
     * By default this just sets the collOrders collection to an empty array (like clearcollOrders());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initOrders($overrideExisting = true)
    {
        if (null !== $this->collOrders && !$overrideExisting) {
            return;
        }

        $collectionClassName = OrderTableMap::getTableMap()->getCollectionClassName();

        $this->collOrders = new $collectionClassName;
        $this->collOrders->setModel('\Shop\Models\Order\Order');
    }

    /**
     * Gets an array of Order objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildState is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|Order[] List of Order objects
     * @throws PropelException
     */
    public function getOrders(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collOrdersPartial && !$this->isNew();
        if (null === $this->collOrders || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collOrders) {
                // return empty collection
                $this->initOrders();
            } else {
                $collOrders = OrderQuery::create(null, $criteria)
                    ->filterByState($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collOrdersPartial && count($collOrders)) {
                        $this->initOrders(false);

                        foreach ($collOrders as $obj) {
                            if (false == $this->collOrders->contains($obj)) {
                                $this->collOrders->append($obj);
                            }
                        }

                        $this->collOrdersPartial = true;
                    }

                    return $collOrders;
                }

                if ($partial && $this->collOrders) {
                    foreach ($this->collOrders as $obj) {
                        if ($obj->isNew()) {
                            $collOrders[] = $obj;
                        }
                    }
                }

                $this->collOrders = $collOrders;
                $this->collOrdersPartial = false;
            }
        }

        return $this->collOrders;
    }

    /**
     * Sets a collection of Order objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $orders A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function setOrders(Collection $orders, ConnectionInterface $con = null)
    {
        /** @var Order[] $ordersToDelete */
        $ordersToDelete = $this->getOrders(new Criteria(), $con)->diff($orders);


        $this->ordersScheduledForDeletion = $ordersToDelete;

        foreach ($ordersToDelete as $orderRemoved) {
            $orderRemoved->setState(null);
        }

        $this->collOrders = null;
        foreach ($orders as $order) {
            $this->addOrder($order);
        }

        $this->collOrders = $orders;
        $this->collOrdersPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseOrder objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseOrder objects.
     * @throws PropelException
     */
    public function countOrders(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collOrdersPartial && !$this->isNew();
        if (null === $this->collOrders || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collOrders) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getOrders());
            }

            $query = OrderQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByState($this)
                ->count($con);
        }

        return count($this->collOrders);
    }

    /**
     * Method called to associate a Order object to this object
     * through the Order foreign key attribute.
     *
     * @param  Order $l Order
     * @return $this|\Shop\Models\State\State The current object (for fluent API support)
     */
    public function addOrder(Order $l)
    {
        if ($this->collOrders === null) {
            $this->initOrders();
            $this->collOrdersPartial = true;
        }

        if (!$this->collOrders->contains($l)) {
            $this->doAddOrder($l);

            if ($this->ordersScheduledForDeletion and $this->ordersScheduledForDeletion->contains($l)) {
                $this->ordersScheduledForDeletion->remove($this->ordersScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Order $order The Order object to add.
     */
    protected function doAddOrder(Order $order)
    {
        $this->collOrders[]= $order;
        $order->setState($this);
    }

    /**
     * @param  Order $order The Order object to remove.
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function removeOrder(Order $order)
    {
        if ($this->getOrders()->contains($order)) {
            $pos = $this->collOrders->search($order);
            $this->collOrders->remove($pos);
            if (null === $this->ordersScheduledForDeletion) {
                $this->ordersScheduledForDeletion = clone $this->collOrders;
                $this->ordersScheduledForDeletion->clear();
            }
            $this->ordersScheduledForDeletion[]= clone $order;
            $order->setState(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this State is new, it will return
     * an empty collection; or if this State has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in State.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinType(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Type', $joinBehavior);

        return $this->getOrders($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this State is new, it will return
     * an empty collection; or if this State has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in State.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinCustomer(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Customer', $joinBehavior);

        return $this->getOrders($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this State is new, it will return
     * an empty collection; or if this State has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in State.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinContractor(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Contractor', $joinBehavior);

        return $this->getOrders($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this State is new, it will return
     * an empty collection; or if this State has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in State.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinPayment(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Payment', $joinBehavior);

        return $this->getOrders($query, $con);
    }

    /**
     * Clears out the collOrderItems collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addOrderItems()
     */
    public function clearOrderItems()
    {
        $this->collOrderItems = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collOrderItems collection loaded partially.
     */
    public function resetPartialOrderItems($v = true)
    {
        $this->collOrderItemsPartial = $v;
    }

    /**
     * Initializes the collOrderItems collection.
     *
     * By default this just sets the collOrderItems collection to an empty array (like clearcollOrderItems());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initOrderItems($overrideExisting = true)
    {
        if (null !== $this->collOrderItems && !$overrideExisting) {
            return;
        }

        $collectionClassName = OrderItemTableMap::getTableMap()->getCollectionClassName();

        $this->collOrderItems = new $collectionClassName;
        $this->collOrderItems->setModel('\Shop\Models\OrderItem\OrderItem');
    }

    /**
     * Gets an array of OrderItem objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildState is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|OrderItem[] List of OrderItem objects
     * @throws PropelException
     */
    public function getOrderItems(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collOrderItemsPartial && !$this->isNew();
        if (null === $this->collOrderItems || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collOrderItems) {
                // return empty collection
                $this->initOrderItems();
            } else {
                $collOrderItems = OrderItemQuery::create(null, $criteria)
                    ->filterByState($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collOrderItemsPartial && count($collOrderItems)) {
                        $this->initOrderItems(false);

                        foreach ($collOrderItems as $obj) {
                            if (false == $this->collOrderItems->contains($obj)) {
                                $this->collOrderItems->append($obj);
                            }
                        }

                        $this->collOrderItemsPartial = true;
                    }

                    return $collOrderItems;
                }

                if ($partial && $this->collOrderItems) {
                    foreach ($this->collOrderItems as $obj) {
                        if ($obj->isNew()) {
                            $collOrderItems[] = $obj;
                        }
                    }
                }

                $this->collOrderItems = $collOrderItems;
                $this->collOrderItemsPartial = false;
            }
        }

        return $this->collOrderItems;
    }

    /**
     * Sets a collection of OrderItem objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $orderItems A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function setOrderItems(Collection $orderItems, ConnectionInterface $con = null)
    {
        /** @var OrderItem[] $orderItemsToDelete */
        $orderItemsToDelete = $this->getOrderItems(new Criteria(), $con)->diff($orderItems);


        $this->orderItemsScheduledForDeletion = $orderItemsToDelete;

        foreach ($orderItemsToDelete as $orderItemRemoved) {
            $orderItemRemoved->setState(null);
        }

        $this->collOrderItems = null;
        foreach ($orderItems as $orderItem) {
            $this->addOrderItem($orderItem);
        }

        $this->collOrderItems = $orderItems;
        $this->collOrderItemsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseOrderItem objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseOrderItem objects.
     * @throws PropelException
     */
    public function countOrderItems(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collOrderItemsPartial && !$this->isNew();
        if (null === $this->collOrderItems || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collOrderItems) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getOrderItems());
            }

            $query = OrderItemQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByState($this)
                ->count($con);
        }

        return count($this->collOrderItems);
    }

    /**
     * Method called to associate a OrderItem object to this object
     * through the OrderItem foreign key attribute.
     *
     * @param  OrderItem $l OrderItem
     * @return $this|\Shop\Models\State\State The current object (for fluent API support)
     */
    public function addOrderItem(OrderItem $l)
    {
        if ($this->collOrderItems === null) {
            $this->initOrderItems();
            $this->collOrderItemsPartial = true;
        }

        if (!$this->collOrderItems->contains($l)) {
            $this->doAddOrderItem($l);

            if ($this->orderItemsScheduledForDeletion and $this->orderItemsScheduledForDeletion->contains($l)) {
                $this->orderItemsScheduledForDeletion->remove($this->orderItemsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param OrderItem $orderItem The OrderItem object to add.
     */
    protected function doAddOrderItem(OrderItem $orderItem)
    {
        $this->collOrderItems[]= $orderItem;
        $orderItem->setState($this);
    }

    /**
     * @param  OrderItem $orderItem The OrderItem object to remove.
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function removeOrderItem(OrderItem $orderItem)
    {
        if ($this->getOrderItems()->contains($orderItem)) {
            $pos = $this->collOrderItems->search($orderItem);
            $this->collOrderItems->remove($pos);
            if (null === $this->orderItemsScheduledForDeletion) {
                $this->orderItemsScheduledForDeletion = clone $this->collOrderItems;
                $this->orderItemsScheduledForDeletion->clear();
            }
            $this->orderItemsScheduledForDeletion[]= clone $orderItem;
            $orderItem->setState(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this State is new, it will return
     * an empty collection; or if this State has previously
     * been saved, it will retrieve related OrderItems from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in State.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|OrderItem[] List of OrderItem objects
     */
    public function getOrderItemsJoinOrder(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderItemQuery::create(null, $criteria);
        $query->joinWith('Order', $joinBehavior);

        return $this->getOrderItems($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this State is new, it will return
     * an empty collection; or if this State has previously
     * been saved, it will retrieve related OrderItems from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in State.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|OrderItem[] List of OrderItem objects
     */
    public function getOrderItemsJoinCurrency(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderItemQuery::create(null, $criteria);
        $query->joinWith('Currency', $joinBehavior);

        return $this->getOrderItems($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this State is new, it will return
     * an empty collection; or if this State has previously
     * been saved, it will retrieve related OrderItems from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in State.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|OrderItem[] List of OrderItem objects
     */
    public function getOrderItemsJoinProvider(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderItemQuery::create(null, $criteria);
        $query->joinWith('Provider', $joinBehavior);

        return $this->getOrderItems($query, $con);
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        $this->id = null;
        $this->title = null;
        $this->color = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collStateLogsRelatedByOldStateId) {
                foreach ($this->collStateLogsRelatedByOldStateId as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collStateLogsRelatedByNewStateId) {
                foreach ($this->collStateLogsRelatedByNewStateId as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collOrders) {
                foreach ($this->collOrders as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collOrderItems) {
                foreach ($this->collOrderItems as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collStateLogsRelatedByOldStateId = null;
        $this->collStateLogsRelatedByNewStateId = null;
        $this->collOrders = null;
        $this->collOrderItems = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(StateTableMap::DEFAULT_STRING_FORMAT);
    }

    // archivable behavior

    /**
     * Get an archived version of the current object.
     *
     * @param ConnectionInterface $con Optional connection object
     *
     * @return     ChildShopStatesArchive An archive object, or null if the current object was never archived
     */
    public function getArchive(ConnectionInterface $con = null)
    {
        if ($this->isNew()) {
            return null;
        }
        $archive = ChildShopStatesArchiveQuery::create()
            ->filterByPrimaryKey($this->getPrimaryKey())
            ->findOne($con);

        return $archive;
    }
    /**
     * Copy the data of the current object into a $archiveTablePhpName archive object.
     * The archived object is then saved.
     * If the current object has already been archived, the archived object
     * is updated and not duplicated.
     *
     * @param ConnectionInterface $con Optional connection object
     *
     * @throws PropelException If the object is new
     *
     * @return     ChildShopStatesArchive The archive object based on this object
     */
    public function archive(ConnectionInterface $con = null)
    {
        if ($this->isNew()) {
            throw new PropelException('New objects cannot be archived. You must save the current object before calling archive().');
        }
        $archive = $this->getArchive($con);
        if (!$archive) {
            $archive = new ChildShopStatesArchive();
            $archive->setPrimaryKey($this->getPrimaryKey());
        }
        $this->copyInto($archive, $deepCopy = false, $makeNew = false);
        $archive->setArchivedAt(time());
        $archive->save($con);

        return $archive;
    }

    /**
     * Revert the the current object to the state it had when it was last archived.
     * The object must be saved afterwards if the changes must persist.
     *
     * @param ConnectionInterface $con Optional connection object
     *
     * @throws PropelException If the object has no corresponding archive.
     *
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function restoreFromArchive(ConnectionInterface $con = null)
    {
        $archive = $this->getArchive($con);
        if (!$archive) {
            throw new PropelException('The current object has never been archived and cannot be restored');
        }
        $this->populateFromArchive($archive);

        return $this;
    }

    /**
     * Populates the the current object based on a $archiveTablePhpName archive object.
     *
     * @param      ChildShopStatesArchive $archive An archived object based on the same class
      * @param      Boolean $populateAutoIncrementPrimaryKeys
     *               If true, autoincrement columns are copied from the archive object.
     *               If false, autoincrement columns are left intact.
      *
     * @return     ChildState The current object (for fluent API support)
     */
    public function populateFromArchive($archive, $populateAutoIncrementPrimaryKeys = false) {
        if ($populateAutoIncrementPrimaryKeys) {
            $this->setId($archive->getId());
        }
        $this->setTitle($archive->getTitle());
        $this->setColor($archive->getColor());

        return $this;
    }

    /**
     * Removes the object from the database without archiving it.
     *
     * @param ConnectionInterface $con Optional connection object
     *
     * @return $this|ChildState The current object (for fluent API support)
     */
    public function deleteWithoutArchive(ConnectionInterface $con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
