<?php

namespace Diamond\Models\Stat\Map;

use Diamond\Models\Stat\Stat;
use Diamond\Models\Stat\StatQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_stat' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class StatTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.Stat.Map.StatTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = '_stat';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Diamond\\Models\\Stat\\Stat';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.Stat.Stat';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 17;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 17;

    /**
     * the column name for the id field
     */
    const COL_ID = '_stat.id';

    /**
     * the column name for the datetime field
     */
    const COL_DATETIME = '_stat.datetime';

    /**
     * the column name for the remote_addr field
     */
    const COL_REMOTE_ADDR = '_stat.remote_addr';

    /**
     * the column name for the requested_page field
     */
    const COL_REQUESTED_PAGE = '_stat.requested_page';

    /**
     * the column name for the request_uri field
     */
    const COL_REQUEST_URI = '_stat.request_uri';

    /**
     * the column name for the user_agent field
     */
    const COL_USER_AGENT = '_stat.user_agent';

    /**
     * the column name for the request_method field
     */
    const COL_REQUEST_METHOD = '_stat.request_method';

    /**
     * the column name for the referer field
     */
    const COL_REFERER = '_stat.referer';

    /**
     * the column name for the elapsed_time field
     */
    const COL_ELAPSED_TIME = '_stat.elapsed_time';

    /**
     * the column name for the memory field
     */
    const COL_MEMORY = '_stat.memory';

    /**
     * the column name for the client_type field
     */
    const COL_CLIENT_TYPE = '_stat.client_type';

    /**
     * the column name for the client field
     */
    const COL_CLIENT = '_stat.client';

    /**
     * the column name for the platform field
     */
    const COL_PLATFORM = '_stat.platform';

    /**
     * the column name for the post_data field
     */
    const COL_POST_DATA = '_stat.post_data';

    /**
     * the column name for the client_user field
     */
    const COL_CLIENT_USER = '_stat.client_user';

    /**
     * the column name for the admin_user field
     */
    const COL_ADMIN_USER = '_stat.admin_user';

    /**
     * the column name for the error_message field
     */
    const COL_ERROR_MESSAGE = '_stat.error_message';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Datetime', 'RemoteAddr', 'RequestedPage', 'RequestUri', 'UserAgent', 'RequestMethod', 'Referer', 'ElapsedTime', 'Memory', 'ClientType', 'Client', 'Platform', 'PostData', 'ClientUser', 'AdminUser', 'ErrorMessage', ),
        self::TYPE_CAMELNAME     => array('id', 'datetime', 'remoteAddr', 'requestedPage', 'requestUri', 'userAgent', 'requestMethod', 'referer', 'elapsedTime', 'memory', 'clientType', 'client', 'platform', 'postData', 'clientUser', 'adminUser', 'errorMessage', ),
        self::TYPE_COLNAME       => array(StatTableMap::COL_ID, StatTableMap::COL_DATETIME, StatTableMap::COL_REMOTE_ADDR, StatTableMap::COL_REQUESTED_PAGE, StatTableMap::COL_REQUEST_URI, StatTableMap::COL_USER_AGENT, StatTableMap::COL_REQUEST_METHOD, StatTableMap::COL_REFERER, StatTableMap::COL_ELAPSED_TIME, StatTableMap::COL_MEMORY, StatTableMap::COL_CLIENT_TYPE, StatTableMap::COL_CLIENT, StatTableMap::COL_PLATFORM, StatTableMap::COL_POST_DATA, StatTableMap::COL_CLIENT_USER, StatTableMap::COL_ADMIN_USER, StatTableMap::COL_ERROR_MESSAGE, ),
        self::TYPE_FIELDNAME     => array('id', 'datetime', 'remote_addr', 'requested_page', 'request_uri', 'user_agent', 'request_method', 'referer', 'elapsed_time', 'memory', 'client_type', 'client', 'platform', 'post_data', 'client_user', 'admin_user', 'error_message', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Datetime' => 1, 'RemoteAddr' => 2, 'RequestedPage' => 3, 'RequestUri' => 4, 'UserAgent' => 5, 'RequestMethod' => 6, 'Referer' => 7, 'ElapsedTime' => 8, 'Memory' => 9, 'ClientType' => 10, 'Client' => 11, 'Platform' => 12, 'PostData' => 13, 'ClientUser' => 14, 'AdminUser' => 15, 'ErrorMessage' => 16, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'datetime' => 1, 'remoteAddr' => 2, 'requestedPage' => 3, 'requestUri' => 4, 'userAgent' => 5, 'requestMethod' => 6, 'referer' => 7, 'elapsedTime' => 8, 'memory' => 9, 'clientType' => 10, 'client' => 11, 'platform' => 12, 'postData' => 13, 'clientUser' => 14, 'adminUser' => 15, 'errorMessage' => 16, ),
        self::TYPE_COLNAME       => array(StatTableMap::COL_ID => 0, StatTableMap::COL_DATETIME => 1, StatTableMap::COL_REMOTE_ADDR => 2, StatTableMap::COL_REQUESTED_PAGE => 3, StatTableMap::COL_REQUEST_URI => 4, StatTableMap::COL_USER_AGENT => 5, StatTableMap::COL_REQUEST_METHOD => 6, StatTableMap::COL_REFERER => 7, StatTableMap::COL_ELAPSED_TIME => 8, StatTableMap::COL_MEMORY => 9, StatTableMap::COL_CLIENT_TYPE => 10, StatTableMap::COL_CLIENT => 11, StatTableMap::COL_PLATFORM => 12, StatTableMap::COL_POST_DATA => 13, StatTableMap::COL_CLIENT_USER => 14, StatTableMap::COL_ADMIN_USER => 15, StatTableMap::COL_ERROR_MESSAGE => 16, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'datetime' => 1, 'remote_addr' => 2, 'requested_page' => 3, 'request_uri' => 4, 'user_agent' => 5, 'request_method' => 6, 'referer' => 7, 'elapsed_time' => 8, 'memory' => 9, 'client_type' => 10, 'client' => 11, 'platform' => 12, 'post_data' => 13, 'client_user' => 14, 'admin_user' => 15, 'error_message' => 16, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('_stat');
        $this->setPhpName('Stat');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Models\\Stat\\Stat');
        $this->setPackage('Models.Stat');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('datetime', 'Datetime', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('remote_addr', 'RemoteAddr', 'CHAR', true, 20, null);
        $this->addColumn('requested_page', 'RequestedPage', 'VARCHAR', true, 1000, null);
        $this->addColumn('request_uri', 'RequestUri', 'VARCHAR', false, 1000, null);
        $this->addColumn('user_agent', 'UserAgent', 'VARCHAR', false, 1000, null);
        $this->addColumn('request_method', 'RequestMethod', 'CHAR', false, 10, null);
        $this->addColumn('referer', 'Referer', 'VARCHAR', false, 255, null);
        $this->addColumn('elapsed_time', 'ElapsedTime', 'DECIMAL', false, 10, null);
        $this->addColumn('memory', 'Memory', 'DECIMAL', false, 10, null);
        $this->addColumn('client_type', 'ClientType', 'CHAR', true, null, 'other');
        $this->addColumn('client', 'Client', 'VARCHAR', false, 120, null);
        $this->addColumn('platform', 'Platform', 'VARCHAR', false, 120, null);
        $this->addColumn('post_data', 'PostData', 'LONGVARCHAR', false, null, null);
        $this->addColumn('client_user', 'ClientUser', 'INTEGER', false, null, null);
        $this->addColumn('admin_user', 'AdminUser', 'INTEGER', false, null, null);
        $this->addColumn('error_message', 'ErrorMessage', 'VARCHAR', false, 500, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? StatTableMap::CLASS_DEFAULT : StatTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (Stat object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = StatTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = StatTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + StatTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = StatTableMap::OM_CLASS;
            /** @var Stat $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            StatTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = StatTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = StatTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Stat $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                StatTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(StatTableMap::COL_ID);
            $criteria->addSelectColumn(StatTableMap::COL_DATETIME);
            $criteria->addSelectColumn(StatTableMap::COL_REMOTE_ADDR);
            $criteria->addSelectColumn(StatTableMap::COL_REQUESTED_PAGE);
            $criteria->addSelectColumn(StatTableMap::COL_REQUEST_URI);
            $criteria->addSelectColumn(StatTableMap::COL_USER_AGENT);
            $criteria->addSelectColumn(StatTableMap::COL_REQUEST_METHOD);
            $criteria->addSelectColumn(StatTableMap::COL_REFERER);
            $criteria->addSelectColumn(StatTableMap::COL_ELAPSED_TIME);
            $criteria->addSelectColumn(StatTableMap::COL_MEMORY);
            $criteria->addSelectColumn(StatTableMap::COL_CLIENT_TYPE);
            $criteria->addSelectColumn(StatTableMap::COL_CLIENT);
            $criteria->addSelectColumn(StatTableMap::COL_PLATFORM);
            $criteria->addSelectColumn(StatTableMap::COL_POST_DATA);
            $criteria->addSelectColumn(StatTableMap::COL_CLIENT_USER);
            $criteria->addSelectColumn(StatTableMap::COL_ADMIN_USER);
            $criteria->addSelectColumn(StatTableMap::COL_ERROR_MESSAGE);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.datetime');
            $criteria->addSelectColumn($alias . '.remote_addr');
            $criteria->addSelectColumn($alias . '.requested_page');
            $criteria->addSelectColumn($alias . '.request_uri');
            $criteria->addSelectColumn($alias . '.user_agent');
            $criteria->addSelectColumn($alias . '.request_method');
            $criteria->addSelectColumn($alias . '.referer');
            $criteria->addSelectColumn($alias . '.elapsed_time');
            $criteria->addSelectColumn($alias . '.memory');
            $criteria->addSelectColumn($alias . '.client_type');
            $criteria->addSelectColumn($alias . '.client');
            $criteria->addSelectColumn($alias . '.platform');
            $criteria->addSelectColumn($alias . '.post_data');
            $criteria->addSelectColumn($alias . '.client_user');
            $criteria->addSelectColumn($alias . '.admin_user');
            $criteria->addSelectColumn($alias . '.error_message');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(StatTableMap::DATABASE_NAME)->getTable(StatTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(StatTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(StatTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new StatTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a Stat or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or Stat object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Models\Stat\Stat) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(StatTableMap::DATABASE_NAME);
            $criteria->add(StatTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = StatQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            StatTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                StatTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _stat table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return StatQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Stat or Criteria object.
     *
     * @param mixed               $criteria Criteria or Stat object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Stat object
        }

        if ($criteria->containsKey(StatTableMap::COL_ID) && $criteria->keyContainsValue(StatTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.StatTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = StatQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // StatTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
StatTableMap::buildTableMap();
