<?php

namespace Diamond\Models\Stat\Base;

use \Exception;
use \PDO;
use Diamond\Models\Stat\Stat as ChildStat;
use Diamond\Models\Stat\StatQuery as ChildStatQuery;
use Diamond\Models\Stat\Map\StatTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_stat' table.
 *
 *
 *
 * @method     ChildStatQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildStatQuery orderByDatetime($order = Criteria::ASC) Order by the datetime column
 * @method     ChildStatQuery orderByRemoteAddr($order = Criteria::ASC) Order by the remote_addr column
 * @method     ChildStatQuery orderByRequestedPage($order = Criteria::ASC) Order by the requested_page column
 * @method     ChildStatQuery orderByRequestUri($order = Criteria::ASC) Order by the request_uri column
 * @method     ChildStatQuery orderByUserAgent($order = Criteria::ASC) Order by the user_agent column
 * @method     ChildStatQuery orderByRequestMethod($order = Criteria::ASC) Order by the request_method column
 * @method     ChildStatQuery orderByReferer($order = Criteria::ASC) Order by the referer column
 * @method     ChildStatQuery orderByElapsedTime($order = Criteria::ASC) Order by the elapsed_time column
 * @method     ChildStatQuery orderByMemory($order = Criteria::ASC) Order by the memory column
 * @method     ChildStatQuery orderByClientType($order = Criteria::ASC) Order by the client_type column
 * @method     ChildStatQuery orderByClient($order = Criteria::ASC) Order by the client column
 * @method     ChildStatQuery orderByPlatform($order = Criteria::ASC) Order by the platform column
 * @method     ChildStatQuery orderByPostData($order = Criteria::ASC) Order by the post_data column
 * @method     ChildStatQuery orderByClientUser($order = Criteria::ASC) Order by the client_user column
 * @method     ChildStatQuery orderByAdminUser($order = Criteria::ASC) Order by the admin_user column
 * @method     ChildStatQuery orderByErrorMessage($order = Criteria::ASC) Order by the error_message column
 *
 * @method     ChildStatQuery groupById() Group by the id column
 * @method     ChildStatQuery groupByDatetime() Group by the datetime column
 * @method     ChildStatQuery groupByRemoteAddr() Group by the remote_addr column
 * @method     ChildStatQuery groupByRequestedPage() Group by the requested_page column
 * @method     ChildStatQuery groupByRequestUri() Group by the request_uri column
 * @method     ChildStatQuery groupByUserAgent() Group by the user_agent column
 * @method     ChildStatQuery groupByRequestMethod() Group by the request_method column
 * @method     ChildStatQuery groupByReferer() Group by the referer column
 * @method     ChildStatQuery groupByElapsedTime() Group by the elapsed_time column
 * @method     ChildStatQuery groupByMemory() Group by the memory column
 * @method     ChildStatQuery groupByClientType() Group by the client_type column
 * @method     ChildStatQuery groupByClient() Group by the client column
 * @method     ChildStatQuery groupByPlatform() Group by the platform column
 * @method     ChildStatQuery groupByPostData() Group by the post_data column
 * @method     ChildStatQuery groupByClientUser() Group by the client_user column
 * @method     ChildStatQuery groupByAdminUser() Group by the admin_user column
 * @method     ChildStatQuery groupByErrorMessage() Group by the error_message column
 *
 * @method     ChildStatQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildStatQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildStatQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildStatQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildStatQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildStatQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildStat findOne(ConnectionInterface $con = null) Return the first ChildStat matching the query
 * @method     ChildStat findOneOrCreate(ConnectionInterface $con = null) Return the first ChildStat matching the query, or a new ChildStat object populated from the query conditions when no match is found
 *
 * @method     ChildStat findOneById(int $id) Return the first ChildStat filtered by the id column
 * @method     ChildStat findOneByDatetime(string $datetime) Return the first ChildStat filtered by the datetime column
 * @method     ChildStat findOneByRemoteAddr(string $remote_addr) Return the first ChildStat filtered by the remote_addr column
 * @method     ChildStat findOneByRequestedPage(string $requested_page) Return the first ChildStat filtered by the requested_page column
 * @method     ChildStat findOneByRequestUri(string $request_uri) Return the first ChildStat filtered by the request_uri column
 * @method     ChildStat findOneByUserAgent(string $user_agent) Return the first ChildStat filtered by the user_agent column
 * @method     ChildStat findOneByRequestMethod(string $request_method) Return the first ChildStat filtered by the request_method column
 * @method     ChildStat findOneByReferer(string $referer) Return the first ChildStat filtered by the referer column
 * @method     ChildStat findOneByElapsedTime(string $elapsed_time) Return the first ChildStat filtered by the elapsed_time column
 * @method     ChildStat findOneByMemory(string $memory) Return the first ChildStat filtered by the memory column
 * @method     ChildStat findOneByClientType(string $client_type) Return the first ChildStat filtered by the client_type column
 * @method     ChildStat findOneByClient(string $client) Return the first ChildStat filtered by the client column
 * @method     ChildStat findOneByPlatform(string $platform) Return the first ChildStat filtered by the platform column
 * @method     ChildStat findOneByPostData(string $post_data) Return the first ChildStat filtered by the post_data column
 * @method     ChildStat findOneByClientUser(int $client_user) Return the first ChildStat filtered by the client_user column
 * @method     ChildStat findOneByAdminUser(int $admin_user) Return the first ChildStat filtered by the admin_user column
 * @method     ChildStat findOneByErrorMessage(string $error_message) Return the first ChildStat filtered by the error_message column *

 * @method     ChildStat requirePk($key, ConnectionInterface $con = null) Return the ChildStat by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOne(ConnectionInterface $con = null) Return the first ChildStat matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStat requireOneById(int $id) Return the first ChildStat filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByDatetime(string $datetime) Return the first ChildStat filtered by the datetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByRemoteAddr(string $remote_addr) Return the first ChildStat filtered by the remote_addr column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByRequestedPage(string $requested_page) Return the first ChildStat filtered by the requested_page column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByRequestUri(string $request_uri) Return the first ChildStat filtered by the request_uri column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByUserAgent(string $user_agent) Return the first ChildStat filtered by the user_agent column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByRequestMethod(string $request_method) Return the first ChildStat filtered by the request_method column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByReferer(string $referer) Return the first ChildStat filtered by the referer column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByElapsedTime(string $elapsed_time) Return the first ChildStat filtered by the elapsed_time column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByMemory(string $memory) Return the first ChildStat filtered by the memory column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByClientType(string $client_type) Return the first ChildStat filtered by the client_type column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByClient(string $client) Return the first ChildStat filtered by the client column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByPlatform(string $platform) Return the first ChildStat filtered by the platform column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByPostData(string $post_data) Return the first ChildStat filtered by the post_data column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByClientUser(int $client_user) Return the first ChildStat filtered by the client_user column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByAdminUser(int $admin_user) Return the first ChildStat filtered by the admin_user column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStat requireOneByErrorMessage(string $error_message) Return the first ChildStat filtered by the error_message column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStat[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildStat objects based on current ModelCriteria
 * @method     ChildStat[]|ObjectCollection findById(int $id) Return ChildStat objects filtered by the id column
 * @method     ChildStat[]|ObjectCollection findByDatetime(string $datetime) Return ChildStat objects filtered by the datetime column
 * @method     ChildStat[]|ObjectCollection findByRemoteAddr(string $remote_addr) Return ChildStat objects filtered by the remote_addr column
 * @method     ChildStat[]|ObjectCollection findByRequestedPage(string $requested_page) Return ChildStat objects filtered by the requested_page column
 * @method     ChildStat[]|ObjectCollection findByRequestUri(string $request_uri) Return ChildStat objects filtered by the request_uri column
 * @method     ChildStat[]|ObjectCollection findByUserAgent(string $user_agent) Return ChildStat objects filtered by the user_agent column
 * @method     ChildStat[]|ObjectCollection findByRequestMethod(string $request_method) Return ChildStat objects filtered by the request_method column
 * @method     ChildStat[]|ObjectCollection findByReferer(string $referer) Return ChildStat objects filtered by the referer column
 * @method     ChildStat[]|ObjectCollection findByElapsedTime(string $elapsed_time) Return ChildStat objects filtered by the elapsed_time column
 * @method     ChildStat[]|ObjectCollection findByMemory(string $memory) Return ChildStat objects filtered by the memory column
 * @method     ChildStat[]|ObjectCollection findByClientType(string $client_type) Return ChildStat objects filtered by the client_type column
 * @method     ChildStat[]|ObjectCollection findByClient(string $client) Return ChildStat objects filtered by the client column
 * @method     ChildStat[]|ObjectCollection findByPlatform(string $platform) Return ChildStat objects filtered by the platform column
 * @method     ChildStat[]|ObjectCollection findByPostData(string $post_data) Return ChildStat objects filtered by the post_data column
 * @method     ChildStat[]|ObjectCollection findByClientUser(int $client_user) Return ChildStat objects filtered by the client_user column
 * @method     ChildStat[]|ObjectCollection findByAdminUser(int $admin_user) Return ChildStat objects filtered by the admin_user column
 * @method     ChildStat[]|ObjectCollection findByErrorMessage(string $error_message) Return ChildStat objects filtered by the error_message column
 * @method     ChildStat[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class StatQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Models\Stat\Base\StatQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Models\\Stat\\Stat', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildStatQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildStatQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildStatQuery) {
            return $criteria;
        }
        $query = new ChildStatQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildStat|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StatTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = StatTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildStat A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `datetime`, `remote_addr`, `requested_page`, `request_uri`, `user_agent`, `request_method`, `referer`, `elapsed_time`, `memory`, `client_type`, `client`, `platform`, `post_data`, `client_user`, `admin_user`, `error_message` FROM `_stat` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildStat $obj */
            $obj = new ChildStat();
            $obj->hydrate($row);
            StatTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildStat|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(StatTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(StatTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(StatTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(StatTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the datetime column
     *
     * Example usage:
     * <code>
     * $query->filterByDatetime('2011-03-14'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime('now'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime(array('max' => 'yesterday')); // WHERE datetime > '2011-03-13'
     * </code>
     *
     * @param     mixed $datetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByDatetime($datetime = null, $comparison = null)
    {
        if (is_array($datetime)) {
            $useMinMax = false;
            if (isset($datetime['min'])) {
                $this->addUsingAlias(StatTableMap::COL_DATETIME, $datetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datetime['max'])) {
                $this->addUsingAlias(StatTableMap::COL_DATETIME, $datetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_DATETIME, $datetime, $comparison);
    }

    /**
     * Filter the query on the remote_addr column
     *
     * Example usage:
     * <code>
     * $query->filterByRemoteAddr('fooValue');   // WHERE remote_addr = 'fooValue'
     * $query->filterByRemoteAddr('%fooValue%', Criteria::LIKE); // WHERE remote_addr LIKE '%fooValue%'
     * </code>
     *
     * @param     string $remoteAddr The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByRemoteAddr($remoteAddr = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($remoteAddr)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_REMOTE_ADDR, $remoteAddr, $comparison);
    }

    /**
     * Filter the query on the requested_page column
     *
     * Example usage:
     * <code>
     * $query->filterByRequestedPage('fooValue');   // WHERE requested_page = 'fooValue'
     * $query->filterByRequestedPage('%fooValue%', Criteria::LIKE); // WHERE requested_page LIKE '%fooValue%'
     * </code>
     *
     * @param     string $requestedPage The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByRequestedPage($requestedPage = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($requestedPage)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_REQUESTED_PAGE, $requestedPage, $comparison);
    }

    /**
     * Filter the query on the request_uri column
     *
     * Example usage:
     * <code>
     * $query->filterByRequestUri('fooValue');   // WHERE request_uri = 'fooValue'
     * $query->filterByRequestUri('%fooValue%', Criteria::LIKE); // WHERE request_uri LIKE '%fooValue%'
     * </code>
     *
     * @param     string $requestUri The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByRequestUri($requestUri = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($requestUri)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_REQUEST_URI, $requestUri, $comparison);
    }

    /**
     * Filter the query on the user_agent column
     *
     * Example usage:
     * <code>
     * $query->filterByUserAgent('fooValue');   // WHERE user_agent = 'fooValue'
     * $query->filterByUserAgent('%fooValue%', Criteria::LIKE); // WHERE user_agent LIKE '%fooValue%'
     * </code>
     *
     * @param     string $userAgent The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByUserAgent($userAgent = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($userAgent)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_USER_AGENT, $userAgent, $comparison);
    }

    /**
     * Filter the query on the request_method column
     *
     * Example usage:
     * <code>
     * $query->filterByRequestMethod('fooValue');   // WHERE request_method = 'fooValue'
     * $query->filterByRequestMethod('%fooValue%', Criteria::LIKE); // WHERE request_method LIKE '%fooValue%'
     * </code>
     *
     * @param     string $requestMethod The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByRequestMethod($requestMethod = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($requestMethod)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_REQUEST_METHOD, $requestMethod, $comparison);
    }

    /**
     * Filter the query on the referer column
     *
     * Example usage:
     * <code>
     * $query->filterByReferer('fooValue');   // WHERE referer = 'fooValue'
     * $query->filterByReferer('%fooValue%', Criteria::LIKE); // WHERE referer LIKE '%fooValue%'
     * </code>
     *
     * @param     string $referer The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByReferer($referer = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($referer)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_REFERER, $referer, $comparison);
    }

    /**
     * Filter the query on the elapsed_time column
     *
     * Example usage:
     * <code>
     * $query->filterByElapsedTime(1234); // WHERE elapsed_time = 1234
     * $query->filterByElapsedTime(array(12, 34)); // WHERE elapsed_time IN (12, 34)
     * $query->filterByElapsedTime(array('min' => 12)); // WHERE elapsed_time > 12
     * </code>
     *
     * @param     mixed $elapsedTime The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByElapsedTime($elapsedTime = null, $comparison = null)
    {
        if (is_array($elapsedTime)) {
            $useMinMax = false;
            if (isset($elapsedTime['min'])) {
                $this->addUsingAlias(StatTableMap::COL_ELAPSED_TIME, $elapsedTime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($elapsedTime['max'])) {
                $this->addUsingAlias(StatTableMap::COL_ELAPSED_TIME, $elapsedTime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_ELAPSED_TIME, $elapsedTime, $comparison);
    }

    /**
     * Filter the query on the memory column
     *
     * Example usage:
     * <code>
     * $query->filterByMemory(1234); // WHERE memory = 1234
     * $query->filterByMemory(array(12, 34)); // WHERE memory IN (12, 34)
     * $query->filterByMemory(array('min' => 12)); // WHERE memory > 12
     * </code>
     *
     * @param     mixed $memory The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByMemory($memory = null, $comparison = null)
    {
        if (is_array($memory)) {
            $useMinMax = false;
            if (isset($memory['min'])) {
                $this->addUsingAlias(StatTableMap::COL_MEMORY, $memory['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($memory['max'])) {
                $this->addUsingAlias(StatTableMap::COL_MEMORY, $memory['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_MEMORY, $memory, $comparison);
    }

    /**
     * Filter the query on the client_type column
     *
     * Example usage:
     * <code>
     * $query->filterByClientType('fooValue');   // WHERE client_type = 'fooValue'
     * $query->filterByClientType('%fooValue%', Criteria::LIKE); // WHERE client_type LIKE '%fooValue%'
     * </code>
     *
     * @param     string $clientType The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByClientType($clientType = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($clientType)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_CLIENT_TYPE, $clientType, $comparison);
    }

    /**
     * Filter the query on the client column
     *
     * Example usage:
     * <code>
     * $query->filterByClient('fooValue');   // WHERE client = 'fooValue'
     * $query->filterByClient('%fooValue%', Criteria::LIKE); // WHERE client LIKE '%fooValue%'
     * </code>
     *
     * @param     string $client The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByClient($client = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($client)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_CLIENT, $client, $comparison);
    }

    /**
     * Filter the query on the platform column
     *
     * Example usage:
     * <code>
     * $query->filterByPlatform('fooValue');   // WHERE platform = 'fooValue'
     * $query->filterByPlatform('%fooValue%', Criteria::LIKE); // WHERE platform LIKE '%fooValue%'
     * </code>
     *
     * @param     string $platform The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByPlatform($platform = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($platform)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_PLATFORM, $platform, $comparison);
    }

    /**
     * Filter the query on the post_data column
     *
     * Example usage:
     * <code>
     * $query->filterByPostData('fooValue');   // WHERE post_data = 'fooValue'
     * $query->filterByPostData('%fooValue%', Criteria::LIKE); // WHERE post_data LIKE '%fooValue%'
     * </code>
     *
     * @param     string $postData The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByPostData($postData = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($postData)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_POST_DATA, $postData, $comparison);
    }

    /**
     * Filter the query on the client_user column
     *
     * Example usage:
     * <code>
     * $query->filterByClientUser(1234); // WHERE client_user = 1234
     * $query->filterByClientUser(array(12, 34)); // WHERE client_user IN (12, 34)
     * $query->filterByClientUser(array('min' => 12)); // WHERE client_user > 12
     * </code>
     *
     * @param     mixed $clientUser The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByClientUser($clientUser = null, $comparison = null)
    {
        if (is_array($clientUser)) {
            $useMinMax = false;
            if (isset($clientUser['min'])) {
                $this->addUsingAlias(StatTableMap::COL_CLIENT_USER, $clientUser['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($clientUser['max'])) {
                $this->addUsingAlias(StatTableMap::COL_CLIENT_USER, $clientUser['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_CLIENT_USER, $clientUser, $comparison);
    }

    /**
     * Filter the query on the admin_user column
     *
     * Example usage:
     * <code>
     * $query->filterByAdminUser(1234); // WHERE admin_user = 1234
     * $query->filterByAdminUser(array(12, 34)); // WHERE admin_user IN (12, 34)
     * $query->filterByAdminUser(array('min' => 12)); // WHERE admin_user > 12
     * </code>
     *
     * @param     mixed $adminUser The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByAdminUser($adminUser = null, $comparison = null)
    {
        if (is_array($adminUser)) {
            $useMinMax = false;
            if (isset($adminUser['min'])) {
                $this->addUsingAlias(StatTableMap::COL_ADMIN_USER, $adminUser['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($adminUser['max'])) {
                $this->addUsingAlias(StatTableMap::COL_ADMIN_USER, $adminUser['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_ADMIN_USER, $adminUser, $comparison);
    }

    /**
     * Filter the query on the error_message column
     *
     * Example usage:
     * <code>
     * $query->filterByErrorMessage('fooValue');   // WHERE error_message = 'fooValue'
     * $query->filterByErrorMessage('%fooValue%', Criteria::LIKE); // WHERE error_message LIKE '%fooValue%'
     * </code>
     *
     * @param     string $errorMessage The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function filterByErrorMessage($errorMessage = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($errorMessage)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StatTableMap::COL_ERROR_MESSAGE, $errorMessage, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   ChildStat $stat Object to remove from the list of results
     *
     * @return $this|ChildStatQuery The current query, for fluid interface
     */
    public function prune($stat = null)
    {
        if ($stat) {
            $this->addUsingAlias(StatTableMap::COL_ID, $stat->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _stat table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            StatTableMap::clearInstancePool();
            StatTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(StatTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            StatTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            StatTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // StatQuery
