<?php

namespace Shop\Models\Provider\Base;

use \Exception;
use \PDO;
use PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelation;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Currency\Currency;
use Shop\Models\Customer\Customer;
use Shop\Models\OrderItem\OrderItem;
use Shop\Models\PricelistFile\PricelistFile;
use Shop\Models\Provider\Provider as ChildProvider;
use Shop\Models\Provider\ProviderQuery as ChildProviderQuery;
use Shop\Models\Provider\ShopProvidersArchive as ChildShopProvidersArchive;
use Shop\Models\Provider\Map\ProviderTableMap;

/**
 * Base class that represents a query for the 'shop_providers' table.
 *
 *
 *
 * @method     ChildProviderQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildProviderQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildProviderQuery orderByTerm($order = Criteria::ASC) Order by the term column
 * @method     ChildProviderQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildProviderQuery orderByContact($order = Criteria::ASC) Order by the contact column
 * @method     ChildProviderQuery orderByDestination($order = Criteria::ASC) Order by the destination column
 * @method     ChildProviderQuery orderByColor($order = Criteria::ASC) Order by the color column
 * @method     ChildProviderQuery orderByShopId($order = Criteria::ASC) Order by the shop_id column
 * @method     ChildProviderQuery orderByCurrencyId($order = Criteria::ASC) Order by the crrency_id column
 * @method     ChildProviderQuery orderByContractorId($order = Criteria::ASC) Order by the contractor_id column
 *
 * @method     ChildProviderQuery groupById() Group by the id column
 * @method     ChildProviderQuery groupByName() Group by the name column
 * @method     ChildProviderQuery groupByTerm() Group by the term column
 * @method     ChildProviderQuery groupByDesc() Group by the desc column
 * @method     ChildProviderQuery groupByContact() Group by the contact column
 * @method     ChildProviderQuery groupByDestination() Group by the destination column
 * @method     ChildProviderQuery groupByColor() Group by the color column
 * @method     ChildProviderQuery groupByShopId() Group by the shop_id column
 * @method     ChildProviderQuery groupByCurrencyId() Group by the crrency_id column
 * @method     ChildProviderQuery groupByContractorId() Group by the contractor_id column
 *
 * @method     ChildProviderQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildProviderQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildProviderQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildProviderQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildProviderQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildProviderQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildProviderQuery leftJoinCurrency($relationAlias = null) Adds a LEFT JOIN clause to the query using the Currency relation
 * @method     ChildProviderQuery rightJoinCurrency($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Currency relation
 * @method     ChildProviderQuery innerJoinCurrency($relationAlias = null) Adds a INNER JOIN clause to the query using the Currency relation
 *
 * @method     ChildProviderQuery joinWithCurrency($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Currency relation
 *
 * @method     ChildProviderQuery leftJoinWithCurrency() Adds a LEFT JOIN clause and with to the query using the Currency relation
 * @method     ChildProviderQuery rightJoinWithCurrency() Adds a RIGHT JOIN clause and with to the query using the Currency relation
 * @method     ChildProviderQuery innerJoinWithCurrency() Adds a INNER JOIN clause and with to the query using the Currency relation
 *
 * @method     ChildProviderQuery leftJoinContractor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Contractor relation
 * @method     ChildProviderQuery rightJoinContractor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Contractor relation
 * @method     ChildProviderQuery innerJoinContractor($relationAlias = null) Adds a INNER JOIN clause to the query using the Contractor relation
 *
 * @method     ChildProviderQuery joinWithContractor($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Contractor relation
 *
 * @method     ChildProviderQuery leftJoinWithContractor() Adds a LEFT JOIN clause and with to the query using the Contractor relation
 * @method     ChildProviderQuery rightJoinWithContractor() Adds a RIGHT JOIN clause and with to the query using the Contractor relation
 * @method     ChildProviderQuery innerJoinWithContractor() Adds a INNER JOIN clause and with to the query using the Contractor relation
 *
 * @method     ChildProviderQuery leftJoinSyncProviderRelation($relationAlias = null) Adds a LEFT JOIN clause to the query using the SyncProviderRelation relation
 * @method     ChildProviderQuery rightJoinSyncProviderRelation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the SyncProviderRelation relation
 * @method     ChildProviderQuery innerJoinSyncProviderRelation($relationAlias = null) Adds a INNER JOIN clause to the query using the SyncProviderRelation relation
 *
 * @method     ChildProviderQuery joinWithSyncProviderRelation($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the SyncProviderRelation relation
 *
 * @method     ChildProviderQuery leftJoinWithSyncProviderRelation() Adds a LEFT JOIN clause and with to the query using the SyncProviderRelation relation
 * @method     ChildProviderQuery rightJoinWithSyncProviderRelation() Adds a RIGHT JOIN clause and with to the query using the SyncProviderRelation relation
 * @method     ChildProviderQuery innerJoinWithSyncProviderRelation() Adds a INNER JOIN clause and with to the query using the SyncProviderRelation relation
 *
 * @method     ChildProviderQuery leftJoinOrderItem($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderItem relation
 * @method     ChildProviderQuery rightJoinOrderItem($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderItem relation
 * @method     ChildProviderQuery innerJoinOrderItem($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderItem relation
 *
 * @method     ChildProviderQuery joinWithOrderItem($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderItem relation
 *
 * @method     ChildProviderQuery leftJoinWithOrderItem() Adds a LEFT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildProviderQuery rightJoinWithOrderItem() Adds a RIGHT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildProviderQuery innerJoinWithOrderItem() Adds a INNER JOIN clause and with to the query using the OrderItem relation
 *
 * @method     ChildProviderQuery leftJoinPricelistFile($relationAlias = null) Adds a LEFT JOIN clause to the query using the PricelistFile relation
 * @method     ChildProviderQuery rightJoinPricelistFile($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PricelistFile relation
 * @method     ChildProviderQuery innerJoinPricelistFile($relationAlias = null) Adds a INNER JOIN clause to the query using the PricelistFile relation
 *
 * @method     ChildProviderQuery joinWithPricelistFile($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the PricelistFile relation
 *
 * @method     ChildProviderQuery leftJoinWithPricelistFile() Adds a LEFT JOIN clause and with to the query using the PricelistFile relation
 * @method     ChildProviderQuery rightJoinWithPricelistFile() Adds a RIGHT JOIN clause and with to the query using the PricelistFile relation
 * @method     ChildProviderQuery innerJoinWithPricelistFile() Adds a INNER JOIN clause and with to the query using the PricelistFile relation
 *
 * @method     \Shop\Models\Currency\CurrencyQuery|\Shop\Models\Customer\CustomerQuery|\PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelationQuery|\Shop\Models\OrderItem\OrderItemQuery|\Shop\Models\PricelistFile\PricelistFileQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildProvider findOne(ConnectionInterface $con = null) Return the first ChildProvider matching the query
 * @method     ChildProvider findOneOrCreate(ConnectionInterface $con = null) Return the first ChildProvider matching the query, or a new ChildProvider object populated from the query conditions when no match is found
 *
 * @method     ChildProvider findOneById(int $id) Return the first ChildProvider filtered by the id column
 * @method     ChildProvider findOneByName(string $name) Return the first ChildProvider filtered by the name column
 * @method     ChildProvider findOneByTerm(int $term) Return the first ChildProvider filtered by the term column
 * @method     ChildProvider findOneByDesc(string $desc) Return the first ChildProvider filtered by the desc column
 * @method     ChildProvider findOneByContact(string $contact) Return the first ChildProvider filtered by the contact column
 * @method     ChildProvider findOneByDestination(string $destination) Return the first ChildProvider filtered by the destination column
 * @method     ChildProvider findOneByColor(string $color) Return the first ChildProvider filtered by the color column
 * @method     ChildProvider findOneByShopId(int $shop_id) Return the first ChildProvider filtered by the shop_id column
 * @method     ChildProvider findOneByCurrencyId(int $crrency_id) Return the first ChildProvider filtered by the crrency_id column
 * @method     ChildProvider findOneByContractorId(int $contractor_id) Return the first ChildProvider filtered by the contractor_id column *

 * @method     ChildProvider requirePk($key, ConnectionInterface $con = null) Return the ChildProvider by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOne(ConnectionInterface $con = null) Return the first ChildProvider matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProvider requireOneById(int $id) Return the first ChildProvider filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByName(string $name) Return the first ChildProvider filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByTerm(int $term) Return the first ChildProvider filtered by the term column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByDesc(string $desc) Return the first ChildProvider filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByContact(string $contact) Return the first ChildProvider filtered by the contact column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByDestination(string $destination) Return the first ChildProvider filtered by the destination column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByColor(string $color) Return the first ChildProvider filtered by the color column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByShopId(int $shop_id) Return the first ChildProvider filtered by the shop_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByCurrencyId(int $crrency_id) Return the first ChildProvider filtered by the crrency_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProvider requireOneByContractorId(int $contractor_id) Return the first ChildProvider filtered by the contractor_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProvider[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildProvider objects based on current ModelCriteria
 * @method     ChildProvider[]|ObjectCollection findById(int $id) Return ChildProvider objects filtered by the id column
 * @method     ChildProvider[]|ObjectCollection findByName(string $name) Return ChildProvider objects filtered by the name column
 * @method     ChildProvider[]|ObjectCollection findByTerm(int $term) Return ChildProvider objects filtered by the term column
 * @method     ChildProvider[]|ObjectCollection findByDesc(string $desc) Return ChildProvider objects filtered by the desc column
 * @method     ChildProvider[]|ObjectCollection findByContact(string $contact) Return ChildProvider objects filtered by the contact column
 * @method     ChildProvider[]|ObjectCollection findByDestination(string $destination) Return ChildProvider objects filtered by the destination column
 * @method     ChildProvider[]|ObjectCollection findByColor(string $color) Return ChildProvider objects filtered by the color column
 * @method     ChildProvider[]|ObjectCollection findByShopId(int $shop_id) Return ChildProvider objects filtered by the shop_id column
 * @method     ChildProvider[]|ObjectCollection findByCurrencyId(int $crrency_id) Return ChildProvider objects filtered by the crrency_id column
 * @method     ChildProvider[]|ObjectCollection findByContractorId(int $contractor_id) Return ChildProvider objects filtered by the contractor_id column
 * @method     ChildProvider[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ProviderQuery extends ModelCriteria
{

    // archivable behavior
    protected $archiveOnDelete = true;
protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\Provider\Base\ProviderQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Provider\\Provider', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildProviderQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildProviderQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildProviderQuery) {
            return $criteria;
        }
        $query = new ChildProviderQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildProvider|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ProviderTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ProviderTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProvider A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `term`, `desc`, `contact`, `destination`, `color`, `shop_id`, `crrency_id`, `contractor_id` FROM `shop_providers` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildProvider $obj */
            $obj = new ChildProvider();
            $obj->hydrate($row);
            ProviderTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildProvider|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProviderTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProviderTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the term column
     *
     * Example usage:
     * <code>
     * $query->filterByTerm(1234); // WHERE term = 1234
     * $query->filterByTerm(array(12, 34)); // WHERE term IN (12, 34)
     * $query->filterByTerm(array('min' => 12)); // WHERE term > 12
     * </code>
     *
     * @param     mixed $term The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByTerm($term = null, $comparison = null)
    {
        if (is_array($term)) {
            $useMinMax = false;
            if (isset($term['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_TERM, $term['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($term['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_TERM, $term['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_TERM, $term, $comparison);
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $desc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByDesc($desc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_DESC, $desc, $comparison);
    }

    /**
     * Filter the query on the contact column
     *
     * Example usage:
     * <code>
     * $query->filterByContact('fooValue');   // WHERE contact = 'fooValue'
     * $query->filterByContact('%fooValue%', Criteria::LIKE); // WHERE contact LIKE '%fooValue%'
     * </code>
     *
     * @param     string $contact The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByContact($contact = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($contact)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_CONTACT, $contact, $comparison);
    }

    /**
     * Filter the query on the destination column
     *
     * Example usage:
     * <code>
     * $query->filterByDestination('fooValue');   // WHERE destination = 'fooValue'
     * $query->filterByDestination('%fooValue%', Criteria::LIKE); // WHERE destination LIKE '%fooValue%'
     * </code>
     *
     * @param     string $destination The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByDestination($destination = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($destination)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_DESTINATION, $destination, $comparison);
    }

    /**
     * Filter the query on the color column
     *
     * Example usage:
     * <code>
     * $query->filterByColor('fooValue');   // WHERE color = 'fooValue'
     * $query->filterByColor('%fooValue%', Criteria::LIKE); // WHERE color LIKE '%fooValue%'
     * </code>
     *
     * @param     string $color The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByColor($color = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($color)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_COLOR, $color, $comparison);
    }

    /**
     * Filter the query on the shop_id column
     *
     * Example usage:
     * <code>
     * $query->filterByShopId(1234); // WHERE shop_id = 1234
     * $query->filterByShopId(array(12, 34)); // WHERE shop_id IN (12, 34)
     * $query->filterByShopId(array('min' => 12)); // WHERE shop_id > 12
     * </code>
     *
     * @param     mixed $shopId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByShopId($shopId = null, $comparison = null)
    {
        if (is_array($shopId)) {
            $useMinMax = false;
            if (isset($shopId['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_SHOP_ID, $shopId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($shopId['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_SHOP_ID, $shopId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_SHOP_ID, $shopId, $comparison);
    }

    /**
     * Filter the query on the crrency_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrencyId(1234); // WHERE crrency_id = 1234
     * $query->filterByCurrencyId(array(12, 34)); // WHERE crrency_id IN (12, 34)
     * $query->filterByCurrencyId(array('min' => 12)); // WHERE crrency_id > 12
     * </code>
     *
     * @see       filterByCurrency()
     *
     * @param     mixed $currencyId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByCurrencyId($currencyId = null, $comparison = null)
    {
        if (is_array($currencyId)) {
            $useMinMax = false;
            if (isset($currencyId['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currencyId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($currencyId['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currencyId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currencyId, $comparison);
    }

    /**
     * Filter the query on the contractor_id column
     *
     * Example usage:
     * <code>
     * $query->filterByContractorId(1234); // WHERE contractor_id = 1234
     * $query->filterByContractorId(array(12, 34)); // WHERE contractor_id IN (12, 34)
     * $query->filterByContractorId(array('min' => 12)); // WHERE contractor_id > 12
     * </code>
     *
     * @see       filterByContractor()
     *
     * @param     mixed $contractorId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function filterByContractorId($contractorId = null, $comparison = null)
    {
        if (is_array($contractorId)) {
            $useMinMax = false;
            if (isset($contractorId['min'])) {
                $this->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $contractorId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contractorId['max'])) {
                $this->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $contractorId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $contractorId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Currency\Currency object
     *
     * @param \Shop\Models\Currency\Currency|ObjectCollection $currency The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProviderQuery The current query, for fluid interface
     */
    public function filterByCurrency($currency, $comparison = null)
    {
        if ($currency instanceof \Shop\Models\Currency\Currency) {
            return $this
                ->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currency->getId(), $comparison);
        } elseif ($currency instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProviderTableMap::COL_CRRENCY_ID, $currency->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCurrency() only accepts arguments of type \Shop\Models\Currency\Currency or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Currency relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function joinCurrency($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Currency');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Currency');
        }

        return $this;
    }

    /**
     * Use the Currency relation Currency object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Currency\CurrencyQuery A secondary query class using the current class as primary query
     */
    public function useCurrencyQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCurrency($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Currency', '\Shop\Models\Currency\CurrencyQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Customer\Customer object
     *
     * @param \Shop\Models\Customer\Customer|ObjectCollection $customer The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProviderQuery The current query, for fluid interface
     */
    public function filterByContractor($customer, $comparison = null)
    {
        if ($customer instanceof \Shop\Models\Customer\Customer) {
            return $this
                ->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $customer->getId(), $comparison);
        } elseif ($customer instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ProviderTableMap::COL_CONTRACTOR_ID, $customer->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByContractor() only accepts arguments of type \Shop\Models\Customer\Customer or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Contractor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function joinContractor($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Contractor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Contractor');
        }

        return $this;
    }

    /**
     * Use the Contractor relation Customer object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Customer\CustomerQuery A secondary query class using the current class as primary query
     */
    public function useContractorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContractor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Contractor', '\Shop\Models\Customer\CustomerQuery');
    }

    /**
     * Filter the query by a related \PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelation object
     *
     * @param \PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelation|ObjectCollection $syncProviderRelation the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProviderQuery The current query, for fluid interface
     */
    public function filterBySyncProviderRelation($syncProviderRelation, $comparison = null)
    {
        if ($syncProviderRelation instanceof \PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelation) {
            return $this
                ->addUsingAlias(ProviderTableMap::COL_ID, $syncProviderRelation->getLocalProviderId(), $comparison);
        } elseif ($syncProviderRelation instanceof ObjectCollection) {
            return $this
                ->useSyncProviderRelationQuery()
                ->filterByPrimaryKeys($syncProviderRelation->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterBySyncProviderRelation() only accepts arguments of type \PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelation or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the SyncProviderRelation relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function joinSyncProviderRelation($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('SyncProviderRelation');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'SyncProviderRelation');
        }

        return $this;
    }

    /**
     * Use the SyncProviderRelation relation SyncProviderRelation object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelationQuery A secondary query class using the current class as primary query
     */
    public function useSyncProviderRelationQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinSyncProviderRelation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'SyncProviderRelation', '\PartScanner\Infrastructure\Models\SyncProviderRelation\SyncProviderRelationQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\OrderItem\OrderItem object
     *
     * @param \Shop\Models\OrderItem\OrderItem|ObjectCollection $orderItem the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProviderQuery The current query, for fluid interface
     */
    public function filterByOrderItem($orderItem, $comparison = null)
    {
        if ($orderItem instanceof \Shop\Models\OrderItem\OrderItem) {
            return $this
                ->addUsingAlias(ProviderTableMap::COL_ID, $orderItem->getProviderId(), $comparison);
        } elseif ($orderItem instanceof ObjectCollection) {
            return $this
                ->useOrderItemQuery()
                ->filterByPrimaryKeys($orderItem->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByOrderItem() only accepts arguments of type \Shop\Models\OrderItem\OrderItem or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderItem relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function joinOrderItem($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderItem');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderItem');
        }

        return $this;
    }

    /**
     * Use the OrderItem relation OrderItem object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\OrderItem\OrderItemQuery A secondary query class using the current class as primary query
     */
    public function useOrderItemQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrderItem($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderItem', '\Shop\Models\OrderItem\OrderItemQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\PricelistFile\PricelistFile object
     *
     * @param \Shop\Models\PricelistFile\PricelistFile|ObjectCollection $pricelistFile the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProviderQuery The current query, for fluid interface
     */
    public function filterByPricelistFile($pricelistFile, $comparison = null)
    {
        if ($pricelistFile instanceof \Shop\Models\PricelistFile\PricelistFile) {
            return $this
                ->addUsingAlias(ProviderTableMap::COL_ID, $pricelistFile->getProviderId(), $comparison);
        } elseif ($pricelistFile instanceof ObjectCollection) {
            return $this
                ->usePricelistFileQuery()
                ->filterByPrimaryKeys($pricelistFile->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPricelistFile() only accepts arguments of type \Shop\Models\PricelistFile\PricelistFile or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PricelistFile relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function joinPricelistFile($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PricelistFile');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PricelistFile');
        }

        return $this;
    }

    /**
     * Use the PricelistFile relation PricelistFile object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\PricelistFile\PricelistFileQuery A secondary query class using the current class as primary query
     */
    public function usePricelistFileQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPricelistFile($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PricelistFile', '\Shop\Models\PricelistFile\PricelistFileQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildProvider $provider Object to remove from the list of results
     *
     * @return $this|ChildProviderQuery The current query, for fluid interface
     */
    public function prune($provider = null)
    {
        if ($provider) {
            $this->addUsingAlias(ProviderTableMap::COL_ID, $provider->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePreDelete(ConnectionInterface $con)
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the shop_providers table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ProviderTableMap::clearInstancePool();
            ProviderTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ProviderTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ProviderTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ProviderTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildShopProvidersArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param      ConnectionInterface $con    Connection to use.
     * @param      Boolean $useLittleMemory    Whether or not to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return     int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProviderTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param boolean True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete($archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

} // ProviderQuery
