<?php

namespace Diamond\Models\Page\Map;

use Diamond\Models\Page\PagesArchive;
use Diamond\Models\Page\PagesArchiveQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_pages_archive' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class PagesArchiveTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.Page.Map.PagesArchiveTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = '_pages_archive';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Diamond\\Models\\Page\\PagesArchive';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.Page.PagesArchive';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 19;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 19;

    /**
     * the column name for the id field
     */
    const COL_ID = '_pages_archive.id';

    /**
     * the column name for the code field
     */
    const COL_CODE = '_pages_archive.code';

    /**
     * the column name for the title field
     */
    const COL_TITLE = '_pages_archive.title';

    /**
     * the column name for the url field
     */
    const COL_URL = '_pages_archive.url';

    /**
     * the column name for the template field
     */
    const COL_TEMPLATE = '_pages_archive.template';

    /**
     * the column name for the script field
     */
    const COL_SCRIPT = '_pages_archive.script';

    /**
     * the column name for the content field
     */
    const COL_CONTENT = '_pages_archive.content';

    /**
     * the column name for the system field
     */
    const COL_SYSTEM = '_pages_archive.system';

    /**
     * the column name for the active field
     */
    const COL_ACTIVE = '_pages_archive.active';

    /**
     * the column name for the module field
     */
    const COL_MODULE = '_pages_archive.module';

    /**
     * the column name for the module_params field
     */
    const COL_MODULE_PARAMS = '_pages_archive.module_params';

    /**
     * the column name for the mt_title field
     */
    const COL_MT_TITLE = '_pages_archive.mt_title';

    /**
     * the column name for the mt_description field
     */
    const COL_MT_DESCRIPTION = '_pages_archive.mt_description';

    /**
     * the column name for the mt_keywords field
     */
    const COL_MT_KEYWORDS = '_pages_archive.mt_keywords';

    /**
     * the column name for the mt_robots field
     */
    const COL_MT_ROBOTS = '_pages_archive.mt_robots';

    /**
     * the column name for the seo_rule field
     */
    const COL_SEO_RULE = '_pages_archive.seo_rule';

    /**
     * the column name for the pgs_seo_fn field
     */
    const COL_PGS_SEO_FN = '_pages_archive.pgs_seo_fn';

    /**
     * the column name for the domain_id field
     */
    const COL_DOMAIN_ID = '_pages_archive.domain_id';

    /**
     * the column name for the archived_at field
     */
    const COL_ARCHIVED_AT = '_pages_archive.archived_at';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Code', 'Title', 'Url', 'Template', 'Script', 'Content', 'System', 'Active', 'Module', 'ModuleParams', 'MtTitle', 'MtDescription', 'MtKeywords', 'MtRobots', 'SeoRule', 'PgsSeoFn', 'DomainId', 'ArchivedAt', ),
        self::TYPE_CAMELNAME     => array('id', 'code', 'title', 'url', 'template', 'script', 'content', 'system', 'active', 'module', 'moduleParams', 'mtTitle', 'mtDescription', 'mtKeywords', 'mtRobots', 'seoRule', 'pgsSeoFn', 'domainId', 'archivedAt', ),
        self::TYPE_COLNAME       => array(PagesArchiveTableMap::COL_ID, PagesArchiveTableMap::COL_CODE, PagesArchiveTableMap::COL_TITLE, PagesArchiveTableMap::COL_URL, PagesArchiveTableMap::COL_TEMPLATE, PagesArchiveTableMap::COL_SCRIPT, PagesArchiveTableMap::COL_CONTENT, PagesArchiveTableMap::COL_SYSTEM, PagesArchiveTableMap::COL_ACTIVE, PagesArchiveTableMap::COL_MODULE, PagesArchiveTableMap::COL_MODULE_PARAMS, PagesArchiveTableMap::COL_MT_TITLE, PagesArchiveTableMap::COL_MT_DESCRIPTION, PagesArchiveTableMap::COL_MT_KEYWORDS, PagesArchiveTableMap::COL_MT_ROBOTS, PagesArchiveTableMap::COL_SEO_RULE, PagesArchiveTableMap::COL_PGS_SEO_FN, PagesArchiveTableMap::COL_DOMAIN_ID, PagesArchiveTableMap::COL_ARCHIVED_AT, ),
        self::TYPE_FIELDNAME     => array('id', 'code', 'title', 'url', 'template', 'script', 'content', 'system', 'active', 'module', 'module_params', 'mt_title', 'mt_description', 'mt_keywords', 'mt_robots', 'seo_rule', 'pgs_seo_fn', 'domain_id', 'archived_at', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Code' => 1, 'Title' => 2, 'Url' => 3, 'Template' => 4, 'Script' => 5, 'Content' => 6, 'System' => 7, 'Active' => 8, 'Module' => 9, 'ModuleParams' => 10, 'MtTitle' => 11, 'MtDescription' => 12, 'MtKeywords' => 13, 'MtRobots' => 14, 'SeoRule' => 15, 'PgsSeoFn' => 16, 'DomainId' => 17, 'ArchivedAt' => 18, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'code' => 1, 'title' => 2, 'url' => 3, 'template' => 4, 'script' => 5, 'content' => 6, 'system' => 7, 'active' => 8, 'module' => 9, 'moduleParams' => 10, 'mtTitle' => 11, 'mtDescription' => 12, 'mtKeywords' => 13, 'mtRobots' => 14, 'seoRule' => 15, 'pgsSeoFn' => 16, 'domainId' => 17, 'archivedAt' => 18, ),
        self::TYPE_COLNAME       => array(PagesArchiveTableMap::COL_ID => 0, PagesArchiveTableMap::COL_CODE => 1, PagesArchiveTableMap::COL_TITLE => 2, PagesArchiveTableMap::COL_URL => 3, PagesArchiveTableMap::COL_TEMPLATE => 4, PagesArchiveTableMap::COL_SCRIPT => 5, PagesArchiveTableMap::COL_CONTENT => 6, PagesArchiveTableMap::COL_SYSTEM => 7, PagesArchiveTableMap::COL_ACTIVE => 8, PagesArchiveTableMap::COL_MODULE => 9, PagesArchiveTableMap::COL_MODULE_PARAMS => 10, PagesArchiveTableMap::COL_MT_TITLE => 11, PagesArchiveTableMap::COL_MT_DESCRIPTION => 12, PagesArchiveTableMap::COL_MT_KEYWORDS => 13, PagesArchiveTableMap::COL_MT_ROBOTS => 14, PagesArchiveTableMap::COL_SEO_RULE => 15, PagesArchiveTableMap::COL_PGS_SEO_FN => 16, PagesArchiveTableMap::COL_DOMAIN_ID => 17, PagesArchiveTableMap::COL_ARCHIVED_AT => 18, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'code' => 1, 'title' => 2, 'url' => 3, 'template' => 4, 'script' => 5, 'content' => 6, 'system' => 7, 'active' => 8, 'module' => 9, 'module_params' => 10, 'mt_title' => 11, 'mt_description' => 12, 'mt_keywords' => 13, 'mt_robots' => 14, 'seo_rule' => 15, 'pgs_seo_fn' => 16, 'domain_id' => 17, 'archived_at' => 18, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('_pages_archive');
        $this->setPhpName('PagesArchive');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Models\\Page\\PagesArchive');
        $this->setPackage('Models.Page');
        $this->setUseIdGenerator(false);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('code', 'Code', 'VARCHAR', false, 50, null);
        $this->addColumn('title', 'Title', 'VARCHAR', false, 255, null);
        $this->addColumn('url', 'Url', 'VARCHAR', false, 255, null);
        $this->addColumn('template', 'Template', 'CHAR', false, 20, null);
        $this->addColumn('script', 'Script', 'VARCHAR', false, 255, null);
        $this->addColumn('content', 'Content', 'LONGVARCHAR', false, null, null);
        $this->addColumn('system', 'System', 'CHAR', false, null, 'N');
        $this->addColumn('active', 'Active', 'CHAR', false, null, 'Y');
        $this->addColumn('module', 'Module', 'VARCHAR', false, 255, null);
        $this->addColumn('module_params', 'ModuleParams', 'LONGVARCHAR', false, null, null);
        $this->addColumn('mt_title', 'MtTitle', 'VARCHAR', false, 255, null);
        $this->addColumn('mt_description', 'MtDescription', 'LONGVARCHAR', false, null, null);
        $this->addColumn('mt_keywords', 'MtKeywords', 'LONGVARCHAR', false, null, null);
        $this->addColumn('mt_robots', 'MtRobots', 'VARCHAR', false, 10, null);
        $this->addColumn('seo_rule', 'SeoRule', 'VARCHAR', false, 50, null);
        $this->addColumn('pgs_seo_fn', 'PgsSeoFn', 'VARCHAR', false, 50, null);
        $this->addColumn('domain_id', 'DomainId', 'INTEGER', true, null, null);
        $this->addColumn('archived_at', 'ArchivedAt', 'TIMESTAMP', false, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? PagesArchiveTableMap::CLASS_DEFAULT : PagesArchiveTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (PagesArchive object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = PagesArchiveTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = PagesArchiveTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + PagesArchiveTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = PagesArchiveTableMap::OM_CLASS;
            /** @var PagesArchive $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            PagesArchiveTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = PagesArchiveTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = PagesArchiveTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var PagesArchive $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                PagesArchiveTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_ID);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_CODE);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_TITLE);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_URL);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_TEMPLATE);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_SCRIPT);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_CONTENT);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_SYSTEM);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_MODULE);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_MODULE_PARAMS);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_MT_TITLE);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_MT_DESCRIPTION);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_MT_KEYWORDS);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_MT_ROBOTS);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_SEO_RULE);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_PGS_SEO_FN);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_DOMAIN_ID);
            $criteria->addSelectColumn(PagesArchiveTableMap::COL_ARCHIVED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.code');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.url');
            $criteria->addSelectColumn($alias . '.template');
            $criteria->addSelectColumn($alias . '.script');
            $criteria->addSelectColumn($alias . '.content');
            $criteria->addSelectColumn($alias . '.system');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.module');
            $criteria->addSelectColumn($alias . '.module_params');
            $criteria->addSelectColumn($alias . '.mt_title');
            $criteria->addSelectColumn($alias . '.mt_description');
            $criteria->addSelectColumn($alias . '.mt_keywords');
            $criteria->addSelectColumn($alias . '.mt_robots');
            $criteria->addSelectColumn($alias . '.seo_rule');
            $criteria->addSelectColumn($alias . '.pgs_seo_fn');
            $criteria->addSelectColumn($alias . '.domain_id');
            $criteria->addSelectColumn($alias . '.archived_at');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(PagesArchiveTableMap::DATABASE_NAME)->getTable(PagesArchiveTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(PagesArchiveTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(PagesArchiveTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new PagesArchiveTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a PagesArchive or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or PagesArchive object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PagesArchiveTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Models\Page\PagesArchive) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(PagesArchiveTableMap::DATABASE_NAME);
            $criteria->add(PagesArchiveTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = PagesArchiveQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            PagesArchiveTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                PagesArchiveTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _pages_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return PagesArchiveQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a PagesArchive or Criteria object.
     *
     * @param mixed               $criteria Criteria or PagesArchive object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PagesArchiveTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from PagesArchive object
        }


        // Set the correct dbName
        $query = PagesArchiveQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // PagesArchiveTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
PagesArchiveTableMap::buildTableMap();
