<?php

namespace Diamond\Models\Page\Base;

use \Exception;
use \PDO;
use Diamond\Models\Page\PagesArchive as ChildPagesArchive;
use Diamond\Models\Page\PagesArchiveQuery as ChildPagesArchiveQuery;
use Diamond\Models\Page\Map\PagesArchiveTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_pages_archive' table.
 *
 *
 *
 * @method     ChildPagesArchiveQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildPagesArchiveQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method     ChildPagesArchiveQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildPagesArchiveQuery orderByUrl($order = Criteria::ASC) Order by the url column
 * @method     ChildPagesArchiveQuery orderByTemplate($order = Criteria::ASC) Order by the template column
 * @method     ChildPagesArchiveQuery orderByScript($order = Criteria::ASC) Order by the script column
 * @method     ChildPagesArchiveQuery orderByContent($order = Criteria::ASC) Order by the content column
 * @method     ChildPagesArchiveQuery orderBySystem($order = Criteria::ASC) Order by the system column
 * @method     ChildPagesArchiveQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildPagesArchiveQuery orderByModule($order = Criteria::ASC) Order by the module column
 * @method     ChildPagesArchiveQuery orderByModuleParams($order = Criteria::ASC) Order by the module_params column
 * @method     ChildPagesArchiveQuery orderByMtTitle($order = Criteria::ASC) Order by the mt_title column
 * @method     ChildPagesArchiveQuery orderByMtDescription($order = Criteria::ASC) Order by the mt_description column
 * @method     ChildPagesArchiveQuery orderByMtKeywords($order = Criteria::ASC) Order by the mt_keywords column
 * @method     ChildPagesArchiveQuery orderByMtRobots($order = Criteria::ASC) Order by the mt_robots column
 * @method     ChildPagesArchiveQuery orderBySeoRule($order = Criteria::ASC) Order by the seo_rule column
 * @method     ChildPagesArchiveQuery orderByPgsSeoFn($order = Criteria::ASC) Order by the pgs_seo_fn column
 * @method     ChildPagesArchiveQuery orderByDomainId($order = Criteria::ASC) Order by the domain_id column
 * @method     ChildPagesArchiveQuery orderByArchivedAt($order = Criteria::ASC) Order by the archived_at column
 *
 * @method     ChildPagesArchiveQuery groupById() Group by the id column
 * @method     ChildPagesArchiveQuery groupByCode() Group by the code column
 * @method     ChildPagesArchiveQuery groupByTitle() Group by the title column
 * @method     ChildPagesArchiveQuery groupByUrl() Group by the url column
 * @method     ChildPagesArchiveQuery groupByTemplate() Group by the template column
 * @method     ChildPagesArchiveQuery groupByScript() Group by the script column
 * @method     ChildPagesArchiveQuery groupByContent() Group by the content column
 * @method     ChildPagesArchiveQuery groupBySystem() Group by the system column
 * @method     ChildPagesArchiveQuery groupByActive() Group by the active column
 * @method     ChildPagesArchiveQuery groupByModule() Group by the module column
 * @method     ChildPagesArchiveQuery groupByModuleParams() Group by the module_params column
 * @method     ChildPagesArchiveQuery groupByMtTitle() Group by the mt_title column
 * @method     ChildPagesArchiveQuery groupByMtDescription() Group by the mt_description column
 * @method     ChildPagesArchiveQuery groupByMtKeywords() Group by the mt_keywords column
 * @method     ChildPagesArchiveQuery groupByMtRobots() Group by the mt_robots column
 * @method     ChildPagesArchiveQuery groupBySeoRule() Group by the seo_rule column
 * @method     ChildPagesArchiveQuery groupByPgsSeoFn() Group by the pgs_seo_fn column
 * @method     ChildPagesArchiveQuery groupByDomainId() Group by the domain_id column
 * @method     ChildPagesArchiveQuery groupByArchivedAt() Group by the archived_at column
 *
 * @method     ChildPagesArchiveQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildPagesArchiveQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildPagesArchiveQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildPagesArchiveQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildPagesArchiveQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildPagesArchiveQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildPagesArchive findOne(ConnectionInterface $con = null) Return the first ChildPagesArchive matching the query
 * @method     ChildPagesArchive findOneOrCreate(ConnectionInterface $con = null) Return the first ChildPagesArchive matching the query, or a new ChildPagesArchive object populated from the query conditions when no match is found
 *
 * @method     ChildPagesArchive findOneById(int $id) Return the first ChildPagesArchive filtered by the id column
 * @method     ChildPagesArchive findOneByCode(string $code) Return the first ChildPagesArchive filtered by the code column
 * @method     ChildPagesArchive findOneByTitle(string $title) Return the first ChildPagesArchive filtered by the title column
 * @method     ChildPagesArchive findOneByUrl(string $url) Return the first ChildPagesArchive filtered by the url column
 * @method     ChildPagesArchive findOneByTemplate(string $template) Return the first ChildPagesArchive filtered by the template column
 * @method     ChildPagesArchive findOneByScript(string $script) Return the first ChildPagesArchive filtered by the script column
 * @method     ChildPagesArchive findOneByContent(string $content) Return the first ChildPagesArchive filtered by the content column
 * @method     ChildPagesArchive findOneBySystem(string $system) Return the first ChildPagesArchive filtered by the system column
 * @method     ChildPagesArchive findOneByActive(string $active) Return the first ChildPagesArchive filtered by the active column
 * @method     ChildPagesArchive findOneByModule(string $module) Return the first ChildPagesArchive filtered by the module column
 * @method     ChildPagesArchive findOneByModuleParams(string $module_params) Return the first ChildPagesArchive filtered by the module_params column
 * @method     ChildPagesArchive findOneByMtTitle(string $mt_title) Return the first ChildPagesArchive filtered by the mt_title column
 * @method     ChildPagesArchive findOneByMtDescription(string $mt_description) Return the first ChildPagesArchive filtered by the mt_description column
 * @method     ChildPagesArchive findOneByMtKeywords(string $mt_keywords) Return the first ChildPagesArchive filtered by the mt_keywords column
 * @method     ChildPagesArchive findOneByMtRobots(string $mt_robots) Return the first ChildPagesArchive filtered by the mt_robots column
 * @method     ChildPagesArchive findOneBySeoRule(string $seo_rule) Return the first ChildPagesArchive filtered by the seo_rule column
 * @method     ChildPagesArchive findOneByPgsSeoFn(string $pgs_seo_fn) Return the first ChildPagesArchive filtered by the pgs_seo_fn column
 * @method     ChildPagesArchive findOneByDomainId(int $domain_id) Return the first ChildPagesArchive filtered by the domain_id column
 * @method     ChildPagesArchive findOneByArchivedAt(string $archived_at) Return the first ChildPagesArchive filtered by the archived_at column *

 * @method     ChildPagesArchive requirePk($key, ConnectionInterface $con = null) Return the ChildPagesArchive by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOne(ConnectionInterface $con = null) Return the first ChildPagesArchive matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPagesArchive requireOneById(int $id) Return the first ChildPagesArchive filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByCode(string $code) Return the first ChildPagesArchive filtered by the code column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByTitle(string $title) Return the first ChildPagesArchive filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByUrl(string $url) Return the first ChildPagesArchive filtered by the url column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByTemplate(string $template) Return the first ChildPagesArchive filtered by the template column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByScript(string $script) Return the first ChildPagesArchive filtered by the script column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByContent(string $content) Return the first ChildPagesArchive filtered by the content column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneBySystem(string $system) Return the first ChildPagesArchive filtered by the system column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByActive(string $active) Return the first ChildPagesArchive filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByModule(string $module) Return the first ChildPagesArchive filtered by the module column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByModuleParams(string $module_params) Return the first ChildPagesArchive filtered by the module_params column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByMtTitle(string $mt_title) Return the first ChildPagesArchive filtered by the mt_title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByMtDescription(string $mt_description) Return the first ChildPagesArchive filtered by the mt_description column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByMtKeywords(string $mt_keywords) Return the first ChildPagesArchive filtered by the mt_keywords column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByMtRobots(string $mt_robots) Return the first ChildPagesArchive filtered by the mt_robots column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneBySeoRule(string $seo_rule) Return the first ChildPagesArchive filtered by the seo_rule column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByPgsSeoFn(string $pgs_seo_fn) Return the first ChildPagesArchive filtered by the pgs_seo_fn column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByDomainId(int $domain_id) Return the first ChildPagesArchive filtered by the domain_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPagesArchive requireOneByArchivedAt(string $archived_at) Return the first ChildPagesArchive filtered by the archived_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPagesArchive[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildPagesArchive objects based on current ModelCriteria
 * @method     ChildPagesArchive[]|ObjectCollection findById(int $id) Return ChildPagesArchive objects filtered by the id column
 * @method     ChildPagesArchive[]|ObjectCollection findByCode(string $code) Return ChildPagesArchive objects filtered by the code column
 * @method     ChildPagesArchive[]|ObjectCollection findByTitle(string $title) Return ChildPagesArchive objects filtered by the title column
 * @method     ChildPagesArchive[]|ObjectCollection findByUrl(string $url) Return ChildPagesArchive objects filtered by the url column
 * @method     ChildPagesArchive[]|ObjectCollection findByTemplate(string $template) Return ChildPagesArchive objects filtered by the template column
 * @method     ChildPagesArchive[]|ObjectCollection findByScript(string $script) Return ChildPagesArchive objects filtered by the script column
 * @method     ChildPagesArchive[]|ObjectCollection findByContent(string $content) Return ChildPagesArchive objects filtered by the content column
 * @method     ChildPagesArchive[]|ObjectCollection findBySystem(string $system) Return ChildPagesArchive objects filtered by the system column
 * @method     ChildPagesArchive[]|ObjectCollection findByActive(string $active) Return ChildPagesArchive objects filtered by the active column
 * @method     ChildPagesArchive[]|ObjectCollection findByModule(string $module) Return ChildPagesArchive objects filtered by the module column
 * @method     ChildPagesArchive[]|ObjectCollection findByModuleParams(string $module_params) Return ChildPagesArchive objects filtered by the module_params column
 * @method     ChildPagesArchive[]|ObjectCollection findByMtTitle(string $mt_title) Return ChildPagesArchive objects filtered by the mt_title column
 * @method     ChildPagesArchive[]|ObjectCollection findByMtDescription(string $mt_description) Return ChildPagesArchive objects filtered by the mt_description column
 * @method     ChildPagesArchive[]|ObjectCollection findByMtKeywords(string $mt_keywords) Return ChildPagesArchive objects filtered by the mt_keywords column
 * @method     ChildPagesArchive[]|ObjectCollection findByMtRobots(string $mt_robots) Return ChildPagesArchive objects filtered by the mt_robots column
 * @method     ChildPagesArchive[]|ObjectCollection findBySeoRule(string $seo_rule) Return ChildPagesArchive objects filtered by the seo_rule column
 * @method     ChildPagesArchive[]|ObjectCollection findByPgsSeoFn(string $pgs_seo_fn) Return ChildPagesArchive objects filtered by the pgs_seo_fn column
 * @method     ChildPagesArchive[]|ObjectCollection findByDomainId(int $domain_id) Return ChildPagesArchive objects filtered by the domain_id column
 * @method     ChildPagesArchive[]|ObjectCollection findByArchivedAt(string $archived_at) Return ChildPagesArchive objects filtered by the archived_at column
 * @method     ChildPagesArchive[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class PagesArchiveQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Models\Page\Base\PagesArchiveQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Models\\Page\\PagesArchive', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildPagesArchiveQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildPagesArchiveQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildPagesArchiveQuery) {
            return $criteria;
        }
        $query = new ChildPagesArchiveQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildPagesArchive|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PagesArchiveTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = PagesArchiveTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPagesArchive A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `code`, `title`, `url`, `template`, `script`, `content`, `system`, `active`, `module`, `module_params`, `mt_title`, `mt_description`, `mt_keywords`, `mt_robots`, `seo_rule`, `pgs_seo_fn`, `domain_id`, `archived_at` FROM `_pages_archive` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildPagesArchive $obj */
            $obj = new ChildPagesArchive();
            $obj->hydrate($row);
            PagesArchiveTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildPagesArchive|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(PagesArchiveTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(PagesArchiveTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(PagesArchiveTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(PagesArchiveTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode('fooValue');   // WHERE code = 'fooValue'
     * $query->filterByCode('%fooValue%', Criteria::LIKE); // WHERE code LIKE '%fooValue%'
     * </code>
     *
     * @param     string $code The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByCode($code = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($code)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_CODE, $code, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the url column
     *
     * Example usage:
     * <code>
     * $query->filterByUrl('fooValue');   // WHERE url = 'fooValue'
     * $query->filterByUrl('%fooValue%', Criteria::LIKE); // WHERE url LIKE '%fooValue%'
     * </code>
     *
     * @param     string $url The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByUrl($url = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($url)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_URL, $url, $comparison);
    }

    /**
     * Filter the query on the template column
     *
     * Example usage:
     * <code>
     * $query->filterByTemplate('fooValue');   // WHERE template = 'fooValue'
     * $query->filterByTemplate('%fooValue%', Criteria::LIKE); // WHERE template LIKE '%fooValue%'
     * </code>
     *
     * @param     string $template The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByTemplate($template = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($template)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_TEMPLATE, $template, $comparison);
    }

    /**
     * Filter the query on the script column
     *
     * Example usage:
     * <code>
     * $query->filterByScript('fooValue');   // WHERE script = 'fooValue'
     * $query->filterByScript('%fooValue%', Criteria::LIKE); // WHERE script LIKE '%fooValue%'
     * </code>
     *
     * @param     string $script The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByScript($script = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($script)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_SCRIPT, $script, $comparison);
    }

    /**
     * Filter the query on the content column
     *
     * Example usage:
     * <code>
     * $query->filterByContent('fooValue');   // WHERE content = 'fooValue'
     * $query->filterByContent('%fooValue%', Criteria::LIKE); // WHERE content LIKE '%fooValue%'
     * </code>
     *
     * @param     string $content The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByContent($content = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($content)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_CONTENT, $content, $comparison);
    }

    /**
     * Filter the query on the system column
     *
     * Example usage:
     * <code>
     * $query->filterBySystem('fooValue');   // WHERE system = 'fooValue'
     * $query->filterBySystem('%fooValue%', Criteria::LIKE); // WHERE system LIKE '%fooValue%'
     * </code>
     *
     * @param     string $system The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterBySystem($system = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($system)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_SYSTEM, $system, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive('fooValue');   // WHERE active = 'fooValue'
     * $query->filterByActive('%fooValue%', Criteria::LIKE); // WHERE active LIKE '%fooValue%'
     * </code>
     *
     * @param     string $active The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($active)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the module column
     *
     * Example usage:
     * <code>
     * $query->filterByModule('fooValue');   // WHERE module = 'fooValue'
     * $query->filterByModule('%fooValue%', Criteria::LIKE); // WHERE module LIKE '%fooValue%'
     * </code>
     *
     * @param     string $module The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByModule($module = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($module)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_MODULE, $module, $comparison);
    }

    /**
     * Filter the query on the module_params column
     *
     * Example usage:
     * <code>
     * $query->filterByModuleParams('fooValue');   // WHERE module_params = 'fooValue'
     * $query->filterByModuleParams('%fooValue%', Criteria::LIKE); // WHERE module_params LIKE '%fooValue%'
     * </code>
     *
     * @param     string $moduleParams The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByModuleParams($moduleParams = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($moduleParams)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_MODULE_PARAMS, $moduleParams, $comparison);
    }

    /**
     * Filter the query on the mt_title column
     *
     * Example usage:
     * <code>
     * $query->filterByMtTitle('fooValue');   // WHERE mt_title = 'fooValue'
     * $query->filterByMtTitle('%fooValue%', Criteria::LIKE); // WHERE mt_title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtTitle The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByMtTitle($mtTitle = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtTitle)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_MT_TITLE, $mtTitle, $comparison);
    }

    /**
     * Filter the query on the mt_description column
     *
     * Example usage:
     * <code>
     * $query->filterByMtDescription('fooValue');   // WHERE mt_description = 'fooValue'
     * $query->filterByMtDescription('%fooValue%', Criteria::LIKE); // WHERE mt_description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtDescription The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByMtDescription($mtDescription = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtDescription)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_MT_DESCRIPTION, $mtDescription, $comparison);
    }

    /**
     * Filter the query on the mt_keywords column
     *
     * Example usage:
     * <code>
     * $query->filterByMtKeywords('fooValue');   // WHERE mt_keywords = 'fooValue'
     * $query->filterByMtKeywords('%fooValue%', Criteria::LIKE); // WHERE mt_keywords LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtKeywords The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByMtKeywords($mtKeywords = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtKeywords)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_MT_KEYWORDS, $mtKeywords, $comparison);
    }

    /**
     * Filter the query on the mt_robots column
     *
     * Example usage:
     * <code>
     * $query->filterByMtRobots('fooValue');   // WHERE mt_robots = 'fooValue'
     * $query->filterByMtRobots('%fooValue%', Criteria::LIKE); // WHERE mt_robots LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtRobots The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByMtRobots($mtRobots = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtRobots)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_MT_ROBOTS, $mtRobots, $comparison);
    }

    /**
     * Filter the query on the seo_rule column
     *
     * Example usage:
     * <code>
     * $query->filterBySeoRule('fooValue');   // WHERE seo_rule = 'fooValue'
     * $query->filterBySeoRule('%fooValue%', Criteria::LIKE); // WHERE seo_rule LIKE '%fooValue%'
     * </code>
     *
     * @param     string $seoRule The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterBySeoRule($seoRule = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($seoRule)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_SEO_RULE, $seoRule, $comparison);
    }

    /**
     * Filter the query on the pgs_seo_fn column
     *
     * Example usage:
     * <code>
     * $query->filterByPgsSeoFn('fooValue');   // WHERE pgs_seo_fn = 'fooValue'
     * $query->filterByPgsSeoFn('%fooValue%', Criteria::LIKE); // WHERE pgs_seo_fn LIKE '%fooValue%'
     * </code>
     *
     * @param     string $pgsSeoFn The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByPgsSeoFn($pgsSeoFn = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($pgsSeoFn)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_PGS_SEO_FN, $pgsSeoFn, $comparison);
    }

    /**
     * Filter the query on the domain_id column
     *
     * Example usage:
     * <code>
     * $query->filterByDomainId(1234); // WHERE domain_id = 1234
     * $query->filterByDomainId(array(12, 34)); // WHERE domain_id IN (12, 34)
     * $query->filterByDomainId(array('min' => 12)); // WHERE domain_id > 12
     * </code>
     *
     * @param     mixed $domainId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByDomainId($domainId = null, $comparison = null)
    {
        if (is_array($domainId)) {
            $useMinMax = false;
            if (isset($domainId['min'])) {
                $this->addUsingAlias(PagesArchiveTableMap::COL_DOMAIN_ID, $domainId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($domainId['max'])) {
                $this->addUsingAlias(PagesArchiveTableMap::COL_DOMAIN_ID, $domainId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_DOMAIN_ID, $domainId, $comparison);
    }

    /**
     * Filter the query on the archived_at column
     *
     * Example usage:
     * <code>
     * $query->filterByArchivedAt('2011-03-14'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt('now'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt(array('max' => 'yesterday')); // WHERE archived_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $archivedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function filterByArchivedAt($archivedAt = null, $comparison = null)
    {
        if (is_array($archivedAt)) {
            $useMinMax = false;
            if (isset($archivedAt['min'])) {
                $this->addUsingAlias(PagesArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($archivedAt['max'])) {
                $this->addUsingAlias(PagesArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PagesArchiveTableMap::COL_ARCHIVED_AT, $archivedAt, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   ChildPagesArchive $pagesArchive Object to remove from the list of results
     *
     * @return $this|ChildPagesArchiveQuery The current query, for fluid interface
     */
    public function prune($pagesArchive = null)
    {
        if ($pagesArchive) {
            $this->addUsingAlias(PagesArchiveTableMap::COL_ID, $pagesArchive->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _pages_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PagesArchiveTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PagesArchiveTableMap::clearInstancePool();
            PagesArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PagesArchiveTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(PagesArchiveTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            PagesArchiveTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            PagesArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // PagesArchiveQuery
