<?php

namespace Diamond\Models\Page\Base;

use \DateTime;
use \Exception;
use \PDO;
use Diamond\Models\Page\PagesArchiveQuery as ChildPagesArchiveQuery;
use Diamond\Models\Page\Map\PagesArchiveTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;

/**
 * Base class that represents a row from the '_pages_archive' table.
 *
 *
 *
 * @package    propel.generator.Models.Page.Base
 */
abstract class PagesArchive implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Diamond\\Models\\Page\\Map\\PagesArchiveTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the code field.
     *
     * @var        string
     */
    protected $code;

    /**
     * The value for the title field.
     *
     * @var        string
     */
    protected $title;

    /**
     * The value for the url field.
     *
     * @var        string
     */
    protected $url;

    /**
     * The value for the template field.
     *
     * @var        string
     */
    protected $template;

    /**
     * The value for the script field.
     *
     * @var        string
     */
    protected $script;

    /**
     * The value for the content field.
     *
     * @var        string
     */
    protected $content;

    /**
     * The value for the system field.
     *
     * Note: this column has a database default value of: 'N'
     * @var        string
     */
    protected $system;

    /**
     * The value for the active field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string
     */
    protected $active;

    /**
     * The value for the module field.
     *
     * @var        string
     */
    protected $module;

    /**
     * The value for the module_params field.
     *
     * @var        string
     */
    protected $module_params;

    /**
     * The value for the mt_title field.
     *
     * @var        string
     */
    protected $mt_title;

    /**
     * The value for the mt_description field.
     *
     * @var        string
     */
    protected $mt_description;

    /**
     * The value for the mt_keywords field.
     *
     * @var        string
     */
    protected $mt_keywords;

    /**
     * The value for the mt_robots field.
     *
     * @var        string
     */
    protected $mt_robots;

    /**
     * The value for the seo_rule field.
     *
     * @var        string
     */
    protected $seo_rule;

    /**
     * The value for the pgs_seo_fn field.
     *
     * @var        string
     */
    protected $pgs_seo_fn;

    /**
     * The value for the domain_id field.
     *
     * @var        int
     */
    protected $domain_id;

    /**
     * The value for the archived_at field.
     *
     * @var        DateTime
     */
    protected $archived_at;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues()
    {
        $this->system = 'N';
        $this->active = 'Y';
    }

    /**
     * Initializes internal state of Diamond\Models\Page\Base\PagesArchive object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>PagesArchive</code> instance.  If
     * <code>obj</code> is an instance of <code>PagesArchive</code>, delegates to
     * <code>equals(PagesArchive)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|PagesArchive The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [code] column value.
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Get the [title] column value.
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [url] column value.
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Get the [template] column value.
     *
     * @return string
     */
    public function getTemplate()
    {
        return $this->template;
    }

    /**
     * Get the [script] column value.
     *
     * @return string
     */
    public function getScript()
    {
        return $this->script;
    }

    /**
     * Get the [content] column value.
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Get the [system] column value.
     *
     * @return string
     */
    public function getSystem()
    {
        return $this->system;
    }

    /**
     * Get the [active] column value.
     *
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Get the [module] column value.
     *
     * @return string
     */
    public function getModule()
    {
        return $this->module;
    }

    /**
     * Get the [module_params] column value.
     *
     * @return string
     */
    public function getModuleParams()
    {
        return $this->module_params;
    }

    /**
     * Get the [mt_title] column value.
     *
     * @return string
     */
    public function getMtTitle()
    {
        return $this->mt_title;
    }

    /**
     * Get the [mt_description] column value.
     *
     * @return string
     */
    public function getMtDescription()
    {
        return $this->mt_description;
    }

    /**
     * Get the [mt_keywords] column value.
     *
     * @return string
     */
    public function getMtKeywords()
    {
        return $this->mt_keywords;
    }

    /**
     * Get the [mt_robots] column value.
     *
     * @return string
     */
    public function getMtRobots()
    {
        return $this->mt_robots;
    }

    /**
     * Get the [seo_rule] column value.
     *
     * @return string
     */
    public function getSeoRule()
    {
        return $this->seo_rule;
    }

    /**
     * Get the [pgs_seo_fn] column value.
     *
     * @return string
     */
    public function getPgsSeoFn()
    {
        return $this->pgs_seo_fn;
    }

    /**
     * Get the [domain_id] column value.
     *
     * @return int
     */
    public function getDomainId()
    {
        return $this->domain_id;
    }

    /**
     * Get the [optionally formatted] temporal [archived_at] column value.
     *
     *
     * @param      string|null $format The date/time format string (either date()-style or strftime()-style).
     *                            If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00
     *
     * @throws PropelException - if unable to parse/validate the date/time value.
     */
    public function getArchivedAt($format = NULL)
    {
        if ($format === null) {
            return $this->archived_at;
        } else {
            return $this->archived_at instanceof \DateTimeInterface ? $this->archived_at->format($format) : null;
        }
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_ID] = true;
        }

        return $this;
    } // setId()

    /**
     * Set the value of [code] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setCode($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->code !== $v) {
            $this->code = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_CODE] = true;
        }

        return $this;
    } // setCode()

    /**
     * Set the value of [title] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_TITLE] = true;
        }

        return $this;
    } // setTitle()

    /**
     * Set the value of [url] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setUrl($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->url !== $v) {
            $this->url = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_URL] = true;
        }

        return $this;
    } // setUrl()

    /**
     * Set the value of [template] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setTemplate($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->template !== $v) {
            $this->template = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_TEMPLATE] = true;
        }

        return $this;
    } // setTemplate()

    /**
     * Set the value of [script] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setScript($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->script !== $v) {
            $this->script = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_SCRIPT] = true;
        }

        return $this;
    } // setScript()

    /**
     * Set the value of [content] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setContent($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->content !== $v) {
            $this->content = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_CONTENT] = true;
        }

        return $this;
    } // setContent()

    /**
     * Set the value of [system] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setSystem($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->system !== $v) {
            $this->system = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_SYSTEM] = true;
        }

        return $this;
    } // setSystem()

    /**
     * Set the value of [active] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setActive($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->active !== $v) {
            $this->active = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_ACTIVE] = true;
        }

        return $this;
    } // setActive()

    /**
     * Set the value of [module] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setModule($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->module !== $v) {
            $this->module = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_MODULE] = true;
        }

        return $this;
    } // setModule()

    /**
     * Set the value of [module_params] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setModuleParams($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->module_params !== $v) {
            $this->module_params = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_MODULE_PARAMS] = true;
        }

        return $this;
    } // setModuleParams()

    /**
     * Set the value of [mt_title] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setMtTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_title !== $v) {
            $this->mt_title = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_MT_TITLE] = true;
        }

        return $this;
    } // setMtTitle()

    /**
     * Set the value of [mt_description] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setMtDescription($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_description !== $v) {
            $this->mt_description = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_MT_DESCRIPTION] = true;
        }

        return $this;
    } // setMtDescription()

    /**
     * Set the value of [mt_keywords] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setMtKeywords($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_keywords !== $v) {
            $this->mt_keywords = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_MT_KEYWORDS] = true;
        }

        return $this;
    } // setMtKeywords()

    /**
     * Set the value of [mt_robots] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setMtRobots($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->mt_robots !== $v) {
            $this->mt_robots = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_MT_ROBOTS] = true;
        }

        return $this;
    } // setMtRobots()

    /**
     * Set the value of [seo_rule] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setSeoRule($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->seo_rule !== $v) {
            $this->seo_rule = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_SEO_RULE] = true;
        }

        return $this;
    } // setSeoRule()

    /**
     * Set the value of [pgs_seo_fn] column.
     *
     * @param string $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setPgsSeoFn($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->pgs_seo_fn !== $v) {
            $this->pgs_seo_fn = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_PGS_SEO_FN] = true;
        }

        return $this;
    } // setPgsSeoFn()

    /**
     * Set the value of [domain_id] column.
     *
     * @param int $v new value
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setDomainId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->domain_id !== $v) {
            $this->domain_id = $v;
            $this->modifiedColumns[PagesArchiveTableMap::COL_DOMAIN_ID] = true;
        }

        return $this;
    } // setDomainId()

    /**
     * Sets the value of [archived_at] column to a normalized version of the date/time value specified.
     *
     * @param  mixed $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this|\Diamond\Models\Page\PagesArchive The current object (for fluent API support)
     */
    public function setArchivedAt($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->archived_at !== null || $dt !== null) {
            if ($this->archived_at === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->archived_at->format("Y-m-d H:i:s.u")) {
                $this->archived_at = $dt === null ? null : clone $dt;
                $this->modifiedColumns[PagesArchiveTableMap::COL_ARCHIVED_AT] = true;
            }
        } // if either are not null

        return $this;
    } // setArchivedAt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->system !== 'N') {
                return false;
            }

            if ($this->active !== 'Y') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : PagesArchiveTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : PagesArchiveTableMap::translateFieldName('Code', TableMap::TYPE_PHPNAME, $indexType)];
            $this->code = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : PagesArchiveTableMap::translateFieldName('Title', TableMap::TYPE_PHPNAME, $indexType)];
            $this->title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : PagesArchiveTableMap::translateFieldName('Url', TableMap::TYPE_PHPNAME, $indexType)];
            $this->url = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : PagesArchiveTableMap::translateFieldName('Template', TableMap::TYPE_PHPNAME, $indexType)];
            $this->template = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : PagesArchiveTableMap::translateFieldName('Script', TableMap::TYPE_PHPNAME, $indexType)];
            $this->script = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : PagesArchiveTableMap::translateFieldName('Content', TableMap::TYPE_PHPNAME, $indexType)];
            $this->content = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : PagesArchiveTableMap::translateFieldName('System', TableMap::TYPE_PHPNAME, $indexType)];
            $this->system = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : PagesArchiveTableMap::translateFieldName('Active', TableMap::TYPE_PHPNAME, $indexType)];
            $this->active = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : PagesArchiveTableMap::translateFieldName('Module', TableMap::TYPE_PHPNAME, $indexType)];
            $this->module = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : PagesArchiveTableMap::translateFieldName('ModuleParams', TableMap::TYPE_PHPNAME, $indexType)];
            $this->module_params = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : PagesArchiveTableMap::translateFieldName('MtTitle', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 12 + $startcol : PagesArchiveTableMap::translateFieldName('MtDescription', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_description = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 13 + $startcol : PagesArchiveTableMap::translateFieldName('MtKeywords', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_keywords = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 14 + $startcol : PagesArchiveTableMap::translateFieldName('MtRobots', TableMap::TYPE_PHPNAME, $indexType)];
            $this->mt_robots = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 15 + $startcol : PagesArchiveTableMap::translateFieldName('SeoRule', TableMap::TYPE_PHPNAME, $indexType)];
            $this->seo_rule = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 16 + $startcol : PagesArchiveTableMap::translateFieldName('PgsSeoFn', TableMap::TYPE_PHPNAME, $indexType)];
            $this->pgs_seo_fn = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 17 + $startcol : PagesArchiveTableMap::translateFieldName('DomainId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->domain_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 18 + $startcol : PagesArchiveTableMap::translateFieldName('ArchivedAt', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->archived_at = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 19; // 19 = PagesArchiveTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Diamond\\Models\\Page\\PagesArchive'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PagesArchiveTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildPagesArchiveQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see PagesArchive::setDeleted()
     * @see PagesArchive::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(PagesArchiveTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildPagesArchiveQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(PagesArchiveTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                PagesArchiveTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;


         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(PagesArchiveTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_CODE)) {
            $modifiedColumns[':p' . $index++]  = '`code`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`title`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_URL)) {
            $modifiedColumns[':p' . $index++]  = '`url`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_TEMPLATE)) {
            $modifiedColumns[':p' . $index++]  = '`template`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_SCRIPT)) {
            $modifiedColumns[':p' . $index++]  = '`script`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_CONTENT)) {
            $modifiedColumns[':p' . $index++]  = '`content`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_SYSTEM)) {
            $modifiedColumns[':p' . $index++]  = '`system`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_ACTIVE)) {
            $modifiedColumns[':p' . $index++]  = '`active`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MODULE)) {
            $modifiedColumns[':p' . $index++]  = '`module`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MODULE_PARAMS)) {
            $modifiedColumns[':p' . $index++]  = '`module_params`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MT_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`mt_title`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MT_DESCRIPTION)) {
            $modifiedColumns[':p' . $index++]  = '`mt_description`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MT_KEYWORDS)) {
            $modifiedColumns[':p' . $index++]  = '`mt_keywords`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MT_ROBOTS)) {
            $modifiedColumns[':p' . $index++]  = '`mt_robots`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_SEO_RULE)) {
            $modifiedColumns[':p' . $index++]  = '`seo_rule`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_PGS_SEO_FN)) {
            $modifiedColumns[':p' . $index++]  = '`pgs_seo_fn`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_DOMAIN_ID)) {
            $modifiedColumns[':p' . $index++]  = '`domain_id`';
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_ARCHIVED_AT)) {
            $modifiedColumns[':p' . $index++]  = '`archived_at`';
        }

        $sql = sprintf(
            'INSERT INTO `_pages_archive` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`code`':
                        $stmt->bindValue($identifier, $this->code, PDO::PARAM_STR);
                        break;
                    case '`title`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`url`':
                        $stmt->bindValue($identifier, $this->url, PDO::PARAM_STR);
                        break;
                    case '`template`':
                        $stmt->bindValue($identifier, $this->template, PDO::PARAM_STR);
                        break;
                    case '`script`':
                        $stmt->bindValue($identifier, $this->script, PDO::PARAM_STR);
                        break;
                    case '`content`':
                        $stmt->bindValue($identifier, $this->content, PDO::PARAM_STR);
                        break;
                    case '`system`':
                        $stmt->bindValue($identifier, $this->system, PDO::PARAM_STR);
                        break;
                    case '`active`':
                        $stmt->bindValue($identifier, $this->active, PDO::PARAM_STR);
                        break;
                    case '`module`':
                        $stmt->bindValue($identifier, $this->module, PDO::PARAM_STR);
                        break;
                    case '`module_params`':
                        $stmt->bindValue($identifier, $this->module_params, PDO::PARAM_STR);
                        break;
                    case '`mt_title`':
                        $stmt->bindValue($identifier, $this->mt_title, PDO::PARAM_STR);
                        break;
                    case '`mt_description`':
                        $stmt->bindValue($identifier, $this->mt_description, PDO::PARAM_STR);
                        break;
                    case '`mt_keywords`':
                        $stmt->bindValue($identifier, $this->mt_keywords, PDO::PARAM_STR);
                        break;
                    case '`mt_robots`':
                        $stmt->bindValue($identifier, $this->mt_robots, PDO::PARAM_STR);
                        break;
                    case '`seo_rule`':
                        $stmt->bindValue($identifier, $this->seo_rule, PDO::PARAM_STR);
                        break;
                    case '`pgs_seo_fn`':
                        $stmt->bindValue($identifier, $this->pgs_seo_fn, PDO::PARAM_STR);
                        break;
                    case '`domain_id`':
                        $stmt->bindValue($identifier, $this->domain_id, PDO::PARAM_INT);
                        break;
                    case '`archived_at`':
                        $stmt->bindValue($identifier, $this->archived_at ? $this->archived_at->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = PagesArchiveTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getCode();
                break;
            case 2:
                return $this->getTitle();
                break;
            case 3:
                return $this->getUrl();
                break;
            case 4:
                return $this->getTemplate();
                break;
            case 5:
                return $this->getScript();
                break;
            case 6:
                return $this->getContent();
                break;
            case 7:
                return $this->getSystem();
                break;
            case 8:
                return $this->getActive();
                break;
            case 9:
                return $this->getModule();
                break;
            case 10:
                return $this->getModuleParams();
                break;
            case 11:
                return $this->getMtTitle();
                break;
            case 12:
                return $this->getMtDescription();
                break;
            case 13:
                return $this->getMtKeywords();
                break;
            case 14:
                return $this->getMtRobots();
                break;
            case 15:
                return $this->getSeoRule();
                break;
            case 16:
                return $this->getPgsSeoFn();
                break;
            case 17:
                return $this->getDomainId();
                break;
            case 18:
                return $this->getArchivedAt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array())
    {

        if (isset($alreadyDumpedObjects['PagesArchive'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['PagesArchive'][$this->hashCode()] = true;
        $keys = PagesArchiveTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getCode(),
            $keys[2] => $this->getTitle(),
            $keys[3] => $this->getUrl(),
            $keys[4] => $this->getTemplate(),
            $keys[5] => $this->getScript(),
            $keys[6] => $this->getContent(),
            $keys[7] => $this->getSystem(),
            $keys[8] => $this->getActive(),
            $keys[9] => $this->getModule(),
            $keys[10] => $this->getModuleParams(),
            $keys[11] => $this->getMtTitle(),
            $keys[12] => $this->getMtDescription(),
            $keys[13] => $this->getMtKeywords(),
            $keys[14] => $this->getMtRobots(),
            $keys[15] => $this->getSeoRule(),
            $keys[16] => $this->getPgsSeoFn(),
            $keys[17] => $this->getDomainId(),
            $keys[18] => $this->getArchivedAt(),
        );
        if ($result[$keys[18]] instanceof \DateTimeInterface) {
            $result[$keys[18]] = $result[$keys[18]]->format('c');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }


        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Diamond\Models\Page\PagesArchive
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = PagesArchiveTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Diamond\Models\Page\PagesArchive
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setCode($value);
                break;
            case 2:
                $this->setTitle($value);
                break;
            case 3:
                $this->setUrl($value);
                break;
            case 4:
                $this->setTemplate($value);
                break;
            case 5:
                $this->setScript($value);
                break;
            case 6:
                $this->setContent($value);
                break;
            case 7:
                $this->setSystem($value);
                break;
            case 8:
                $this->setActive($value);
                break;
            case 9:
                $this->setModule($value);
                break;
            case 10:
                $this->setModuleParams($value);
                break;
            case 11:
                $this->setMtTitle($value);
                break;
            case 12:
                $this->setMtDescription($value);
                break;
            case 13:
                $this->setMtKeywords($value);
                break;
            case 14:
                $this->setMtRobots($value);
                break;
            case 15:
                $this->setSeoRule($value);
                break;
            case 16:
                $this->setPgsSeoFn($value);
                break;
            case 17:
                $this->setDomainId($value);
                break;
            case 18:
                $this->setArchivedAt($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = PagesArchiveTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setCode($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setTitle($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setUrl($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setTemplate($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setScript($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setContent($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setSystem($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setActive($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setModule($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setModuleParams($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setMtTitle($arr[$keys[11]]);
        }
        if (array_key_exists($keys[12], $arr)) {
            $this->setMtDescription($arr[$keys[12]]);
        }
        if (array_key_exists($keys[13], $arr)) {
            $this->setMtKeywords($arr[$keys[13]]);
        }
        if (array_key_exists($keys[14], $arr)) {
            $this->setMtRobots($arr[$keys[14]]);
        }
        if (array_key_exists($keys[15], $arr)) {
            $this->setSeoRule($arr[$keys[15]]);
        }
        if (array_key_exists($keys[16], $arr)) {
            $this->setPgsSeoFn($arr[$keys[16]]);
        }
        if (array_key_exists($keys[17], $arr)) {
            $this->setDomainId($arr[$keys[17]]);
        }
        if (array_key_exists($keys[18], $arr)) {
            $this->setArchivedAt($arr[$keys[18]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Diamond\Models\Page\PagesArchive The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(PagesArchiveTableMap::DATABASE_NAME);

        if ($this->isColumnModified(PagesArchiveTableMap::COL_ID)) {
            $criteria->add(PagesArchiveTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_CODE)) {
            $criteria->add(PagesArchiveTableMap::COL_CODE, $this->code);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_TITLE)) {
            $criteria->add(PagesArchiveTableMap::COL_TITLE, $this->title);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_URL)) {
            $criteria->add(PagesArchiveTableMap::COL_URL, $this->url);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_TEMPLATE)) {
            $criteria->add(PagesArchiveTableMap::COL_TEMPLATE, $this->template);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_SCRIPT)) {
            $criteria->add(PagesArchiveTableMap::COL_SCRIPT, $this->script);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_CONTENT)) {
            $criteria->add(PagesArchiveTableMap::COL_CONTENT, $this->content);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_SYSTEM)) {
            $criteria->add(PagesArchiveTableMap::COL_SYSTEM, $this->system);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_ACTIVE)) {
            $criteria->add(PagesArchiveTableMap::COL_ACTIVE, $this->active);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MODULE)) {
            $criteria->add(PagesArchiveTableMap::COL_MODULE, $this->module);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MODULE_PARAMS)) {
            $criteria->add(PagesArchiveTableMap::COL_MODULE_PARAMS, $this->module_params);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MT_TITLE)) {
            $criteria->add(PagesArchiveTableMap::COL_MT_TITLE, $this->mt_title);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MT_DESCRIPTION)) {
            $criteria->add(PagesArchiveTableMap::COL_MT_DESCRIPTION, $this->mt_description);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MT_KEYWORDS)) {
            $criteria->add(PagesArchiveTableMap::COL_MT_KEYWORDS, $this->mt_keywords);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_MT_ROBOTS)) {
            $criteria->add(PagesArchiveTableMap::COL_MT_ROBOTS, $this->mt_robots);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_SEO_RULE)) {
            $criteria->add(PagesArchiveTableMap::COL_SEO_RULE, $this->seo_rule);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_PGS_SEO_FN)) {
            $criteria->add(PagesArchiveTableMap::COL_PGS_SEO_FN, $this->pgs_seo_fn);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_DOMAIN_ID)) {
            $criteria->add(PagesArchiveTableMap::COL_DOMAIN_ID, $this->domain_id);
        }
        if ($this->isColumnModified(PagesArchiveTableMap::COL_ARCHIVED_AT)) {
            $criteria->add(PagesArchiveTableMap::COL_ARCHIVED_AT, $this->archived_at);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildPagesArchiveQuery::create();
        $criteria->add(PagesArchiveTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Diamond\Models\Page\PagesArchive (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setId($this->getId());
        $copyObj->setCode($this->getCode());
        $copyObj->setTitle($this->getTitle());
        $copyObj->setUrl($this->getUrl());
        $copyObj->setTemplate($this->getTemplate());
        $copyObj->setScript($this->getScript());
        $copyObj->setContent($this->getContent());
        $copyObj->setSystem($this->getSystem());
        $copyObj->setActive($this->getActive());
        $copyObj->setModule($this->getModule());
        $copyObj->setModuleParams($this->getModuleParams());
        $copyObj->setMtTitle($this->getMtTitle());
        $copyObj->setMtDescription($this->getMtDescription());
        $copyObj->setMtKeywords($this->getMtKeywords());
        $copyObj->setMtRobots($this->getMtRobots());
        $copyObj->setSeoRule($this->getSeoRule());
        $copyObj->setPgsSeoFn($this->getPgsSeoFn());
        $copyObj->setDomainId($this->getDomainId());
        $copyObj->setArchivedAt($this->getArchivedAt());
        if ($makeNew) {
            $copyObj->setNew(true);
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Diamond\Models\Page\PagesArchive Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        $this->id = null;
        $this->code = null;
        $this->title = null;
        $this->url = null;
        $this->template = null;
        $this->script = null;
        $this->content = null;
        $this->system = null;
        $this->active = null;
        $this->module = null;
        $this->module_params = null;
        $this->mt_title = null;
        $this->mt_description = null;
        $this->mt_keywords = null;
        $this->mt_robots = null;
        $this->seo_rule = null;
        $this->pgs_seo_fn = null;
        $this->domain_id = null;
        $this->archived_at = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
        } // if ($deep)

    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(PagesArchiveTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
