<?php

namespace Diamond\Models\Page\Base;

use \Exception;
use \PDO;
use Diamond\Models\Domain\Domain;
use Diamond\Models\Page\Page as ChildPage;
use Diamond\Models\Page\PageQuery as ChildPageQuery;
use Diamond\Models\Page\PagesArchive as ChildPagesArchive;
use Diamond\Models\Page\Map\PageTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_pages' table.
 *
 *
 *
 * @method     ChildPageQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildPageQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method     ChildPageQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildPageQuery orderByUrl($order = Criteria::ASC) Order by the url column
 * @method     ChildPageQuery orderByTemplate($order = Criteria::ASC) Order by the template column
 * @method     ChildPageQuery orderByScript($order = Criteria::ASC) Order by the script column
 * @method     ChildPageQuery orderByContent($order = Criteria::ASC) Order by the content column
 * @method     ChildPageQuery orderBySystem($order = Criteria::ASC) Order by the system column
 * @method     ChildPageQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildPageQuery orderByModule($order = Criteria::ASC) Order by the module column
 * @method     ChildPageQuery orderByModuleParams($order = Criteria::ASC) Order by the module_params column
 * @method     ChildPageQuery orderByMtTitle($order = Criteria::ASC) Order by the mt_title column
 * @method     ChildPageQuery orderByMtDescription($order = Criteria::ASC) Order by the mt_description column
 * @method     ChildPageQuery orderByMtKeywords($order = Criteria::ASC) Order by the mt_keywords column
 * @method     ChildPageQuery orderByMtRobots($order = Criteria::ASC) Order by the mt_robots column
 * @method     ChildPageQuery orderBySeoRule($order = Criteria::ASC) Order by the seo_rule column
 * @method     ChildPageQuery orderByPgsSeoFn($order = Criteria::ASC) Order by the pgs_seo_fn column
 * @method     ChildPageQuery orderByDomainId($order = Criteria::ASC) Order by the domain_id column
 *
 * @method     ChildPageQuery groupById() Group by the id column
 * @method     ChildPageQuery groupByCode() Group by the code column
 * @method     ChildPageQuery groupByTitle() Group by the title column
 * @method     ChildPageQuery groupByUrl() Group by the url column
 * @method     ChildPageQuery groupByTemplate() Group by the template column
 * @method     ChildPageQuery groupByScript() Group by the script column
 * @method     ChildPageQuery groupByContent() Group by the content column
 * @method     ChildPageQuery groupBySystem() Group by the system column
 * @method     ChildPageQuery groupByActive() Group by the active column
 * @method     ChildPageQuery groupByModule() Group by the module column
 * @method     ChildPageQuery groupByModuleParams() Group by the module_params column
 * @method     ChildPageQuery groupByMtTitle() Group by the mt_title column
 * @method     ChildPageQuery groupByMtDescription() Group by the mt_description column
 * @method     ChildPageQuery groupByMtKeywords() Group by the mt_keywords column
 * @method     ChildPageQuery groupByMtRobots() Group by the mt_robots column
 * @method     ChildPageQuery groupBySeoRule() Group by the seo_rule column
 * @method     ChildPageQuery groupByPgsSeoFn() Group by the pgs_seo_fn column
 * @method     ChildPageQuery groupByDomainId() Group by the domain_id column
 *
 * @method     ChildPageQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildPageQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildPageQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildPageQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildPageQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildPageQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildPageQuery leftJoinDomain($relationAlias = null) Adds a LEFT JOIN clause to the query using the Domain relation
 * @method     ChildPageQuery rightJoinDomain($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Domain relation
 * @method     ChildPageQuery innerJoinDomain($relationAlias = null) Adds a INNER JOIN clause to the query using the Domain relation
 *
 * @method     ChildPageQuery joinWithDomain($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Domain relation
 *
 * @method     ChildPageQuery leftJoinWithDomain() Adds a LEFT JOIN clause and with to the query using the Domain relation
 * @method     ChildPageQuery rightJoinWithDomain() Adds a RIGHT JOIN clause and with to the query using the Domain relation
 * @method     ChildPageQuery innerJoinWithDomain() Adds a INNER JOIN clause and with to the query using the Domain relation
 *
 * @method     \Diamond\Models\Domain\DomainQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildPage findOne(ConnectionInterface $con = null) Return the first ChildPage matching the query
 * @method     ChildPage findOneOrCreate(ConnectionInterface $con = null) Return the first ChildPage matching the query, or a new ChildPage object populated from the query conditions when no match is found
 *
 * @method     ChildPage findOneById(int $id) Return the first ChildPage filtered by the id column
 * @method     ChildPage findOneByCode(string $code) Return the first ChildPage filtered by the code column
 * @method     ChildPage findOneByTitle(string $title) Return the first ChildPage filtered by the title column
 * @method     ChildPage findOneByUrl(string $url) Return the first ChildPage filtered by the url column
 * @method     ChildPage findOneByTemplate(string $template) Return the first ChildPage filtered by the template column
 * @method     ChildPage findOneByScript(string $script) Return the first ChildPage filtered by the script column
 * @method     ChildPage findOneByContent(string $content) Return the first ChildPage filtered by the content column
 * @method     ChildPage findOneBySystem(string $system) Return the first ChildPage filtered by the system column
 * @method     ChildPage findOneByActive(string $active) Return the first ChildPage filtered by the active column
 * @method     ChildPage findOneByModule(string $module) Return the first ChildPage filtered by the module column
 * @method     ChildPage findOneByModuleParams(string $module_params) Return the first ChildPage filtered by the module_params column
 * @method     ChildPage findOneByMtTitle(string $mt_title) Return the first ChildPage filtered by the mt_title column
 * @method     ChildPage findOneByMtDescription(string $mt_description) Return the first ChildPage filtered by the mt_description column
 * @method     ChildPage findOneByMtKeywords(string $mt_keywords) Return the first ChildPage filtered by the mt_keywords column
 * @method     ChildPage findOneByMtRobots(string $mt_robots) Return the first ChildPage filtered by the mt_robots column
 * @method     ChildPage findOneBySeoRule(string $seo_rule) Return the first ChildPage filtered by the seo_rule column
 * @method     ChildPage findOneByPgsSeoFn(string $pgs_seo_fn) Return the first ChildPage filtered by the pgs_seo_fn column
 * @method     ChildPage findOneByDomainId(int $domain_id) Return the first ChildPage filtered by the domain_id column *

 * @method     ChildPage requirePk($key, ConnectionInterface $con = null) Return the ChildPage by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOne(ConnectionInterface $con = null) Return the first ChildPage matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPage requireOneById(int $id) Return the first ChildPage filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByCode(string $code) Return the first ChildPage filtered by the code column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByTitle(string $title) Return the first ChildPage filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByUrl(string $url) Return the first ChildPage filtered by the url column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByTemplate(string $template) Return the first ChildPage filtered by the template column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByScript(string $script) Return the first ChildPage filtered by the script column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByContent(string $content) Return the first ChildPage filtered by the content column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneBySystem(string $system) Return the first ChildPage filtered by the system column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByActive(string $active) Return the first ChildPage filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByModule(string $module) Return the first ChildPage filtered by the module column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByModuleParams(string $module_params) Return the first ChildPage filtered by the module_params column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByMtTitle(string $mt_title) Return the first ChildPage filtered by the mt_title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByMtDescription(string $mt_description) Return the first ChildPage filtered by the mt_description column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByMtKeywords(string $mt_keywords) Return the first ChildPage filtered by the mt_keywords column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByMtRobots(string $mt_robots) Return the first ChildPage filtered by the mt_robots column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneBySeoRule(string $seo_rule) Return the first ChildPage filtered by the seo_rule column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByPgsSeoFn(string $pgs_seo_fn) Return the first ChildPage filtered by the pgs_seo_fn column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPage requireOneByDomainId(int $domain_id) Return the first ChildPage filtered by the domain_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPage[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildPage objects based on current ModelCriteria
 * @method     ChildPage[]|ObjectCollection findById(int $id) Return ChildPage objects filtered by the id column
 * @method     ChildPage[]|ObjectCollection findByCode(string $code) Return ChildPage objects filtered by the code column
 * @method     ChildPage[]|ObjectCollection findByTitle(string $title) Return ChildPage objects filtered by the title column
 * @method     ChildPage[]|ObjectCollection findByUrl(string $url) Return ChildPage objects filtered by the url column
 * @method     ChildPage[]|ObjectCollection findByTemplate(string $template) Return ChildPage objects filtered by the template column
 * @method     ChildPage[]|ObjectCollection findByScript(string $script) Return ChildPage objects filtered by the script column
 * @method     ChildPage[]|ObjectCollection findByContent(string $content) Return ChildPage objects filtered by the content column
 * @method     ChildPage[]|ObjectCollection findBySystem(string $system) Return ChildPage objects filtered by the system column
 * @method     ChildPage[]|ObjectCollection findByActive(string $active) Return ChildPage objects filtered by the active column
 * @method     ChildPage[]|ObjectCollection findByModule(string $module) Return ChildPage objects filtered by the module column
 * @method     ChildPage[]|ObjectCollection findByModuleParams(string $module_params) Return ChildPage objects filtered by the module_params column
 * @method     ChildPage[]|ObjectCollection findByMtTitle(string $mt_title) Return ChildPage objects filtered by the mt_title column
 * @method     ChildPage[]|ObjectCollection findByMtDescription(string $mt_description) Return ChildPage objects filtered by the mt_description column
 * @method     ChildPage[]|ObjectCollection findByMtKeywords(string $mt_keywords) Return ChildPage objects filtered by the mt_keywords column
 * @method     ChildPage[]|ObjectCollection findByMtRobots(string $mt_robots) Return ChildPage objects filtered by the mt_robots column
 * @method     ChildPage[]|ObjectCollection findBySeoRule(string $seo_rule) Return ChildPage objects filtered by the seo_rule column
 * @method     ChildPage[]|ObjectCollection findByPgsSeoFn(string $pgs_seo_fn) Return ChildPage objects filtered by the pgs_seo_fn column
 * @method     ChildPage[]|ObjectCollection findByDomainId(int $domain_id) Return ChildPage objects filtered by the domain_id column
 * @method     ChildPage[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class PageQuery extends ModelCriteria
{

    // archivable behavior
    protected $archiveOnDelete = true;
protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Models\Page\Base\PageQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Models\\Page\\Page', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildPageQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildPageQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildPageQuery) {
            return $criteria;
        }
        $query = new ChildPageQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildPage|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PageTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = PageTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPage A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `code`, `title`, `url`, `template`, `script`, `content`, `system`, `active`, `module`, `module_params`, `mt_title`, `mt_description`, `mt_keywords`, `mt_robots`, `seo_rule`, `pgs_seo_fn`, `domain_id` FROM `_pages` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildPage $obj */
            $obj = new ChildPage();
            $obj->hydrate($row);
            PageTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildPage|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(PageTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(PageTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(PageTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(PageTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode('fooValue');   // WHERE code = 'fooValue'
     * $query->filterByCode('%fooValue%', Criteria::LIKE); // WHERE code LIKE '%fooValue%'
     * </code>
     *
     * @param     string $code The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByCode($code = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($code)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_CODE, $code, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the url column
     *
     * Example usage:
     * <code>
     * $query->filterByUrl('fooValue');   // WHERE url = 'fooValue'
     * $query->filterByUrl('%fooValue%', Criteria::LIKE); // WHERE url LIKE '%fooValue%'
     * </code>
     *
     * @param     string $url The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByUrl($url = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($url)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_URL, $url, $comparison);
    }

    /**
     * Filter the query on the template column
     *
     * Example usage:
     * <code>
     * $query->filterByTemplate('fooValue');   // WHERE template = 'fooValue'
     * $query->filterByTemplate('%fooValue%', Criteria::LIKE); // WHERE template LIKE '%fooValue%'
     * </code>
     *
     * @param     string $template The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByTemplate($template = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($template)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_TEMPLATE, $template, $comparison);
    }

    /**
     * Filter the query on the script column
     *
     * Example usage:
     * <code>
     * $query->filterByScript('fooValue');   // WHERE script = 'fooValue'
     * $query->filterByScript('%fooValue%', Criteria::LIKE); // WHERE script LIKE '%fooValue%'
     * </code>
     *
     * @param     string $script The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByScript($script = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($script)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_SCRIPT, $script, $comparison);
    }

    /**
     * Filter the query on the content column
     *
     * Example usage:
     * <code>
     * $query->filterByContent('fooValue');   // WHERE content = 'fooValue'
     * $query->filterByContent('%fooValue%', Criteria::LIKE); // WHERE content LIKE '%fooValue%'
     * </code>
     *
     * @param     string $content The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByContent($content = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($content)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_CONTENT, $content, $comparison);
    }

    /**
     * Filter the query on the system column
     *
     * Example usage:
     * <code>
     * $query->filterBySystem('fooValue');   // WHERE system = 'fooValue'
     * $query->filterBySystem('%fooValue%', Criteria::LIKE); // WHERE system LIKE '%fooValue%'
     * </code>
     *
     * @param     string $system The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterBySystem($system = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($system)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_SYSTEM, $system, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive('fooValue');   // WHERE active = 'fooValue'
     * $query->filterByActive('%fooValue%', Criteria::LIKE); // WHERE active LIKE '%fooValue%'
     * </code>
     *
     * @param     string $active The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($active)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the module column
     *
     * Example usage:
     * <code>
     * $query->filterByModule('fooValue');   // WHERE module = 'fooValue'
     * $query->filterByModule('%fooValue%', Criteria::LIKE); // WHERE module LIKE '%fooValue%'
     * </code>
     *
     * @param     string $module The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByModule($module = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($module)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_MODULE, $module, $comparison);
    }

    /**
     * Filter the query on the module_params column
     *
     * Example usage:
     * <code>
     * $query->filterByModuleParams('fooValue');   // WHERE module_params = 'fooValue'
     * $query->filterByModuleParams('%fooValue%', Criteria::LIKE); // WHERE module_params LIKE '%fooValue%'
     * </code>
     *
     * @param     string $moduleParams The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByModuleParams($moduleParams = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($moduleParams)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_MODULE_PARAMS, $moduleParams, $comparison);
    }

    /**
     * Filter the query on the mt_title column
     *
     * Example usage:
     * <code>
     * $query->filterByMtTitle('fooValue');   // WHERE mt_title = 'fooValue'
     * $query->filterByMtTitle('%fooValue%', Criteria::LIKE); // WHERE mt_title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtTitle The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByMtTitle($mtTitle = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtTitle)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_MT_TITLE, $mtTitle, $comparison);
    }

    /**
     * Filter the query on the mt_description column
     *
     * Example usage:
     * <code>
     * $query->filterByMtDescription('fooValue');   // WHERE mt_description = 'fooValue'
     * $query->filterByMtDescription('%fooValue%', Criteria::LIKE); // WHERE mt_description LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtDescription The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByMtDescription($mtDescription = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtDescription)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_MT_DESCRIPTION, $mtDescription, $comparison);
    }

    /**
     * Filter the query on the mt_keywords column
     *
     * Example usage:
     * <code>
     * $query->filterByMtKeywords('fooValue');   // WHERE mt_keywords = 'fooValue'
     * $query->filterByMtKeywords('%fooValue%', Criteria::LIKE); // WHERE mt_keywords LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtKeywords The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByMtKeywords($mtKeywords = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtKeywords)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_MT_KEYWORDS, $mtKeywords, $comparison);
    }

    /**
     * Filter the query on the mt_robots column
     *
     * Example usage:
     * <code>
     * $query->filterByMtRobots('fooValue');   // WHERE mt_robots = 'fooValue'
     * $query->filterByMtRobots('%fooValue%', Criteria::LIKE); // WHERE mt_robots LIKE '%fooValue%'
     * </code>
     *
     * @param     string $mtRobots The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByMtRobots($mtRobots = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($mtRobots)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_MT_ROBOTS, $mtRobots, $comparison);
    }

    /**
     * Filter the query on the seo_rule column
     *
     * Example usage:
     * <code>
     * $query->filterBySeoRule('fooValue');   // WHERE seo_rule = 'fooValue'
     * $query->filterBySeoRule('%fooValue%', Criteria::LIKE); // WHERE seo_rule LIKE '%fooValue%'
     * </code>
     *
     * @param     string $seoRule The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterBySeoRule($seoRule = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($seoRule)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_SEO_RULE, $seoRule, $comparison);
    }

    /**
     * Filter the query on the pgs_seo_fn column
     *
     * Example usage:
     * <code>
     * $query->filterByPgsSeoFn('fooValue');   // WHERE pgs_seo_fn = 'fooValue'
     * $query->filterByPgsSeoFn('%fooValue%', Criteria::LIKE); // WHERE pgs_seo_fn LIKE '%fooValue%'
     * </code>
     *
     * @param     string $pgsSeoFn The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByPgsSeoFn($pgsSeoFn = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($pgsSeoFn)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_PGS_SEO_FN, $pgsSeoFn, $comparison);
    }

    /**
     * Filter the query on the domain_id column
     *
     * Example usage:
     * <code>
     * $query->filterByDomainId(1234); // WHERE domain_id = 1234
     * $query->filterByDomainId(array(12, 34)); // WHERE domain_id IN (12, 34)
     * $query->filterByDomainId(array('min' => 12)); // WHERE domain_id > 12
     * </code>
     *
     * @see       filterByDomain()
     *
     * @param     mixed $domainId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function filterByDomainId($domainId = null, $comparison = null)
    {
        if (is_array($domainId)) {
            $useMinMax = false;
            if (isset($domainId['min'])) {
                $this->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domainId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($domainId['max'])) {
                $this->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domainId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domainId, $comparison);
    }

    /**
     * Filter the query by a related \Diamond\Models\Domain\Domain object
     *
     * @param \Diamond\Models\Domain\Domain|ObjectCollection $domain The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPageQuery The current query, for fluid interface
     */
    public function filterByDomain($domain, $comparison = null)
    {
        if ($domain instanceof \Diamond\Models\Domain\Domain) {
            return $this
                ->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domain->getId(), $comparison);
        } elseif ($domain instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PageTableMap::COL_DOMAIN_ID, $domain->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByDomain() only accepts arguments of type \Diamond\Models\Domain\Domain or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Domain relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function joinDomain($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Domain');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Domain');
        }

        return $this;
    }

    /**
     * Use the Domain relation Domain object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\Domain\DomainQuery A secondary query class using the current class as primary query
     */
    public function useDomainQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinDomain($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Domain', '\Diamond\Models\Domain\DomainQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildPage $page Object to remove from the list of results
     *
     * @return $this|ChildPageQuery The current query, for fluid interface
     */
    public function prune($page = null)
    {
        if ($page) {
            $this->addUsingAlias(PageTableMap::COL_ID, $page->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePreDelete(ConnectionInterface $con)
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the _pages table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PageTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PageTableMap::clearInstancePool();
            PageTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PageTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(PageTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            PageTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            PageTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildPagesArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param      ConnectionInterface $con    Connection to use.
     * @param      Boolean $useLittleMemory    Whether or not to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return     int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(PageTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param boolean True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete($archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

} // PageQuery
