<?php

namespace Diamond\Models\Menu\Map;

use Diamond\Models\Menu\MenuArchive;
use Diamond\Models\Menu\MenuArchiveQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_menu_archive' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class MenuArchiveTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.Menu.Map.MenuArchiveTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = '_menu_archive';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Diamond\\Models\\Menu\\MenuArchive';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.Menu.MenuArchive';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 11;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 11;

    /**
     * the column name for the id field
     */
    const COL_ID = '_menu_archive.id';

    /**
     * the column name for the title field
     */
    const COL_TITLE = '_menu_archive.title';

    /**
     * the column name for the url field
     */
    const COL_URL = '_menu_archive.url';

    /**
     * the column name for the parent_id field
     */
    const COL_PARENT_ID = '_menu_archive.parent_id';

    /**
     * the column name for the name field
     */
    const COL_NAME = '_menu_archive.name';

    /**
     * the column name for the position field
     */
    const COL_POSITION = '_menu_archive.position';

    /**
     * the column name for the code field
     */
    const COL_CODE = '_menu_archive.code';

    /**
     * the column name for the description field
     */
    const COL_DESCRIPTION = '_menu_archive.description';

    /**
     * the column name for the active field
     */
    const COL_ACTIVE = '_menu_archive.active';

    /**
     * the column name for the domain_id field
     */
    const COL_DOMAIN_ID = '_menu_archive.domain_id';

    /**
     * the column name for the archived_at field
     */
    const COL_ARCHIVED_AT = '_menu_archive.archived_at';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Title', 'Url', 'ParentId', 'Name', 'Position', 'Code', 'Desc', 'Active', 'DomainId', 'ArchivedAt', ),
        self::TYPE_CAMELNAME     => array('id', 'title', 'url', 'parentId', 'name', 'position', 'code', 'desc', 'active', 'domainId', 'archivedAt', ),
        self::TYPE_COLNAME       => array(MenuArchiveTableMap::COL_ID, MenuArchiveTableMap::COL_TITLE, MenuArchiveTableMap::COL_URL, MenuArchiveTableMap::COL_PARENT_ID, MenuArchiveTableMap::COL_NAME, MenuArchiveTableMap::COL_POSITION, MenuArchiveTableMap::COL_CODE, MenuArchiveTableMap::COL_DESCRIPTION, MenuArchiveTableMap::COL_ACTIVE, MenuArchiveTableMap::COL_DOMAIN_ID, MenuArchiveTableMap::COL_ARCHIVED_AT, ),
        self::TYPE_FIELDNAME     => array('id', 'title', 'url', 'parent_id', 'name', 'position', 'code', 'description', 'active', 'domain_id', 'archived_at', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Title' => 1, 'Url' => 2, 'ParentId' => 3, 'Name' => 4, 'Position' => 5, 'Code' => 6, 'Desc' => 7, 'Active' => 8, 'DomainId' => 9, 'ArchivedAt' => 10, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'title' => 1, 'url' => 2, 'parentId' => 3, 'name' => 4, 'position' => 5, 'code' => 6, 'desc' => 7, 'active' => 8, 'domainId' => 9, 'archivedAt' => 10, ),
        self::TYPE_COLNAME       => array(MenuArchiveTableMap::COL_ID => 0, MenuArchiveTableMap::COL_TITLE => 1, MenuArchiveTableMap::COL_URL => 2, MenuArchiveTableMap::COL_PARENT_ID => 3, MenuArchiveTableMap::COL_NAME => 4, MenuArchiveTableMap::COL_POSITION => 5, MenuArchiveTableMap::COL_CODE => 6, MenuArchiveTableMap::COL_DESCRIPTION => 7, MenuArchiveTableMap::COL_ACTIVE => 8, MenuArchiveTableMap::COL_DOMAIN_ID => 9, MenuArchiveTableMap::COL_ARCHIVED_AT => 10, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'title' => 1, 'url' => 2, 'parent_id' => 3, 'name' => 4, 'position' => 5, 'code' => 6, 'description' => 7, 'active' => 8, 'domain_id' => 9, 'archived_at' => 10, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('_menu_archive');
        $this->setPhpName('MenuArchive');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Models\\Menu\\MenuArchive');
        $this->setPackage('Models.Menu');
        $this->setUseIdGenerator(false);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', true, 120, null);
        $this->addColumn('url', 'Url', 'VARCHAR', true, 255, null);
        $this->addColumn('parent_id', 'ParentId', 'INTEGER', false, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', false, 50, null);
        $this->addColumn('position', 'Position', 'INTEGER', true, null, 0);
        $this->addColumn('code', 'Code', 'VARCHAR', false, 50, null);
        $this->addColumn('description', 'Desc', 'VARCHAR', false, 255, null);
        $this->addColumn('active', 'Active', 'CHAR', false, null, 'Y');
        $this->addColumn('domain_id', 'DomainId', 'INTEGER', true, null, null);
        $this->addColumn('archived_at', 'ArchivedAt', 'TIMESTAMP', false, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? MenuArchiveTableMap::CLASS_DEFAULT : MenuArchiveTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (MenuArchive object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = MenuArchiveTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = MenuArchiveTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + MenuArchiveTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = MenuArchiveTableMap::OM_CLASS;
            /** @var MenuArchive $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            MenuArchiveTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = MenuArchiveTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = MenuArchiveTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var MenuArchive $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                MenuArchiveTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_ID);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_TITLE);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_URL);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_PARENT_ID);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_NAME);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_POSITION);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_CODE);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_DESCRIPTION);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_DOMAIN_ID);
            $criteria->addSelectColumn(MenuArchiveTableMap::COL_ARCHIVED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.url');
            $criteria->addSelectColumn($alias . '.parent_id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.position');
            $criteria->addSelectColumn($alias . '.code');
            $criteria->addSelectColumn($alias . '.description');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.domain_id');
            $criteria->addSelectColumn($alias . '.archived_at');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(MenuArchiveTableMap::DATABASE_NAME)->getTable(MenuArchiveTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(MenuArchiveTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(MenuArchiveTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new MenuArchiveTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a MenuArchive or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or MenuArchive object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MenuArchiveTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Models\Menu\MenuArchive) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(MenuArchiveTableMap::DATABASE_NAME);
            $criteria->add(MenuArchiveTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = MenuArchiveQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            MenuArchiveTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                MenuArchiveTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _menu_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return MenuArchiveQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a MenuArchive or Criteria object.
     *
     * @param mixed               $criteria Criteria or MenuArchive object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MenuArchiveTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from MenuArchive object
        }


        // Set the correct dbName
        $query = MenuArchiveQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // MenuArchiveTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
MenuArchiveTableMap::buildTableMap();
