<?php

namespace Diamond\Models\MailingSubscriber\Base;

use \Exception;
use \PDO;
use Diamond\Models\Mailing\Mailing;
use Diamond\Models\MailingSubscriber\MailingSubscriber as ChildMailingSubscriber;
use Diamond\Models\MailingSubscriber\MailingSubscriberQuery as ChildMailingSubscriberQuery;
use Diamond\Models\MailingSubscriber\Map\MailingSubscriberTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_mailing_subscribers' table.
 *
 *
 *
 * @method     ChildMailingSubscriberQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildMailingSubscriberQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildMailingSubscriberQuery orderByFn($order = Criteria::ASC) Order by the fn column
 * @method     ChildMailingSubscriberQuery orderByCustomMails($order = Criteria::ASC) Order by the custom_mails column
 * @method     ChildMailingSubscriberQuery orderByIgnoreMails($order = Criteria::ASC) Order by the ignore_mails column
 *
 * @method     ChildMailingSubscriberQuery groupById() Group by the id column
 * @method     ChildMailingSubscriberQuery groupByTitle() Group by the title column
 * @method     ChildMailingSubscriberQuery groupByFn() Group by the fn column
 * @method     ChildMailingSubscriberQuery groupByCustomMails() Group by the custom_mails column
 * @method     ChildMailingSubscriberQuery groupByIgnoreMails() Group by the ignore_mails column
 *
 * @method     ChildMailingSubscriberQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildMailingSubscriberQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildMailingSubscriberQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildMailingSubscriberQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildMailingSubscriberQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildMailingSubscriberQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildMailingSubscriberQuery leftJoinMailing($relationAlias = null) Adds a LEFT JOIN clause to the query using the Mailing relation
 * @method     ChildMailingSubscriberQuery rightJoinMailing($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Mailing relation
 * @method     ChildMailingSubscriberQuery innerJoinMailing($relationAlias = null) Adds a INNER JOIN clause to the query using the Mailing relation
 *
 * @method     ChildMailingSubscriberQuery joinWithMailing($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Mailing relation
 *
 * @method     ChildMailingSubscriberQuery leftJoinWithMailing() Adds a LEFT JOIN clause and with to the query using the Mailing relation
 * @method     ChildMailingSubscriberQuery rightJoinWithMailing() Adds a RIGHT JOIN clause and with to the query using the Mailing relation
 * @method     ChildMailingSubscriberQuery innerJoinWithMailing() Adds a INNER JOIN clause and with to the query using the Mailing relation
 *
 * @method     \Diamond\Models\Mailing\MailingQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildMailingSubscriber findOne(ConnectionInterface $con = null) Return the first ChildMailingSubscriber matching the query
 * @method     ChildMailingSubscriber findOneOrCreate(ConnectionInterface $con = null) Return the first ChildMailingSubscriber matching the query, or a new ChildMailingSubscriber object populated from the query conditions when no match is found
 *
 * @method     ChildMailingSubscriber findOneById(int $id) Return the first ChildMailingSubscriber filtered by the id column
 * @method     ChildMailingSubscriber findOneByTitle(string $title) Return the first ChildMailingSubscriber filtered by the title column
 * @method     ChildMailingSubscriber findOneByFn(string $fn) Return the first ChildMailingSubscriber filtered by the fn column
 * @method     ChildMailingSubscriber findOneByCustomMails(string $custom_mails) Return the first ChildMailingSubscriber filtered by the custom_mails column
 * @method     ChildMailingSubscriber findOneByIgnoreMails(string $ignore_mails) Return the first ChildMailingSubscriber filtered by the ignore_mails column *

 * @method     ChildMailingSubscriber requirePk($key, ConnectionInterface $con = null) Return the ChildMailingSubscriber by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingSubscriber requireOne(ConnectionInterface $con = null) Return the first ChildMailingSubscriber matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMailingSubscriber requireOneById(int $id) Return the first ChildMailingSubscriber filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingSubscriber requireOneByTitle(string $title) Return the first ChildMailingSubscriber filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingSubscriber requireOneByFn(string $fn) Return the first ChildMailingSubscriber filtered by the fn column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingSubscriber requireOneByCustomMails(string $custom_mails) Return the first ChildMailingSubscriber filtered by the custom_mails column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMailingSubscriber requireOneByIgnoreMails(string $ignore_mails) Return the first ChildMailingSubscriber filtered by the ignore_mails column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMailingSubscriber[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildMailingSubscriber objects based on current ModelCriteria
 * @method     ChildMailingSubscriber[]|ObjectCollection findById(int $id) Return ChildMailingSubscriber objects filtered by the id column
 * @method     ChildMailingSubscriber[]|ObjectCollection findByTitle(string $title) Return ChildMailingSubscriber objects filtered by the title column
 * @method     ChildMailingSubscriber[]|ObjectCollection findByFn(string $fn) Return ChildMailingSubscriber objects filtered by the fn column
 * @method     ChildMailingSubscriber[]|ObjectCollection findByCustomMails(string $custom_mails) Return ChildMailingSubscriber objects filtered by the custom_mails column
 * @method     ChildMailingSubscriber[]|ObjectCollection findByIgnoreMails(string $ignore_mails) Return ChildMailingSubscriber objects filtered by the ignore_mails column
 * @method     ChildMailingSubscriber[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class MailingSubscriberQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Models\MailingSubscriber\Base\MailingSubscriberQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Models\\MailingSubscriber\\MailingSubscriber', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildMailingSubscriberQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildMailingSubscriberQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildMailingSubscriberQuery) {
            return $criteria;
        }
        $query = new ChildMailingSubscriberQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildMailingSubscriber|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(MailingSubscriberTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = MailingSubscriberTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildMailingSubscriber A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `fn`, `custom_mails`, `ignore_mails` FROM `_mailing_subscribers` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildMailingSubscriber $obj */
            $obj = new ChildMailingSubscriber();
            $obj->hydrate($row);
            MailingSubscriberTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildMailingSubscriber|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(MailingSubscriberTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(MailingSubscriberTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(MailingSubscriberTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(MailingSubscriberTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MailingSubscriberTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MailingSubscriberTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the fn column
     *
     * Example usage:
     * <code>
     * $query->filterByFn('fooValue');   // WHERE fn = 'fooValue'
     * $query->filterByFn('%fooValue%', Criteria::LIKE); // WHERE fn LIKE '%fooValue%'
     * </code>
     *
     * @param     string $fn The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function filterByFn($fn = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($fn)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MailingSubscriberTableMap::COL_FN, $fn, $comparison);
    }

    /**
     * Filter the query on the custom_mails column
     *
     * Example usage:
     * <code>
     * $query->filterByCustomMails('fooValue');   // WHERE custom_mails = 'fooValue'
     * $query->filterByCustomMails('%fooValue%', Criteria::LIKE); // WHERE custom_mails LIKE '%fooValue%'
     * </code>
     *
     * @param     string $customMails The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function filterByCustomMails($customMails = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($customMails)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MailingSubscriberTableMap::COL_CUSTOM_MAILS, $customMails, $comparison);
    }

    /**
     * Filter the query on the ignore_mails column
     *
     * Example usage:
     * <code>
     * $query->filterByIgnoreMails('fooValue');   // WHERE ignore_mails = 'fooValue'
     * $query->filterByIgnoreMails('%fooValue%', Criteria::LIKE); // WHERE ignore_mails LIKE '%fooValue%'
     * </code>
     *
     * @param     string $ignoreMails The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function filterByIgnoreMails($ignoreMails = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ignoreMails)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(MailingSubscriberTableMap::COL_IGNORE_MAILS, $ignoreMails, $comparison);
    }

    /**
     * Filter the query by a related \Diamond\Models\Mailing\Mailing object
     *
     * @param \Diamond\Models\Mailing\Mailing|ObjectCollection $mailing the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function filterByMailing($mailing, $comparison = null)
    {
        if ($mailing instanceof \Diamond\Models\Mailing\Mailing) {
            return $this
                ->addUsingAlias(MailingSubscriberTableMap::COL_ID, $mailing->getSubId(), $comparison);
        } elseif ($mailing instanceof ObjectCollection) {
            return $this
                ->useMailingQuery()
                ->filterByPrimaryKeys($mailing->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMailing() only accepts arguments of type \Diamond\Models\Mailing\Mailing or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Mailing relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function joinMailing($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Mailing');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Mailing');
        }

        return $this;
    }

    /**
     * Use the Mailing relation Mailing object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\Mailing\MailingQuery A secondary query class using the current class as primary query
     */
    public function useMailingQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMailing($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Mailing', '\Diamond\Models\Mailing\MailingQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildMailingSubscriber $mailingSubscriber Object to remove from the list of results
     *
     * @return $this|ChildMailingSubscriberQuery The current query, for fluid interface
     */
    public function prune($mailingSubscriber = null)
    {
        if ($mailingSubscriber) {
            $this->addUsingAlias(MailingSubscriberTableMap::COL_ID, $mailingSubscriber->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _mailing_subscribers table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingSubscriberTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            MailingSubscriberTableMap::clearInstancePool();
            MailingSubscriberTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingSubscriberTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(MailingSubscriberTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            MailingSubscriberTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            MailingSubscriberTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // MailingSubscriberQuery
