<?php

namespace Diamond\Models\MailingRequestRecipient\Map;

use Diamond\Models\MailingRequestRecipient\MailingRequestRecipient;
use Diamond\Models\MailingRequestRecipient\MailingRequestRecipientQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_mailing_request_recipients' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class MailingRequestRecipientTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.MailingRequestRecipient.Map.MailingRequestRecipientTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = '_mailing_request_recipients';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Diamond\\Models\\MailingRequestRecipient\\MailingRequestRecipient';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.MailingRequestRecipient.MailingRequestRecipient';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 6;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 6;

    /**
     * the column name for the id field
     */
    const COL_ID = '_mailing_request_recipients.id';

    /**
     * the column name for the email field
     */
    const COL_EMAIL = '_mailing_request_recipients.email';

    /**
     * the column name for the request_id field
     */
    const COL_REQUEST_ID = '_mailing_request_recipients.request_id';

    /**
     * the column name for the created_at field
     */
    const COL_CREATED_AT = '_mailing_request_recipients.created_at';

    /**
     * the column name for the sending_at field
     */
    const COL_SENDING_AT = '_mailing_request_recipients.sending_at';

    /**
     * the column name for the viewed_at field
     */
    const COL_VIEWED_AT = '_mailing_request_recipients.viewed_at';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Email', 'RequestId', 'CreatedAt', 'SendingAt', 'ViewedAt', ),
        self::TYPE_CAMELNAME     => array('id', 'email', 'requestId', 'createdAt', 'sendingAt', 'viewedAt', ),
        self::TYPE_COLNAME       => array(MailingRequestRecipientTableMap::COL_ID, MailingRequestRecipientTableMap::COL_EMAIL, MailingRequestRecipientTableMap::COL_REQUEST_ID, MailingRequestRecipientTableMap::COL_CREATED_AT, MailingRequestRecipientTableMap::COL_SENDING_AT, MailingRequestRecipientTableMap::COL_VIEWED_AT, ),
        self::TYPE_FIELDNAME     => array('id', 'email', 'request_id', 'created_at', 'sending_at', 'viewed_at', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Email' => 1, 'RequestId' => 2, 'CreatedAt' => 3, 'SendingAt' => 4, 'ViewedAt' => 5, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'email' => 1, 'requestId' => 2, 'createdAt' => 3, 'sendingAt' => 4, 'viewedAt' => 5, ),
        self::TYPE_COLNAME       => array(MailingRequestRecipientTableMap::COL_ID => 0, MailingRequestRecipientTableMap::COL_EMAIL => 1, MailingRequestRecipientTableMap::COL_REQUEST_ID => 2, MailingRequestRecipientTableMap::COL_CREATED_AT => 3, MailingRequestRecipientTableMap::COL_SENDING_AT => 4, MailingRequestRecipientTableMap::COL_VIEWED_AT => 5, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'email' => 1, 'request_id' => 2, 'created_at' => 3, 'sending_at' => 4, 'viewed_at' => 5, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('_mailing_request_recipients');
        $this->setPhpName('MailingRequestRecipient');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Models\\MailingRequestRecipient\\MailingRequestRecipient');
        $this->setPackage('Models.MailingRequestRecipient');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('email', 'Email', 'VARCHAR', true, 50, null);
        $this->addForeignKey('request_id', 'RequestId', 'INTEGER', '_mailing_requests', 'id', true, null, null);
        $this->addColumn('created_at', 'CreatedAt', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('sending_at', 'SendingAt', 'TIMESTAMP', false, null, null);
        $this->addColumn('viewed_at', 'ViewedAt', 'TIMESTAMP', false, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('MailingRequest', '\\Diamond\\Models\\MailingRequest\\MailingRequest', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':request_id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? MailingRequestRecipientTableMap::CLASS_DEFAULT : MailingRequestRecipientTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (MailingRequestRecipient object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = MailingRequestRecipientTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = MailingRequestRecipientTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + MailingRequestRecipientTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = MailingRequestRecipientTableMap::OM_CLASS;
            /** @var MailingRequestRecipient $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            MailingRequestRecipientTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = MailingRequestRecipientTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = MailingRequestRecipientTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var MailingRequestRecipient $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                MailingRequestRecipientTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(MailingRequestRecipientTableMap::COL_ID);
            $criteria->addSelectColumn(MailingRequestRecipientTableMap::COL_EMAIL);
            $criteria->addSelectColumn(MailingRequestRecipientTableMap::COL_REQUEST_ID);
            $criteria->addSelectColumn(MailingRequestRecipientTableMap::COL_CREATED_AT);
            $criteria->addSelectColumn(MailingRequestRecipientTableMap::COL_SENDING_AT);
            $criteria->addSelectColumn(MailingRequestRecipientTableMap::COL_VIEWED_AT);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.email');
            $criteria->addSelectColumn($alias . '.request_id');
            $criteria->addSelectColumn($alias . '.created_at');
            $criteria->addSelectColumn($alias . '.sending_at');
            $criteria->addSelectColumn($alias . '.viewed_at');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(MailingRequestRecipientTableMap::DATABASE_NAME)->getTable(MailingRequestRecipientTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(MailingRequestRecipientTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(MailingRequestRecipientTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new MailingRequestRecipientTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a MailingRequestRecipient or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or MailingRequestRecipient object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingRequestRecipientTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Models\MailingRequestRecipient\MailingRequestRecipient) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(MailingRequestRecipientTableMap::DATABASE_NAME);
            $criteria->add(MailingRequestRecipientTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = MailingRequestRecipientQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            MailingRequestRecipientTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                MailingRequestRecipientTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _mailing_request_recipients table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return MailingRequestRecipientQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a MailingRequestRecipient or Criteria object.
     *
     * @param mixed               $criteria Criteria or MailingRequestRecipient object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingRequestRecipientTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from MailingRequestRecipient object
        }

        if ($criteria->containsKey(MailingRequestRecipientTableMap::COL_ID) && $criteria->keyContainsValue(MailingRequestRecipientTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.MailingRequestRecipientTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = MailingRequestRecipientQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // MailingRequestRecipientTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
MailingRequestRecipientTableMap::buildTableMap();
