<?php

namespace Diamond\Models\ImageSlider\Base;

use \Exception;
use \PDO;
use Diamond\Models\Domain\Domain;
use Diamond\Models\ImageSlider\ImageSlider as ChildImageSlider;
use Diamond\Models\ImageSlider\ImageSliderQuery as ChildImageSliderQuery;
use Diamond\Models\ImageSlider\Map\ImageSliderTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_slider_images' table.
 *
 *
 *
 * @method     ChildImageSliderQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildImageSliderQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildImageSliderQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildImageSliderQuery orderByBigImage($order = Criteria::ASC) Order by the bigimage column
 * @method     ChildImageSliderQuery orderByMiddleImage($order = Criteria::ASC) Order by the middleimage column
 * @method     ChildImageSliderQuery orderByLink($order = Criteria::ASC) Order by the link column
 * @method     ChildImageSliderQuery orderByDomainId($order = Criteria::ASC) Order by the domain_id column
 *
 * @method     ChildImageSliderQuery groupById() Group by the id column
 * @method     ChildImageSliderQuery groupByTitle() Group by the title column
 * @method     ChildImageSliderQuery groupByActive() Group by the active column
 * @method     ChildImageSliderQuery groupByBigImage() Group by the bigimage column
 * @method     ChildImageSliderQuery groupByMiddleImage() Group by the middleimage column
 * @method     ChildImageSliderQuery groupByLink() Group by the link column
 * @method     ChildImageSliderQuery groupByDomainId() Group by the domain_id column
 *
 * @method     ChildImageSliderQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildImageSliderQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildImageSliderQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildImageSliderQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildImageSliderQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildImageSliderQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildImageSliderQuery leftJoinDomain($relationAlias = null) Adds a LEFT JOIN clause to the query using the Domain relation
 * @method     ChildImageSliderQuery rightJoinDomain($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Domain relation
 * @method     ChildImageSliderQuery innerJoinDomain($relationAlias = null) Adds a INNER JOIN clause to the query using the Domain relation
 *
 * @method     ChildImageSliderQuery joinWithDomain($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Domain relation
 *
 * @method     ChildImageSliderQuery leftJoinWithDomain() Adds a LEFT JOIN clause and with to the query using the Domain relation
 * @method     ChildImageSliderQuery rightJoinWithDomain() Adds a RIGHT JOIN clause and with to the query using the Domain relation
 * @method     ChildImageSliderQuery innerJoinWithDomain() Adds a INNER JOIN clause and with to the query using the Domain relation
 *
 * @method     \Diamond\Models\Domain\DomainQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildImageSlider findOne(ConnectionInterface $con = null) Return the first ChildImageSlider matching the query
 * @method     ChildImageSlider findOneOrCreate(ConnectionInterface $con = null) Return the first ChildImageSlider matching the query, or a new ChildImageSlider object populated from the query conditions when no match is found
 *
 * @method     ChildImageSlider findOneById(int $id) Return the first ChildImageSlider filtered by the id column
 * @method     ChildImageSlider findOneByTitle(string $title) Return the first ChildImageSlider filtered by the title column
 * @method     ChildImageSlider findOneByActive(int $active) Return the first ChildImageSlider filtered by the active column
 * @method     ChildImageSlider findOneByBigImage(string $bigimage) Return the first ChildImageSlider filtered by the bigimage column
 * @method     ChildImageSlider findOneByMiddleImage(string $middleimage) Return the first ChildImageSlider filtered by the middleimage column
 * @method     ChildImageSlider findOneByLink(string $link) Return the first ChildImageSlider filtered by the link column
 * @method     ChildImageSlider findOneByDomainId(int $domain_id) Return the first ChildImageSlider filtered by the domain_id column *

 * @method     ChildImageSlider requirePk($key, ConnectionInterface $con = null) Return the ChildImageSlider by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildImageSlider requireOne(ConnectionInterface $con = null) Return the first ChildImageSlider matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildImageSlider requireOneById(int $id) Return the first ChildImageSlider filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildImageSlider requireOneByTitle(string $title) Return the first ChildImageSlider filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildImageSlider requireOneByActive(int $active) Return the first ChildImageSlider filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildImageSlider requireOneByBigImage(string $bigimage) Return the first ChildImageSlider filtered by the bigimage column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildImageSlider requireOneByMiddleImage(string $middleimage) Return the first ChildImageSlider filtered by the middleimage column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildImageSlider requireOneByLink(string $link) Return the first ChildImageSlider filtered by the link column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildImageSlider requireOneByDomainId(int $domain_id) Return the first ChildImageSlider filtered by the domain_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildImageSlider[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildImageSlider objects based on current ModelCriteria
 * @method     ChildImageSlider[]|ObjectCollection findById(int $id) Return ChildImageSlider objects filtered by the id column
 * @method     ChildImageSlider[]|ObjectCollection findByTitle(string $title) Return ChildImageSlider objects filtered by the title column
 * @method     ChildImageSlider[]|ObjectCollection findByActive(int $active) Return ChildImageSlider objects filtered by the active column
 * @method     ChildImageSlider[]|ObjectCollection findByBigImage(string $bigimage) Return ChildImageSlider objects filtered by the bigimage column
 * @method     ChildImageSlider[]|ObjectCollection findByMiddleImage(string $middleimage) Return ChildImageSlider objects filtered by the middleimage column
 * @method     ChildImageSlider[]|ObjectCollection findByLink(string $link) Return ChildImageSlider objects filtered by the link column
 * @method     ChildImageSlider[]|ObjectCollection findByDomainId(int $domain_id) Return ChildImageSlider objects filtered by the domain_id column
 * @method     ChildImageSlider[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ImageSliderQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Models\ImageSlider\Base\ImageSliderQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Models\\ImageSlider\\ImageSlider', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildImageSliderQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildImageSliderQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildImageSliderQuery) {
            return $criteria;
        }
        $query = new ChildImageSliderQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildImageSlider|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ImageSliderTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ImageSliderTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildImageSlider A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `active`, `bigimage`, `middleimage`, `link`, `domain_id` FROM `_slider_images` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildImageSlider $obj */
            $obj = new ChildImageSlider();
            $obj->hydrate($row);
            ImageSliderTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildImageSlider|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ImageSliderTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ImageSliderTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ImageSliderTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ImageSliderTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ImageSliderTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ImageSliderTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive(1234); // WHERE active = 1234
     * $query->filterByActive(array(12, 34)); // WHERE active IN (12, 34)
     * $query->filterByActive(array('min' => 12)); // WHERE active > 12
     * </code>
     *
     * @param     mixed $active The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (is_array($active)) {
            $useMinMax = false;
            if (isset($active['min'])) {
                $this->addUsingAlias(ImageSliderTableMap::COL_ACTIVE, $active['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($active['max'])) {
                $this->addUsingAlias(ImageSliderTableMap::COL_ACTIVE, $active['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ImageSliderTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the bigimage column
     *
     * Example usage:
     * <code>
     * $query->filterByBigImage('fooValue');   // WHERE bigimage = 'fooValue'
     * $query->filterByBigImage('%fooValue%', Criteria::LIKE); // WHERE bigimage LIKE '%fooValue%'
     * </code>
     *
     * @param     string $bigImage The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterByBigImage($bigImage = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($bigImage)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ImageSliderTableMap::COL_BIGIMAGE, $bigImage, $comparison);
    }

    /**
     * Filter the query on the middleimage column
     *
     * Example usage:
     * <code>
     * $query->filterByMiddleImage('fooValue');   // WHERE middleimage = 'fooValue'
     * $query->filterByMiddleImage('%fooValue%', Criteria::LIKE); // WHERE middleimage LIKE '%fooValue%'
     * </code>
     *
     * @param     string $middleImage The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterByMiddleImage($middleImage = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($middleImage)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ImageSliderTableMap::COL_MIDDLEIMAGE, $middleImage, $comparison);
    }

    /**
     * Filter the query on the link column
     *
     * Example usage:
     * <code>
     * $query->filterByLink('fooValue');   // WHERE link = 'fooValue'
     * $query->filterByLink('%fooValue%', Criteria::LIKE); // WHERE link LIKE '%fooValue%'
     * </code>
     *
     * @param     string $link The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterByLink($link = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($link)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ImageSliderTableMap::COL_LINK, $link, $comparison);
    }

    /**
     * Filter the query on the domain_id column
     *
     * Example usage:
     * <code>
     * $query->filterByDomainId(1234); // WHERE domain_id = 1234
     * $query->filterByDomainId(array(12, 34)); // WHERE domain_id IN (12, 34)
     * $query->filterByDomainId(array('min' => 12)); // WHERE domain_id > 12
     * </code>
     *
     * @see       filterByDomain()
     *
     * @param     mixed $domainId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterByDomainId($domainId = null, $comparison = null)
    {
        if (is_array($domainId)) {
            $useMinMax = false;
            if (isset($domainId['min'])) {
                $this->addUsingAlias(ImageSliderTableMap::COL_DOMAIN_ID, $domainId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($domainId['max'])) {
                $this->addUsingAlias(ImageSliderTableMap::COL_DOMAIN_ID, $domainId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ImageSliderTableMap::COL_DOMAIN_ID, $domainId, $comparison);
    }

    /**
     * Filter the query by a related \Diamond\Models\Domain\Domain object
     *
     * @param \Diamond\Models\Domain\Domain|ObjectCollection $domain The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildImageSliderQuery The current query, for fluid interface
     */
    public function filterByDomain($domain, $comparison = null)
    {
        if ($domain instanceof \Diamond\Models\Domain\Domain) {
            return $this
                ->addUsingAlias(ImageSliderTableMap::COL_DOMAIN_ID, $domain->getId(), $comparison);
        } elseif ($domain instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ImageSliderTableMap::COL_DOMAIN_ID, $domain->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByDomain() only accepts arguments of type \Diamond\Models\Domain\Domain or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Domain relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function joinDomain($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Domain');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Domain');
        }

        return $this;
    }

    /**
     * Use the Domain relation Domain object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\Domain\DomainQuery A secondary query class using the current class as primary query
     */
    public function useDomainQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinDomain($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Domain', '\Diamond\Models\Domain\DomainQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildImageSlider $imageSlider Object to remove from the list of results
     *
     * @return $this|ChildImageSliderQuery The current query, for fluid interface
     */
    public function prune($imageSlider = null)
    {
        if ($imageSlider) {
            $this->addUsingAlias(ImageSliderTableMap::COL_ID, $imageSlider->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _slider_images table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ImageSliderTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ImageSliderTableMap::clearInstancePool();
            ImageSliderTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ImageSliderTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ImageSliderTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ImageSliderTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ImageSliderTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // ImageSliderQuery
