<?php

namespace Diamond\Models\GuestBookItem\Map;

use Diamond\Models\GuestBookItem\GuestBookItem;
use Diamond\Models\GuestBookItem\GuestBookItemQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_guest_book_items' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class GuestBookItemTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.GuestBookItem.Map.GuestBookItemTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = '_guest_book_items';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Diamond\\Models\\GuestBookItem\\GuestBookItem';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.GuestBookItem.GuestBookItem';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 10;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 10;

    /**
     * the column name for the id field
     */
    const COL_ID = '_guest_book_items.id';

    /**
     * the column name for the text field
     */
    const COL_TEXT = '_guest_book_items.text';

    /**
     * the column name for the date field
     */
    const COL_DATE = '_guest_book_items.date';

    /**
     * the column name for the ip field
     */
    const COL_IP = '_guest_book_items.ip';

    /**
     * the column name for the published field
     */
    const COL_PUBLISHED = '_guest_book_items.published';

    /**
     * the column name for the username field
     */
    const COL_USERNAME = '_guest_book_items.username';

    /**
     * the column name for the useremail field
     */
    const COL_USEREMAIL = '_guest_book_items.useremail';

    /**
     * the column name for the book_id field
     */
    const COL_BOOK_ID = '_guest_book_items.book_id';

    /**
     * the column name for the object_id field
     */
    const COL_OBJECT_ID = '_guest_book_items.object_id';

    /**
     * the column name for the rank field
     */
    const COL_RANK = '_guest_book_items.rank';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Text', 'Date', 'Ip', 'Published', 'Username', 'Useremail', 'BookId', 'ObjectId', 'Rank', ),
        self::TYPE_CAMELNAME     => array('id', 'text', 'date', 'ip', 'published', 'username', 'useremail', 'bookId', 'objectId', 'rank', ),
        self::TYPE_COLNAME       => array(GuestBookItemTableMap::COL_ID, GuestBookItemTableMap::COL_TEXT, GuestBookItemTableMap::COL_DATE, GuestBookItemTableMap::COL_IP, GuestBookItemTableMap::COL_PUBLISHED, GuestBookItemTableMap::COL_USERNAME, GuestBookItemTableMap::COL_USEREMAIL, GuestBookItemTableMap::COL_BOOK_ID, GuestBookItemTableMap::COL_OBJECT_ID, GuestBookItemTableMap::COL_RANK, ),
        self::TYPE_FIELDNAME     => array('id', 'text', 'date', 'ip', 'published', 'username', 'useremail', 'book_id', 'object_id', 'rank', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Text' => 1, 'Date' => 2, 'Ip' => 3, 'Published' => 4, 'Username' => 5, 'Useremail' => 6, 'BookId' => 7, 'ObjectId' => 8, 'Rank' => 9, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'text' => 1, 'date' => 2, 'ip' => 3, 'published' => 4, 'username' => 5, 'useremail' => 6, 'bookId' => 7, 'objectId' => 8, 'rank' => 9, ),
        self::TYPE_COLNAME       => array(GuestBookItemTableMap::COL_ID => 0, GuestBookItemTableMap::COL_TEXT => 1, GuestBookItemTableMap::COL_DATE => 2, GuestBookItemTableMap::COL_IP => 3, GuestBookItemTableMap::COL_PUBLISHED => 4, GuestBookItemTableMap::COL_USERNAME => 5, GuestBookItemTableMap::COL_USEREMAIL => 6, GuestBookItemTableMap::COL_BOOK_ID => 7, GuestBookItemTableMap::COL_OBJECT_ID => 8, GuestBookItemTableMap::COL_RANK => 9, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'text' => 1, 'date' => 2, 'ip' => 3, 'published' => 4, 'username' => 5, 'useremail' => 6, 'book_id' => 7, 'object_id' => 8, 'rank' => 9, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('_guest_book_items');
        $this->setPhpName('GuestBookItem');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Models\\GuestBookItem\\GuestBookItem');
        $this->setPackage('Models.GuestBookItem');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('text', 'Text', 'LONGVARCHAR', true, null, null);
        $this->addColumn('date', 'Date', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('ip', 'Ip', 'VARCHAR', false, 20, null);
        $this->addColumn('published', 'Published', 'CHAR', true, null, 'N');
        $this->addColumn('username', 'Username', 'VARCHAR', true, 50, null);
        $this->addColumn('useremail', 'Useremail', 'VARCHAR', false, 100, null);
        $this->addForeignKey('book_id', 'BookId', 'INTEGER', '_guest_books', 'id', true, null, null);
        $this->addColumn('object_id', 'ObjectId', 'CHAR', false, 20, null);
        $this->addColumn('rank', 'Rank', 'TINYINT', false, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('GuestBook', '\\Diamond\\Models\\GuestBook\\GuestBook', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':book_id',
    1 => ':id',
  ),
), null, null, null, false);
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? GuestBookItemTableMap::CLASS_DEFAULT : GuestBookItemTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (GuestBookItem object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = GuestBookItemTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = GuestBookItemTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + GuestBookItemTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = GuestBookItemTableMap::OM_CLASS;
            /** @var GuestBookItem $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            GuestBookItemTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = GuestBookItemTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = GuestBookItemTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var GuestBookItem $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                GuestBookItemTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_ID);
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_TEXT);
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_DATE);
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_IP);
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_PUBLISHED);
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_USERNAME);
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_USEREMAIL);
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_BOOK_ID);
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_OBJECT_ID);
            $criteria->addSelectColumn(GuestBookItemTableMap::COL_RANK);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.text');
            $criteria->addSelectColumn($alias . '.date');
            $criteria->addSelectColumn($alias . '.ip');
            $criteria->addSelectColumn($alias . '.published');
            $criteria->addSelectColumn($alias . '.username');
            $criteria->addSelectColumn($alias . '.useremail');
            $criteria->addSelectColumn($alias . '.book_id');
            $criteria->addSelectColumn($alias . '.object_id');
            $criteria->addSelectColumn($alias . '.rank');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(GuestBookItemTableMap::DATABASE_NAME)->getTable(GuestBookItemTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(GuestBookItemTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(GuestBookItemTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new GuestBookItemTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a GuestBookItem or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or GuestBookItem object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(GuestBookItemTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Models\GuestBookItem\GuestBookItem) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(GuestBookItemTableMap::DATABASE_NAME);
            $criteria->add(GuestBookItemTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = GuestBookItemQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            GuestBookItemTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                GuestBookItemTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _guest_book_items table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return GuestBookItemQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a GuestBookItem or Criteria object.
     *
     * @param mixed               $criteria Criteria or GuestBookItem object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(GuestBookItemTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from GuestBookItem object
        }

        if ($criteria->containsKey(GuestBookItemTableMap::COL_ID) && $criteria->keyContainsValue(GuestBookItemTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.GuestBookItemTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = GuestBookItemQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // GuestBookItemTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
GuestBookItemTableMap::buildTableMap();
