<?php

namespace Diamond\Models\Domain\Base;

use \Exception;
use \PDO;
use Diamond\Models\Domain\Domain as ChildDomain;
use Diamond\Models\Domain\DomainQuery as ChildDomainQuery;
use Diamond\Models\Domain\Map\DomainTableMap;
use Diamond\Models\ImageSlider\ImageSlider;
use Diamond\Models\Menu\Menu;
use Diamond\Models\Page\Page;
use Diamond\Models\Promoblock\Promoblock;
use Diamond\Models\Template\Template;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Catalog\Catalog;
use Shop\Models\Shop\Shop;

/**
 * Base class that represents a query for the '_domains' table.
 *
 *
 *
 * @method     ChildDomainQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildDomainQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildDomainQuery orderByLang($order = Criteria::ASC) Order by the lang column
 * @method     ChildDomainQuery orderByDomain($order = Criteria::ASC) Order by the domain column
 *
 * @method     ChildDomainQuery groupById() Group by the id column
 * @method     ChildDomainQuery groupByName() Group by the name column
 * @method     ChildDomainQuery groupByLang() Group by the lang column
 * @method     ChildDomainQuery groupByDomain() Group by the domain column
 *
 * @method     ChildDomainQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildDomainQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildDomainQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildDomainQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildDomainQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildDomainQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildDomainQuery leftJoinMenu($relationAlias = null) Adds a LEFT JOIN clause to the query using the Menu relation
 * @method     ChildDomainQuery rightJoinMenu($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Menu relation
 * @method     ChildDomainQuery innerJoinMenu($relationAlias = null) Adds a INNER JOIN clause to the query using the Menu relation
 *
 * @method     ChildDomainQuery joinWithMenu($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Menu relation
 *
 * @method     ChildDomainQuery leftJoinWithMenu() Adds a LEFT JOIN clause and with to the query using the Menu relation
 * @method     ChildDomainQuery rightJoinWithMenu() Adds a RIGHT JOIN clause and with to the query using the Menu relation
 * @method     ChildDomainQuery innerJoinWithMenu() Adds a INNER JOIN clause and with to the query using the Menu relation
 *
 * @method     ChildDomainQuery leftJoinPage($relationAlias = null) Adds a LEFT JOIN clause to the query using the Page relation
 * @method     ChildDomainQuery rightJoinPage($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Page relation
 * @method     ChildDomainQuery innerJoinPage($relationAlias = null) Adds a INNER JOIN clause to the query using the Page relation
 *
 * @method     ChildDomainQuery joinWithPage($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Page relation
 *
 * @method     ChildDomainQuery leftJoinWithPage() Adds a LEFT JOIN clause and with to the query using the Page relation
 * @method     ChildDomainQuery rightJoinWithPage() Adds a RIGHT JOIN clause and with to the query using the Page relation
 * @method     ChildDomainQuery innerJoinWithPage() Adds a INNER JOIN clause and with to the query using the Page relation
 *
 * @method     ChildDomainQuery leftJoinPromoblock($relationAlias = null) Adds a LEFT JOIN clause to the query using the Promoblock relation
 * @method     ChildDomainQuery rightJoinPromoblock($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Promoblock relation
 * @method     ChildDomainQuery innerJoinPromoblock($relationAlias = null) Adds a INNER JOIN clause to the query using the Promoblock relation
 *
 * @method     ChildDomainQuery joinWithPromoblock($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Promoblock relation
 *
 * @method     ChildDomainQuery leftJoinWithPromoblock() Adds a LEFT JOIN clause and with to the query using the Promoblock relation
 * @method     ChildDomainQuery rightJoinWithPromoblock() Adds a RIGHT JOIN clause and with to the query using the Promoblock relation
 * @method     ChildDomainQuery innerJoinWithPromoblock() Adds a INNER JOIN clause and with to the query using the Promoblock relation
 *
 * @method     ChildDomainQuery leftJoinTemplate($relationAlias = null) Adds a LEFT JOIN clause to the query using the Template relation
 * @method     ChildDomainQuery rightJoinTemplate($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Template relation
 * @method     ChildDomainQuery innerJoinTemplate($relationAlias = null) Adds a INNER JOIN clause to the query using the Template relation
 *
 * @method     ChildDomainQuery joinWithTemplate($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Template relation
 *
 * @method     ChildDomainQuery leftJoinWithTemplate() Adds a LEFT JOIN clause and with to the query using the Template relation
 * @method     ChildDomainQuery rightJoinWithTemplate() Adds a RIGHT JOIN clause and with to the query using the Template relation
 * @method     ChildDomainQuery innerJoinWithTemplate() Adds a INNER JOIN clause and with to the query using the Template relation
 *
 * @method     ChildDomainQuery leftJoinImageSlider($relationAlias = null) Adds a LEFT JOIN clause to the query using the ImageSlider relation
 * @method     ChildDomainQuery rightJoinImageSlider($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ImageSlider relation
 * @method     ChildDomainQuery innerJoinImageSlider($relationAlias = null) Adds a INNER JOIN clause to the query using the ImageSlider relation
 *
 * @method     ChildDomainQuery joinWithImageSlider($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ImageSlider relation
 *
 * @method     ChildDomainQuery leftJoinWithImageSlider() Adds a LEFT JOIN clause and with to the query using the ImageSlider relation
 * @method     ChildDomainQuery rightJoinWithImageSlider() Adds a RIGHT JOIN clause and with to the query using the ImageSlider relation
 * @method     ChildDomainQuery innerJoinWithImageSlider() Adds a INNER JOIN clause and with to the query using the ImageSlider relation
 *
 * @method     ChildDomainQuery leftJoinShop($relationAlias = null) Adds a LEFT JOIN clause to the query using the Shop relation
 * @method     ChildDomainQuery rightJoinShop($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Shop relation
 * @method     ChildDomainQuery innerJoinShop($relationAlias = null) Adds a INNER JOIN clause to the query using the Shop relation
 *
 * @method     ChildDomainQuery joinWithShop($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Shop relation
 *
 * @method     ChildDomainQuery leftJoinWithShop() Adds a LEFT JOIN clause and with to the query using the Shop relation
 * @method     ChildDomainQuery rightJoinWithShop() Adds a RIGHT JOIN clause and with to the query using the Shop relation
 * @method     ChildDomainQuery innerJoinWithShop() Adds a INNER JOIN clause and with to the query using the Shop relation
 *
 * @method     ChildDomainQuery leftJoinCatalog($relationAlias = null) Adds a LEFT JOIN clause to the query using the Catalog relation
 * @method     ChildDomainQuery rightJoinCatalog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Catalog relation
 * @method     ChildDomainQuery innerJoinCatalog($relationAlias = null) Adds a INNER JOIN clause to the query using the Catalog relation
 *
 * @method     ChildDomainQuery joinWithCatalog($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Catalog relation
 *
 * @method     ChildDomainQuery leftJoinWithCatalog() Adds a LEFT JOIN clause and with to the query using the Catalog relation
 * @method     ChildDomainQuery rightJoinWithCatalog() Adds a RIGHT JOIN clause and with to the query using the Catalog relation
 * @method     ChildDomainQuery innerJoinWithCatalog() Adds a INNER JOIN clause and with to the query using the Catalog relation
 *
 * @method     \Diamond\Models\Menu\MenuQuery|\Diamond\Models\Page\PageQuery|\Diamond\Models\Promoblock\PromoblockQuery|\Diamond\Models\Template\TemplateQuery|\Diamond\Models\ImageSlider\ImageSliderQuery|\Shop\Models\Shop\ShopQuery|\Shop\Models\Catalog\CatalogQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildDomain findOne(ConnectionInterface $con = null) Return the first ChildDomain matching the query
 * @method     ChildDomain findOneOrCreate(ConnectionInterface $con = null) Return the first ChildDomain matching the query, or a new ChildDomain object populated from the query conditions when no match is found
 *
 * @method     ChildDomain findOneById(int $id) Return the first ChildDomain filtered by the id column
 * @method     ChildDomain findOneByName(string $name) Return the first ChildDomain filtered by the name column
 * @method     ChildDomain findOneByLang(string $lang) Return the first ChildDomain filtered by the lang column
 * @method     ChildDomain findOneByDomain(string $domain) Return the first ChildDomain filtered by the domain column *

 * @method     ChildDomain requirePk($key, ConnectionInterface $con = null) Return the ChildDomain by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDomain requireOne(ConnectionInterface $con = null) Return the first ChildDomain matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildDomain requireOneById(int $id) Return the first ChildDomain filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDomain requireOneByName(string $name) Return the first ChildDomain filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDomain requireOneByLang(string $lang) Return the first ChildDomain filtered by the lang column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildDomain requireOneByDomain(string $domain) Return the first ChildDomain filtered by the domain column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildDomain[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildDomain objects based on current ModelCriteria
 * @method     ChildDomain[]|ObjectCollection findById(int $id) Return ChildDomain objects filtered by the id column
 * @method     ChildDomain[]|ObjectCollection findByName(string $name) Return ChildDomain objects filtered by the name column
 * @method     ChildDomain[]|ObjectCollection findByLang(string $lang) Return ChildDomain objects filtered by the lang column
 * @method     ChildDomain[]|ObjectCollection findByDomain(string $domain) Return ChildDomain objects filtered by the domain column
 * @method     ChildDomain[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class DomainQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Models\Domain\Base\DomainQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Models\\Domain\\Domain', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildDomainQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildDomainQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildDomainQuery) {
            return $criteria;
        }
        $query = new ChildDomainQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildDomain|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(DomainTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = DomainTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildDomain A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `lang`, `domain` FROM `_domains` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildDomain $obj */
            $obj = new ChildDomain();
            $obj->hydrate($row);
            DomainTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildDomain|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(DomainTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(DomainTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(DomainTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(DomainTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DomainTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DomainTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the lang column
     *
     * Example usage:
     * <code>
     * $query->filterByLang('fooValue');   // WHERE lang = 'fooValue'
     * $query->filterByLang('%fooValue%', Criteria::LIKE); // WHERE lang LIKE '%fooValue%'
     * </code>
     *
     * @param     string $lang The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function filterByLang($lang = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($lang)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DomainTableMap::COL_LANG, $lang, $comparison);
    }

    /**
     * Filter the query on the domain column
     *
     * Example usage:
     * <code>
     * $query->filterByDomain('fooValue');   // WHERE domain = 'fooValue'
     * $query->filterByDomain('%fooValue%', Criteria::LIKE); // WHERE domain LIKE '%fooValue%'
     * </code>
     *
     * @param     string $domain The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function filterByDomain($domain = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($domain)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(DomainTableMap::COL_DOMAIN, $domain, $comparison);
    }

    /**
     * Filter the query by a related \Diamond\Models\Menu\Menu object
     *
     * @param \Diamond\Models\Menu\Menu|ObjectCollection $menu the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildDomainQuery The current query, for fluid interface
     */
    public function filterByMenu($menu, $comparison = null)
    {
        if ($menu instanceof \Diamond\Models\Menu\Menu) {
            return $this
                ->addUsingAlias(DomainTableMap::COL_ID, $menu->getDomainId(), $comparison);
        } elseif ($menu instanceof ObjectCollection) {
            return $this
                ->useMenuQuery()
                ->filterByPrimaryKeys($menu->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMenu() only accepts arguments of type \Diamond\Models\Menu\Menu or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Menu relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function joinMenu($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Menu');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Menu');
        }

        return $this;
    }

    /**
     * Use the Menu relation Menu object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\Menu\MenuQuery A secondary query class using the current class as primary query
     */
    public function useMenuQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinMenu($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Menu', '\Diamond\Models\Menu\MenuQuery');
    }

    /**
     * Filter the query by a related \Diamond\Models\Page\Page object
     *
     * @param \Diamond\Models\Page\Page|ObjectCollection $page the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildDomainQuery The current query, for fluid interface
     */
    public function filterByPage($page, $comparison = null)
    {
        if ($page instanceof \Diamond\Models\Page\Page) {
            return $this
                ->addUsingAlias(DomainTableMap::COL_ID, $page->getDomainId(), $comparison);
        } elseif ($page instanceof ObjectCollection) {
            return $this
                ->usePageQuery()
                ->filterByPrimaryKeys($page->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPage() only accepts arguments of type \Diamond\Models\Page\Page or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Page relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function joinPage($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Page');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Page');
        }

        return $this;
    }

    /**
     * Use the Page relation Page object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\Page\PageQuery A secondary query class using the current class as primary query
     */
    public function usePageQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPage($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Page', '\Diamond\Models\Page\PageQuery');
    }

    /**
     * Filter the query by a related \Diamond\Models\Promoblock\Promoblock object
     *
     * @param \Diamond\Models\Promoblock\Promoblock|ObjectCollection $promoblock the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildDomainQuery The current query, for fluid interface
     */
    public function filterByPromoblock($promoblock, $comparison = null)
    {
        if ($promoblock instanceof \Diamond\Models\Promoblock\Promoblock) {
            return $this
                ->addUsingAlias(DomainTableMap::COL_ID, $promoblock->getDomainId(), $comparison);
        } elseif ($promoblock instanceof ObjectCollection) {
            return $this
                ->usePromoblockQuery()
                ->filterByPrimaryKeys($promoblock->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPromoblock() only accepts arguments of type \Diamond\Models\Promoblock\Promoblock or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Promoblock relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function joinPromoblock($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Promoblock');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Promoblock');
        }

        return $this;
    }

    /**
     * Use the Promoblock relation Promoblock object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\Promoblock\PromoblockQuery A secondary query class using the current class as primary query
     */
    public function usePromoblockQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPromoblock($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Promoblock', '\Diamond\Models\Promoblock\PromoblockQuery');
    }

    /**
     * Filter the query by a related \Diamond\Models\Template\Template object
     *
     * @param \Diamond\Models\Template\Template|ObjectCollection $template the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildDomainQuery The current query, for fluid interface
     */
    public function filterByTemplate($template, $comparison = null)
    {
        if ($template instanceof \Diamond\Models\Template\Template) {
            return $this
                ->addUsingAlias(DomainTableMap::COL_ID, $template->getDomainId(), $comparison);
        } elseif ($template instanceof ObjectCollection) {
            return $this
                ->useTemplateQuery()
                ->filterByPrimaryKeys($template->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByTemplate() only accepts arguments of type \Diamond\Models\Template\Template or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Template relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function joinTemplate($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Template');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Template');
        }

        return $this;
    }

    /**
     * Use the Template relation Template object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\Template\TemplateQuery A secondary query class using the current class as primary query
     */
    public function useTemplateQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinTemplate($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Template', '\Diamond\Models\Template\TemplateQuery');
    }

    /**
     * Filter the query by a related \Diamond\Models\ImageSlider\ImageSlider object
     *
     * @param \Diamond\Models\ImageSlider\ImageSlider|ObjectCollection $imageSlider the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildDomainQuery The current query, for fluid interface
     */
    public function filterByImageSlider($imageSlider, $comparison = null)
    {
        if ($imageSlider instanceof \Diamond\Models\ImageSlider\ImageSlider) {
            return $this
                ->addUsingAlias(DomainTableMap::COL_ID, $imageSlider->getDomainId(), $comparison);
        } elseif ($imageSlider instanceof ObjectCollection) {
            return $this
                ->useImageSliderQuery()
                ->filterByPrimaryKeys($imageSlider->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByImageSlider() only accepts arguments of type \Diamond\Models\ImageSlider\ImageSlider or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ImageSlider relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function joinImageSlider($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ImageSlider');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ImageSlider');
        }

        return $this;
    }

    /**
     * Use the ImageSlider relation ImageSlider object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\ImageSlider\ImageSliderQuery A secondary query class using the current class as primary query
     */
    public function useImageSliderQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinImageSlider($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ImageSlider', '\Diamond\Models\ImageSlider\ImageSliderQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Shop\Shop object
     *
     * @param \Shop\Models\Shop\Shop|ObjectCollection $shop the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildDomainQuery The current query, for fluid interface
     */
    public function filterByShop($shop, $comparison = null)
    {
        if ($shop instanceof \Shop\Models\Shop\Shop) {
            return $this
                ->addUsingAlias(DomainTableMap::COL_ID, $shop->getDomainId(), $comparison);
        } elseif ($shop instanceof ObjectCollection) {
            return $this
                ->useShopQuery()
                ->filterByPrimaryKeys($shop->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByShop() only accepts arguments of type \Shop\Models\Shop\Shop or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Shop relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function joinShop($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Shop');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Shop');
        }

        return $this;
    }

    /**
     * Use the Shop relation Shop object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Shop\ShopQuery A secondary query class using the current class as primary query
     */
    public function useShopQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinShop($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Shop', '\Shop\Models\Shop\ShopQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Catalog\Catalog object
     *
     * @param \Shop\Models\Catalog\Catalog|ObjectCollection $catalog the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildDomainQuery The current query, for fluid interface
     */
    public function filterByCatalog($catalog, $comparison = null)
    {
        if ($catalog instanceof \Shop\Models\Catalog\Catalog) {
            return $this
                ->addUsingAlias(DomainTableMap::COL_ID, $catalog->getDomainId(), $comparison);
        } elseif ($catalog instanceof ObjectCollection) {
            return $this
                ->useCatalogQuery()
                ->filterByPrimaryKeys($catalog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByCatalog() only accepts arguments of type \Shop\Models\Catalog\Catalog or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Catalog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function joinCatalog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Catalog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Catalog');
        }

        return $this;
    }

    /**
     * Use the Catalog relation Catalog object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Catalog\CatalogQuery A secondary query class using the current class as primary query
     */
    public function useCatalogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCatalog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Catalog', '\Shop\Models\Catalog\CatalogQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildDomain $domain Object to remove from the list of results
     *
     * @return $this|ChildDomainQuery The current query, for fluid interface
     */
    public function prune($domain = null)
    {
        if ($domain) {
            $this->addUsingAlias(DomainTableMap::COL_ID, $domain->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _domains table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DomainTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            DomainTableMap::clearInstancePool();
            DomainTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(DomainTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(DomainTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            DomainTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            DomainTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // DomainQuery
