<?php

namespace Diamond\Models\Content\Base;

use \Exception;
use \PDO;
use Diamond\Models\Content\Content as ChildContent;
use Diamond\Models\Content\ContentArchive as ChildContentArchive;
use Diamond\Models\Content\ContentQuery as ChildContentQuery;
use Diamond\Models\ContentCategory\ContentCategory;
use Diamond\Models\ContentTagRel\ContentTagRel;
use Diamond\Models\Content\Map\ContentTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_content' table.
 *
 *
 *
 * @method     ChildContentQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildContentQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildContentQuery orderByBody($order = Criteria::ASC) Order by the body column
 * @method     ChildContentQuery orderByPreview($order = Criteria::ASC) Order by the preview column
 * @method     ChildContentQuery orderByDatecreate($order = Criteria::ASC) Order by the datecreate column
 * @method     ChildContentQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildContentQuery orderByAuthor($order = Criteria::ASC) Order by the author column
 * @method     ChildContentQuery orderByAuthorId($order = Criteria::ASC) Order by the author_id column
 * @method     ChildContentQuery orderByCategoryId($order = Criteria::ASC) Order by the category_id column
 *
 * @method     ChildContentQuery groupById() Group by the id column
 * @method     ChildContentQuery groupByTitle() Group by the title column
 * @method     ChildContentQuery groupByBody() Group by the body column
 * @method     ChildContentQuery groupByPreview() Group by the preview column
 * @method     ChildContentQuery groupByDatecreate() Group by the datecreate column
 * @method     ChildContentQuery groupByActive() Group by the active column
 * @method     ChildContentQuery groupByAuthor() Group by the author column
 * @method     ChildContentQuery groupByAuthorId() Group by the author_id column
 * @method     ChildContentQuery groupByCategoryId() Group by the category_id column
 *
 * @method     ChildContentQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildContentQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildContentQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildContentQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildContentQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildContentQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildContentQuery leftJoinContentCategory($relationAlias = null) Adds a LEFT JOIN clause to the query using the ContentCategory relation
 * @method     ChildContentQuery rightJoinContentCategory($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ContentCategory relation
 * @method     ChildContentQuery innerJoinContentCategory($relationAlias = null) Adds a INNER JOIN clause to the query using the ContentCategory relation
 *
 * @method     ChildContentQuery joinWithContentCategory($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ContentCategory relation
 *
 * @method     ChildContentQuery leftJoinWithContentCategory() Adds a LEFT JOIN clause and with to the query using the ContentCategory relation
 * @method     ChildContentQuery rightJoinWithContentCategory() Adds a RIGHT JOIN clause and with to the query using the ContentCategory relation
 * @method     ChildContentQuery innerJoinWithContentCategory() Adds a INNER JOIN clause and with to the query using the ContentCategory relation
 *
 * @method     ChildContentQuery leftJoinContentTagRel($relationAlias = null) Adds a LEFT JOIN clause to the query using the ContentTagRel relation
 * @method     ChildContentQuery rightJoinContentTagRel($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ContentTagRel relation
 * @method     ChildContentQuery innerJoinContentTagRel($relationAlias = null) Adds a INNER JOIN clause to the query using the ContentTagRel relation
 *
 * @method     ChildContentQuery joinWithContentTagRel($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ContentTagRel relation
 *
 * @method     ChildContentQuery leftJoinWithContentTagRel() Adds a LEFT JOIN clause and with to the query using the ContentTagRel relation
 * @method     ChildContentQuery rightJoinWithContentTagRel() Adds a RIGHT JOIN clause and with to the query using the ContentTagRel relation
 * @method     ChildContentQuery innerJoinWithContentTagRel() Adds a INNER JOIN clause and with to the query using the ContentTagRel relation
 *
 * @method     \Diamond\Models\ContentCategory\ContentCategoryQuery|\Diamond\Models\ContentTagRel\ContentTagRelQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildContent findOne(ConnectionInterface $con = null) Return the first ChildContent matching the query
 * @method     ChildContent findOneOrCreate(ConnectionInterface $con = null) Return the first ChildContent matching the query, or a new ChildContent object populated from the query conditions when no match is found
 *
 * @method     ChildContent findOneById(int $id) Return the first ChildContent filtered by the id column
 * @method     ChildContent findOneByTitle(string $title) Return the first ChildContent filtered by the title column
 * @method     ChildContent findOneByBody(string $body) Return the first ChildContent filtered by the body column
 * @method     ChildContent findOneByPreview(string $preview) Return the first ChildContent filtered by the preview column
 * @method     ChildContent findOneByDatecreate(string $datecreate) Return the first ChildContent filtered by the datecreate column
 * @method     ChildContent findOneByActive(string $active) Return the first ChildContent filtered by the active column
 * @method     ChildContent findOneByAuthor(string $author) Return the first ChildContent filtered by the author column
 * @method     ChildContent findOneByAuthorId(int $author_id) Return the first ChildContent filtered by the author_id column
 * @method     ChildContent findOneByCategoryId(int $category_id) Return the first ChildContent filtered by the category_id column *

 * @method     ChildContent requirePk($key, ConnectionInterface $con = null) Return the ChildContent by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContent requireOne(ConnectionInterface $con = null) Return the first ChildContent matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildContent requireOneById(int $id) Return the first ChildContent filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContent requireOneByTitle(string $title) Return the first ChildContent filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContent requireOneByBody(string $body) Return the first ChildContent filtered by the body column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContent requireOneByPreview(string $preview) Return the first ChildContent filtered by the preview column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContent requireOneByDatecreate(string $datecreate) Return the first ChildContent filtered by the datecreate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContent requireOneByActive(string $active) Return the first ChildContent filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContent requireOneByAuthor(string $author) Return the first ChildContent filtered by the author column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContent requireOneByAuthorId(int $author_id) Return the first ChildContent filtered by the author_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContent requireOneByCategoryId(int $category_id) Return the first ChildContent filtered by the category_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildContent[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildContent objects based on current ModelCriteria
 * @method     ChildContent[]|ObjectCollection findById(int $id) Return ChildContent objects filtered by the id column
 * @method     ChildContent[]|ObjectCollection findByTitle(string $title) Return ChildContent objects filtered by the title column
 * @method     ChildContent[]|ObjectCollection findByBody(string $body) Return ChildContent objects filtered by the body column
 * @method     ChildContent[]|ObjectCollection findByPreview(string $preview) Return ChildContent objects filtered by the preview column
 * @method     ChildContent[]|ObjectCollection findByDatecreate(string $datecreate) Return ChildContent objects filtered by the datecreate column
 * @method     ChildContent[]|ObjectCollection findByActive(string $active) Return ChildContent objects filtered by the active column
 * @method     ChildContent[]|ObjectCollection findByAuthor(string $author) Return ChildContent objects filtered by the author column
 * @method     ChildContent[]|ObjectCollection findByAuthorId(int $author_id) Return ChildContent objects filtered by the author_id column
 * @method     ChildContent[]|ObjectCollection findByCategoryId(int $category_id) Return ChildContent objects filtered by the category_id column
 * @method     ChildContent[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ContentQuery extends ModelCriteria
{

    // archivable behavior
    protected $archiveOnDelete = true;
protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Models\Content\Base\ContentQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Models\\Content\\Content', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildContentQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildContentQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildContentQuery) {
            return $criteria;
        }
        $query = new ChildContentQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildContent|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ContentTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ContentTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildContent A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `body`, `preview`, `datecreate`, `active`, `author`, `author_id`, `category_id` FROM `_content` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildContent $obj */
            $obj = new ChildContent();
            $obj->hydrate($row);
            ContentTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildContent|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ContentTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ContentTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ContentTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ContentTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the body column
     *
     * Example usage:
     * <code>
     * $query->filterByBody('fooValue');   // WHERE body = 'fooValue'
     * $query->filterByBody('%fooValue%', Criteria::LIKE); // WHERE body LIKE '%fooValue%'
     * </code>
     *
     * @param     string $body The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByBody($body = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($body)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentTableMap::COL_BODY, $body, $comparison);
    }

    /**
     * Filter the query on the preview column
     *
     * Example usage:
     * <code>
     * $query->filterByPreview('fooValue');   // WHERE preview = 'fooValue'
     * $query->filterByPreview('%fooValue%', Criteria::LIKE); // WHERE preview LIKE '%fooValue%'
     * </code>
     *
     * @param     string $preview The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByPreview($preview = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($preview)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentTableMap::COL_PREVIEW, $preview, $comparison);
    }

    /**
     * Filter the query on the datecreate column
     *
     * Example usage:
     * <code>
     * $query->filterByDatecreate('2011-03-14'); // WHERE datecreate = '2011-03-14'
     * $query->filterByDatecreate('now'); // WHERE datecreate = '2011-03-14'
     * $query->filterByDatecreate(array('max' => 'yesterday')); // WHERE datecreate > '2011-03-13'
     * </code>
     *
     * @param     mixed $datecreate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByDatecreate($datecreate = null, $comparison = null)
    {
        if (is_array($datecreate)) {
            $useMinMax = false;
            if (isset($datecreate['min'])) {
                $this->addUsingAlias(ContentTableMap::COL_DATECREATE, $datecreate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datecreate['max'])) {
                $this->addUsingAlias(ContentTableMap::COL_DATECREATE, $datecreate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentTableMap::COL_DATECREATE, $datecreate, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive('fooValue');   // WHERE active = 'fooValue'
     * $query->filterByActive('%fooValue%', Criteria::LIKE); // WHERE active LIKE '%fooValue%'
     * </code>
     *
     * @param     string $active The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($active)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the author column
     *
     * Example usage:
     * <code>
     * $query->filterByAuthor('fooValue');   // WHERE author = 'fooValue'
     * $query->filterByAuthor('%fooValue%', Criteria::LIKE); // WHERE author LIKE '%fooValue%'
     * </code>
     *
     * @param     string $author The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByAuthor($author = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($author)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentTableMap::COL_AUTHOR, $author, $comparison);
    }

    /**
     * Filter the query on the author_id column
     *
     * Example usage:
     * <code>
     * $query->filterByAuthorId(1234); // WHERE author_id = 1234
     * $query->filterByAuthorId(array(12, 34)); // WHERE author_id IN (12, 34)
     * $query->filterByAuthorId(array('min' => 12)); // WHERE author_id > 12
     * </code>
     *
     * @param     mixed $authorId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByAuthorId($authorId = null, $comparison = null)
    {
        if (is_array($authorId)) {
            $useMinMax = false;
            if (isset($authorId['min'])) {
                $this->addUsingAlias(ContentTableMap::COL_AUTHOR_ID, $authorId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($authorId['max'])) {
                $this->addUsingAlias(ContentTableMap::COL_AUTHOR_ID, $authorId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentTableMap::COL_AUTHOR_ID, $authorId, $comparison);
    }

    /**
     * Filter the query on the category_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryId(1234); // WHERE category_id = 1234
     * $query->filterByCategoryId(array(12, 34)); // WHERE category_id IN (12, 34)
     * $query->filterByCategoryId(array('min' => 12)); // WHERE category_id > 12
     * </code>
     *
     * @see       filterByContentCategory()
     *
     * @param     mixed $categoryId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function filterByCategoryId($categoryId = null, $comparison = null)
    {
        if (is_array($categoryId)) {
            $useMinMax = false;
            if (isset($categoryId['min'])) {
                $this->addUsingAlias(ContentTableMap::COL_CATEGORY_ID, $categoryId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($categoryId['max'])) {
                $this->addUsingAlias(ContentTableMap::COL_CATEGORY_ID, $categoryId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentTableMap::COL_CATEGORY_ID, $categoryId, $comparison);
    }

    /**
     * Filter the query by a related \Diamond\Models\ContentCategory\ContentCategory object
     *
     * @param \Diamond\Models\ContentCategory\ContentCategory|ObjectCollection $contentCategory The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildContentQuery The current query, for fluid interface
     */
    public function filterByContentCategory($contentCategory, $comparison = null)
    {
        if ($contentCategory instanceof \Diamond\Models\ContentCategory\ContentCategory) {
            return $this
                ->addUsingAlias(ContentTableMap::COL_CATEGORY_ID, $contentCategory->getId(), $comparison);
        } elseif ($contentCategory instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ContentTableMap::COL_CATEGORY_ID, $contentCategory->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByContentCategory() only accepts arguments of type \Diamond\Models\ContentCategory\ContentCategory or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ContentCategory relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function joinContentCategory($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ContentCategory');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ContentCategory');
        }

        return $this;
    }

    /**
     * Use the ContentCategory relation ContentCategory object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\ContentCategory\ContentCategoryQuery A secondary query class using the current class as primary query
     */
    public function useContentCategoryQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContentCategory($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ContentCategory', '\Diamond\Models\ContentCategory\ContentCategoryQuery');
    }

    /**
     * Filter the query by a related \Diamond\Models\ContentTagRel\ContentTagRel object
     *
     * @param \Diamond\Models\ContentTagRel\ContentTagRel|ObjectCollection $contentTagRel the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildContentQuery The current query, for fluid interface
     */
    public function filterByContentTagRel($contentTagRel, $comparison = null)
    {
        if ($contentTagRel instanceof \Diamond\Models\ContentTagRel\ContentTagRel) {
            return $this
                ->addUsingAlias(ContentTableMap::COL_ID, $contentTagRel->getContentId(), $comparison);
        } elseif ($contentTagRel instanceof ObjectCollection) {
            return $this
                ->useContentTagRelQuery()
                ->filterByPrimaryKeys($contentTagRel->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByContentTagRel() only accepts arguments of type \Diamond\Models\ContentTagRel\ContentTagRel or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ContentTagRel relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function joinContentTagRel($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ContentTagRel');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ContentTagRel');
        }

        return $this;
    }

    /**
     * Use the ContentTagRel relation ContentTagRel object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Models\ContentTagRel\ContentTagRelQuery A secondary query class using the current class as primary query
     */
    public function useContentTagRelQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContentTagRel($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ContentTagRel', '\Diamond\Models\ContentTagRel\ContentTagRelQuery');
    }

    /**
     * Filter the query by a related ContentTag object
     * using the _content_tag_rel table as cross reference
     *
     * @param ContentTag $contentTag the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildContentQuery The current query, for fluid interface
     */
    public function filterByContentTag($contentTag, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useContentTagRelQuery()
            ->filterByContentTag($contentTag, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   ChildContent $content Object to remove from the list of results
     *
     * @return $this|ChildContentQuery The current query, for fluid interface
     */
    public function prune($content = null)
    {
        if ($content) {
            $this->addUsingAlias(ContentTableMap::COL_ID, $content->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePreDelete(ConnectionInterface $con)
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the _content table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ContentTableMap::clearInstancePool();
            ContentTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ContentTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ContentTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ContentTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildContentArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param      ConnectionInterface $con    Connection to use.
     * @param      Boolean $useLittleMemory    Whether or not to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return     int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param boolean True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete($archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

} // ContentQuery
