<?php

namespace Diamond\Models\Content\Base;

use \Exception;
use \PDO;
use Diamond\Models\Content\ContentArchive as ChildContentArchive;
use Diamond\Models\Content\ContentArchiveQuery as ChildContentArchiveQuery;
use Diamond\Models\Content\Map\ContentArchiveTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_content_archive' table.
 *
 *
 *
 * @method     ChildContentArchiveQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildContentArchiveQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildContentArchiveQuery orderByBody($order = Criteria::ASC) Order by the body column
 * @method     ChildContentArchiveQuery orderByPreview($order = Criteria::ASC) Order by the preview column
 * @method     ChildContentArchiveQuery orderByDatecreate($order = Criteria::ASC) Order by the datecreate column
 * @method     ChildContentArchiveQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildContentArchiveQuery orderByAuthor($order = Criteria::ASC) Order by the author column
 * @method     ChildContentArchiveQuery orderByAuthorId($order = Criteria::ASC) Order by the author_id column
 * @method     ChildContentArchiveQuery orderByCategoryId($order = Criteria::ASC) Order by the category_id column
 * @method     ChildContentArchiveQuery orderByArchivedAt($order = Criteria::ASC) Order by the archived_at column
 *
 * @method     ChildContentArchiveQuery groupById() Group by the id column
 * @method     ChildContentArchiveQuery groupByTitle() Group by the title column
 * @method     ChildContentArchiveQuery groupByBody() Group by the body column
 * @method     ChildContentArchiveQuery groupByPreview() Group by the preview column
 * @method     ChildContentArchiveQuery groupByDatecreate() Group by the datecreate column
 * @method     ChildContentArchiveQuery groupByActive() Group by the active column
 * @method     ChildContentArchiveQuery groupByAuthor() Group by the author column
 * @method     ChildContentArchiveQuery groupByAuthorId() Group by the author_id column
 * @method     ChildContentArchiveQuery groupByCategoryId() Group by the category_id column
 * @method     ChildContentArchiveQuery groupByArchivedAt() Group by the archived_at column
 *
 * @method     ChildContentArchiveQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildContentArchiveQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildContentArchiveQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildContentArchiveQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildContentArchiveQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildContentArchiveQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildContentArchive findOne(ConnectionInterface $con = null) Return the first ChildContentArchive matching the query
 * @method     ChildContentArchive findOneOrCreate(ConnectionInterface $con = null) Return the first ChildContentArchive matching the query, or a new ChildContentArchive object populated from the query conditions when no match is found
 *
 * @method     ChildContentArchive findOneById(int $id) Return the first ChildContentArchive filtered by the id column
 * @method     ChildContentArchive findOneByTitle(string $title) Return the first ChildContentArchive filtered by the title column
 * @method     ChildContentArchive findOneByBody(string $body) Return the first ChildContentArchive filtered by the body column
 * @method     ChildContentArchive findOneByPreview(string $preview) Return the first ChildContentArchive filtered by the preview column
 * @method     ChildContentArchive findOneByDatecreate(string $datecreate) Return the first ChildContentArchive filtered by the datecreate column
 * @method     ChildContentArchive findOneByActive(string $active) Return the first ChildContentArchive filtered by the active column
 * @method     ChildContentArchive findOneByAuthor(string $author) Return the first ChildContentArchive filtered by the author column
 * @method     ChildContentArchive findOneByAuthorId(int $author_id) Return the first ChildContentArchive filtered by the author_id column
 * @method     ChildContentArchive findOneByCategoryId(int $category_id) Return the first ChildContentArchive filtered by the category_id column
 * @method     ChildContentArchive findOneByArchivedAt(string $archived_at) Return the first ChildContentArchive filtered by the archived_at column *

 * @method     ChildContentArchive requirePk($key, ConnectionInterface $con = null) Return the ChildContentArchive by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOne(ConnectionInterface $con = null) Return the first ChildContentArchive matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildContentArchive requireOneById(int $id) Return the first ChildContentArchive filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOneByTitle(string $title) Return the first ChildContentArchive filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOneByBody(string $body) Return the first ChildContentArchive filtered by the body column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOneByPreview(string $preview) Return the first ChildContentArchive filtered by the preview column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOneByDatecreate(string $datecreate) Return the first ChildContentArchive filtered by the datecreate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOneByActive(string $active) Return the first ChildContentArchive filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOneByAuthor(string $author) Return the first ChildContentArchive filtered by the author column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOneByAuthorId(int $author_id) Return the first ChildContentArchive filtered by the author_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOneByCategoryId(int $category_id) Return the first ChildContentArchive filtered by the category_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildContentArchive requireOneByArchivedAt(string $archived_at) Return the first ChildContentArchive filtered by the archived_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildContentArchive[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildContentArchive objects based on current ModelCriteria
 * @method     ChildContentArchive[]|ObjectCollection findById(int $id) Return ChildContentArchive objects filtered by the id column
 * @method     ChildContentArchive[]|ObjectCollection findByTitle(string $title) Return ChildContentArchive objects filtered by the title column
 * @method     ChildContentArchive[]|ObjectCollection findByBody(string $body) Return ChildContentArchive objects filtered by the body column
 * @method     ChildContentArchive[]|ObjectCollection findByPreview(string $preview) Return ChildContentArchive objects filtered by the preview column
 * @method     ChildContentArchive[]|ObjectCollection findByDatecreate(string $datecreate) Return ChildContentArchive objects filtered by the datecreate column
 * @method     ChildContentArchive[]|ObjectCollection findByActive(string $active) Return ChildContentArchive objects filtered by the active column
 * @method     ChildContentArchive[]|ObjectCollection findByAuthor(string $author) Return ChildContentArchive objects filtered by the author column
 * @method     ChildContentArchive[]|ObjectCollection findByAuthorId(int $author_id) Return ChildContentArchive objects filtered by the author_id column
 * @method     ChildContentArchive[]|ObjectCollection findByCategoryId(int $category_id) Return ChildContentArchive objects filtered by the category_id column
 * @method     ChildContentArchive[]|ObjectCollection findByArchivedAt(string $archived_at) Return ChildContentArchive objects filtered by the archived_at column
 * @method     ChildContentArchive[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ContentArchiveQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Models\Content\Base\ContentArchiveQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Models\\Content\\ContentArchive', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildContentArchiveQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildContentArchiveQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildContentArchiveQuery) {
            return $criteria;
        }
        $query = new ChildContentArchiveQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildContentArchive|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ContentArchiveTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ContentArchiveTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildContentArchive A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `body`, `preview`, `datecreate`, `active`, `author`, `author_id`, `category_id`, `archived_at` FROM `_content_archive` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildContentArchive $obj */
            $obj = new ChildContentArchive();
            $obj->hydrate($row);
            ContentArchiveTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildContentArchive|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ContentArchiveTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ContentArchiveTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the body column
     *
     * Example usage:
     * <code>
     * $query->filterByBody('fooValue');   // WHERE body = 'fooValue'
     * $query->filterByBody('%fooValue%', Criteria::LIKE); // WHERE body LIKE '%fooValue%'
     * </code>
     *
     * @param     string $body The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByBody($body = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($body)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_BODY, $body, $comparison);
    }

    /**
     * Filter the query on the preview column
     *
     * Example usage:
     * <code>
     * $query->filterByPreview('fooValue');   // WHERE preview = 'fooValue'
     * $query->filterByPreview('%fooValue%', Criteria::LIKE); // WHERE preview LIKE '%fooValue%'
     * </code>
     *
     * @param     string $preview The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByPreview($preview = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($preview)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_PREVIEW, $preview, $comparison);
    }

    /**
     * Filter the query on the datecreate column
     *
     * Example usage:
     * <code>
     * $query->filterByDatecreate('2011-03-14'); // WHERE datecreate = '2011-03-14'
     * $query->filterByDatecreate('now'); // WHERE datecreate = '2011-03-14'
     * $query->filterByDatecreate(array('max' => 'yesterday')); // WHERE datecreate > '2011-03-13'
     * </code>
     *
     * @param     mixed $datecreate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByDatecreate($datecreate = null, $comparison = null)
    {
        if (is_array($datecreate)) {
            $useMinMax = false;
            if (isset($datecreate['min'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_DATECREATE, $datecreate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datecreate['max'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_DATECREATE, $datecreate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_DATECREATE, $datecreate, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive('fooValue');   // WHERE active = 'fooValue'
     * $query->filterByActive('%fooValue%', Criteria::LIKE); // WHERE active LIKE '%fooValue%'
     * </code>
     *
     * @param     string $active The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($active)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the author column
     *
     * Example usage:
     * <code>
     * $query->filterByAuthor('fooValue');   // WHERE author = 'fooValue'
     * $query->filterByAuthor('%fooValue%', Criteria::LIKE); // WHERE author LIKE '%fooValue%'
     * </code>
     *
     * @param     string $author The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByAuthor($author = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($author)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_AUTHOR, $author, $comparison);
    }

    /**
     * Filter the query on the author_id column
     *
     * Example usage:
     * <code>
     * $query->filterByAuthorId(1234); // WHERE author_id = 1234
     * $query->filterByAuthorId(array(12, 34)); // WHERE author_id IN (12, 34)
     * $query->filterByAuthorId(array('min' => 12)); // WHERE author_id > 12
     * </code>
     *
     * @param     mixed $authorId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByAuthorId($authorId = null, $comparison = null)
    {
        if (is_array($authorId)) {
            $useMinMax = false;
            if (isset($authorId['min'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_AUTHOR_ID, $authorId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($authorId['max'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_AUTHOR_ID, $authorId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_AUTHOR_ID, $authorId, $comparison);
    }

    /**
     * Filter the query on the category_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryId(1234); // WHERE category_id = 1234
     * $query->filterByCategoryId(array(12, 34)); // WHERE category_id IN (12, 34)
     * $query->filterByCategoryId(array('min' => 12)); // WHERE category_id > 12
     * </code>
     *
     * @param     mixed $categoryId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByCategoryId($categoryId = null, $comparison = null)
    {
        if (is_array($categoryId)) {
            $useMinMax = false;
            if (isset($categoryId['min'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_CATEGORY_ID, $categoryId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($categoryId['max'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_CATEGORY_ID, $categoryId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_CATEGORY_ID, $categoryId, $comparison);
    }

    /**
     * Filter the query on the archived_at column
     *
     * Example usage:
     * <code>
     * $query->filterByArchivedAt('2011-03-14'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt('now'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt(array('max' => 'yesterday')); // WHERE archived_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $archivedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function filterByArchivedAt($archivedAt = null, $comparison = null)
    {
        if (is_array($archivedAt)) {
            $useMinMax = false;
            if (isset($archivedAt['min'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($archivedAt['max'])) {
                $this->addUsingAlias(ContentArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ContentArchiveTableMap::COL_ARCHIVED_AT, $archivedAt, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   ChildContentArchive $contentArchive Object to remove from the list of results
     *
     * @return $this|ChildContentArchiveQuery The current query, for fluid interface
     */
    public function prune($contentArchive = null)
    {
        if ($contentArchive) {
            $this->addUsingAlias(ContentArchiveTableMap::COL_ID, $contentArchive->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _content_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentArchiveTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ContentArchiveTableMap::clearInstancePool();
            ContentArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentArchiveTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ContentArchiveTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ContentArchiveTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ContentArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // ContentArchiveQuery
