<?php

namespace Shop\Models\ComplexRate\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Models\ComplexRate\ComplexRate;
use Shop\Models\ComplexRate\ComplexRateQuery;


/**
 * This class defines the structure of the 'shop_complex_rates' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ComplexRateTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.ComplexRate.Map.ComplexRateTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'shop_complex_rates';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Shop\\Models\\ComplexRate\\ComplexRate';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.ComplexRate.ComplexRate';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 10;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 10;

    /**
     * the column name for the id field
     */
    const COL_ID = 'shop_complex_rates.id';

    /**
     * the column name for the brand_id field
     */
    const COL_BRAND_ID = 'shop_complex_rates.brand_id';

    /**
     * the column name for the customer_group_id field
     */
    const COL_CUSTOMER_GROUP_ID = 'shop_complex_rates.customer_group_id';

    /**
     * the column name for the customer_id field
     */
    const COL_CUSTOMER_ID = 'shop_complex_rates.customer_id';

    /**
     * the column name for the shop_id field
     */
    const COL_SHOP_ID = 'shop_complex_rates.shop_id';

    /**
     * the column name for the category_id field
     */
    const COL_CATEGORY_ID = 'shop_complex_rates.category_id';

    /**
     * the column name for the pricelist_sheet_id field
     */
    const COL_PRICELIST_SHEET_ID = 'shop_complex_rates.pricelist_sheet_id';

    /**
     * the column name for the rate field
     */
    const COL_RATE = 'shop_complex_rates.rate';

    /**
     * the column name for the priority field
     */
    const COL_PRIORITY = 'shop_complex_rates.priority';

    /**
     * the column name for the active field
     */
    const COL_ACTIVE = 'shop_complex_rates.active';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'BrandId', 'CustomerGroupId', 'CustomerId', 'ShopId', 'CategoryId', 'PricelistSheetId', 'Rate', 'Priority', 'Active', ),
        self::TYPE_CAMELNAME     => array('id', 'brandId', 'customerGroupId', 'customerId', 'shopId', 'categoryId', 'pricelistSheetId', 'rate', 'priority', 'active', ),
        self::TYPE_COLNAME       => array(ComplexRateTableMap::COL_ID, ComplexRateTableMap::COL_BRAND_ID, ComplexRateTableMap::COL_CUSTOMER_GROUP_ID, ComplexRateTableMap::COL_CUSTOMER_ID, ComplexRateTableMap::COL_SHOP_ID, ComplexRateTableMap::COL_CATEGORY_ID, ComplexRateTableMap::COL_PRICELIST_SHEET_ID, ComplexRateTableMap::COL_RATE, ComplexRateTableMap::COL_PRIORITY, ComplexRateTableMap::COL_ACTIVE, ),
        self::TYPE_FIELDNAME     => array('id', 'brand_id', 'customer_group_id', 'customer_id', 'shop_id', 'category_id', 'pricelist_sheet_id', 'rate', 'priority', 'active', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'BrandId' => 1, 'CustomerGroupId' => 2, 'CustomerId' => 3, 'ShopId' => 4, 'CategoryId' => 5, 'PricelistSheetId' => 6, 'Rate' => 7, 'Priority' => 8, 'Active' => 9, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'brandId' => 1, 'customerGroupId' => 2, 'customerId' => 3, 'shopId' => 4, 'categoryId' => 5, 'pricelistSheetId' => 6, 'rate' => 7, 'priority' => 8, 'active' => 9, ),
        self::TYPE_COLNAME       => array(ComplexRateTableMap::COL_ID => 0, ComplexRateTableMap::COL_BRAND_ID => 1, ComplexRateTableMap::COL_CUSTOMER_GROUP_ID => 2, ComplexRateTableMap::COL_CUSTOMER_ID => 3, ComplexRateTableMap::COL_SHOP_ID => 4, ComplexRateTableMap::COL_CATEGORY_ID => 5, ComplexRateTableMap::COL_PRICELIST_SHEET_ID => 6, ComplexRateTableMap::COL_RATE => 7, ComplexRateTableMap::COL_PRIORITY => 8, ComplexRateTableMap::COL_ACTIVE => 9, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'brand_id' => 1, 'customer_group_id' => 2, 'customer_id' => 3, 'shop_id' => 4, 'category_id' => 5, 'pricelist_sheet_id' => 6, 'rate' => 7, 'priority' => 8, 'active' => 9, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('shop_complex_rates');
        $this->setPhpName('ComplexRate');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Models\\ComplexRate\\ComplexRate');
        $this->setPackage('Models.ComplexRate');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('brand_id', 'BrandId', 'CHAR', true, 20, '%');
        $this->addColumn('customer_group_id', 'CustomerGroupId', 'CHAR', true, 20, '%');
        $this->addColumn('customer_id', 'CustomerId', 'CHAR', true, 20, '%');
        $this->addColumn('shop_id', 'ShopId', 'CHAR', true, 20, '%');
        $this->addColumn('category_id', 'CategoryId', 'CHAR', true, 20, '%');
        $this->addColumn('pricelist_sheet_id', 'PricelistSheetId', 'CHAR', true, 20, '%');
        $this->addColumn('rate', 'Rate', 'DECIMAL', false, 19, 0);
        $this->addColumn('priority', 'Priority', 'INTEGER', false, null, 0);
        $this->addColumn('active', 'Active', 'INTEGER', false, null, 1);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? ComplexRateTableMap::CLASS_DEFAULT : ComplexRateTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (ComplexRate object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = ComplexRateTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ComplexRateTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ComplexRateTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ComplexRateTableMap::OM_CLASS;
            /** @var ComplexRate $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ComplexRateTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ComplexRateTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ComplexRateTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var ComplexRate $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ComplexRateTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ComplexRateTableMap::COL_ID);
            $criteria->addSelectColumn(ComplexRateTableMap::COL_BRAND_ID);
            $criteria->addSelectColumn(ComplexRateTableMap::COL_CUSTOMER_GROUP_ID);
            $criteria->addSelectColumn(ComplexRateTableMap::COL_CUSTOMER_ID);
            $criteria->addSelectColumn(ComplexRateTableMap::COL_SHOP_ID);
            $criteria->addSelectColumn(ComplexRateTableMap::COL_CATEGORY_ID);
            $criteria->addSelectColumn(ComplexRateTableMap::COL_PRICELIST_SHEET_ID);
            $criteria->addSelectColumn(ComplexRateTableMap::COL_RATE);
            $criteria->addSelectColumn(ComplexRateTableMap::COL_PRIORITY);
            $criteria->addSelectColumn(ComplexRateTableMap::COL_ACTIVE);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.brand_id');
            $criteria->addSelectColumn($alias . '.customer_group_id');
            $criteria->addSelectColumn($alias . '.customer_id');
            $criteria->addSelectColumn($alias . '.shop_id');
            $criteria->addSelectColumn($alias . '.category_id');
            $criteria->addSelectColumn($alias . '.pricelist_sheet_id');
            $criteria->addSelectColumn($alias . '.rate');
            $criteria->addSelectColumn($alias . '.priority');
            $criteria->addSelectColumn($alias . '.active');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(ComplexRateTableMap::DATABASE_NAME)->getTable(ComplexRateTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(ComplexRateTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(ComplexRateTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new ComplexRateTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a ComplexRate or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or ComplexRate object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ComplexRateTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Models\ComplexRate\ComplexRate) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ComplexRateTableMap::DATABASE_NAME);
            $criteria->add(ComplexRateTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ComplexRateQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ComplexRateTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ComplexRateTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_complex_rates table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return ComplexRateQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a ComplexRate or Criteria object.
     *
     * @param mixed               $criteria Criteria or ComplexRate object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ComplexRateTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from ComplexRate object
        }

        if ($criteria->containsKey(ComplexRateTableMap::COL_ID) && $criteria->keyContainsValue(ComplexRateTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ComplexRateTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = ComplexRateQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // ComplexRateTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
ComplexRateTableMap::buildTableMap();
