<?php


namespace Shop\Application\Shopping\ChangeOrderState;


use Shop\Models\Order\Order;

class ChangeOrderStateCommand
{

    protected $order;
    protected $stateId;

    public function __construct(Order $order, int $stateId)
    {
        $this->order = $order;
        $this->stateId = $stateId;
    }

    /**
     * @return Order
     */
    public function getOrder(): Order
    {
        return $this->order;
    }

    /**
     * @return int
     */
    public function getStateId(): int
    {
        return $this->stateId;
    }

}