<?php

namespace Shop\Controllers;

use Core\Form\ControlBuilder;
use Shop\Repositories\Region\RegionCriteria;
use Shop\Repositories\Region\RegionRepository;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Description of Region
 *
 * @author Admin
 */
class RegionController extends \Core\BaseController
{

    protected $regionRepo;
    protected $builder;

    public function __construct(RegionRepository $repo, ControlBuilder $cBuilder)
    {
        $this->regionRepo = $repo;
        $this->builder  = $cBuilder;
    }

    function index(): JsonResponse
    {

        $dropdown = $this->regionRepo->findByCriteria(
            RegionCriteria::create()->setFilterByCountryId(input_get('country'))
        )->getDropdownList();

        $data [] = [
            'id'    => null,
            'value' => '- не выбранно -'
        ];
        foreach ($dropdown as $key => $value) {

            $data[] = [
                'id'    => $key,
                'value' => $value
            ];
        }

        return new JsonResponse($data);
    }

}