<?php


namespace Shop\Application\Basket\AddItemInCurrentBasket;


use Shop\Domain\Basket\BasketItem;
use Shop\Services\Basket\BasketService;

class AddItemInCurrentBasketHandler
{
    protected $basketService;

    public function __construct(BasketService $basketService)
    {
        $this->basketService = $basketService;
    }

    /**
     * @param AddItemInCurrentBasketCommand $command
     * @throws \Propel\Runtime\Exception\PropelException
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    public function handle(AddItemInCurrentBasketCommand $command): void
    {

        $request = $command->getBasketItemRequest();

        $basket = $this->basketService->getCurrentBasket();


        $item = (new BasketItem())
            ->setProviderId($request->getProviderId())
            ->setName($request->getName())
            ->setDesc($request->getDesc())
            ->setBrand($request->getBrand())
            ->setArticle($request->getArticle())
            ->setAmount($request->getAmount())
            ->setPrice($request->getPrice())
            ->setMenagerComment($request->getMenagerComment())
            ->setRef($request->getRef())
            ->setDestination($request->getDestination());

        $basket->addItem($item);

        $this->basketService->saveBasket($basket);

        $command->getBasketItemResult()->setSourceId($item->getId());
    }
}