<?php


namespace Shop\Modules\AdminProviders;


use ActiveTable\DataTableEngine;
use Core\Form\ControlBuilder;
use Diamond\Helpers\Form;
use Repo\CrudRepositoryBuilderInterface;
use Shop\Config\Main;
use Shop\Domain\City\CityCollection;
use Shop\Domain\Region\RegionCollection;
use Shop\Domain\Stock\Contracts\StockEntityInterface;
use Shop\Repositories\City\CityCriteria;
use Shop\Repositories\Country\CountryCriteria;
use Shop\Repositories\Provider\ProviderRepository;
use Shop\Repositories\Region\RegionCriteria;

trait ContractorFormTrait
{

    /**
     * @var ControlBuilder
     */
    protected $controlBuilder;


    /**
     * @var ProviderRepository
     */
    protected $providerRepository;

    /**
     * @var Main
     */
    protected $mainConf;


    /**
     * @param DataTableEngine $table
     * @param CrudRepositoryBuilderInterface $repo
     */
    public function makeContractorForm(DataTableEngine $table, CrudRepositoryBuilderInterface $repo): void
    {
        $contractorName = '-укажите контрагента-';

        if (input_get('id') > 0) {
            $entity = $repo->findById(input_get('id'));
            if($entity->getContractor() !== null){
                $contractorName = $entity->getContractor()->getName();
            }
        }

        $table
            ->addField(
                $this->controlBuilder
                    ->buildWindowSelect('contractorId', '/admin/shop/stocks/contractors-lite?filter=1', $contractorName)
                ->setValue('NULL'),true
            );



        $cities = new CityCollection();
        $regions = new RegionCollection();
        $regionId = $cityId = $countryId = null;

        $stock = null;

        $countries = $this->countryRepository->findByCriteria(
            CountryCriteria::create()
        );

        if(input_get('id')){
            $stock = $this->stockRepository->findById(input_get('id'));
        }


        if ($stock !== null && $stock->getAddress()) {
            $cityId = $stock->getAddress()->getCityId();

            $city = $this->cityRepository->findById($cityId);

            $regionId = $city->getRegionId();

            $countryId = $city->getCityRegion()->getCountryId();

            $cities = $this->cityRepository->findByCriteria(
                CityCriteria::create()->setFilterByRegionId($regionId)
            );
            $regions = $this->regionRepository->findByCriteria(
                RegionCriteria::create()
                    ->setFilterByCountryId($countryId)
                    ->setSortByName('ASC')
            );
        }


        if (input_post('countryId') > 0) {
            $cityId = input_post('countryId');
            $regions = $this->regionRepository->findByCriteria(
                RegionCriteria::create()->setFilterByCountryId($cityId)
            );
        }

        if (input_post('regionId') > 0) {
            $regionId = input_post('regionId');
            $cities = $this->cityRepository->findByCriteria(
                CityCriteria::create()->setFilterByRegionId($regionId)->setSortByName('ASC')
            );
        }
//dump($cityId);
        //PHONE MASK
        $masks = [];
        foreach ($countries as $country) {
            if (empty($country->getPhoneMask())) {
                continue;
            }
            $masks[$country->getId()] = $country->getPhoneMask();
        }

        $table
            ->addField(
                $this->controlBuilder->buildFormHeader('Адрес', 'address')
            )
            ->addField(
                $this
                    ->controlBuilder
                    ->buildDropdownUniform('countryId', Form::prepareDropdown($countries, 'страну'))
                    ->setValue($countryId)
                    ->onChange("select_region(this,'regionId',0,'#phoneMask')")
                    ->setId('countryId'),
                false,
                'Страна'
            )
            ->addField(
                $this
                    ->controlBuilder
                    ->buildDropdownUniform('regionId', Form::prepareDropdown($regions, 'регион'))
                    ->setValue($regionId)
                    ->onChange("select_city(this,'cityId')"),
                false,
                'Область'
            )
            ->addField(
                $this
                    ->controlBuilder
                    ->buildDropdownUniform('cityId', Form::prepareDropdown($cities, 'город'))
                    ->setValue($cityId),
                true,
                'Город'
            );


    }

}