<?php

namespace Shop\Models\Order\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Customer\Customer;
use Shop\Models\Order\Order as ChildOrder;
use Shop\Models\Order\OrderQuery as ChildOrderQuery;
use Shop\Models\Order\ShopOrdersArchive as ChildShopOrdersArchive;
use Shop\Models\OrderItem\OrderItem;
use Shop\Models\OrderSign\OrderSign;
use Shop\Models\OrderType\OrderType;
use Shop\Models\Order\Map\OrderTableMap;
use Shop\Models\Payment\Payment;
use Shop\Models\PaymentTransaction\PaymentTransaction;
use Shop\Models\State\State;
use Shop\Models\SyncLog\SyncLog;

/**
 * Base class that represents a query for the 'shop_orders' table.
 *
 *
 *
 * @method     ChildOrderQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildOrderQuery orderByTypeId($order = Criteria::ASC) Order by the type_id column
 * @method     ChildOrderQuery orderByCustomerId($order = Criteria::ASC) Order by the customer_id column
 * @method     ChildOrderQuery orderByContractorId($order = Criteria::ASC) Order by the contractor_id column
 * @method     ChildOrderQuery orderByDatetime($order = Criteria::ASC) Order by the datetime column
 * @method     ChildOrderQuery orderByUDatetime($order = Criteria::ASC) Order by the udatetime column
 * @method     ChildOrderQuery orderByDiscountSumm($order = Criteria::ASC) Order by the discount_summ column
 * @method     ChildOrderQuery orderByReload($order = Criteria::ASC) Order by the reload column
 * @method     ChildOrderQuery orderByDeliveryAddress($order = Criteria::ASC) Order by the delivery_address column
 * @method     ChildOrderQuery orderByPaymentId($order = Criteria::ASC) Order by the payment_id column
 * @method     ChildOrderQuery orderByStateId($order = Criteria::ASC) Order by the state_id column
 * @method     ChildOrderQuery orderByComment($order = Criteria::ASC) Order by the comment column
 * @method     ChildOrderQuery orderByPostCode($order = Criteria::ASC) Order by the post_code column
 * @method     ChildOrderQuery orderByShopId($order = Criteria::ASC) Order by the shop_id column
 *
 * @method     ChildOrderQuery groupById() Group by the id column
 * @method     ChildOrderQuery groupByTypeId() Group by the type_id column
 * @method     ChildOrderQuery groupByCustomerId() Group by the customer_id column
 * @method     ChildOrderQuery groupByContractorId() Group by the contractor_id column
 * @method     ChildOrderQuery groupByDatetime() Group by the datetime column
 * @method     ChildOrderQuery groupByUDatetime() Group by the udatetime column
 * @method     ChildOrderQuery groupByDiscountSumm() Group by the discount_summ column
 * @method     ChildOrderQuery groupByReload() Group by the reload column
 * @method     ChildOrderQuery groupByDeliveryAddress() Group by the delivery_address column
 * @method     ChildOrderQuery groupByPaymentId() Group by the payment_id column
 * @method     ChildOrderQuery groupByStateId() Group by the state_id column
 * @method     ChildOrderQuery groupByComment() Group by the comment column
 * @method     ChildOrderQuery groupByPostCode() Group by the post_code column
 * @method     ChildOrderQuery groupByShopId() Group by the shop_id column
 *
 * @method     ChildOrderQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildOrderQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildOrderQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildOrderQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildOrderQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildOrderQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildOrderQuery leftJoinType($relationAlias = null) Adds a LEFT JOIN clause to the query using the Type relation
 * @method     ChildOrderQuery rightJoinType($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Type relation
 * @method     ChildOrderQuery innerJoinType($relationAlias = null) Adds a INNER JOIN clause to the query using the Type relation
 *
 * @method     ChildOrderQuery joinWithType($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Type relation
 *
 * @method     ChildOrderQuery leftJoinWithType() Adds a LEFT JOIN clause and with to the query using the Type relation
 * @method     ChildOrderQuery rightJoinWithType() Adds a RIGHT JOIN clause and with to the query using the Type relation
 * @method     ChildOrderQuery innerJoinWithType() Adds a INNER JOIN clause and with to the query using the Type relation
 *
 * @method     ChildOrderQuery leftJoinCustomer($relationAlias = null) Adds a LEFT JOIN clause to the query using the Customer relation
 * @method     ChildOrderQuery rightJoinCustomer($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Customer relation
 * @method     ChildOrderQuery innerJoinCustomer($relationAlias = null) Adds a INNER JOIN clause to the query using the Customer relation
 *
 * @method     ChildOrderQuery joinWithCustomer($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Customer relation
 *
 * @method     ChildOrderQuery leftJoinWithCustomer() Adds a LEFT JOIN clause and with to the query using the Customer relation
 * @method     ChildOrderQuery rightJoinWithCustomer() Adds a RIGHT JOIN clause and with to the query using the Customer relation
 * @method     ChildOrderQuery innerJoinWithCustomer() Adds a INNER JOIN clause and with to the query using the Customer relation
 *
 * @method     ChildOrderQuery leftJoinContractor($relationAlias = null) Adds a LEFT JOIN clause to the query using the Contractor relation
 * @method     ChildOrderQuery rightJoinContractor($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Contractor relation
 * @method     ChildOrderQuery innerJoinContractor($relationAlias = null) Adds a INNER JOIN clause to the query using the Contractor relation
 *
 * @method     ChildOrderQuery joinWithContractor($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Contractor relation
 *
 * @method     ChildOrderQuery leftJoinWithContractor() Adds a LEFT JOIN clause and with to the query using the Contractor relation
 * @method     ChildOrderQuery rightJoinWithContractor() Adds a RIGHT JOIN clause and with to the query using the Contractor relation
 * @method     ChildOrderQuery innerJoinWithContractor() Adds a INNER JOIN clause and with to the query using the Contractor relation
 *
 * @method     ChildOrderQuery leftJoinPayment($relationAlias = null) Adds a LEFT JOIN clause to the query using the Payment relation
 * @method     ChildOrderQuery rightJoinPayment($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Payment relation
 * @method     ChildOrderQuery innerJoinPayment($relationAlias = null) Adds a INNER JOIN clause to the query using the Payment relation
 *
 * @method     ChildOrderQuery joinWithPayment($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Payment relation
 *
 * @method     ChildOrderQuery leftJoinWithPayment() Adds a LEFT JOIN clause and with to the query using the Payment relation
 * @method     ChildOrderQuery rightJoinWithPayment() Adds a RIGHT JOIN clause and with to the query using the Payment relation
 * @method     ChildOrderQuery innerJoinWithPayment() Adds a INNER JOIN clause and with to the query using the Payment relation
 *
 * @method     ChildOrderQuery leftJoinState($relationAlias = null) Adds a LEFT JOIN clause to the query using the State relation
 * @method     ChildOrderQuery rightJoinState($relationAlias = null) Adds a RIGHT JOIN clause to the query using the State relation
 * @method     ChildOrderQuery innerJoinState($relationAlias = null) Adds a INNER JOIN clause to the query using the State relation
 *
 * @method     ChildOrderQuery joinWithState($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the State relation
 *
 * @method     ChildOrderQuery leftJoinWithState() Adds a LEFT JOIN clause and with to the query using the State relation
 * @method     ChildOrderQuery rightJoinWithState() Adds a RIGHT JOIN clause and with to the query using the State relation
 * @method     ChildOrderQuery innerJoinWithState() Adds a INNER JOIN clause and with to the query using the State relation
 *
 * @method     ChildOrderQuery leftJoinPaymentTransaction($relationAlias = null) Adds a LEFT JOIN clause to the query using the PaymentTransaction relation
 * @method     ChildOrderQuery rightJoinPaymentTransaction($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PaymentTransaction relation
 * @method     ChildOrderQuery innerJoinPaymentTransaction($relationAlias = null) Adds a INNER JOIN clause to the query using the PaymentTransaction relation
 *
 * @method     ChildOrderQuery joinWithPaymentTransaction($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the PaymentTransaction relation
 *
 * @method     ChildOrderQuery leftJoinWithPaymentTransaction() Adds a LEFT JOIN clause and with to the query using the PaymentTransaction relation
 * @method     ChildOrderQuery rightJoinWithPaymentTransaction() Adds a RIGHT JOIN clause and with to the query using the PaymentTransaction relation
 * @method     ChildOrderQuery innerJoinWithPaymentTransaction() Adds a INNER JOIN clause and with to the query using the PaymentTransaction relation
 *
 * @method     ChildOrderQuery leftJoinOrderItem($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderItem relation
 * @method     ChildOrderQuery rightJoinOrderItem($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderItem relation
 * @method     ChildOrderQuery innerJoinOrderItem($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderItem relation
 *
 * @method     ChildOrderQuery joinWithOrderItem($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderItem relation
 *
 * @method     ChildOrderQuery leftJoinWithOrderItem() Adds a LEFT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildOrderQuery rightJoinWithOrderItem() Adds a RIGHT JOIN clause and with to the query using the OrderItem relation
 * @method     ChildOrderQuery innerJoinWithOrderItem() Adds a INNER JOIN clause and with to the query using the OrderItem relation
 *
 * @method     ChildOrderQuery leftJoinSyncLog($relationAlias = null) Adds a LEFT JOIN clause to the query using the SyncLog relation
 * @method     ChildOrderQuery rightJoinSyncLog($relationAlias = null) Adds a RIGHT JOIN clause to the query using the SyncLog relation
 * @method     ChildOrderQuery innerJoinSyncLog($relationAlias = null) Adds a INNER JOIN clause to the query using the SyncLog relation
 *
 * @method     ChildOrderQuery joinWithSyncLog($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the SyncLog relation
 *
 * @method     ChildOrderQuery leftJoinWithSyncLog() Adds a LEFT JOIN clause and with to the query using the SyncLog relation
 * @method     ChildOrderQuery rightJoinWithSyncLog() Adds a RIGHT JOIN clause and with to the query using the SyncLog relation
 * @method     ChildOrderQuery innerJoinWithSyncLog() Adds a INNER JOIN clause and with to the query using the SyncLog relation
 *
 * @method     ChildOrderQuery leftJoinOrderSign($relationAlias = null) Adds a LEFT JOIN clause to the query using the OrderSign relation
 * @method     ChildOrderQuery rightJoinOrderSign($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OrderSign relation
 * @method     ChildOrderQuery innerJoinOrderSign($relationAlias = null) Adds a INNER JOIN clause to the query using the OrderSign relation
 *
 * @method     ChildOrderQuery joinWithOrderSign($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OrderSign relation
 *
 * @method     ChildOrderQuery leftJoinWithOrderSign() Adds a LEFT JOIN clause and with to the query using the OrderSign relation
 * @method     ChildOrderQuery rightJoinWithOrderSign() Adds a RIGHT JOIN clause and with to the query using the OrderSign relation
 * @method     ChildOrderQuery innerJoinWithOrderSign() Adds a INNER JOIN clause and with to the query using the OrderSign relation
 *
 * @method     \Shop\Models\OrderType\OrderTypeQuery|\Shop\Models\Customer\CustomerQuery|\Shop\Models\Payment\PaymentQuery|\Shop\Models\State\StateQuery|\Shop\Models\PaymentTransaction\PaymentTransactionQuery|\Shop\Models\OrderItem\OrderItemQuery|\Shop\Models\SyncLog\SyncLogQuery|\Shop\Models\OrderSign\OrderSignQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildOrder findOne(ConnectionInterface $con = null) Return the first ChildOrder matching the query
 * @method     ChildOrder findOneOrCreate(ConnectionInterface $con = null) Return the first ChildOrder matching the query, or a new ChildOrder object populated from the query conditions when no match is found
 *
 * @method     ChildOrder findOneById(int $id) Return the first ChildOrder filtered by the id column
 * @method     ChildOrder findOneByTypeId(int $type_id) Return the first ChildOrder filtered by the type_id column
 * @method     ChildOrder findOneByCustomerId(int $customer_id) Return the first ChildOrder filtered by the customer_id column
 * @method     ChildOrder findOneByContractorId(int $contractor_id) Return the first ChildOrder filtered by the contractor_id column
 * @method     ChildOrder findOneByDatetime(string $datetime) Return the first ChildOrder filtered by the datetime column
 * @method     ChildOrder findOneByUDatetime(string $udatetime) Return the first ChildOrder filtered by the udatetime column
 * @method     ChildOrder findOneByDiscountSumm(string $discount_summ) Return the first ChildOrder filtered by the discount_summ column
 * @method     ChildOrder findOneByReload(string $reload) Return the first ChildOrder filtered by the reload column
 * @method     ChildOrder findOneByDeliveryAddress(string $delivery_address) Return the first ChildOrder filtered by the delivery_address column
 * @method     ChildOrder findOneByPaymentId(int $payment_id) Return the first ChildOrder filtered by the payment_id column
 * @method     ChildOrder findOneByStateId(int $state_id) Return the first ChildOrder filtered by the state_id column
 * @method     ChildOrder findOneByComment(string $comment) Return the first ChildOrder filtered by the comment column
 * @method     ChildOrder findOneByPostCode(string $post_code) Return the first ChildOrder filtered by the post_code column
 * @method     ChildOrder findOneByShopId(int $shop_id) Return the first ChildOrder filtered by the shop_id column *

 * @method     ChildOrder requirePk($key, ConnectionInterface $con = null) Return the ChildOrder by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOne(ConnectionInterface $con = null) Return the first ChildOrder matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildOrder requireOneById(int $id) Return the first ChildOrder filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByTypeId(int $type_id) Return the first ChildOrder filtered by the type_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByCustomerId(int $customer_id) Return the first ChildOrder filtered by the customer_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByContractorId(int $contractor_id) Return the first ChildOrder filtered by the contractor_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByDatetime(string $datetime) Return the first ChildOrder filtered by the datetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByUDatetime(string $udatetime) Return the first ChildOrder filtered by the udatetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByDiscountSumm(string $discount_summ) Return the first ChildOrder filtered by the discount_summ column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByReload(string $reload) Return the first ChildOrder filtered by the reload column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByDeliveryAddress(string $delivery_address) Return the first ChildOrder filtered by the delivery_address column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByPaymentId(int $payment_id) Return the first ChildOrder filtered by the payment_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByStateId(int $state_id) Return the first ChildOrder filtered by the state_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByComment(string $comment) Return the first ChildOrder filtered by the comment column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByPostCode(string $post_code) Return the first ChildOrder filtered by the post_code column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrder requireOneByShopId(int $shop_id) Return the first ChildOrder filtered by the shop_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildOrder[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildOrder objects based on current ModelCriteria
 * @method     ChildOrder[]|ObjectCollection findById(int $id) Return ChildOrder objects filtered by the id column
 * @method     ChildOrder[]|ObjectCollection findByTypeId(int $type_id) Return ChildOrder objects filtered by the type_id column
 * @method     ChildOrder[]|ObjectCollection findByCustomerId(int $customer_id) Return ChildOrder objects filtered by the customer_id column
 * @method     ChildOrder[]|ObjectCollection findByContractorId(int $contractor_id) Return ChildOrder objects filtered by the contractor_id column
 * @method     ChildOrder[]|ObjectCollection findByDatetime(string $datetime) Return ChildOrder objects filtered by the datetime column
 * @method     ChildOrder[]|ObjectCollection findByUDatetime(string $udatetime) Return ChildOrder objects filtered by the udatetime column
 * @method     ChildOrder[]|ObjectCollection findByDiscountSumm(string $discount_summ) Return ChildOrder objects filtered by the discount_summ column
 * @method     ChildOrder[]|ObjectCollection findByReload(string $reload) Return ChildOrder objects filtered by the reload column
 * @method     ChildOrder[]|ObjectCollection findByDeliveryAddress(string $delivery_address) Return ChildOrder objects filtered by the delivery_address column
 * @method     ChildOrder[]|ObjectCollection findByPaymentId(int $payment_id) Return ChildOrder objects filtered by the payment_id column
 * @method     ChildOrder[]|ObjectCollection findByStateId(int $state_id) Return ChildOrder objects filtered by the state_id column
 * @method     ChildOrder[]|ObjectCollection findByComment(string $comment) Return ChildOrder objects filtered by the comment column
 * @method     ChildOrder[]|ObjectCollection findByPostCode(string $post_code) Return ChildOrder objects filtered by the post_code column
 * @method     ChildOrder[]|ObjectCollection findByShopId(int $shop_id) Return ChildOrder objects filtered by the shop_id column
 * @method     ChildOrder[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class OrderQuery extends ModelCriteria
{

    // delegate behavior

    protected $delegatedFields = [
        'MoyskladSync' => 'OrderSign',
        'BitrixSync' => 'OrderSign',
    ];


    // archivable behavior
    protected $archiveOnDelete = true;
protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\Order\Base\OrderQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Order\\Order', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildOrderQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildOrderQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildOrderQuery) {
            return $criteria;
        }
        $query = new ChildOrderQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildOrder|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(OrderTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = OrderTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrder A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `type_id`, `customer_id`, `contractor_id`, `datetime`, `udatetime`, `discount_summ`, `reload`, `delivery_address`, `payment_id`, `state_id`, `comment`, `post_code`, `shop_id` FROM `shop_orders` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildOrder $obj */
            $obj = new ChildOrder();
            $obj->hydrate($row);
            OrderTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildOrder|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(OrderTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(OrderTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the type_id column
     *
     * Example usage:
     * <code>
     * $query->filterByTypeId(1234); // WHERE type_id = 1234
     * $query->filterByTypeId(array(12, 34)); // WHERE type_id IN (12, 34)
     * $query->filterByTypeId(array('min' => 12)); // WHERE type_id > 12
     * </code>
     *
     * @see       filterByType()
     *
     * @param     mixed $typeId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByTypeId($typeId = null, $comparison = null)
    {
        if (is_array($typeId)) {
            $useMinMax = false;
            if (isset($typeId['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_TYPE_ID, $typeId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($typeId['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_TYPE_ID, $typeId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_TYPE_ID, $typeId, $comparison);
    }

    /**
     * Filter the query on the customer_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCustomerId(1234); // WHERE customer_id = 1234
     * $query->filterByCustomerId(array(12, 34)); // WHERE customer_id IN (12, 34)
     * $query->filterByCustomerId(array('min' => 12)); // WHERE customer_id > 12
     * </code>
     *
     * @see       filterByCustomer()
     *
     * @param     mixed $customerId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByCustomerId($customerId = null, $comparison = null)
    {
        if (is_array($customerId)) {
            $useMinMax = false;
            if (isset($customerId['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_CUSTOMER_ID, $customerId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($customerId['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_CUSTOMER_ID, $customerId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_CUSTOMER_ID, $customerId, $comparison);
    }

    /**
     * Filter the query on the contractor_id column
     *
     * Example usage:
     * <code>
     * $query->filterByContractorId(1234); // WHERE contractor_id = 1234
     * $query->filterByContractorId(array(12, 34)); // WHERE contractor_id IN (12, 34)
     * $query->filterByContractorId(array('min' => 12)); // WHERE contractor_id > 12
     * </code>
     *
     * @see       filterByContractor()
     *
     * @param     mixed $contractorId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByContractorId($contractorId = null, $comparison = null)
    {
        if (is_array($contractorId)) {
            $useMinMax = false;
            if (isset($contractorId['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_CONTRACTOR_ID, $contractorId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contractorId['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_CONTRACTOR_ID, $contractorId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_CONTRACTOR_ID, $contractorId, $comparison);
    }

    /**
     * Filter the query on the datetime column
     *
     * Example usage:
     * <code>
     * $query->filterByDatetime('2011-03-14'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime('now'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime(array('max' => 'yesterday')); // WHERE datetime > '2011-03-13'
     * </code>
     *
     * @param     mixed $datetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByDatetime($datetime = null, $comparison = null)
    {
        if (is_array($datetime)) {
            $useMinMax = false;
            if (isset($datetime['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_DATETIME, $datetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datetime['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_DATETIME, $datetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_DATETIME, $datetime, $comparison);
    }

    /**
     * Filter the query on the udatetime column
     *
     * Example usage:
     * <code>
     * $query->filterByUDatetime('2011-03-14'); // WHERE udatetime = '2011-03-14'
     * $query->filterByUDatetime('now'); // WHERE udatetime = '2011-03-14'
     * $query->filterByUDatetime(array('max' => 'yesterday')); // WHERE udatetime > '2011-03-13'
     * </code>
     *
     * @param     mixed $uDatetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByUDatetime($uDatetime = null, $comparison = null)
    {
        if (is_array($uDatetime)) {
            $useMinMax = false;
            if (isset($uDatetime['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_UDATETIME, $uDatetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($uDatetime['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_UDATETIME, $uDatetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_UDATETIME, $uDatetime, $comparison);
    }

    /**
     * Filter the query on the discount_summ column
     *
     * Example usage:
     * <code>
     * $query->filterByDiscountSumm(1234); // WHERE discount_summ = 1234
     * $query->filterByDiscountSumm(array(12, 34)); // WHERE discount_summ IN (12, 34)
     * $query->filterByDiscountSumm(array('min' => 12)); // WHERE discount_summ > 12
     * </code>
     *
     * @param     mixed $discountSumm The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByDiscountSumm($discountSumm = null, $comparison = null)
    {
        if (is_array($discountSumm)) {
            $useMinMax = false;
            if (isset($discountSumm['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_DISCOUNT_SUMM, $discountSumm['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($discountSumm['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_DISCOUNT_SUMM, $discountSumm['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_DISCOUNT_SUMM, $discountSumm, $comparison);
    }

    /**
     * Filter the query on the reload column
     *
     * Example usage:
     * <code>
     * $query->filterByReload('fooValue');   // WHERE reload = 'fooValue'
     * $query->filterByReload('%fooValue%', Criteria::LIKE); // WHERE reload LIKE '%fooValue%'
     * </code>
     *
     * @param     string $reload The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByReload($reload = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($reload)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_RELOAD, $reload, $comparison);
    }

    /**
     * Filter the query on the delivery_address column
     *
     * Example usage:
     * <code>
     * $query->filterByDeliveryAddress('fooValue');   // WHERE delivery_address = 'fooValue'
     * $query->filterByDeliveryAddress('%fooValue%', Criteria::LIKE); // WHERE delivery_address LIKE '%fooValue%'
     * </code>
     *
     * @param     string $deliveryAddress The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByDeliveryAddress($deliveryAddress = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($deliveryAddress)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_DELIVERY_ADDRESS, $deliveryAddress, $comparison);
    }

    /**
     * Filter the query on the payment_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPaymentId(1234); // WHERE payment_id = 1234
     * $query->filterByPaymentId(array(12, 34)); // WHERE payment_id IN (12, 34)
     * $query->filterByPaymentId(array('min' => 12)); // WHERE payment_id > 12
     * </code>
     *
     * @see       filterByPayment()
     *
     * @param     mixed $paymentId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByPaymentId($paymentId = null, $comparison = null)
    {
        if (is_array($paymentId)) {
            $useMinMax = false;
            if (isset($paymentId['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_PAYMENT_ID, $paymentId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($paymentId['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_PAYMENT_ID, $paymentId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_PAYMENT_ID, $paymentId, $comparison);
    }

    /**
     * Filter the query on the state_id column
     *
     * Example usage:
     * <code>
     * $query->filterByStateId(1234); // WHERE state_id = 1234
     * $query->filterByStateId(array(12, 34)); // WHERE state_id IN (12, 34)
     * $query->filterByStateId(array('min' => 12)); // WHERE state_id > 12
     * </code>
     *
     * @see       filterByState()
     *
     * @param     mixed $stateId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByStateId($stateId = null, $comparison = null)
    {
        if (is_array($stateId)) {
            $useMinMax = false;
            if (isset($stateId['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_STATE_ID, $stateId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($stateId['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_STATE_ID, $stateId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_STATE_ID, $stateId, $comparison);
    }

    /**
     * Filter the query on the comment column
     *
     * Example usage:
     * <code>
     * $query->filterByComment('fooValue');   // WHERE comment = 'fooValue'
     * $query->filterByComment('%fooValue%', Criteria::LIKE); // WHERE comment LIKE '%fooValue%'
     * </code>
     *
     * @param     string $comment The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByComment($comment = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($comment)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_COMMENT, $comment, $comparison);
    }

    /**
     * Filter the query on the post_code column
     *
     * Example usage:
     * <code>
     * $query->filterByPostCode('fooValue');   // WHERE post_code = 'fooValue'
     * $query->filterByPostCode('%fooValue%', Criteria::LIKE); // WHERE post_code LIKE '%fooValue%'
     * </code>
     *
     * @param     string $postCode The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByPostCode($postCode = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($postCode)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_POST_CODE, $postCode, $comparison);
    }

    /**
     * Filter the query on the shop_id column
     *
     * Example usage:
     * <code>
     * $query->filterByShopId(1234); // WHERE shop_id = 1234
     * $query->filterByShopId(array(12, 34)); // WHERE shop_id IN (12, 34)
     * $query->filterByShopId(array('min' => 12)); // WHERE shop_id > 12
     * </code>
     *
     * @param     mixed $shopId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function filterByShopId($shopId = null, $comparison = null)
    {
        if (is_array($shopId)) {
            $useMinMax = false;
            if (isset($shopId['min'])) {
                $this->addUsingAlias(OrderTableMap::COL_SHOP_ID, $shopId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($shopId['max'])) {
                $this->addUsingAlias(OrderTableMap::COL_SHOP_ID, $shopId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderTableMap::COL_SHOP_ID, $shopId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\OrderType\OrderType object
     *
     * @param \Shop\Models\OrderType\OrderType|ObjectCollection $orderType The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrderQuery The current query, for fluid interface
     */
    public function filterByType($orderType, $comparison = null)
    {
        if ($orderType instanceof \Shop\Models\OrderType\OrderType) {
            return $this
                ->addUsingAlias(OrderTableMap::COL_TYPE_ID, $orderType->getId(), $comparison);
        } elseif ($orderType instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(OrderTableMap::COL_TYPE_ID, $orderType->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByType() only accepts arguments of type \Shop\Models\OrderType\OrderType or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Type relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function joinType($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Type');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Type');
        }

        return $this;
    }

    /**
     * Use the Type relation OrderType object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\OrderType\OrderTypeQuery A secondary query class using the current class as primary query
     */
    public function useTypeQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinType($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Type', '\Shop\Models\OrderType\OrderTypeQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Customer\Customer object
     *
     * @param \Shop\Models\Customer\Customer|ObjectCollection $customer The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrderQuery The current query, for fluid interface
     */
    public function filterByCustomer($customer, $comparison = null)
    {
        if ($customer instanceof \Shop\Models\Customer\Customer) {
            return $this
                ->addUsingAlias(OrderTableMap::COL_CUSTOMER_ID, $customer->getId(), $comparison);
        } elseif ($customer instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(OrderTableMap::COL_CUSTOMER_ID, $customer->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCustomer() only accepts arguments of type \Shop\Models\Customer\Customer or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Customer relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function joinCustomer($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Customer');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Customer');
        }

        return $this;
    }

    /**
     * Use the Customer relation Customer object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Customer\CustomerQuery A secondary query class using the current class as primary query
     */
    public function useCustomerQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCustomer($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Customer', '\Shop\Models\Customer\CustomerQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Customer\Customer object
     *
     * @param \Shop\Models\Customer\Customer|ObjectCollection $customer The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrderQuery The current query, for fluid interface
     */
    public function filterByContractor($customer, $comparison = null)
    {
        if ($customer instanceof \Shop\Models\Customer\Customer) {
            return $this
                ->addUsingAlias(OrderTableMap::COL_CONTRACTOR_ID, $customer->getId(), $comparison);
        } elseif ($customer instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(OrderTableMap::COL_CONTRACTOR_ID, $customer->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByContractor() only accepts arguments of type \Shop\Models\Customer\Customer or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Contractor relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function joinContractor($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Contractor');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Contractor');
        }

        return $this;
    }

    /**
     * Use the Contractor relation Customer object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Customer\CustomerQuery A secondary query class using the current class as primary query
     */
    public function useContractorQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinContractor($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Contractor', '\Shop\Models\Customer\CustomerQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Payment\Payment object
     *
     * @param \Shop\Models\Payment\Payment|ObjectCollection $payment The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrderQuery The current query, for fluid interface
     */
    public function filterByPayment($payment, $comparison = null)
    {
        if ($payment instanceof \Shop\Models\Payment\Payment) {
            return $this
                ->addUsingAlias(OrderTableMap::COL_PAYMENT_ID, $payment->getId(), $comparison);
        } elseif ($payment instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(OrderTableMap::COL_PAYMENT_ID, $payment->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPayment() only accepts arguments of type \Shop\Models\Payment\Payment or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Payment relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function joinPayment($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Payment');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Payment');
        }

        return $this;
    }

    /**
     * Use the Payment relation Payment object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Payment\PaymentQuery A secondary query class using the current class as primary query
     */
    public function usePaymentQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPayment($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Payment', '\Shop\Models\Payment\PaymentQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\State\State object
     *
     * @param \Shop\Models\State\State|ObjectCollection $state The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrderQuery The current query, for fluid interface
     */
    public function filterByState($state, $comparison = null)
    {
        if ($state instanceof \Shop\Models\State\State) {
            return $this
                ->addUsingAlias(OrderTableMap::COL_STATE_ID, $state->getId(), $comparison);
        } elseif ($state instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(OrderTableMap::COL_STATE_ID, $state->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByState() only accepts arguments of type \Shop\Models\State\State or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the State relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function joinState($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('State');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'State');
        }

        return $this;
    }

    /**
     * Use the State relation State object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\State\StateQuery A secondary query class using the current class as primary query
     */
    public function useStateQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinState($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'State', '\Shop\Models\State\StateQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\PaymentTransaction\PaymentTransaction object
     *
     * @param \Shop\Models\PaymentTransaction\PaymentTransaction|ObjectCollection $paymentTransaction the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildOrderQuery The current query, for fluid interface
     */
    public function filterByPaymentTransaction($paymentTransaction, $comparison = null)
    {
        if ($paymentTransaction instanceof \Shop\Models\PaymentTransaction\PaymentTransaction) {
            return $this
                ->addUsingAlias(OrderTableMap::COL_ID, $paymentTransaction->getOrderId(), $comparison);
        } elseif ($paymentTransaction instanceof ObjectCollection) {
            return $this
                ->usePaymentTransactionQuery()
                ->filterByPrimaryKeys($paymentTransaction->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPaymentTransaction() only accepts arguments of type \Shop\Models\PaymentTransaction\PaymentTransaction or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PaymentTransaction relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function joinPaymentTransaction($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PaymentTransaction');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PaymentTransaction');
        }

        return $this;
    }

    /**
     * Use the PaymentTransaction relation PaymentTransaction object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\PaymentTransaction\PaymentTransactionQuery A secondary query class using the current class as primary query
     */
    public function usePaymentTransactionQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinPaymentTransaction($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PaymentTransaction', '\Shop\Models\PaymentTransaction\PaymentTransactionQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\OrderItem\OrderItem object
     *
     * @param \Shop\Models\OrderItem\OrderItem|ObjectCollection $orderItem the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildOrderQuery The current query, for fluid interface
     */
    public function filterByOrderItem($orderItem, $comparison = null)
    {
        if ($orderItem instanceof \Shop\Models\OrderItem\OrderItem) {
            return $this
                ->addUsingAlias(OrderTableMap::COL_ID, $orderItem->getOrderId(), $comparison);
        } elseif ($orderItem instanceof ObjectCollection) {
            return $this
                ->useOrderItemQuery()
                ->filterByPrimaryKeys($orderItem->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByOrderItem() only accepts arguments of type \Shop\Models\OrderItem\OrderItem or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderItem relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function joinOrderItem($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderItem');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderItem');
        }

        return $this;
    }

    /**
     * Use the OrderItem relation OrderItem object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\OrderItem\OrderItemQuery A secondary query class using the current class as primary query
     */
    public function useOrderItemQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrderItem($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderItem', '\Shop\Models\OrderItem\OrderItemQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\SyncLog\SyncLog object
     *
     * @param \Shop\Models\SyncLog\SyncLog|ObjectCollection $syncLog the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildOrderQuery The current query, for fluid interface
     */
    public function filterBySyncLog($syncLog, $comparison = null)
    {
        if ($syncLog instanceof \Shop\Models\SyncLog\SyncLog) {
            return $this
                ->addUsingAlias(OrderTableMap::COL_ID, $syncLog->getOrderId(), $comparison);
        } elseif ($syncLog instanceof ObjectCollection) {
            return $this
                ->useSyncLogQuery()
                ->filterByPrimaryKeys($syncLog->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterBySyncLog() only accepts arguments of type \Shop\Models\SyncLog\SyncLog or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the SyncLog relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function joinSyncLog($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('SyncLog');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'SyncLog');
        }

        return $this;
    }

    /**
     * Use the SyncLog relation SyncLog object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\SyncLog\SyncLogQuery A secondary query class using the current class as primary query
     */
    public function useSyncLogQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinSyncLog($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'SyncLog', '\Shop\Models\SyncLog\SyncLogQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\OrderSign\OrderSign object
     *
     * @param \Shop\Models\OrderSign\OrderSign|ObjectCollection $orderSign the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildOrderQuery The current query, for fluid interface
     */
    public function filterByOrderSign($orderSign, $comparison = null)
    {
        if ($orderSign instanceof \Shop\Models\OrderSign\OrderSign) {
            return $this
                ->addUsingAlias(OrderTableMap::COL_ID, $orderSign->getId(), $comparison);
        } elseif ($orderSign instanceof ObjectCollection) {
            return $this
                ->useOrderSignQuery()
                ->filterByPrimaryKeys($orderSign->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByOrderSign() only accepts arguments of type \Shop\Models\OrderSign\OrderSign or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OrderSign relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function joinOrderSign($relationAlias = null, $joinType = 'LEFT JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OrderSign');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OrderSign');
        }

        return $this;
    }

    /**
     * Use the OrderSign relation OrderSign object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\OrderSign\OrderSignQuery A secondary query class using the current class as primary query
     */
    public function useOrderSignQuery($relationAlias = null, $joinType = 'LEFT JOIN')
    {
        return $this
            ->joinOrderSign($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OrderSign', '\Shop\Models\OrderSign\OrderSignQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildOrder $order Object to remove from the list of results
     *
     * @return $this|ChildOrderQuery The current query, for fluid interface
     */
    public function prune($order = null)
    {
        if ($order) {
            $this->addUsingAlias(OrderTableMap::COL_ID, $order->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute before every DELETE statement
     *
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePreDelete(ConnectionInterface $con)
    {
        // archivable behavior

        if ($this->archiveOnDelete) {
            $this->archive($con);
        } else {
            $this->archiveOnDelete = true;
        }


        return $this->preDelete($con);
    }

    /**
     * Deletes all rows from the shop_orders table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            OrderTableMap::clearInstancePool();
            OrderTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(OrderTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            OrderTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            OrderTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // delegate behavior
    /**
    * Filter the query by moysklad_sync column
    *
    * Example usage:
    * <code>
        * $query->filterByMoyskladSync(1234); // WHERE moysklad_sync = 1234
        * $query->filterByMoyskladSync(array(12, 34)); // WHERE moysklad_sync IN (12, 34)
        * $query->filterByMoyskladSync(array('min' => 12)); // WHERE moysklad_sync >= 12
        * </code>
    *
    * @param     mixed $value The value to use as filter.
    *              Use scalar values for equality.
    *              Use array values for in_array() equivalent.
    *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
    * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
    *
    * @return $this|ChildOrderQuery The current query, for fluid interface
    */
    public function filterByMoyskladSync($value = null, $comparison = null)
    {
        return $this->useOrderSignQuery()->filterByMoyskladSync($value, $comparison)->endUse();
    }

    /**
    * Adds an ORDER BY clause to the query
    * Usability layer on top of Criteria::addAscendingOrderByColumn() and Criteria::addDescendingOrderByColumn()
    * Infers $column and $order from $columnName and some optional arguments
    * Examples:
    *   $c->orderBy('Book.CreatedAt')
    *    => $c->addAscendingOrderByColumn(BookTableMap::CREATED_AT)
    *   $c->orderBy('Book.CategoryId', 'desc')
    *    => $c->addDescendingOrderByColumn(BookTableMap::CATEGORY_ID)
    *
    * @param string $order      The sorting order. Criteria::ASC by default, also accepts Criteria::DESC
    *
    * @return $this|ModelCriteria The current object, for fluid interface
    */
    public function orderByMoyskladSync($order = Criteria::ASC)
    {
        return $this->useOrderSignQuery()->orderByMoyskladSync($order)->endUse();
    }
    /**
    * Filter the query by bitrix_sync column
    *
    * Example usage:
    * <code>
        * $query->filterByBitrixSync(1234); // WHERE bitrix_sync = 1234
        * $query->filterByBitrixSync(array(12, 34)); // WHERE bitrix_sync IN (12, 34)
        * $query->filterByBitrixSync(array('min' => 12)); // WHERE bitrix_sync >= 12
        * </code>
    *
    * @param     mixed $value The value to use as filter.
    *              Use scalar values for equality.
    *              Use array values for in_array() equivalent.
    *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
    * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
    *
    * @return $this|ChildOrderQuery The current query, for fluid interface
    */
    public function filterByBitrixSync($value = null, $comparison = null)
    {
        return $this->useOrderSignQuery()->filterByBitrixSync($value, $comparison)->endUse();
    }

    /**
    * Adds an ORDER BY clause to the query
    * Usability layer on top of Criteria::addAscendingOrderByColumn() and Criteria::addDescendingOrderByColumn()
    * Infers $column and $order from $columnName and some optional arguments
    * Examples:
    *   $c->orderBy('Book.CreatedAt')
    *    => $c->addAscendingOrderByColumn(BookTableMap::CREATED_AT)
    *   $c->orderBy('Book.CategoryId', 'desc')
    *    => $c->addDescendingOrderByColumn(BookTableMap::CATEGORY_ID)
    *
    * @param string $order      The sorting order. Criteria::ASC by default, also accepts Criteria::DESC
    *
    * @return $this|ModelCriteria The current object, for fluid interface
    */
    public function orderByBitrixSync($order = Criteria::ASC)
    {
        return $this->useOrderSignQuery()->orderByBitrixSync($order)->endUse();
    }

    /**
     * Adds a condition on a column based on a column phpName and a value
     * Uses introspection to translate the column phpName into a fully qualified name
     * Warning: recognizes only the phpNames of the main Model (not joined tables)
     * <code>
     * $c->filterBy('Title', 'foo');
     * </code>
     *
     * @see Criteria::add()
     *
     * @param string $column     A string representing thecolumn phpName, e.g. 'AuthorId'
     * @param mixed  $value      A value for the condition
     * @param string $comparison What to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ModelCriteria The current object, for fluid interface
     */
    public function filterBy($column, $value, $comparison = Criteria::EQUAL)
    {
        if (isset($this->delegatedFields[$column])) {
            $methodUse = "use{$this->delegatedFields[$column]}Query";

            return $this->{$methodUse}()->filterBy($column, $value, $comparison)->endUse();
        } else {
            return $this->add($this->getRealColumnName($column), $value, $comparison);
        }
    }

    // archivable behavior

    /**
     * Copy the data of the objects satisfying the query into ChildShopOrdersArchive archive objects.
     * The archived objects are then saved.
     * If any of the objects has already been archived, the archived object
     * is updated and not duplicated.
     * Warning: This termination methods issues 2n+1 queries.
     *
     * @param      ConnectionInterface $con    Connection to use.
     * @param      Boolean $useLittleMemory    Whether or not to use OnDemandFormatter to retrieve objects.
     *               Set to false if the identity map matters.
     *               Set to true (default) to use less memory.
     *
     * @return     int the number of archived objects
     */
    public function archive($con = null, $useLittleMemory = true)
    {
        $criteria = clone $this;
        // prepare the query
        $criteria->setWith(array());
        if ($useLittleMemory) {
            $criteria->setFormatter(ModelCriteria::FORMAT_ON_DEMAND);
        }
        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con, $criteria) {
            $totalArchivedObjects = 0;

            // archive all results one by one
            foreach ($criteria->find($con) as $object) {
                $object->archive($con);
                $totalArchivedObjects++;
            }

            return $totalArchivedObjects;
        });
    }

    /**
     * Enable/disable auto-archiving on delete for the next query.
     *
     * @param boolean True if the query must archive deleted objects, false otherwise.
     */
    public function setArchiveOnDelete($archiveOnDelete)
    {
        $this->archiveOnDelete = $archiveOnDelete;
    }

    /**
     * Delete records matching the current query without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Delete all records without archiving them.
     *
     * @param      ConnectionInterface $con    Connection to use.
     *
     * @return integer the number of deleted rows
     */
    public function deleteAllWithoutArchive($con = null)
    {
        $this->archiveOnDelete = false;

        return $this->deleteAll($con);
    }

} // OrderQuery
