<?php

namespace Shop\Domain\Stock;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Stock\Contracts\StockEntityInterface;

/**
* Description of Stock
*
* @author Diamond Code Generator
*/
class StockCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return StockEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = $sort = [];

        foreach ($this->_entities as $entity){
            $ar[$entity->getparentId()??0] [$entity->getId()] =
                ($entity->getparentId()>0?' - - ':'') . $entity->getTitle(). ' ('.$entity->getTypeDisplay().')'
            ;
        }

        if(isset($ar[0])){
            $this->makeSort($ar[0],$ar,$sort);
        }

        return $sort;
    }

    /**
     * @return array
     */
    public function getDropdownListSimple(): array
    {
        $ar = $sort = [];

        foreach ($this->_entities as $entity){
            $ar[$entity->getparentId()??0] [$entity->getId()] = $entity->getTitle();
        }

        if(isset($ar[0])){
            $this->makeSort($ar[0],$ar,$sort);
        }

        return $sort;
    }


    /**
     * @param array $ar
     * @param array $all
     * @param array $sort
     * @param int $level
     */
    protected function makeSort(array $ar, array $all, array &$sort, $level = 0){
        foreach ($ar as $key => $stock){
            $sort[$key]= $stock;
            if(isset($all[$key])){
                $this->makeSort($all[$key], $all, $sort, $level++);
            }
        }
    }


}               