<?php

namespace Shop\Domain\PaymentTransaction\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;
use Shop\Repositories\PaymentTransaction\PaymentTransactionCriteria;

/**
 * Description of PaymentTransaction
 *
 * @author Diamond Code Generator
 */
interface PaymentTransactionCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    /**
     * @param string|null $code
     * @return mixed
     */
    public function setFilterByCode(?string $code);

    /**
     * @return string|null
     */
    public function getFilterByCode(): ?string;

    public function setFilterByOrderId(?int $filterByOrderId): PaymentTransactionCriteria;

    public function getFilterByOrderId(): ?int;
}           