<?php

namespace Shop\Domain\City;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\City\Contracts\CityEntityInterface;

/**
 * Description of City
 *
 * @author Diamond Code Generator
 */
class CityCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return CityEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }
}               