<?php


namespace Shop\Application\Office\ChangeCustomerPassword;


use Shop\Repositories\Customer\CustomerRepository;

class ChangeCustomerPasswordHandler
{
    protected $customerRepository;

    /**
     * ChangeCustomerPasswordHandler constructor.
     * @param CustomerRepository $customerRepository
     */
    public function __construct(CustomerRepository $customerRepository)
    {
        $this->customerRepository = $customerRepository;
    }

    /**
     * @param ChangeCustomerPasswordCommand $command
     */
    public function handle(ChangeCustomerPasswordCommand $command): void
    {
        $customer = $command->getCustomer();
        $customer->setPassword(md5($command->getPassword()));
        $this->customerRepository->save($customer);
    }
}