<?php


namespace Shop\Repositories\SizeGrid;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\SizeGrid\SizeGridCollection;
use Shop\Models\SizeGrid\SizeGrid;
use Shop\Models\SizeGrid\SizeGridQuery;

class SizeGridRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new SizeGrid();
    }

    protected function createQuery(): ModelCriteria
    {
        return SizeGridQuery::create();
    }

    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $this->modifyCriteriaForFilterSort($criteria, $dbCriteria);
    }

    public function findByCriteria(PaginationInterface $criteria): CollectionInterface
    {
        $query = $this->createQuery();
        $this->modifyCriteria($criteria, $query);
        $result = $query->paginate($criteria->getPage(), $criteria->getLimit());

        $collection = new SizeGridCollection();

        foreach ($result->getResults() as $row) {
            $collection->push($row);
        }

        return $collection;
    }


    /**
     * @param array $categoryIds
     * @param int $sizeGridId
     * @return bool
     */
    public function addRelationCategories(array $categoryIds, int $sizeGridId): void
    {

        $grid = $this->createQuery()->findPk($sizeGridId);

        $categories = \Shop\Models\Category\CategoryQuery::create()->filterByPrimaryKeys($categoryIds)->find();

        $grid->setCategories($categories);

        $grid->save();
    }
}