<?php

namespace Shop\Models\StateLog\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\State\State;
use Shop\Models\StateLog\StateLog as ChildStateLog;
use Shop\Models\StateLog\StateLogQuery as ChildStateLogQuery;
use Shop\Models\StateLog\Map\StateLogTableMap;

/**
 * Base class that represents a query for the 'shop_state_logs' table.
 *
 *
 *
 * @method     ChildStateLogQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildStateLogQuery orderByDatetime($order = Criteria::ASC) Order by the datetime column
 * @method     ChildStateLogQuery orderByOldStateId($order = Criteria::ASC) Order by the old_state_id column
 * @method     ChildStateLogQuery orderByNewStateId($order = Criteria::ASC) Order by the new_state_id column
 * @method     ChildStateLogQuery orderByObjectId($order = Criteria::ASC) Order by the object_id column
 * @method     ChildStateLogQuery orderByTypeId($order = Criteria::ASC) Order by the type_id column
 *
 * @method     ChildStateLogQuery groupById() Group by the id column
 * @method     ChildStateLogQuery groupByDatetime() Group by the datetime column
 * @method     ChildStateLogQuery groupByOldStateId() Group by the old_state_id column
 * @method     ChildStateLogQuery groupByNewStateId() Group by the new_state_id column
 * @method     ChildStateLogQuery groupByObjectId() Group by the object_id column
 * @method     ChildStateLogQuery groupByTypeId() Group by the type_id column
 *
 * @method     ChildStateLogQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildStateLogQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildStateLogQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildStateLogQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildStateLogQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildStateLogQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildStateLogQuery leftJoinOldState($relationAlias = null) Adds a LEFT JOIN clause to the query using the OldState relation
 * @method     ChildStateLogQuery rightJoinOldState($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OldState relation
 * @method     ChildStateLogQuery innerJoinOldState($relationAlias = null) Adds a INNER JOIN clause to the query using the OldState relation
 *
 * @method     ChildStateLogQuery joinWithOldState($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OldState relation
 *
 * @method     ChildStateLogQuery leftJoinWithOldState() Adds a LEFT JOIN clause and with to the query using the OldState relation
 * @method     ChildStateLogQuery rightJoinWithOldState() Adds a RIGHT JOIN clause and with to the query using the OldState relation
 * @method     ChildStateLogQuery innerJoinWithOldState() Adds a INNER JOIN clause and with to the query using the OldState relation
 *
 * @method     ChildStateLogQuery leftJoinNewState($relationAlias = null) Adds a LEFT JOIN clause to the query using the NewState relation
 * @method     ChildStateLogQuery rightJoinNewState($relationAlias = null) Adds a RIGHT JOIN clause to the query using the NewState relation
 * @method     ChildStateLogQuery innerJoinNewState($relationAlias = null) Adds a INNER JOIN clause to the query using the NewState relation
 *
 * @method     ChildStateLogQuery joinWithNewState($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the NewState relation
 *
 * @method     ChildStateLogQuery leftJoinWithNewState() Adds a LEFT JOIN clause and with to the query using the NewState relation
 * @method     ChildStateLogQuery rightJoinWithNewState() Adds a RIGHT JOIN clause and with to the query using the NewState relation
 * @method     ChildStateLogQuery innerJoinWithNewState() Adds a INNER JOIN clause and with to the query using the NewState relation
 *
 * @method     \Shop\Models\State\StateQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildStateLog findOne(ConnectionInterface $con = null) Return the first ChildStateLog matching the query
 * @method     ChildStateLog findOneOrCreate(ConnectionInterface $con = null) Return the first ChildStateLog matching the query, or a new ChildStateLog object populated from the query conditions when no match is found
 *
 * @method     ChildStateLog findOneById(int $id) Return the first ChildStateLog filtered by the id column
 * @method     ChildStateLog findOneByDatetime(string $datetime) Return the first ChildStateLog filtered by the datetime column
 * @method     ChildStateLog findOneByOldStateId(int $old_state_id) Return the first ChildStateLog filtered by the old_state_id column
 * @method     ChildStateLog findOneByNewStateId(int $new_state_id) Return the first ChildStateLog filtered by the new_state_id column
 * @method     ChildStateLog findOneByObjectId(int $object_id) Return the first ChildStateLog filtered by the object_id column
 * @method     ChildStateLog findOneByTypeId(int $type_id) Return the first ChildStateLog filtered by the type_id column *

 * @method     ChildStateLog requirePk($key, ConnectionInterface $con = null) Return the ChildStateLog by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStateLog requireOne(ConnectionInterface $con = null) Return the first ChildStateLog matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStateLog requireOneById(int $id) Return the first ChildStateLog filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStateLog requireOneByDatetime(string $datetime) Return the first ChildStateLog filtered by the datetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStateLog requireOneByOldStateId(int $old_state_id) Return the first ChildStateLog filtered by the old_state_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStateLog requireOneByNewStateId(int $new_state_id) Return the first ChildStateLog filtered by the new_state_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStateLog requireOneByObjectId(int $object_id) Return the first ChildStateLog filtered by the object_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStateLog requireOneByTypeId(int $type_id) Return the first ChildStateLog filtered by the type_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStateLog[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildStateLog objects based on current ModelCriteria
 * @method     ChildStateLog[]|ObjectCollection findById(int $id) Return ChildStateLog objects filtered by the id column
 * @method     ChildStateLog[]|ObjectCollection findByDatetime(string $datetime) Return ChildStateLog objects filtered by the datetime column
 * @method     ChildStateLog[]|ObjectCollection findByOldStateId(int $old_state_id) Return ChildStateLog objects filtered by the old_state_id column
 * @method     ChildStateLog[]|ObjectCollection findByNewStateId(int $new_state_id) Return ChildStateLog objects filtered by the new_state_id column
 * @method     ChildStateLog[]|ObjectCollection findByObjectId(int $object_id) Return ChildStateLog objects filtered by the object_id column
 * @method     ChildStateLog[]|ObjectCollection findByTypeId(int $type_id) Return ChildStateLog objects filtered by the type_id column
 * @method     ChildStateLog[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class StateLogQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\StateLog\Base\StateLogQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\StateLog\\StateLog', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildStateLogQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildStateLogQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildStateLogQuery) {
            return $criteria;
        }
        $query = new ChildStateLogQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildStateLog|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StateLogTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = StateLogTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildStateLog A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `datetime`, `old_state_id`, `new_state_id`, `object_id`, `type_id` FROM `shop_state_logs` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildStateLog $obj */
            $obj = new ChildStateLog();
            $obj->hydrate($row);
            StateLogTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildStateLog|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(StateLogTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(StateLogTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(StateLogTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(StateLogTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StateLogTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the datetime column
     *
     * Example usage:
     * <code>
     * $query->filterByDatetime('2011-03-14'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime('now'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime(array('max' => 'yesterday')); // WHERE datetime > '2011-03-13'
     * </code>
     *
     * @param     mixed $datetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function filterByDatetime($datetime = null, $comparison = null)
    {
        if (is_array($datetime)) {
            $useMinMax = false;
            if (isset($datetime['min'])) {
                $this->addUsingAlias(StateLogTableMap::COL_DATETIME, $datetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datetime['max'])) {
                $this->addUsingAlias(StateLogTableMap::COL_DATETIME, $datetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StateLogTableMap::COL_DATETIME, $datetime, $comparison);
    }

    /**
     * Filter the query on the old_state_id column
     *
     * Example usage:
     * <code>
     * $query->filterByOldStateId(1234); // WHERE old_state_id = 1234
     * $query->filterByOldStateId(array(12, 34)); // WHERE old_state_id IN (12, 34)
     * $query->filterByOldStateId(array('min' => 12)); // WHERE old_state_id > 12
     * </code>
     *
     * @see       filterByOldState()
     *
     * @param     mixed $oldStateId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function filterByOldStateId($oldStateId = null, $comparison = null)
    {
        if (is_array($oldStateId)) {
            $useMinMax = false;
            if (isset($oldStateId['min'])) {
                $this->addUsingAlias(StateLogTableMap::COL_OLD_STATE_ID, $oldStateId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oldStateId['max'])) {
                $this->addUsingAlias(StateLogTableMap::COL_OLD_STATE_ID, $oldStateId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StateLogTableMap::COL_OLD_STATE_ID, $oldStateId, $comparison);
    }

    /**
     * Filter the query on the new_state_id column
     *
     * Example usage:
     * <code>
     * $query->filterByNewStateId(1234); // WHERE new_state_id = 1234
     * $query->filterByNewStateId(array(12, 34)); // WHERE new_state_id IN (12, 34)
     * $query->filterByNewStateId(array('min' => 12)); // WHERE new_state_id > 12
     * </code>
     *
     * @see       filterByNewState()
     *
     * @param     mixed $newStateId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function filterByNewStateId($newStateId = null, $comparison = null)
    {
        if (is_array($newStateId)) {
            $useMinMax = false;
            if (isset($newStateId['min'])) {
                $this->addUsingAlias(StateLogTableMap::COL_NEW_STATE_ID, $newStateId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($newStateId['max'])) {
                $this->addUsingAlias(StateLogTableMap::COL_NEW_STATE_ID, $newStateId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StateLogTableMap::COL_NEW_STATE_ID, $newStateId, $comparison);
    }

    /**
     * Filter the query on the object_id column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectId(1234); // WHERE object_id = 1234
     * $query->filterByObjectId(array(12, 34)); // WHERE object_id IN (12, 34)
     * $query->filterByObjectId(array('min' => 12)); // WHERE object_id > 12
     * </code>
     *
     * @param     mixed $objectId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function filterByObjectId($objectId = null, $comparison = null)
    {
        if (is_array($objectId)) {
            $useMinMax = false;
            if (isset($objectId['min'])) {
                $this->addUsingAlias(StateLogTableMap::COL_OBJECT_ID, $objectId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($objectId['max'])) {
                $this->addUsingAlias(StateLogTableMap::COL_OBJECT_ID, $objectId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StateLogTableMap::COL_OBJECT_ID, $objectId, $comparison);
    }

    /**
     * Filter the query on the type_id column
     *
     * Example usage:
     * <code>
     * $query->filterByTypeId(1234); // WHERE type_id = 1234
     * $query->filterByTypeId(array(12, 34)); // WHERE type_id IN (12, 34)
     * $query->filterByTypeId(array('min' => 12)); // WHERE type_id > 12
     * </code>
     *
     * @param     mixed $typeId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function filterByTypeId($typeId = null, $comparison = null)
    {
        if (is_array($typeId)) {
            $useMinMax = false;
            if (isset($typeId['min'])) {
                $this->addUsingAlias(StateLogTableMap::COL_TYPE_ID, $typeId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($typeId['max'])) {
                $this->addUsingAlias(StateLogTableMap::COL_TYPE_ID, $typeId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StateLogTableMap::COL_TYPE_ID, $typeId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\State\State object
     *
     * @param \Shop\Models\State\State|ObjectCollection $state The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildStateLogQuery The current query, for fluid interface
     */
    public function filterByOldState($state, $comparison = null)
    {
        if ($state instanceof \Shop\Models\State\State) {
            return $this
                ->addUsingAlias(StateLogTableMap::COL_OLD_STATE_ID, $state->getId(), $comparison);
        } elseif ($state instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(StateLogTableMap::COL_OLD_STATE_ID, $state->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByOldState() only accepts arguments of type \Shop\Models\State\State or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OldState relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function joinOldState($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OldState');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OldState');
        }

        return $this;
    }

    /**
     * Use the OldState relation State object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\State\StateQuery A secondary query class using the current class as primary query
     */
    public function useOldStateQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOldState($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OldState', '\Shop\Models\State\StateQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\State\State object
     *
     * @param \Shop\Models\State\State|ObjectCollection $state The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildStateLogQuery The current query, for fluid interface
     */
    public function filterByNewState($state, $comparison = null)
    {
        if ($state instanceof \Shop\Models\State\State) {
            return $this
                ->addUsingAlias(StateLogTableMap::COL_NEW_STATE_ID, $state->getId(), $comparison);
        } elseif ($state instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(StateLogTableMap::COL_NEW_STATE_ID, $state->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByNewState() only accepts arguments of type \Shop\Models\State\State or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the NewState relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function joinNewState($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('NewState');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'NewState');
        }

        return $this;
    }

    /**
     * Use the NewState relation State object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\State\StateQuery A secondary query class using the current class as primary query
     */
    public function useNewStateQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinNewState($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'NewState', '\Shop\Models\State\StateQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildStateLog $stateLog Object to remove from the list of results
     *
     * @return $this|ChildStateLogQuery The current query, for fluid interface
     */
    public function prune($stateLog = null)
    {
        if ($stateLog) {
            $this->addUsingAlias(StateLogTableMap::COL_ID, $stateLog->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_state_logs table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StateLogTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            StateLogTableMap::clearInstancePool();
            StateLogTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StateLogTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(StateLogTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            StateLogTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            StateLogTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // StateLogQuery
