<?php

namespace Shop\Modules\AdminGuests;

use Shop\Domain\CustomerGroup\CustomerGroupCollection;
use Shop\Modules\AdminClients\AdminClients;
use Shop\Repositories\Customer\CustomerCriteria;

/**
 * Description of AdminClients
 *
 * @author Diamond Code Generator
 */
class AdminGuests extends AdminClients
{
    /**
     * @param CustomerGroupCollection $customerGroups
     * @param CustomerGroupCollection $customerGroupsCollection
     * @return CustomerCriteria
     */
    protected function prepareCustomerCriteria(CustomerGroupCollection $customerGroups,
                                               CustomerGroupCollection $customerGroupsCollection): CustomerCriteria
    {
        $filterGroupIds = [];
        foreach ($customerGroupsCollection as $group) {

            if ($group->getId() !== $this->mainConfig->getDefaultGuestGroup()) {

                $customerGroups->offsetUnset($group);
                continue;
            }
            $filterGroupIds[] = $group->getId();
        }
        return CustomerCriteria::create()->setFilterByGroupIds($filterGroupIds);
    }

}