<?php


namespace Shop\Repositories\Manager;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Manager\Contracts\ManagerCriteriaInterface;

class ManagerCriteria extends AbstractCriteria implements ManagerCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $sortByName;

    /**
     * @var int|null
     */
    protected $filterByStockId;

    /**
     * @var string|null
     */
    protected $filterByEmail;

    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @var string|null
     */
    protected $searchByEmail;

    /**
     * @var bool|null
     */
    protected $filterByActiveStock;

    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getSearchByEmail(): ?string
    {
        return $this->searchByEmail;
    }

    /**
     * @param string|null $searchByEmail
     * @return ManagerCriteria
     */
    public function setSearchByEmail(?string $searchByEmail): ManagerCriteria
    {
        $this->searchByEmail = $searchByEmail;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return ManagerCriteria
     */
    public function setSearchByName(?string $searchByName): ManagerCriteriaInterface
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByEmail(): ?string
    {
        return $this->filterByEmail;
    }

    /**
     * @param string|null $filterByEmail
     * @return ManagerCriteria
     */
    public function setFilterByEmail(?string $filterByEmail): ManagerCriteriaInterface
    {
        $this->filterByEmail = $filterByEmail;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getFilterByActiveStock(): ?bool
    {
        return $this->filterByActiveStock;
    }

    /**
     * @param bool|null $filterByActiveStock
     * @return ManagerCriteria
     */
    public function setFilterByActiveStock(?bool $filterByActiveStock): ManagerCriteriaInterface
    {
        $this->filterByActiveStock = $filterByActiveStock;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    /**
     * @param string|null $sortByName
     * @return ManagerCriteria
     */
    public function setSortByName(?string $sortByName): ManagerCriteriaInterface
    {
        $this->sortByName = $sortByName;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByStockId():?int
    {
        return $this->filterByStockId;
    }

    /**
     * @param int|null $filterByStockId
     * @return $this
     */
    public function setFilterByStockId(?int $filterByStockId): ManagerCriteriaInterface
    {
        $this->filterByStockId = $filterByStockId;
        return $this;
    }

}