<?php

namespace Shop;

use Aura\Auth\Service\ResumeService;
use Core\Concrete\AuthFactory;
use Diamond\Config\Main;
use Diamond\Helpers\Url;
use League\Container\ServiceProvider\AbstractServiceProvider;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\Storage\NativeSessionStorage;


/**
 * Description of SystemServiceProvider
 *
 * @author Dmitriy
 */
class ServiceProvider extends AbstractServiceProvider
{

    protected $provides = [
        'shop.views_path',
        \Core\Basket\Basket::class,
        "CurrentCustomer",
        \Diamond\Services\Mailing::class,
        \Shop\Config\Main::class,
        \Shop\Config\Payment::class,
        \Shop\Config\Sms::class
    ];

    public function register()
    {
        $this->getContainer()->share(\Shop\Config\Main::class);
        $this->getContainer()->share(\Shop\Config\Payment::class);
        $this->getContainer()->share(\Shop\Config\Sms::class);


        $this->getContainer()->add('shop.views_path', function () {
            return __DIR__ . '/../views/';
        });

        /**
         * set Debug bar
         */
        $this->getContainer()->add(Session::class, function () {
            $lifetime = $this->getContainer()->get(Main::class)->getSessionLife();
            if (!$lifetime) {
                $lifetime = 1;//час
            }
            session_set_cookie_params($lifetime * 60 * 60);

            return new Session(
                new NativeSessionStorage([
                    //"cache_expire" => $lifetime*10*60*60,
                   // "cookie_domain"=>   Url::createQookieMainDomain(),
                    "cookie_lifetime" => $lifetime * 60 * 60,
                    "gc_maxlifetime" => $lifetime * 60 * 60
                ])
            );
        }, true);

        $this->getContainer()->add(\Shop\Services\Auth::class, null, true)
            ->addArgument($this->getContainer()->get(AuthFactory::class))
            ->addArgument($this->getContainer()->get(\Diamond\Config\Main::class));

        $this->getContainer()->add(\Core\Basket\Basket::class, null, true)
            ->addArgument($this->getContainer()->get(Session::class));

        $this->getContainer()->add(\Diamond\Services\Mailing::class)
            ->addArgument($this->getContainer()->get(\Diamond\Repositories\MailingSubscriber::class))
            ->addArgument($this->getContainer()->get(Services\Customer::class))
            ->addArgument($this->getContainer()->get(\Diamond\Repositories\Mailing::class))
            ->addArgument($this->getContainer()->get(\Diamond\Services\Notify::class))
            ->addArgument($this->getContainer()->get(\Diamond\Config\Main::class));


        $this->getContainer()
            ->inflector(Contracts\ShopCurrentInterface::class)
            ->invokeMethod('setShopByAuthUserService', [Concrete\ShopByAuthUser::class]);


    }
}
