<?php
namespace Shop\Repositories\Shop;

use Shop\Repositories\AbstractCriteria;

class ShopCriteria extends AbstractCriteria
{

    /**
     * @var int|null
     */
    protected $filterByParentId;

    /**
     * @var string|null
     */
    protected $filterByType;

    /**
     * @return int|null
     */
    public function getFilterByParentId(): ?int
    {
        return $this->filterByParentId;
    }

    /**
     * @param int|null $filterByParentId
     * @return ShopCriteria
     */
    public function setFilterByParentId(?int $filterByParentId): ShopCriteria
    {
        $this->filterByParentId = $filterByParentId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByType(): ?string
    {
        return $this->filterByType;
    }

    /**
     * @param string|null $filterByType
     * @return ShopCriteria
     */
    public function setFilterByType(?string $filterByType): ShopCriteria
    {
        $this->filterByType = $filterByType;
        return $this;
    }

    /**
     * @return ShopCriteria
     */
    public static function create()
    {
        return new self;
    }

}