<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Score\Score as ScoreEntity;
use Shop\Models\Score\ScoreQuery;

/**
 * Description of Score
 *
 * @author Admin
 */
class Score extends PropelQueryAbstract implements CrudInterface
{

    public function buildQuery()
    {
        return ScoreQuery ::create();
    }

    public function buildEntity()
    {
        return new ScoreEntity;
    }

    /**
     * 
     * @param type $id
     * @return int
     */
    public function calculateByCustomerId($id): int
    {
        $scores = $this->buildQuery()
                ->addAsColumn('summ', 'SUM(score)')
                ->filterBycustomerId($id)
                ->findOne();
        return (int) $scores->getVirtualColumn("summ");
    }

}