<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\Collection\ObjectCollection;
use Shop\Models\Sale\Sale as SaleEntity;
use Shop\Models\Sale\SaleQuery;


/**
 * Description of Sale
 *
 * @author Admin
 */
class Sale extends PropelQueryAbstract implements CrudInterface, \Core\Repository\DropdownInreface{

    public function buildQuery(){
	return SaleQuery ::create();
    }

    public function buildEntity(){
	return new SaleEntity;
    }
    
    /**
     * получение списка
     * @return type
     */
    public function getDropdownList(){
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id', 'name');
    }    
   
}
