<?

namespace Shop\Repositories\Product;

use Shop\Repositories\AbstractCriteria;

/**
 * Description of ProductCriteria
 *
 * @author Admin
 */
class ProductCriteria extends  AbstractCriteria
{

    /**
     * @var array
     */
    protected $filterByBrandNames = [];

    /**
     *
     * @var bool
     */
    protected $filterByNewGoodDays = false;

    /**
     *
     * @var int|null
     */
    protected $newGoodDays;


    /**
     *
     * @var string|null
     */
    protected $sortedByDateCreate;


    /**
     *
     * @var string|null
     */
    protected $sortedByDateUpdate;

    /**
     * @var string|null
     */
    protected $sortedByPrice;

    /**
     *
     * @var string
     */
    protected $searchByName;


    /**
     *
     * @var \DateTime
     */
    protected $filterByDateCreate;


    /**
     * @var \DateTime
     */
    protected $filterByDateUpdate;

    /**
     *
     * @var bool
     */
    protected $sortedRandom = false;


    /**
     *
     * @var bool
     */
    protected $filterByRemains = false;


    /**
     *
     * @var bool
     */
    protected $filterByPopular = false;


    /**
     * @var bool
     */
    protected $filterByImageExist = false;


    /**
     *
     * @var int|null
     */
    protected $filterByCategoryId;

    /**
     *
     * @var int|null
     */
    protected $filterByBrandId;


    /**
     * @var array
     */
    protected $filterByPriceListScheetIds;

    /**
     * @var bool|null
     */
    protected $filterBySpecial;

    /**
     * @var bool|null
     */
    protected $filterByActive;

    /**
     * @var array|null
     */
    protected $filterByweights;

    /**
     * @return array|null
     */
    public function getFilterByweights(): ?array
    {
        return $this->filterByweights;
    }

    /**
     * @param array|null $filterByweights
     * @return ProductCriteria
     */
    public function setFilterByweights(?array $filterByweights): ProductCriteria
    {
        $this->filterByweights = $filterByweights;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSortedByPrice(): ?string
    {
        return $this->sortedByPrice;
    }

    /**
     * @param string|null $sortedByPrice
     * @return ProductCriteria
     */
    public function setSortedByPrice(?string $sortedByPrice): ProductCriteria
    {
        $this->sortedByPrice = $sortedByPrice;
        return $this;
    }



    /**
     * @return \DateTime
     */
    public function getFilterByDateUpdate(): ?\DateTime
    {
        return $this->filterByDateUpdate;
    }

    /**
     * @param \DateTime $filterByDateUpdate
     * @return ProductCriteria
     */
    public function setFilterByDateUpdate(\DateTime $filterByDateUpdate): ProductCriteria
    {
        $this->filterByDateUpdate = $filterByDateUpdate;
        return $this;
    }


    /**
     * @return bool
     */
    public function getFilterByActive():? bool
    {
        return $this->filterByActive;
    }

    /**
     * @param bool $filterByActive
     * @return ProductCriteria
     */
    public function setFilterByActive(?bool $filterByActive): ProductCriteria
    {
        $this->filterByActive = $filterByActive;
        return $this;
    }


    /**
     * @return bool
     */
    public function getFilterBySpecial(): ?bool
    {
        return $this->filterBySpecial;
    }

    /**
     * @param bool $filterBySpecial
     * @return ProductCriteria
     */
    public function setFilterBySpecial(?bool $filterBySpecial): ProductCriteria
    {
        $this->filterBySpecial = $filterBySpecial;
        return $this;
    }



    /**
     * @return string|null
     */
    public function getSortedByDateUpdate(): ?string
    {
        return $this->sortedByDateUpdate;
    }

    /**
     * @param string|null $sortedByDateUpdate
     * @return ProductCriteria
     */
    public function setSortedByDateUpdate(?string $sortedByDateUpdate): ProductCriteria
    {
        $this->sortedByDateUpdate = $sortedByDateUpdate;
        return $this;
    }


    /**
     * @return array
     */
    public function getFilterByBrandNames()
    {
        return $this->filterByBrandNames;
    }

    /**
     * @param array $filterByBrandNames
     * @return ProductCriteria
     */
    public function setFilterByBrandNames($filterByBrandNames)
    {
        $this->filterByBrandNames = $filterByBrandNames;
        return $this;
    }


    function getFilterByNewGoodDays(): bool
    {
        return $this->filterByNewGoodDays;
    }

    function setFilterByNewGoodDays(bool $filterByNewGoodDays)
    {
        $this->filterByNewGoodDays = $filterByNewGoodDays;
        return $this;
    }


    function getNewGoodDays()
    {
        return $this->newGoodDays;
    }

    function setNewGoodDays($newGoodDays)
    {
        $this->newGoodDays = $newGoodDays;
        return $this;
    }

    function getSortedByDateCreate()
    {
        return $this->sortedByDateCreate;
    }

    function setSortedByDateCreate($sortedByDateCreate)
    {
        $this->sortedByDateCreate = $sortedByDateCreate;
        return $this;
    }


    function getSearchByName()
    {
        return $this->searchByName;
    }

    function setSearchByName($searchByName)
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    function getFilterByDateCreate()
    {
        return $this->filterByDateCreate;
    }

    function setFilterByDateCreate($filterByDateCreate)
    {
        $this->filterByDateCreate = $filterByDateCreate;
        return $this;
    }


    public function getSortedRandom(): bool
    {
        return $this->sortedRandom;
    }

    public function setSortedRandom(bool $useRandomSort)
    {
        $this->sortedRandom = $useRandomSort;
        return $this;
    }

    public function getFilterByRemains(): bool
    {
        return $this->filterByRemains;
    }

    public function setFilterByRemains(bool $filterByRemains)
    {
        $this->filterByRemains = $filterByRemains;
        return $this;
    }

    public function getFilterByPopular(): bool
    {
        return $this->filterByPopular;
    }

    public function setFilterByPopular(bool $filterByPopular)
    {
        $this->filterByPopular = $filterByPopular;
        return $this;
    }


    public function getFilterByPriceListScheetIds():?array
    {

        return $this->filterByPriceListScheetIds;
    }

    public function setFilterByPriceListScheetIds(?array $filter)
    {

        $this->filterByPriceListScheetIds = $filter;

        return $this;
    }

    public function getFilterByImageExist(): bool
    {

        return $this->filterByImageExist;
    }

    public function setFilterByImageExist(bool $filter)
    {

        $this->filterByImageExist = $filter;

        return $this;
    }


    function getFilterByCategoryId()
    {
        return $this->filterByCategoryId;
    }

    function getFilterByBrandId()
    {
        return $this->filterByBrandId;
    }


    function setFilterByCategoryId($filterByCategoryId)
    {
        $this->filterByCategoryId = $filterByCategoryId;
        return $this;
    }

    function setFilterByBrandId($filterByBrandId)
    {
        $this->filterByBrandId = $filterByBrandId;
        return $this;
    }

    /**
     * @return ProductCriteria
     */
    public static function create()
    {
        return new self;
    }


}