<?php

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\DropdownInreface;
use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\ActiveQuery\Criteria;
use Shop\Models\PricelistSheet\PricelistSheet as PricelistSheetEntity;
use Shop\Models\PricelistSheet\PricelistSheetQuery;

/**
 * Description of Brand
 *
 * @author Dmitriy
 */
class PricelistSheet extends PropelQueryAbstract implements CrudInterface, DropdownInreface,
        \Shop\Contracts\ShopCurrentInterface
{

    use \Shop\Concrete\ShopAuthUserTrait;
    
    public function buildEntity()
    {
        return new PricelistSheetEntity;
    }

    public function buildQuery()
    {
        return PricelistSheetQuery::create()
                ->_if($this->curShop)
                    ->usePricelistFileQuery()
                        ->useProviderQuery()
                            ->filterByShop($this->curShop)
                        ->endUse()
                    ->endUse()
                ->_endif();
    }

    public function getDropdownList()
    {
        return $this->buildQuery()
                        ->orderByTitle()
                        ->find()
                        ->toKeyValue('id', 'title');
    }

    
    public function getDropdownListCur(){
        return $this->buildQuery()
                        ->orderByTitle()
                        ->find()
                        ->toKeyValue('id', 'titleWithCur');
    }

}