<?php

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Position\Position as PositionEntity;
use Shop\Models\Position\PositionQuery;

/**
 * Description of Bonus
 *
 * @author Dmitriy
 */
class Position extends PropelQueryAbstract implements CrudInterface, \Shop\Contracts\ShopCurrentInterface
{
    use \Shop\Concrete\ShopAuthUserTrait;

    public function buildQuery()
    {
        return PositionQuery::create()
                ->_if($this->curShop)
                    ->usePricelistSheetQuery()
                        ->usePricelistFileQuery()
                            ->useProviderQuery()
                                ->filterByShop($this->curShop)
                            ->endUse()
                        ->endUse()
                    ->endUse()
                ->_endif()
                ;
    }


    /**
     * 
     * @return PositionEntity
     */
    public function buildEntity()
    {
        return new PositionEntity;
    }

    /**
     * 
     * @param type $id
     * @return PositionEntity
     */
    public function findByRefId($id)
    {
        return $this->buildQuery()->withComplexRate()->findOneByRefId($id);
    }

    public function findById($id){
	return $this->buildQuery()->withComplexRate()->findPk($id);
    }    
}