<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\DropdownInreface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\OrderItem\OrderItemQuery;
use Shop\Models\OrderItem\OrderItem as OrderItemEntity;

/**
 * Description of Payment
 *
 * @author Admin
 */
class OrderItem extends PropelQueryAbstract implements CrudInterface, DropdownInreface
{

    public function buildEntity()
    {
        return new OrderItemEntity;
    }

    public function buildQuery()
    {
        return OrderItemQuery::create();
    }

    public function getDropdownList(){
	return $this->buildQuery()
		->find()
		->toKeyValue('id','title');
    }

    /**
     * 
     * @param type $id
     * @return OrderEntity
     */
    public function findById($id){
        return parent::findById($id);
    }
}