<?

namespace Shop\Modules\LastOrdersWidget;

/**
 * Description of LastOrdersWidget
 *
 * @author Diamond Code Generator
 */
class LastOrdersWidget extends \Core\ModuleController
{

    protected $orderRepo;
    protected $mainConf;
    protected $shopService;

    use \Shop\Modules\Traits\FormatterTrait;
    
    function __construct(\Shop\Repositories\Order $orderRepo, \Shop\Config\Main $mainConf,
                         \Shop\Services\Shop $shopService)
    {
        $this->orderRepo   = $orderRepo;
        $this->mainConf    = $mainConf;
        $this->shopService = $shopService;
    }

    public function process()
    {

        $table = new \Core\Table\PropelDataTable($this->orderRepo->setSelectFilter([$this, "prepareQuery"]));

        $table
                ->setBottomPanel(false)
                ->setLimit(8)
                ->addColumn((new \Core\Table\Column("orderCode", "Номер заказа"))->setFn([$this, "columnCode"]))
                ->addColumn((new \Core\Table\Column("datetime", "Дата заказа"))->setFn([$this, "columnDateTime"]))
                ->addColumn((new \Core\Table\Column("customer", "Клиент/Группа клиента"))->setFn([$this, "formatCustomer"]))
                ->addColumn((new \Core\Table\Column("discount", "Скидка," . $this->mainConf->getCurencyDisplay(), 50))
                        ->setFn($this, "formatDiscount"))
                ->addColumn((new \Core\Table\Column("orderFinalSumm",
                                                    "Сумма заказа, " . $this->mainConf->getCurencyDisplay()))->setFn($this,
                                                                                                                     "formatSumm"))
                ->addColumn(new \Core\Table\Column("itemsCount", "Товаров"))
                ->addColumn((new \Core\Table\Column("state", "Состояние"))->setFn([$this, "columnState"]))
        ;

        return $this->render([
                    "table" => $table->Render()
        ]);
    }

    /**
     * 
     * @param \Shop\Models\Order\Order $order
     * @return int
     */
    public function formatSumm(\Shop\Models\Order\Order $order)
    {
        return \Shop\Helpers\Price::format($order->getOrderFinalSumm());
    }

    /**
     * 
     * @param \Shop\Models\Order\Order $order
     * @return int
     */
    public function formatDiscount(\Shop\Models\Order\Order $order)
    {
        return sprintf(
                "%s (%s)", \Shop\Helpers\Price::format($order->getDiscountSumm()), $order->getDiscountPercent() . '%'
        );
    }

    /**
     * 
     * @param \Shop\Models\Order\OrderQuery $query
     * @return type
     */
    public function prepareQuery(\Shop\Models\Order\OrderQuery $query)
    {
        return $query
                        ->orderById(\Propel\Runtime\ActiveQuery\Criteria::DESC)
                        ->filterByStateId($this->mainConf->getStateDefault())
        ;
    }

    /**
     * 
     * @param \Shop\Models\Order\Order $order
     * @return string
     */
    public function columnDateTime(\Shop\Models\Order\Order $order)
    {
        return $order->getDatetime(\Diamond\Helpers\Date::formatDisplay());
    }

    

    /**
     * 
     * @param \Shop\Models\Order\Order $order
     * @return string
     */
    public function columnState(\Shop\Models\Order\Order $order)
    {
        return \Shop\Helpers\State::formatColor($order->getState());
    }

    /**
     * 
     * @param \Shop\Models\Order\Order $order
     * @return string
     */
    public function columnCode(\Shop\Models\Order\Order $order)
    {
        return anchor("/admin/shop/orders", $order->getOrderCode(), [], ["id" => $order->getId()]);
    }

}