<?php

namespace Shop\Models\OrderItem\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Models\OrderItem\OrderItem;
use Shop\Models\OrderItem\OrderItemQuery;


/**
 * This class defines the structure of the 'shop_order_items' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 */
class OrderItemTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.OrderItem.Map.OrderItemTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'shop_order_items';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Shop\\Models\\OrderItem\\OrderItem';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.OrderItem.OrderItem';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 12;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 12;

    /**
     * the column name for the id field
     */
    const COL_ID = 'shop_order_items.id';

    /**
     * the column name for the order_id field
     */
    const COL_ORDER_ID = 'shop_order_items.order_id';

    /**
     * the column name for the name field
     */
    const COL_NAME = 'shop_order_items.name';

    /**
     * the column name for the brand field
     */
    const COL_BRAND = 'shop_order_items.brand';

    /**
     * the column name for the article field
     */
    const COL_ARTICLE = 'shop_order_items.article';

    /**
     * the column name for the desc field
     */
    const COL_DESC = 'shop_order_items.desc';

    /**
     * the column name for the price field
     */
    const COL_PRICE = 'shop_order_items.price';

    /**
     * the column name for the amount field
     */
    const COL_AMOUNT = 'shop_order_items.amount';

    /**
     * the column name for the menager_comment field
     */
    const COL_MENAGER_COMMENT = 'shop_order_items.menager_comment';

    /**
     * the column name for the destination field
     */
    const COL_DESTINATION = 'shop_order_items.destination';

    /**
     * the column name for the ref_id field
     */
    const COL_REF_ID = 'shop_order_items.ref_id';

    /**
     * the column name for the crrency_id field
     */
    const COL_CRRENCY_ID = 'shop_order_items.crrency_id';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'OrderId', 'Name', 'Brand', 'Article', 'Desc', 'Price', 'Amount', 'menagerComment', 'Destination', 'RefId', 'CurrencyId', ),
        self::TYPE_CAMELNAME     => array('id', 'orderId', 'name', 'brand', 'article', 'desc', 'price', 'amount', 'menagerComment', 'destination', 'refId', 'currencyId', ),
        self::TYPE_COLNAME       => array(OrderItemTableMap::COL_ID, OrderItemTableMap::COL_ORDER_ID, OrderItemTableMap::COL_NAME, OrderItemTableMap::COL_BRAND, OrderItemTableMap::COL_ARTICLE, OrderItemTableMap::COL_DESC, OrderItemTableMap::COL_PRICE, OrderItemTableMap::COL_AMOUNT, OrderItemTableMap::COL_MENAGER_COMMENT, OrderItemTableMap::COL_DESTINATION, OrderItemTableMap::COL_REF_ID, OrderItemTableMap::COL_CRRENCY_ID, ),
        self::TYPE_FIELDNAME     => array('id', 'order_id', 'name', 'brand', 'article', 'desc', 'price', 'amount', 'menager_comment', 'destination', 'ref_id', 'crrency_id', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'OrderId' => 1, 'Name' => 2, 'Brand' => 3, 'Article' => 4, 'Desc' => 5, 'Price' => 6, 'Amount' => 7, 'menagerComment' => 8, 'Destination' => 9, 'RefId' => 10, 'CurrencyId' => 11, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'orderId' => 1, 'name' => 2, 'brand' => 3, 'article' => 4, 'desc' => 5, 'price' => 6, 'amount' => 7, 'menagerComment' => 8, 'destination' => 9, 'refId' => 10, 'currencyId' => 11, ),
        self::TYPE_COLNAME       => array(OrderItemTableMap::COL_ID => 0, OrderItemTableMap::COL_ORDER_ID => 1, OrderItemTableMap::COL_NAME => 2, OrderItemTableMap::COL_BRAND => 3, OrderItemTableMap::COL_ARTICLE => 4, OrderItemTableMap::COL_DESC => 5, OrderItemTableMap::COL_PRICE => 6, OrderItemTableMap::COL_AMOUNT => 7, OrderItemTableMap::COL_MENAGER_COMMENT => 8, OrderItemTableMap::COL_DESTINATION => 9, OrderItemTableMap::COL_REF_ID => 10, OrderItemTableMap::COL_CRRENCY_ID => 11, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'order_id' => 1, 'name' => 2, 'brand' => 3, 'article' => 4, 'desc' => 5, 'price' => 6, 'amount' => 7, 'menager_comment' => 8, 'destination' => 9, 'ref_id' => 10, 'crrency_id' => 11, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('shop_order_items');
        $this->setPhpName('OrderItem');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Models\\OrderItem\\OrderItem');
        $this->setPackage('Models.OrderItem');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addForeignKey('order_id', 'OrderId', 'INTEGER', 'shop_orders', 'id', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', false, 100, null);
        $this->addColumn('brand', 'Brand', 'VARCHAR', false, 100, null);
        $this->addColumn('article', 'Article', 'VARCHAR', false, 50, null);
        $this->addColumn('desc', 'Desc', 'VARCHAR', false, 255, null);
        $this->addColumn('price', 'Price', 'DECIMAL', false, 19, 0);
        $this->addColumn('amount', 'Amount', 'INTEGER', true, null, null);
        $this->addColumn('menager_comment', 'menagerComment', 'LONGVARCHAR', false, null, null);
        $this->addColumn('destination', 'Destination', 'VARCHAR', false, 255, null);
        $this->addColumn('ref_id', 'RefId', 'CHAR', false, 100, null);
        $this->addForeignKey('crrency_id', 'CurrencyId', 'INTEGER', 'shop_currencies', 'id', true, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Order', '\\Shop\\Models\\Order\\Order', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':order_id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
        $this->addRelation('Currency', '\\Shop\\Models\\Currency\\Currency', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':crrency_id',
    1 => ':id',
  ),
), null, null, null, false);
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? OrderItemTableMap::CLASS_DEFAULT : OrderItemTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (OrderItem object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = OrderItemTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = OrderItemTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + OrderItemTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = OrderItemTableMap::OM_CLASS;
            /** @var OrderItem $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            OrderItemTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = OrderItemTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = OrderItemTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var OrderItem $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                OrderItemTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(OrderItemTableMap::COL_ID);
            $criteria->addSelectColumn(OrderItemTableMap::COL_ORDER_ID);
            $criteria->addSelectColumn(OrderItemTableMap::COL_NAME);
            $criteria->addSelectColumn(OrderItemTableMap::COL_BRAND);
            $criteria->addSelectColumn(OrderItemTableMap::COL_ARTICLE);
            $criteria->addSelectColumn(OrderItemTableMap::COL_DESC);
            $criteria->addSelectColumn(OrderItemTableMap::COL_PRICE);
            $criteria->addSelectColumn(OrderItemTableMap::COL_AMOUNT);
            $criteria->addSelectColumn(OrderItemTableMap::COL_MENAGER_COMMENT);
            $criteria->addSelectColumn(OrderItemTableMap::COL_DESTINATION);
            $criteria->addSelectColumn(OrderItemTableMap::COL_REF_ID);
            $criteria->addSelectColumn(OrderItemTableMap::COL_CRRENCY_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.order_id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.brand');
            $criteria->addSelectColumn($alias . '.article');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.price');
            $criteria->addSelectColumn($alias . '.amount');
            $criteria->addSelectColumn($alias . '.menager_comment');
            $criteria->addSelectColumn($alias . '.destination');
            $criteria->addSelectColumn($alias . '.ref_id');
            $criteria->addSelectColumn($alias . '.crrency_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(OrderItemTableMap::DATABASE_NAME)->getTable(OrderItemTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(OrderItemTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(OrderItemTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new OrderItemTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a OrderItem or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or OrderItem object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderItemTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Models\OrderItem\OrderItem) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(OrderItemTableMap::DATABASE_NAME);
            $criteria->add(OrderItemTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = OrderItemQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            OrderItemTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                OrderItemTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_order_items table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return OrderItemQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a OrderItem or Criteria object.
     *
     * @param mixed               $criteria Criteria or OrderItem object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderItemTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from OrderItem object
        }

        if ($criteria->containsKey(OrderItemTableMap::COL_ID) && $criteria->keyContainsValue(OrderItemTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.OrderItemTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = OrderItemQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // OrderItemTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
OrderItemTableMap::buildTableMap();
