<?php

namespace Shop\Models\OrderItem\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Currency\Currency;
use Shop\Models\Order\Order;
use Shop\Models\OrderItem\OrderItem as ChildOrderItem;
use Shop\Models\OrderItem\OrderItemQuery as ChildOrderItemQuery;
use Shop\Models\OrderItem\Map\OrderItemTableMap;

/**
 * Base class that represents a query for the 'shop_order_items' table.
 *
 *
 *
 * @method     ChildOrderItemQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildOrderItemQuery orderByOrderId($order = Criteria::ASC) Order by the order_id column
 * @method     ChildOrderItemQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildOrderItemQuery orderByBrand($order = Criteria::ASC) Order by the brand column
 * @method     ChildOrderItemQuery orderByArticle($order = Criteria::ASC) Order by the article column
 * @method     ChildOrderItemQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildOrderItemQuery orderByPrice($order = Criteria::ASC) Order by the price column
 * @method     ChildOrderItemQuery orderByAmount($order = Criteria::ASC) Order by the amount column
 * @method     ChildOrderItemQuery orderBymenagerComment($order = Criteria::ASC) Order by the menager_comment column
 * @method     ChildOrderItemQuery orderByDestination($order = Criteria::ASC) Order by the destination column
 * @method     ChildOrderItemQuery orderByRefId($order = Criteria::ASC) Order by the ref_id column
 * @method     ChildOrderItemQuery orderByCurrencyId($order = Criteria::ASC) Order by the crrency_id column
 *
 * @method     ChildOrderItemQuery groupById() Group by the id column
 * @method     ChildOrderItemQuery groupByOrderId() Group by the order_id column
 * @method     ChildOrderItemQuery groupByName() Group by the name column
 * @method     ChildOrderItemQuery groupByBrand() Group by the brand column
 * @method     ChildOrderItemQuery groupByArticle() Group by the article column
 * @method     ChildOrderItemQuery groupByDesc() Group by the desc column
 * @method     ChildOrderItemQuery groupByPrice() Group by the price column
 * @method     ChildOrderItemQuery groupByAmount() Group by the amount column
 * @method     ChildOrderItemQuery groupBymenagerComment() Group by the menager_comment column
 * @method     ChildOrderItemQuery groupByDestination() Group by the destination column
 * @method     ChildOrderItemQuery groupByRefId() Group by the ref_id column
 * @method     ChildOrderItemQuery groupByCurrencyId() Group by the crrency_id column
 *
 * @method     ChildOrderItemQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildOrderItemQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildOrderItemQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildOrderItemQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildOrderItemQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildOrderItemQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildOrderItemQuery leftJoinOrder($relationAlias = null) Adds a LEFT JOIN clause to the query using the Order relation
 * @method     ChildOrderItemQuery rightJoinOrder($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Order relation
 * @method     ChildOrderItemQuery innerJoinOrder($relationAlias = null) Adds a INNER JOIN clause to the query using the Order relation
 *
 * @method     ChildOrderItemQuery joinWithOrder($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Order relation
 *
 * @method     ChildOrderItemQuery leftJoinWithOrder() Adds a LEFT JOIN clause and with to the query using the Order relation
 * @method     ChildOrderItemQuery rightJoinWithOrder() Adds a RIGHT JOIN clause and with to the query using the Order relation
 * @method     ChildOrderItemQuery innerJoinWithOrder() Adds a INNER JOIN clause and with to the query using the Order relation
 *
 * @method     ChildOrderItemQuery leftJoinCurrency($relationAlias = null) Adds a LEFT JOIN clause to the query using the Currency relation
 * @method     ChildOrderItemQuery rightJoinCurrency($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Currency relation
 * @method     ChildOrderItemQuery innerJoinCurrency($relationAlias = null) Adds a INNER JOIN clause to the query using the Currency relation
 *
 * @method     ChildOrderItemQuery joinWithCurrency($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Currency relation
 *
 * @method     ChildOrderItemQuery leftJoinWithCurrency() Adds a LEFT JOIN clause and with to the query using the Currency relation
 * @method     ChildOrderItemQuery rightJoinWithCurrency() Adds a RIGHT JOIN clause and with to the query using the Currency relation
 * @method     ChildOrderItemQuery innerJoinWithCurrency() Adds a INNER JOIN clause and with to the query using the Currency relation
 *
 * @method     \Shop\Models\Order\OrderQuery|\Shop\Models\Currency\CurrencyQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildOrderItem findOne(ConnectionInterface $con = null) Return the first ChildOrderItem matching the query
 * @method     ChildOrderItem findOneOrCreate(ConnectionInterface $con = null) Return the first ChildOrderItem matching the query, or a new ChildOrderItem object populated from the query conditions when no match is found
 *
 * @method     ChildOrderItem findOneById(int $id) Return the first ChildOrderItem filtered by the id column
 * @method     ChildOrderItem findOneByOrderId(int $order_id) Return the first ChildOrderItem filtered by the order_id column
 * @method     ChildOrderItem findOneByName(string $name) Return the first ChildOrderItem filtered by the name column
 * @method     ChildOrderItem findOneByBrand(string $brand) Return the first ChildOrderItem filtered by the brand column
 * @method     ChildOrderItem findOneByArticle(string $article) Return the first ChildOrderItem filtered by the article column
 * @method     ChildOrderItem findOneByDesc(string $desc) Return the first ChildOrderItem filtered by the desc column
 * @method     ChildOrderItem findOneByPrice(string $price) Return the first ChildOrderItem filtered by the price column
 * @method     ChildOrderItem findOneByAmount(int $amount) Return the first ChildOrderItem filtered by the amount column
 * @method     ChildOrderItem findOneBymenagerComment(string $menager_comment) Return the first ChildOrderItem filtered by the menager_comment column
 * @method     ChildOrderItem findOneByDestination(string $destination) Return the first ChildOrderItem filtered by the destination column
 * @method     ChildOrderItem findOneByRefId(string $ref_id) Return the first ChildOrderItem filtered by the ref_id column
 * @method     ChildOrderItem findOneByCurrencyId(int $crrency_id) Return the first ChildOrderItem filtered by the crrency_id column *

 * @method     ChildOrderItem requirePk($key, ConnectionInterface $con = null) Return the ChildOrderItem by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOne(ConnectionInterface $con = null) Return the first ChildOrderItem matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildOrderItem requireOneById(int $id) Return the first ChildOrderItem filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByOrderId(int $order_id) Return the first ChildOrderItem filtered by the order_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByName(string $name) Return the first ChildOrderItem filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByBrand(string $brand) Return the first ChildOrderItem filtered by the brand column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByArticle(string $article) Return the first ChildOrderItem filtered by the article column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByDesc(string $desc) Return the first ChildOrderItem filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByPrice(string $price) Return the first ChildOrderItem filtered by the price column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByAmount(int $amount) Return the first ChildOrderItem filtered by the amount column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneBymenagerComment(string $menager_comment) Return the first ChildOrderItem filtered by the menager_comment column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByDestination(string $destination) Return the first ChildOrderItem filtered by the destination column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByRefId(string $ref_id) Return the first ChildOrderItem filtered by the ref_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildOrderItem requireOneByCurrencyId(int $crrency_id) Return the first ChildOrderItem filtered by the crrency_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildOrderItem[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildOrderItem objects based on current ModelCriteria
 * @method     ChildOrderItem[]|ObjectCollection findById(int $id) Return ChildOrderItem objects filtered by the id column
 * @method     ChildOrderItem[]|ObjectCollection findByOrderId(int $order_id) Return ChildOrderItem objects filtered by the order_id column
 * @method     ChildOrderItem[]|ObjectCollection findByName(string $name) Return ChildOrderItem objects filtered by the name column
 * @method     ChildOrderItem[]|ObjectCollection findByBrand(string $brand) Return ChildOrderItem objects filtered by the brand column
 * @method     ChildOrderItem[]|ObjectCollection findByArticle(string $article) Return ChildOrderItem objects filtered by the article column
 * @method     ChildOrderItem[]|ObjectCollection findByDesc(string $desc) Return ChildOrderItem objects filtered by the desc column
 * @method     ChildOrderItem[]|ObjectCollection findByPrice(string $price) Return ChildOrderItem objects filtered by the price column
 * @method     ChildOrderItem[]|ObjectCollection findByAmount(int $amount) Return ChildOrderItem objects filtered by the amount column
 * @method     ChildOrderItem[]|ObjectCollection findBymenagerComment(string $menager_comment) Return ChildOrderItem objects filtered by the menager_comment column
 * @method     ChildOrderItem[]|ObjectCollection findByDestination(string $destination) Return ChildOrderItem objects filtered by the destination column
 * @method     ChildOrderItem[]|ObjectCollection findByRefId(string $ref_id) Return ChildOrderItem objects filtered by the ref_id column
 * @method     ChildOrderItem[]|ObjectCollection findByCurrencyId(int $crrency_id) Return ChildOrderItem objects filtered by the crrency_id column
 * @method     ChildOrderItem[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class OrderItemQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\OrderItem\Base\OrderItemQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\OrderItem\\OrderItem', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildOrderItemQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildOrderItemQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildOrderItemQuery) {
            return $criteria;
        }
        $query = new ChildOrderItemQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildOrderItem|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(OrderItemTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = OrderItemTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrderItem A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `order_id`, `name`, `brand`, `article`, `desc`, `price`, `amount`, `menager_comment`, `destination`, `ref_id`, `crrency_id` FROM `shop_order_items` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildOrderItem $obj */
            $obj = new ChildOrderItem();
            $obj->hydrate($row);
            OrderItemTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildOrderItem|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(OrderItemTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(OrderItemTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the order_id column
     *
     * Example usage:
     * <code>
     * $query->filterByOrderId(1234); // WHERE order_id = 1234
     * $query->filterByOrderId(array(12, 34)); // WHERE order_id IN (12, 34)
     * $query->filterByOrderId(array('min' => 12)); // WHERE order_id > 12
     * </code>
     *
     * @see       filterByOrder()
     *
     * @param     mixed $orderId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByOrderId($orderId = null, $comparison = null)
    {
        if (is_array($orderId)) {
            $useMinMax = false;
            if (isset($orderId['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $orderId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($orderId['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $orderId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $orderId, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the brand column
     *
     * Example usage:
     * <code>
     * $query->filterByBrand('fooValue');   // WHERE brand = 'fooValue'
     * $query->filterByBrand('%fooValue%', Criteria::LIKE); // WHERE brand LIKE '%fooValue%'
     * </code>
     *
     * @param     string $brand The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByBrand($brand = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($brand)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_BRAND, $brand, $comparison);
    }

    /**
     * Filter the query on the article column
     *
     * Example usage:
     * <code>
     * $query->filterByArticle('fooValue');   // WHERE article = 'fooValue'
     * $query->filterByArticle('%fooValue%', Criteria::LIKE); // WHERE article LIKE '%fooValue%'
     * </code>
     *
     * @param     string $article The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByArticle($article = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($article)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_ARTICLE, $article, $comparison);
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $desc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByDesc($desc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_DESC, $desc, $comparison);
    }

    /**
     * Filter the query on the price column
     *
     * Example usage:
     * <code>
     * $query->filterByPrice(1234); // WHERE price = 1234
     * $query->filterByPrice(array(12, 34)); // WHERE price IN (12, 34)
     * $query->filterByPrice(array('min' => 12)); // WHERE price > 12
     * </code>
     *
     * @param     mixed $price The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByPrice($price = null, $comparison = null)
    {
        if (is_array($price)) {
            $useMinMax = false;
            if (isset($price['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_PRICE, $price['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($price['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_PRICE, $price['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_PRICE, $price, $comparison);
    }

    /**
     * Filter the query on the amount column
     *
     * Example usage:
     * <code>
     * $query->filterByAmount(1234); // WHERE amount = 1234
     * $query->filterByAmount(array(12, 34)); // WHERE amount IN (12, 34)
     * $query->filterByAmount(array('min' => 12)); // WHERE amount > 12
     * </code>
     *
     * @param     mixed $amount The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByAmount($amount = null, $comparison = null)
    {
        if (is_array($amount)) {
            $useMinMax = false;
            if (isset($amount['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_AMOUNT, $amount['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($amount['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_AMOUNT, $amount['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_AMOUNT, $amount, $comparison);
    }

    /**
     * Filter the query on the menager_comment column
     *
     * Example usage:
     * <code>
     * $query->filterBymenagerComment('fooValue');   // WHERE menager_comment = 'fooValue'
     * $query->filterBymenagerComment('%fooValue%', Criteria::LIKE); // WHERE menager_comment LIKE '%fooValue%'
     * </code>
     *
     * @param     string $menagerComment The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterBymenagerComment($menagerComment = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($menagerComment)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_MENAGER_COMMENT, $menagerComment, $comparison);
    }

    /**
     * Filter the query on the destination column
     *
     * Example usage:
     * <code>
     * $query->filterByDestination('fooValue');   // WHERE destination = 'fooValue'
     * $query->filterByDestination('%fooValue%', Criteria::LIKE); // WHERE destination LIKE '%fooValue%'
     * </code>
     *
     * @param     string $destination The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByDestination($destination = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($destination)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_DESTINATION, $destination, $comparison);
    }

    /**
     * Filter the query on the ref_id column
     *
     * Example usage:
     * <code>
     * $query->filterByRefId('fooValue');   // WHERE ref_id = 'fooValue'
     * $query->filterByRefId('%fooValue%', Criteria::LIKE); // WHERE ref_id LIKE '%fooValue%'
     * </code>
     *
     * @param     string $refId The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByRefId($refId = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($refId)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_REF_ID, $refId, $comparison);
    }

    /**
     * Filter the query on the crrency_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrencyId(1234); // WHERE crrency_id = 1234
     * $query->filterByCurrencyId(array(12, 34)); // WHERE crrency_id IN (12, 34)
     * $query->filterByCurrencyId(array('min' => 12)); // WHERE crrency_id > 12
     * </code>
     *
     * @see       filterByCurrency()
     *
     * @param     mixed $currencyId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByCurrencyId($currencyId = null, $comparison = null)
    {
        if (is_array($currencyId)) {
            $useMinMax = false;
            if (isset($currencyId['min'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currencyId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($currencyId['max'])) {
                $this->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currencyId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currencyId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Order\Order object
     *
     * @param \Shop\Models\Order\Order|ObjectCollection $order The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByOrder($order, $comparison = null)
    {
        if ($order instanceof \Shop\Models\Order\Order) {
            return $this
                ->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $order->getId(), $comparison);
        } elseif ($order instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(OrderItemTableMap::COL_ORDER_ID, $order->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByOrder() only accepts arguments of type \Shop\Models\Order\Order or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Order relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function joinOrder($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Order');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Order');
        }

        return $this;
    }

    /**
     * Use the Order relation Order object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Order\OrderQuery A secondary query class using the current class as primary query
     */
    public function useOrderQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOrder($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Order', '\Shop\Models\Order\OrderQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Currency\Currency object
     *
     * @param \Shop\Models\Currency\Currency|ObjectCollection $currency The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildOrderItemQuery The current query, for fluid interface
     */
    public function filterByCurrency($currency, $comparison = null)
    {
        if ($currency instanceof \Shop\Models\Currency\Currency) {
            return $this
                ->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currency->getId(), $comparison);
        } elseif ($currency instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(OrderItemTableMap::COL_CRRENCY_ID, $currency->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCurrency() only accepts arguments of type \Shop\Models\Currency\Currency or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Currency relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function joinCurrency($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Currency');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Currency');
        }

        return $this;
    }

    /**
     * Use the Currency relation Currency object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Currency\CurrencyQuery A secondary query class using the current class as primary query
     */
    public function useCurrencyQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCurrency($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Currency', '\Shop\Models\Currency\CurrencyQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildOrderItem $orderItem Object to remove from the list of results
     *
     * @return $this|ChildOrderItemQuery The current query, for fluid interface
     */
    public function prune($orderItem = null)
    {
        if ($orderItem) {
            $this->addUsingAlias(OrderItemTableMap::COL_ID, $orderItem->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_order_items table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderItemTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            OrderItemTableMap::clearInstancePool();
            OrderItemTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(OrderItemTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(OrderItemTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            OrderItemTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            OrderItemTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // OrderItemQuery
