<?

namespace Shop\Helpers;

/**
 * Помошник для отображения цены
 *
 * @author Admin
 */
class Price {

    public static function format($n = '',$p = 2){
        return ($n === '') ? '' : number_format( (float) $n, $p, '.', ' ');
    }


    /**
     * Форматироание цены, или цен
     * @param type $prices
     * @param type $currency
     * @param type $delim
     * @return type
     */
    public static function display($prices, $currency = "", $delim = "-", $p = 2) {

        $min = $max = 0;
        foreach ((array) $prices as $price) {
            if ($price > $max)
                $max = $price;
            if ($price < $min || $min == 0)
                $min = $price;
        }
        
        if ($min != $max)
            $output = self::format($min,$p) . $delim . self::format($max,$p);
        else
            $output = self::format($min,$p);
        
        return sprintf("%s%s",$output,$currency?$currency:"");
    }

}
